/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant16;

public class MXVisitantRecorder
implements TableModel {
    private static final MXDebugLines _debug = new MXDebugLines(MXVisitantRecorder.class);
    private ArrayList<MXVisitant16> _element;
    String[] tableColumns = new String[]{"Port/Ch", "Bank", "Prog", "Vol", "Exp", "Pan", "Data"};
    LinkedList<TableModelListener> _listeners = new LinkedList();

    public MXVisitantRecorder() {
        this._element = new ArrayList();
        for (int port = 0; port < 16; ++port) {
            this._element.add(new MXVisitant16());
        }
    }

    public MXVisitant16 getVisitant16(int port) {
        return this._element.get(port);
    }

    public MXVisitant getVisitant(int port, int ch) {
        return this._element.get(port).get(ch);
    }

    public boolean updateVisitant16WithMessage(MXMessage message) {
        MXVisitant visitant = this._element.get(message.getPort()).get(message.getChannel());
        if (visitant.updatevisitantChannel(message)) {
            this.invokeListener();
            return true;
        }
        return false;
    }

    public boolean mergeVisitant16WithVisitant(MXMessage message) {
        MXVisitant visitant = this._element.get(message.getPort()).get(message.getChannel());
        if (visitant.mergeNew(message.getVisitant())) {
            this.invokeListener();
            return true;
        }
        return false;
    }

    public MXMessage incProg(int port, MXTraceNumber traceNumber, int channel) {
        MXVisitant e = this.getVisitant(port, channel);
        if (e.getProgram() >= 127) {
            return null;
        }
        e.setProgram(e.getProgram() + 1);
        this.invokeListener();
        return MXMessageFactory.fromShortMessage(port, traceNumber, 192 + channel, e.getProgram(), 0);
    }

    public MXMessage decProg(int port, MXTraceNumber traceNumber, int channel) {
        MXVisitant e = this.getVisitant(port, channel);
        if (e.getProgram() <= 0) {
            return null;
        }
        e.setProgram(e.getProgram() - 1);
        this.invokeListener();
        return MXMessageFactory.fromShortMessage(port, traceNumber, 192 + channel, e.getProgram(), 0);
    }

    @Override
    public int getRowCount() {
        return this._element.size() * 16;
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.length;
    }

    @Override
    public String getColumnName(int i) {
        return this.tableColumns[i];
    }

    @Override
    public Class<?> getColumnClass(int i) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int port = rowIndex / 16;
        int channel = rowIndex - port * 16;
        MXVisitant info = this.getVisitant(port, channel);
        switch (columnIndex) {
            case 0: {
                return MXUtilMidi.nameOfPortShort(port) + (channel + 1);
            }
            case 1: {
                if (!info.isHavingBank()) break;
                return MXUtil.toHexFF(info.getBankMSB()) + ":" + MXUtil.toHexFF(info.getBankLSB());
            }
            case 2: {
                if (!info.isHavingProgram()) break;
                return Integer.toString(info.getProgram());
            }
            case 3: {
                if (!info.isHavingVolume()) break;
                return Integer.toString(info.getInfoVolume());
            }
            case 4: {
                if (!info.isHavingExpression()) break;
                return Integer.toString(info.getInfoExpression());
            }
            case 5: {
                if (!info.isHavingPan()) break;
                return Integer.toString(info.getInfoPan());
            }
            case 6: {
                if (info.isHaveDataentryRPN()) {
                    return "R(" + MXUtil.toHexFF(info.getDataentryMSB()) + ":" + MXUtil.toHexFF(info.getDataentryLSB()) + ")=" + info.getDataentryValue14();
                }
                if (!info.isHaveDataentryNRPN()) break;
                return "N(" + MXUtil.toHexFF(info.getDataentryMSB()) + ":" + MXUtil.toHexFF(info.getDataentryLSB()) + ")=" + info.getDataentryValue14();
            }
        }
        return "-";
    }

    @Override
    public void setValueAt(Object o, int i, int i1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTableModelListener(TableModelListener l) {
        LinkedList<TableModelListener> linkedList = this._listeners;
        synchronized (linkedList) {
            this._listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableModelListener(TableModelListener l) {
        LinkedList<TableModelListener> linkedList = this._listeners;
        synchronized (linkedList) {
            this._listeners.remove(l);
        }
    }

    public void invokeListener() {
        for (TableModelListener l : this._listeners) {
            TableModelEvent e = new TableModelEvent(this, 0, this.getRowCount());
            l.tableChanged(e);
        }
    }
}

