/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;

public class MXVisitant
implements Cloneable {
    public static final int HAVE_VAL_NOT = 0;
    public static final int HAVE_VAL_MSB = 1;
    public static final int HAVE_VAL_LSB = 2;
    public static final int HAVE_VAL_BOTH = 3;
    public static final int ROOMTYPE_NODATA = 0;
    public static final int ROOMTYPE_RPN = 1;
    public static final int ROOMTYPE_NRPN = 2;
    boolean _havingProgram;
    int _program;
    boolean _havingVolume = false;
    int _infoVolume = 127;
    boolean _havingExpression = false;
    int _infoExpression = 127;
    boolean _havingPan = false;
    int _infoPan = 64;
    int _havingBank;
    int _bankMSB;
    int _bankLSB;
    int _dataroomType = 0;
    int _gotDataroom = 0;
    int _dataroomLSB = 0;
    int _dataroomMSB = 0;
    int _gotDataentry = 0;
    int _dataentryMSB = 0;
    int _dataentryLSB = 0;
    int _currentAge = 0;
    MXVisitant _lastSnapShort = null;
    boolean _isImmutable = false;

    public void setBankMSB(int msb) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._bankMSB = msb;
        switch (this._havingBank) {
            case 0: 
            case 3: {
                this._havingBank = 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this._havingBank = 3;
            }
        }
    }

    public int getBankMSB() {
        return this._bankMSB;
    }

    public void setBankLSB(int lsb) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._bankLSB = lsb;
        switch (this._havingBank) {
            case 0: 
            case 3: {
                this._havingBank = 2;
                break;
            }
            case 1: {
                this._havingBank = 3;
                break;
            }
        }
    }

    public int getBankLSB() {
        return this._bankLSB;
    }

    public boolean isHavingBank() {
        return this._havingBank == 3;
    }

    public boolean isIncompleteBankInfo() {
        return this._havingBank != 0 && this._havingBank != 3;
    }

    public void forceCompleteBankInfo() {
        if (this._havingBank != 0) {
            this._havingBank = 3;
        }
    }

    public boolean isIncomplemteDataroom() {
        return this._gotDataroom != 0 && this._gotDataroom != 3;
    }

    public void forceCompleteBankDataroom() {
        if (this._gotDataroom != 0) {
            this._gotDataroom = 3;
        }
    }

    public boolean isIncomplemteDataentry() {
        return this._gotDataentry != 0 && this._gotDataentry != 3;
    }

    public void forceCompleteBankDataentry() {
        if (this._gotDataentry != 0) {
            this._gotDataentry = 3;
        }
    }

    public boolean isHaveDataroom() {
        return this._gotDataroom == 3;
    }

    public boolean isHaveDataentryRPN() {
        if (this._gotDataentry == 3 && this._dataroomType == 1) {
            return this.isHaveDataroom();
        }
        return false;
    }

    public boolean isHaveDataentryNRPN() {
        if (this._gotDataentry == 3 && this._dataroomType == 2) {
            return this.isHaveDataroom();
        }
        return false;
    }

    public int getDataroomLSB() {
        return this._dataroomLSB;
    }

    public int getDataroomMSB() {
        return this._dataroomMSB;
    }

    public int getDataentryLSB() {
        return this._dataentryLSB;
    }

    public int getDataentryMSB() {
        return this._dataentryMSB;
    }

    public int getDataentryValue14() {
        return (this._dataentryMSB & 0x7F) << 7 | this._dataentryLSB & 0x7F;
    }

    public void setDataroom14(int longValue) {
        int msb = longValue >> 7;
        int lsb = longValue & 0x7F;
        this.setDataroomMSB(msb);
        this.setDataroomLSB(lsb);
        this._gotDataroom = 3;
    }

    public void setDataentry14(int longValue) {
        int msb = longValue >> 7;
        int lsb = longValue & 0x7F;
        this.setDataentryMSB(msb);
        this.setDataentryLSB(lsb);
        this._gotDataentry = 3;
    }

    public void setDataroomType(int roomType) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._dataroomType = roomType;
    }

    public int getDataroomType() {
        return this._dataroomType;
    }

    public void setDataroomMSB(int msb) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._dataroomMSB = msb;
        switch (this._gotDataroom) {
            case 0: 
            case 3: {
                this._gotDataroom = 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this._gotDataroom = 3;
            }
        }
    }

    public void setDataroomLSB(int lsb) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._dataroomLSB = lsb;
        switch (this._gotDataroom) {
            case 0: 
            case 3: {
                this._gotDataroom = 2;
                break;
            }
            case 1: {
                this._gotDataroom = 3;
                break;
            }
        }
    }

    public void setDataentryMSB(int msb) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._dataentryMSB = msb;
        switch (this._gotDataentry) {
            case 0: 
            case 3: {
                this._gotDataentry = 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this._gotDataentry = 3;
            }
        }
    }

    public void setDataentryLSB(int lsb) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._dataentryLSB = lsb;
        switch (this._gotDataentry) {
            case 0: 
            case 3: {
                this._gotDataentry = 2;
                break;
            }
            case 1: {
                this._gotDataentry = 3;
                break;
            }
        }
    }

    public String toString() {
        Object str = "";
        if (this._havingBank != 0) {
            str = (String)str + " Bank[" + MXUtil.toHexFF(this._bankMSB) + ":" + MXUtil.toHexFF(this._bankLSB) + "]";
        }
        if (this._havingProgram) {
            str = (String)str + " Prog." + this._program;
        }
        if (this._havingPan) {
            str = (String)str + " Pan." + this._infoPan;
        }
        if (this._havingVolume) {
            str = (String)str + " Voume." + this._infoVolume;
        }
        if (this._havingExpression) {
            str = (String)str + " Expression." + this._infoExpression;
        }
        if (this._dataroomType != 1) {
            str = (String)str + " RPN." + this._dataroomMSB + "," + this._dataroomLSB + " = " + this.getDataentryValue14();
        }
        if (this._dataroomType != 2) {
            str = (String)str + " NRPN." + this._dataroomMSB + "," + this._dataroomLSB + " = " + this.getDataentryValue14();
        }
        return ((String)str).substring(1);
    }

    public MXVisitant clone() {
        MXVisitant obj = new MXVisitant();
        obj._havingProgram = this._havingProgram;
        obj._program = this._program;
        obj._havingVolume = this._havingVolume;
        obj._infoVolume = this._infoVolume;
        obj._havingExpression = this._havingExpression;
        obj._infoExpression = this._infoExpression;
        obj._havingPan = this._havingPan;
        obj._infoPan = this._infoPan;
        obj._havingBank = this._havingBank;
        obj._bankMSB = this._bankMSB;
        obj._bankLSB = this._bankLSB;
        obj._dataroomType = this._dataroomType;
        obj._gotDataroom = this._gotDataroom;
        obj._dataroomLSB = this._dataroomLSB;
        obj._dataroomMSB = this._dataroomMSB;
        obj._gotDataentry = this._gotDataentry;
        obj._dataentryMSB = this._dataentryMSB;
        obj._dataentryLSB = this._dataentryLSB;
        return obj;
    }

    public boolean mergeNew(MXVisitant visitant) {
        boolean mod = false;
        if (visitant == null) {
            return mod;
        }
        if (visitant.isHavingProgram() && (!this._havingProgram || this._program != visitant._program)) {
            this._havingProgram = true;
            this._program = visitant._program;
            mod = true;
        }
        if (visitant._havingBank != 0 && (this._havingBank == 0 || this._bankMSB != visitant._bankMSB || this._bankLSB != visitant._bankLSB)) {
            this._havingBank = visitant._havingBank;
            this._bankMSB = visitant._bankMSB;
            this._bankLSB = visitant._bankLSB;
            mod = true;
        }
        if (visitant.isHavingVolume() && (!this._havingVolume || this._infoVolume != visitant._infoVolume)) {
            this._infoVolume = visitant._infoVolume;
            mod = true;
        }
        if (visitant.isHavingExpression() && (!this._havingExpression || this._infoExpression != visitant._infoExpression)) {
            this._havingExpression = true;
            this._infoExpression = visitant._infoExpression;
            mod = true;
        }
        if (visitant.isHavingPan() && (!this._havingPan || this._infoPan != visitant._infoPan)) {
            this._havingPan = true;
            this._infoPan = visitant._infoPan;
            mod = true;
        }
        if (visitant.getDataroomType() != 0 && (this._dataroomType != visitant._dataroomType || this._dataentryMSB != visitant._dataentryMSB || this._dataroomLSB != visitant._dataentryLSB || this._dataentryMSB != visitant._dataentryMSB || this._dataentryLSB != visitant._dataentryLSB)) {
            this._gotDataroom = visitant._gotDataroom;
            this._dataroomType = visitant._dataroomType;
            this._dataentryMSB = visitant._dataentryMSB;
            this._gotDataentry = visitant._gotDataentry;
            this._dataroomLSB = visitant._dataentryLSB;
            this._dataentryMSB = visitant._dataentryMSB;
            this._dataentryLSB = visitant._dataentryLSB;
            mod = true;
        }
        return mod;
    }

    public static boolean isMesssageHaveVisitant(MXMessage message) {
        if (message.isMessageTypeChannel()) {
            switch (message.getCommand()) {
                case 192: {
                    return true;
                }
                case 176: {
                    switch (message.getData1()) {
                        case 0: 
                        case 6: 
                        case 7: 
                        case 10: 
                        case 11: 
                        case 32: 
                        case 38: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public synchronized MXVisitant getSnapShot() {
        if (this._lastSnapShort == null || this._lastSnapShort._currentAge != this._currentAge) {
            this._lastSnapShort = this.clone();
            this._lastSnapShort._currentAge = this._currentAge;
            this._lastSnapShort._isImmutable = true;
        }
        return this._lastSnapShort;
    }

    public synchronized boolean updatevisitantChannel(MXMessage message) {
        if (message.isMessageTypeChannel()) {
            int ch = message.getChannel();
            int gate = message.getGate();
            int value = message.getValue();
            switch (message.getCommand()) {
                case 192: {
                    if (gate >= 0 && gate <= 127) {
                        this.setHavingProgram(true);
                        this.setProgram(gate);
                        ++this._currentAge;
                    }
                    return true;
                }
                case 176: {
                    switch (gate) {
                        case 6: {
                            this.setDataentryMSB(value);
                            ++this._currentAge;
                            return true;
                        }
                        case 38: {
                            this.setDataentryLSB(value);
                            ++this._currentAge;
                            return true;
                        }
                        case 96: {
                            int oldValue = this.getDataentryValue14();
                            int newValue = oldValue + 1;
                            if (newValue >= 128) {
                                newValue = 127;
                            }
                            this.setDataentry14(newValue);
                            ++this._currentAge;
                            return true;
                        }
                        case 97: {
                            int oldValue = this.getDataentryValue14();
                            int newValue = oldValue - 1;
                            if (newValue < 0) {
                                newValue = 0;
                            }
                            this.setDataentry14(newValue);
                            ++this._currentAge;
                            return true;
                        }
                        case 0: {
                            this.setBankMSB(value);
                            ++this._currentAge;
                            return true;
                        }
                        case 32: {
                            this.setBankLSB(value);
                            this.forceCompleteBankInfo();
                            ++this._currentAge;
                            return true;
                        }
                        case 101: {
                            this.setDataroomType(1);
                            this.setDataroomMSB(value);
                            ++this._currentAge;
                            return true;
                        }
                        case 100: {
                            this.setDataroomType(1);
                            this.setDataroomLSB(value);
                            ++this._currentAge;
                            return true;
                        }
                        case 99: {
                            this.setDataroomType(2);
                            this.setDataroomMSB(value);
                            return true;
                        }
                        case 98: {
                            this.setDataroomType(2);
                            this.setDataroomLSB(value);
                            ++this._currentAge;
                            return true;
                        }
                        case 10: {
                            this.setHavingPan(true);
                            this.setInfoPan(value);
                            ++this._currentAge;
                            return true;
                        }
                        case 11: {
                            this.setHavingExpression(true);
                            this.setInfoExpression(value);
                            ++this._currentAge;
                            return true;
                        }
                        case 7: {
                            this.setHavingVolume(true);
                            this.setInfoVolume(value);
                            ++this._currentAge;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public void attachChannelVisitantToMessage(MXMessage message) {
        message.setVisitant(this.getSnapShot());
    }

    public boolean isHavingProgram() {
        return this._havingProgram;
    }

    public void setHavingProgram(boolean _havingProgram) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._havingProgram = _havingProgram;
    }

    public int getProgram() {
        return this._program;
    }

    public void setProgram(int _program) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._program = _program;
    }

    public void setHavingBank(int _havingBank) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._havingBank = _havingBank;
    }

    public boolean isHavingVolume() {
        return this._havingVolume;
    }

    public void setHavingVolume(boolean _havingVolume) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._havingVolume = _havingVolume;
    }

    public int getInfoVolume() {
        return this._infoVolume;
    }

    public void setInfoVolume(int _infoVolume) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._infoVolume = _infoVolume;
    }

    public boolean isHavingExpression() {
        return this._havingExpression;
    }

    public void setHavingExpression(boolean _havingExpression) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._havingExpression = _havingExpression;
    }

    public int getInfoExpression() {
        return this._infoExpression;
    }

    public void setInfoExpression(int _infoExpression) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._infoExpression = _infoExpression;
    }

    public boolean isHavingPan() {
        return this._havingPan;
    }

    public void setHavingPan(boolean _havingPan) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._havingPan = _havingPan;
    }

    public int getInfoPan() {
        return this._infoPan;
    }

    public void setInfoPan(int _infoPan) {
        if (this._isImmutable) {
            throw new IllegalStateException("Immutable can't change");
        }
        this._infoPan = _infoPan;
    }
}

