/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.io.File;
import java.util.TreeMap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDevice;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDriverJava;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDriverUWP;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIOut;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import org.xml.sax.SAXException;

public class MXMIDIOutManager
implements MXSettingTarget {
    private static final MXMIDIOutManager _instance = new MXMIDIOutManager();
    private MXSetting _setting;
    protected MXWrapList<MXMIDIOut> _listAllOutput;
    protected MXWrapList<MXMIDIOut> _selectedOutput = null;
    protected MXMIDIOut[] _cache;

    public static MXMIDIOutManager getManager() {
        return _instance;
    }

    public void reloadDeviceList() {
    }

    public void initWithSetting() {
        if (this._setting == null) {
            this._setting = new MXSetting("MIDIOutput");
            this._setting.setTarget(this);
            this.listAllOutput();
            this._setting.readFile();
            MXMIDIOut reserve = MXMIDIOutManager.getManager().findMIDIOutput("Gervill");
            MXMIDIOut reserve2 = MXMIDIOutManager.getManager().findMIDIOutput("Microsoft GS Wavetable Synth");
            MXMIDIOut reserve3 = MXMIDIOutManager.getManager().findMIDIOutput("VirtualMIDISynth #1");
            if (reserve2 != null && reserve2.assignedPort() >= 0) {
                reserve = reserve2;
            }
            if (reserve3 != null && reserve3.assignedPort() >= 0) {
                reserve = reserve3;
            }
            if (reserve.assignedPort() < 0) {
                int found = -1;
                for (int i = 0; i < 16; ++i) {
                    boolean retry = false;
                    for (MXMIDIOut out : this.listAllOutput().valueList()) {
                        if (out.assignedPort() != i) continue;
                        retry = true;
                        break;
                    }
                    if (retry) continue;
                    found = i;
                    break;
                }
                if (found >= 0) {
                    this.reserveOutput(reserve, found);
                    reserve.open();
                }
            }
        }
    }

    protected MXMIDIOutManager() {
    }

    public synchronized MXWrapList<MXMIDIOut> listAllOutput() {
        if (this._listAllOutput != null) {
            return this._listAllOutput;
        }
        MXWrapList<MXMIDIOut> temp = new MXWrapList<MXMIDIOut>();
        MXMIDIDriverJava java = MXMIDIDriverJava._instance;
        for (int i = 0; i < java.OutputDevicesRoomSize(); ++i) {
            MXMIDIDevice device = new MXMIDIDevice(java, false, i);
            String name = device.getName();
            if (MXMIDIDriverUWP._instance.isUsable() && (name.equals("Real Time Sequencer") || name.equals("Unknown name") || name.startsWith("Microsoft GS Wave"))) continue;
            temp.addNameAndValue(name, new MXMIDIOut(name, device));
        }
        if (MXMIDIDriverUWP._instance.isUsable()) {
            MXMIDIDriverUWP uwp = MXMIDIDriverUWP._instance;
            for (int i = 0; i < uwp.OutputDevicesRoomSize(); ++i) {
                MXMIDIDevice device = new MXMIDIDevice(uwp, false, i);
                Object name = device.getName();
                if (((String)name).equals("Real Time Sequencer") || ((String)name).equals("Unknown name") || ((String)name).equals("MIDI") || temp.indexOfName((String)name) >= 0) continue;
                name = (String)name + " (UWP)";
                temp.addNameAndValue((String)name, new MXMIDIOut((String)name, device));
            }
        }
        this._listAllOutput = temp;
        return this._listAllOutput;
    }

    public MXMIDIOut findMIDIOutput(String deviceName) {
        MXWrapList<MXMIDIOut> model = this.listAllOutput();
        return model.valueOfName(deviceName);
    }

    public MXMIDIOut findMIDIOutput(int assigned) {
        this.listSelectedOutput();
        if (assigned >= 0) {
            return this._cache[assigned];
        }
        return null;
    }

    synchronized void onClose(MXMIDIOut output) {
        this.clearMIDIOutCache();
    }

    protected synchronized void clearMIDIOutCache() {
        this._selectedOutput = null;
        this._cache = null;
    }

    public synchronized MXWrapList<MXMIDIOut> listSelectedOutput() {
        if (this._selectedOutput != null) {
            return this._selectedOutput;
        }
        this._selectedOutput = new MXWrapList();
        this._cache = new MXMIDIOut[16];
        for (MXMIDIOut midi : this.listAllOutput().valueList()) {
            int port = midi.assignedPort();
            if (port < 0) continue;
            this._selectedOutput.addNameAndValue(midi.getName(), midi);
            this._cache[port] = midi;
        }
        return this._selectedOutput;
    }

    public synchronized void closeAll() {
        for (MXMIDIOut output : this.listAllOutput().valueList()) {
            if (!output.isOpen()) continue;
            output.close();
        }
    }

    public synchronized boolean reserveOutput(MXMIDIOut output, int assignnew) {
        MXWrapList<MXMIDIOut> list = this.listAllOutput();
        if (output.assignedPort() >= 0 && output.assignedPort() == assignnew) {
            return true;
        }
        if (assignnew < 0) {
            output.close();
            this.clearMIDIOutCache();
            output._assigned = assignnew;
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            MXMIDIOut x = list.valueOfIndex(i);
            if (x.assignedPort() != assignnew) continue;
            x.close();
            x._assigned = -1;
        }
        output._assigned = assignnew;
        this.clearMIDIOutCache();
        return true;
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        setting.register("device[].name");
        setting.register("device[].open");
        setting.register("device[].fromDXML");
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        TreeMap<String, MXMIDIOut> dummy = new TreeMap<String, MXMIDIOut>();
        for (int x = 0; x < 16; ++x) {
            File f;
            MXWrapList<MXMIDIOut> detected;
            MXMIDIOut out;
            String deviceName = setting.getSetting("device[" + x + "].name");
            String deviceOpen = setting.getSetting("device[" + x + "].open");
            String deviceFile = setting.getSetting("device[" + x + "].fromDXML");
            if (deviceName == null) continue;
            if (deviceOpen == null) {
                deviceOpen = "0";
            }
            if ((out = (detected = this.listAllOutput()).valueOfName(deviceName)) != null) {
                this.reserveOutput(out, x);
                if (deviceOpen.equals("1")) {
                    out.open();
                }
            } else {
                out = new MXMIDIOut(deviceName, null);
                this.reserveOutput(out, x);
                dummy.put(deviceName, out);
            }
            if (deviceFile == null || !(f = new File(deviceFile)).isFile()) continue;
            try {
                out.setDXMLFile(f);
                continue;
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        for (MXMIDIOut out : dummy.values()) {
            this._listAllOutput.addNameAndValue(out.getName(), out);
        }
        this.clearMIDIOutCache();
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        MXWrapList<MXMIDIOut> all = this.listAllOutput();
        for (MXMIDIOut e : all.valueList()) {
            int x = e.assignedPort();
            if (x < 0) continue;
            setting.setSetting("device[" + x + "].name", e.getName());
            setting.setSetting("device[" + x + "].open", e.isOpen() ? "1" : "0");
            setting.setSetting("device[" + x + "].fromDXML", e.getDXMLFile() == null ? "" : e.getDXMLFile().getPath());
        }
    }
}

