/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.util.TreeMap;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDevice;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDriverJava;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDriverUWP;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIIn;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInForPlayer;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;

public class MXMIDIInManager
implements MXSettingTarget {
    private static final MXDebugLines _debug = new MXDebugLines(MXMIDIInManager.class);
    private static final MXMIDIInManager _instance = new MXMIDIInManager();
    private MXSetting _setting;
    protected MXWrapList<MXMIDIIn> _listAllInput;
    protected MXWrapList<MXMIDIIn> _listUsingInput;
    protected MXMIDIIn[] _cache;

    public static MXMIDIInManager getManager() {
        return _instance;
    }

    public void reloadDeviceList() {
    }

    protected MXMIDIInManager() {
    }

    public void initWithSetting() {
        if (this._setting == null) {
            this._setting = new MXSetting("MIDIInput");
            this._setting.setTarget(this);
            this.listAllInput();
            this._setting.readFile();
            if (MXMIDIIn.INTERNAL_PLAYER.assigned() < 0) {
                int found = -1;
                for (int i = 0; i < 16; ++i) {
                    boolean retry = false;
                    for (MXMIDIIn in : this.listAllInput().valueList()) {
                        if (in.assigned() != i) continue;
                        retry = true;
                        break;
                    }
                    if (retry) continue;
                    found = i;
                    break;
                }
                if (found >= 0) {
                    this.reserveInput(MXMIDIIn.INTERNAL_PLAYER, found);
                    MXMIDIIn.INTERNAL_PLAYER.open();
                }
            }
        }
    }

    public synchronized MXWrapList<MXMIDIIn> listAllInput() {
        if (this._listAllInput != null) {
            return this._listAllInput;
        }
        MXWrapList<MXMIDIIn> temp = new MXWrapList<MXMIDIIn>();
        MXMIDIDriverJava java = MXMIDIDriverJava._instance;
        MXMIDIInForPlayer sequencer = MXMIDIIn.INTERNAL_PLAYER;
        temp.addNameAndValue(sequencer.getName(), sequencer);
        for (int i = 0; i < java.InputDevicesRoomSize(); ++i) {
            MXMIDIDevice device = new MXMIDIDevice(java, true, i);
            try {
                String name = device.getName();
                if (name.equals("Real Time Sequencer")) continue;
                temp.addNameAndValue(name, new MXMIDIIn(name, device));
                continue;
            }
            catch (Exception name) {
                // empty catch block
            }
        }
        MXMIDIDriverUWP uwp = MXMIDIDriverUWP._instance;
        for (int i = 0; i < uwp.InputDevicesRoomSize(); ++i) {
            MXMIDIDevice device = new MXMIDIDevice(uwp, true, i);
            Object name = device.getName();
            if (temp.indexOfName((String)name) >= 0) continue;
            name = (String)name + " (UWP)";
            temp.addNameAndValue((String)name, new MXMIDIIn((String)name, device));
        }
        this._listAllInput = temp;
        return this._listAllInput;
    }

    public MXMIDIIn findMIDIInput(String deviceName) {
        MXWrapList<MXMIDIIn> model = this.listAllInput();
        return model.valueOfName(deviceName);
    }

    public MXMIDIIn findMIDIInput(int assigned) {
        this.listSelectedInput();
        if (assigned >= 0) {
            return this._cache[assigned];
        }
        return null;
    }

    synchronized void onClose(MXMIDIIn input) {
        this.clearMIDIInCache();
    }

    protected synchronized void clearMIDIInCache() {
        this._listUsingInput = null;
        this._cache = null;
    }

    public synchronized MXWrapList<MXMIDIIn> listSelectedInput() {
        if (this._listUsingInput != null) {
            return this._listUsingInput;
        }
        this._cache = new MXMIDIIn[16];
        MXWrapList<MXMIDIIn> newInput = new MXWrapList<MXMIDIIn>();
        for (MXMIDIIn midi : this.listAllInput().valueList()) {
            if (midi.assigned() < 0) continue;
            newInput.addNameAndValue(midi.toString(), midi);
            this._cache[midi.assigned()] = midi;
        }
        this._listUsingInput = newInput;
        return newInput;
    }

    public synchronized void closeAll() {
        for (MXMIDIIn input : this.listSelectedInput().valueList()) {
            input.close();
        }
    }

    public synchronized boolean reserveInput(MXMIDIIn input, int assignnew) {
        MXWrapList<MXMIDIIn> list = this.listAllInput();
        if (input.assigned() >= 0 && input.assigned() == assignnew) {
            return true;
        }
        if (assignnew < 0) {
            input.close();
            this.clearMIDIInCache();
            input._assigned = assignnew;
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            MXMIDIIn x = list.valueOfIndex(i);
            if (x.assigned() != assignnew) continue;
            x._assigned = -1;
            x.close();
        }
        this.clearMIDIInCache();
        input._assigned = assignnew;
        return true;
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        setting.register("device[].name");
        setting.register("device[].open");
        setting.register("device[].toMaster");
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        TreeMap<String, MXMIDIIn> dummy = new TreeMap<String, MXMIDIIn>();
        for (int x = 0; x < 16; ++x) {
            MXWrapList<MXMIDIIn> detected;
            MXMIDIIn in;
            String deviceName = setting.getSetting("device[" + x + "].name");
            String deviceOpen = setting.getSetting("device[" + x + "].open");
            String deviceMaster = setting.getSetting("device[" + x + "].toMaster");
            if (deviceName == null) continue;
            if (deviceOpen == null) {
                deviceOpen = "0";
            }
            if ((in = (detected = this.listAllInput()).valueOfName(deviceName)) != null) {
                this.reserveInput(in, x);
                if (deviceOpen.equals("1")) {
                    in.open();
                }
            } else {
                in = new MXMIDIIn(deviceName, null);
                this.reserveInput(in, x);
                dummy.put(deviceName, in);
            }
            in.setMasterList(deviceMaster);
        }
        for (MXMIDIIn in : dummy.values()) {
            this._listAllInput.addNameAndValue(in.getName(), in);
        }
        this.clearMIDIInCache();
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        MXWrapList<MXMIDIIn> all = this.listAllInput();
        for (MXMIDIIn e : all.valueList()) {
            int x = e.assigned();
            if (x < 0) continue;
            setting.setSetting("device[" + x + "].name", e.getName());
            setting.setSetting("device[" + x + "].open", e.isOpen() ? "1" : "0");
            setting.setSetting("device[" + x + "].toMaster", e.getMasterList());
        }
    }
}

