/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.io.IOException;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.MXException;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIIn;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessage;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessageList;
import jp.synthtarou.midimixer.libs.midi.smf.SMFPlayer;
import jp.synthtarou.midimixer.libs.midi.smf.SMFPlayerCallback;
import jp.synthtarou.midimixer.mx00playlist.FileWithId;

public class MXMIDIInForPlayer
extends MXMIDIIn {
    private static final MXDebugLines _debug = new MXDebugLines(MXMIDIInForPlayer.class);
    FileWithId _file;
    private Callback _callback;
    long whenShow = 0L;
    private SMFPlayer _sequencer = null;
    private Thread _threadSeq = null;
    private boolean _gotBreak = false;
    boolean _skipAnother = false;
    int _forceSingleChannel = -1;
    int _firstNotePos = -1;

    public MXMIDIInForPlayer() {
        super("<PlayList>", null);
    }

    public void setOutPort(int outPort) {
        this.open();
        this._assigned = outPort;
    }

    public void openFile(FileWithId file) throws IOException, MidiUnavailableException, InvalidMidiDataException {
        int hi2;
        this._file = file;
        String fileName = file.toString();
        if (this._sequencer != null) {
            this._sequencer.stop();
            this._sequencer = null;
        }
        this._sequencer = new SMFPlayer(file._file);
        int _noteLowest = 200;
        int _noteHighest = 0;
        if (this.getCallback() != null) {
            this.getCallback().setSongName(fileName);
        }
        this._sequencer.setCallback(new SMFPlayerCallback(){

            @Override
            public void playingSMFNote(SMFMessage smf) {
                try {
                    int port = MXMIDIInForPlayer.this.assigned();
                    long timing = System.currentTimeMillis();
                    if (MXMIDIInForPlayer.this._callback != null && MXMIDIInForPlayer.this.whenShow + 1000L < timing) {
                        MXMIDIInForPlayer.this._callback.scoreProgress(MXMIDIInForPlayer.this._sequencer.getPosition(), MXMIDIInForPlayer.this._sequencer.getLength());
                        MXMIDIInForPlayer.this.whenShow = timing;
                    }
                    if (port >= 0) {
                        if (smf.isBinaryMessage()) {
                            MXMIDIInForPlayer.this.startMainPath(0, smf.getBinary());
                        } else {
                            int dword = smf.toDwordMessage();
                            if (MXMIDIInForPlayer.this._skipAnother) {
                                boolean skip = true;
                                int status = dword >> 16 & 0xFF;
                                int data1 = dword >> 8 & 0xFF;
                                int data2 = dword & 0xFF;
                                if (MXMIDIInForPlayer.this._forceSingleChannel >= 0 && status >= 128 && status <= 239) {
                                    status = status & 0xF0 | MXMIDIInForPlayer.this._forceSingleChannel;
                                }
                                switch (status & 0xF0) {
                                    case 128: 
                                    case 144: 
                                    case 224: {
                                        skip = false;
                                        break;
                                    }
                                    case 176: {
                                        if (data1 != 64 && data1 != 1 && data1 != 123 && data1 != 120) break;
                                        skip = false;
                                    }
                                }
                                if (skip) {
                                    return;
                                }
                            }
                            if (MXMIDIInForPlayer.this.getCallback() != null) {
                                MXMIDIInForPlayer.this.getCallback().updatePianoKeys(port, dword);
                            }
                            MXMIDIInForPlayer.this.startMainPath(smf.toDwordMessage(), null);
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        boolean[] existNoteChannel = new boolean[16];
        int[] programList = new int[16];
        ArrayList<Integer> drums = new ArrayList<Integer>();
        int firstNotePos = -1;
        ArrayList<SMFMessage> list = this._sequencer.getParser().getMessageList().listAll();
        for (int i = 0; i < list.size(); ++i) {
            int msg = 0;
            if (list.get(i).isBinaryMessage()) continue;
            try {
                msg = list.get(i).toDwordMessage();
            }
            catch (MXException e) {
                continue;
            }
            int status = msg >> 8 >> 8;
            int command = status & 0xF0;
            int ch = status & 0xF;
            int data1 = msg >> 8 & 0xFF;
            int data2 = msg & 0xFF;
            if (command == 144) {
                if (firstNotePos < 0) {
                    firstNotePos = i;
                }
                existNoteChannel[ch] = true;
                if (ch == 9 && data2 >= 1) {
                    drums.add(data1);
                    continue;
                }
                if (data1 < _noteLowest) {
                    _noteLowest = data1;
                }
                if (data1 <= _noteHighest) continue;
                _noteHighest = data1;
                continue;
            }
            if (command != 192 || programList[ch] >= 0) continue;
            programList[ch] = data1;
        }
        int lo2 = _noteLowest;
        lo2 /= 12;
        for (hi2 = lo2 *= 12; hi2 < _noteHighest; hi2 += 12) {
        }
        int x = lo2 / 12;
        int width = hi2 / 12;
        width -= x;
        x *= 12;
        if (width <= 2) {
            if (x >= 12) {
                x -= 12;
                ++width;
            }
            if (width <= 2) {
                ++width;
            }
        }
        boolean rows = false;
        int[] drumProgs = new int[drums.size()];
        for (int id = 0; id < drums.size(); ++id) {
            drumProgs[id] = (Integer)drums.get(id);
        }
        if (this.getCallback() != null) {
            this.getCallback().createPianoControls(lo2, width, existNoteChannel, programList, drumProgs);
        }
        this._firstNotePos = firstNotePos;
    }

    public static String[] readFileInfo(FileWithId file) {
        ArrayList<Object> ret = new ArrayList<Object>();
        String fileName = file.toString();
        try {
            SMFPlayer player = new SMFPlayer(file._file);
            SMFMessageList list = player.getParser().getMessageList();
            ArrayList<SMFMessage> listMessage = list.listAll();
            for (SMFMessage message : listMessage) {
                if (message.getStatus() != 255) continue;
                int type = message.getDataType();
                byte[] data = message.getBinary();
                String text = null;
                try {
                    text = new String(data, "ASCII");
                    text = new String(data);
                    text = new String(data, "SJIS");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int number = 0;
                switch (type) {
                    case 0: {
                        if (data.length < 2) break;
                        number = data[0] * 128 + data[1];
                        ret.add("Sequence Number : " + number);
                        break;
                    }
                    case 1: {
                        ret.add("Text : " + text);
                        break;
                    }
                    case 2: {
                        ret.add("Copyright : " + text);
                        break;
                    }
                    case 3: {
                        ret.add("Track Name : " + text);
                    }
                }
            }
        }
        catch (Exception e) {
            ret.add("Can't open [" + file.toString() + "]");
            ret.add(e.toString());
        }
        String[] list = new String[ret.size()];
        ret.toArray(list);
        return list;
    }

    public long getLength() {
        return this._sequencer.getLength();
    }

    public int getFirstNotePos() {
        if (this._firstNotePos < 0) {
            ArrayList<SMFMessage> list = this._sequencer.getParser().getMessageList().listAll();
            int pos = 0;
            for (SMFMessage smf : list) {
                int command = smf.getStatus();
                if ((command & 0xF0) == 144) {
                    this._firstNotePos = pos;
                    break;
                }
                ++pos;
            }
            if (this._firstNotePos < 0) {
                this._firstNotePos = 0;
            }
        }
        return this._firstNotePos >= 0 ? this._firstNotePos : 0;
    }

    public void setOnlyNotePitchWheel(boolean skipAnother) {
        this._skipAnother = skipAnother;
    }

    public void setPlayAsSingleChannel(int channel) {
        this._forceSingleChannel = channel;
    }

    public synchronized void startSequencer() {
        this.stopSequencer();
        this._gotBreak = false;
        this._threadSeq = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (MXMIDIInForPlayer.this.getCallback() != null) {
                        MXMIDIInForPlayer.this.getCallback().scoreStart(MXMIDIInForPlayer.this._file);
                        MXMIDIInForPlayer.this.getCallback().scoreProgress(0, MXMIDIInForPlayer.this._sequencer.getLength());
                    }
                    MXMIDIInForPlayer.this._sequencer.start();
                    try {
                        MXMIDIInForPlayer.this._sequencer.stop();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!MXMIDIInForPlayer.this._gotBreak && MXMIDIInForPlayer.this.getCallback() != null) {
                        MXMIDIInForPlayer.this.getCallback().scoreDone(MXMIDIInForPlayer.this._file);
                        MXMIDIInForPlayer.this.getCallback().scoreProgress(MXMIDIInForPlayer.this._sequencer.getLength(), MXMIDIInForPlayer.this._sequencer.getLength());
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        this._threadSeq.start();
    }

    public FileWithId getCurrent() {
        return this._file;
    }

    public synchronized boolean isSequencerPlaying() {
        return this._threadSeq != null && this._threadSeq.isAlive();
    }

    public synchronized void stopSequencer() {
        if (this._threadSeq != null && this._threadSeq.isAlive()) {
            try {
                this._gotBreak = true;
                this._threadSeq.interrupt();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void waitSequencerDone() {
        while (this._threadSeq != null && this._threadSeq.isAlive()) {
            try {
                this._gotBreak = true;
                this.wait(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean hasGotBreak() {
        return this._gotBreak;
    }

    public void setCurrentPos(int pos) {
        this._sequencer.setPosition(pos);
    }

    public Callback getCallback() {
        return this._callback;
    }

    public void setCallback(Callback _callback) {
        this._callback = _callback;
    }

    public static interface Callback {
        public void scoreStart(FileWithId var1);

        public void scoreProgress(int var1, int var2);

        public void scoreDone(FileWithId var1);

        public void setSongName(String var1);

        public void updatePianoKeys(int var1, int var2);

        public void createPianoControls(int var1, int var2, boolean[] var3, int[] var4, int[] var5);
    }
}

