/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.driver;

import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDriver;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDriverReceiver;

public class MXMIDIDriverJava
implements MXMIDIDriver {
    public static final MXMIDIDriverJava _instance = new MXMIDIDriverJava();
    ArrayList<MidiDevice> _listInput;
    ArrayList<MidiDevice> _listOutput;
    MXMIDIDriverReceiver _inputReceiver;

    @Override
    public boolean isUsable() {
        return true;
    }

    @Override
    public void StartLibrary() {
        this.listAllInput();
        this.listAllOutput();
    }

    @Override
    public void InputSetReceiver(MXMIDIDriverReceiver receiver) {
        this._inputReceiver = receiver;
    }

    public synchronized void listAllInput() {
        if (this._listInput != null) {
            return;
        }
        ArrayList<MidiDevice> newList = new ArrayList<MidiDevice>();
        MidiDevice.Info[] infoList = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infoList.length; ++i) {
            MidiDevice device = null;
            try {
                device = MidiSystem.getMidiDevice(infoList[i]);
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
                continue;
            }
            if (device.getMaxTransmitters() == 0) continue;
            try {
                String name = device.getDeviceInfo().getName();
                if (name.equals("Real Time Sequencer")) continue;
                newList.add(device);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._listInput = newList;
    }

    public synchronized void listAllOutput() {
        if (this._listOutput != null) {
            return;
        }
        ArrayList<MidiDevice> newList = new ArrayList<MidiDevice>();
        MidiDevice.Info[] infoList = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infoList.length; ++i) {
            String name;
            MidiDevice device = null;
            try {
                device = MidiSystem.getMidiDevice(infoList[i]);
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
                continue;
            }
            if (device.getMaxReceivers() == 0 || (name = device.getDeviceInfo().getName()).equals("Real Time Sequencer")) continue;
            newList.add(device);
        }
        this._listOutput = newList;
    }

    @Override
    public int InputDevicesRoomSize() {
        this.listAllInput();
        return this._listInput.size();
    }

    @Override
    public String InputDeviceName(int x) {
        this.listAllInput();
        MidiDevice device = this._listInput.get(x);
        return device.getDeviceInfo().getName();
    }

    @Override
    public String InputDeviceId(int x) {
        this.listAllInput();
        return this.InputDeviceName(x);
    }

    @Override
    public boolean InputDeviceIsOpen(int x) {
        this.listAllInput();
        return this._listInput.get(x).isOpen();
    }

    @Override
    public boolean InputDeviceOpen(int x) {
        this.listAllInput();
        if (!this._listInput.get(x).isOpen()) {
            try {
                this._listInput.get(x).open();
                this._listInput.get(x).getTransmitter().setReceiver(new InputReceiver(x));
            }
            catch (MidiUnavailableException e) {
                return false;
            }
        }
        return this._listInput.get(x).isOpen();
    }

    @Override
    public boolean InputDeviceQueryOpen(int x) {
        this.listAllInput();
        this.InputDeviceOpen(x);
        return true;
    }

    @Override
    public boolean InputDeviceWaitDoneOpening(int device, long timeout) {
        this.listAllInput();
        return false;
    }

    @Override
    public boolean InputDeviceClose(int x) {
        this.listAllInput();
        if (!this._listInput.get(x).isOpen()) {
            return false;
        }
        this._listInput.get(x).close();
        return true;
    }

    @Override
    public int OutputDevicesRoomSize() {
        this.listAllOutput();
        return this._listOutput.size();
    }

    @Override
    public String OutputDeviceName(int x) {
        this.listAllOutput();
        return this._listOutput.get(x).getDeviceInfo().getName();
    }

    @Override
    public String OutputDeviceId(int x) {
        this.listAllOutput();
        return this.OutputDeviceName(x);
    }

    @Override
    public boolean OutputDeviceIsOpen(int x) {
        this.listAllOutput();
        return this._listOutput.get(x).isOpen();
    }

    @Override
    public boolean OutputDeviceOpen(int x) {
        this.listAllOutput();
        if (!this._listOutput.get(x).isOpen()) {
            try {
                this._listOutput.get(x).open();
            }
            catch (MidiUnavailableException e) {
                return false;
            }
        }
        return this._listOutput.get(x).isOpen();
    }

    @Override
    public boolean OutputDeviceQueryOpen(int x) {
        this.listAllOutput();
        return this.OutputDeviceOpen(x);
    }

    @Override
    public boolean OutputDeviceWaitDoneOpening(int x, long timeout) {
        this.listAllOutput();
        return false;
    }

    @Override
    public boolean OutputDeviceClose(int x) {
        this.listAllOutput();
        if (!this._listOutput.get(x).isOpen()) {
            return false;
        }
        this._listOutput.get(x).close();
        return true;
    }

    @Override
    public boolean OutputShortMessage(int x, int message) {
        this.listAllOutput();
        int status = message >> 8 >> 8 & 0xFF;
        int data1 = message >> 8 & 0xFF;
        int data2 = message & 0xFF;
        if (this._listOutput.get(x).isOpen()) {
            try {
                ShortMessage msg = new ShortMessage(status, data1, data2);
                this._listOutput.get(x).getReceiver().send(msg, 0L);
                return true;
            }
            catch (Throwable e) {
                System.out.println("Unknown Message: " + MXUtil.toHexFF(status) + "  " + MXUtil.toHexFF(data1) + " " + MXUtil.toHexFF(data2));
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean OutputLongMessage(int x, byte[] data) {
        this.listAllOutput();
        if (data == null || data.length == 0) {
            return true;
        }
        try {
            int status = data[0] & 0xFF;
            switch (status) {
                case 240: 
                case 247: {
                    byte[] newData = new byte[data.length - 1];
                    for (int i = 1; i < data.length; ++i) {
                        newData[i - 1] = data[i];
                    }
                    try {
                        SysexMessage msg = new SysexMessage(data[0] & 0xFF, newData, newData.length);
                        this._listOutput.get(x).getReceiver().send(msg, 0L);
                    }
                    catch (InvalidMidiDataException e) {
                        System.out.println("Bug Message " + MXUtil.dumpHexFF(data));
                    }
                    break;
                }
                case 255: {
                    break;
                }
                default: {
                    if (data.length <= 3) {
                        byte data2;
                        byte data1 = data.length >= 2 ? data[1] : (byte)0;
                        byte by = data2 = data.length >= 3 ? data[2] : (byte)0;
                        if (this._listOutput.get(x).isOpen()) {
                            try {
                                ShortMessage msg3 = new ShortMessage(status & 0xFF, data1 & 0xFF, data2 & 0xFF);
                                this._listOutput.get(x).getReceiver().send(msg3, 0L);
                                return true;
                            }
                            catch (InvalidMidiDataException msg3) {
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    class InputReceiver
    implements Receiver {
        int _port;

        public InputReceiver(int port) {
            this._port = port;
        }

        @Override
        public void send(MidiMessage msg, long timestamp) {
            if (msg instanceof ShortMessage) {
                ShortMessage shortMsg = (ShortMessage)msg;
                int status = shortMsg.getStatus() & 0xFF;
                int data1 = shortMsg.getData1() & 0xFF;
                int data2 = shortMsg.getData2() & 0xFF;
                if (status == 255 || status == 254) {
                    return;
                }
                int x = (status << 8 | data1) << 8 | data2;
                MXTraceNumber traceNumber = new MXTraceNumber();
                MXMIDIDriverJava.this._inputReceiver.DoShortMessage(this._port, traceNumber, x);
            } else {
                byte[] data = msg.getMessage();
                MXTraceNumber traceNUmber = new MXTraceNumber();
                MXMIDIDriverJava.this._inputReceiver.DoLongMessage(this._port, traceNUmber, data);
            }
        }

        @Override
        public void close() {
            MXMIDIDriverJava.this.InputDeviceClose(this._port);
        }
    }
}

