/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.driver;

import jp.synthtarou.midimixer.libs.MultiThreadQueue;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDriver;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDriverReceiver;

public class MXMIDIDevice {
    int _deviveNumber;
    MXMIDIDriver _driver;
    boolean _isInput;
    OutputThread _outputThread = null;
    boolean _tryThread = false;

    public MXMIDIDevice(MXMIDIDriver driver, boolean isInput, int deviveNumber) {
        this._driver = driver;
        this._isInput = isInput;
        this._deviveNumber = deviveNumber;
    }

    private MXMIDIDriver getDriver() {
        return this._driver;
    }

    private int getDeviceNumber() {
        return this._deviveNumber;
    }

    public void open() {
        if (this._isInput) {
            this._driver.InputDeviceOpen(this._deviveNumber);
        } else {
            this._driver.OutputDeviceOpen(this._deviveNumber);
            if (this._tryThread) {
                this._outputThread = new OutputThread();
                new Thread(this._outputThread).start();
            }
        }
    }

    public void setInputReceiver(MXMIDIDriverReceiver receiver) {
        this._driver.InputSetReceiver(receiver);
    }

    public void close() {
        if (this._isInput) {
            this._driver.InputDeviceClose(this._deviveNumber);
        } else {
            this._driver.OutputDeviceClose(this._deviveNumber);
            if (this._outputThread != null) {
                this._outputThread.quit();
            }
        }
    }

    public boolean isOpen() {
        if (this._isInput) {
            return this._driver.InputDeviceIsOpen(this._deviveNumber);
        }
        return this._driver.OutputDeviceIsOpen(this._deviveNumber);
    }

    public String getName() {
        if (this._isInput) {
            return this._driver.InputDeviceName(this._deviveNumber);
        }
        return this._driver.OutputDeviceName(this._deviveNumber);
    }

    public void OutputShortMessage(int dword) {
        if (!this._isInput) {
            if (this._outputThread != null) {
                this._outputThread.push(new OutputElement(dword));
            } else {
                if (!this._driver.OutputDeviceIsOpen(this._deviveNumber)) {
                    new IllegalStateException().printStackTrace();
                }
                this._driver.OutputShortMessage(this._deviveNumber, dword);
            }
        }
    }

    public void OutputLongMessage(byte[] data) {
        if (!this._isInput) {
            if (this._outputThread != null) {
                this._outputThread.push(new OutputElement(data));
            } else {
                this._driver.OutputLongMessage(this._deviveNumber, data);
            }
        }
    }

    synchronized void OutputInternal(OutputElement elem) {
        if (elem._isBinary) {
            this._driver.OutputLongMessage(this._deviveNumber, elem._data);
        } else {
            this._driver.OutputShortMessage(this._deviveNumber, elem._dword);
        }
    }

    class OutputThread
    implements Runnable {
        MultiThreadQueue<OutputElement> _queue = new MultiThreadQueue();
        boolean _finish = false;

        public void push(OutputElement elem) {
            this._queue.push(elem);
        }

        @Override
        public void run() {
            try {
                Thread.currentThread().setPriority(10);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            OutputElement e;
            while ((e = this._queue.pop()) != null) {
                try {
                    if (e._isBinary) {
                        MXMIDIDevice.this._driver.OutputLongMessage(MXMIDIDevice.this._deviveNumber, e._data);
                        continue;
                    }
                    MXMIDIDevice.this._driver.OutputShortMessage(MXMIDIDevice.this._deviveNumber, e._dword);
                    continue;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
            return;
        }

        public void quit() {
            this._queue.quit();
        }
    }

    class OutputElement {
        boolean _isBinary = false;
        int _dword;
        byte[] _data;

        public OutputElement(int dword) {
            this._dword = dword;
            this._isBinary = false;
        }

        public OutputElement(byte[] data) {
            this._data = data;
            this._isBinary = true;
        }
    }
}

