/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

public class MXTraceNumber
implements Comparable<MXTraceNumber> {
    public final long _clock;
    public final int _order;
    public final Throwable _traceBirthDay;
    long[] _thisWrap = new long[10];
    static long _lastClock = 0L;
    static int _lastOrder = 0;
    static long[] _totalWrap = new long[10];
    static long[] _totalBottom = new long[10];
    static long[] _totalCount = new long[10];

    public String toString() {
        return this._clock + ":" + this._order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MXTraceNumber() {
        Class<MXTraceNumber> clazz = MXTraceNumber.class;
        synchronized (MXTraceNumber.class) {
            long t = System.currentTimeMillis();
            if (t < _lastClock) {
                System.err.print(" --- something bad --- (never happens before)");
                t = _lastClock;
            }
            this._clock = t;
            if (this._clock != _lastClock) {
                _lastClock = this._clock;
                _lastOrder = 0;
            }
            this._order = _lastOrder++;
            this._traceBirthDay = new Throwable(this._clock + "(" + this._order + ")");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int compareTo(MXTraceNumber o) {
        if (o == null) {
            return -1;
        }
        if (this._clock < o._clock) {
            return -1;
        }
        if (this._clock > o._clock) {
            return 1;
        }
        if (this._order < o._order) {
            return -1;
        }
        if (this._order > o._order) {
            return 1;
        }
        return 0;
    }

    public long recordWrap(int selector) {
        long wrap;
        this._thisWrap[selector] = wrap = System.currentTimeMillis() - this._clock;
        int n = selector;
        _totalWrap[n] = _totalWrap[n] + wrap;
        int n2 = selector;
        _totalCount[n2] = _totalCount[n2] + 1L;
        if (_totalBottom[selector] < wrap) {
            MXTraceNumber._totalBottom[selector] = wrap;
        }
        return wrap;
    }

    public long thisWrap(int selector) {
        return this._thisWrap[selector];
    }

    public static long totalWrap(int selector) {
        return _totalWrap[selector];
    }

    public static long totalCount(int selector) {
        return _totalCount[selector];
    }

    public static long totalBottom(int selector) {
        return _totalBottom[selector];
    }
}

