/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.io.PrintStream;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXMessageTemplate;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.mx70console.ConsoleElement;

public final class MXMessage {
    private MXVisitant _visitant;
    private static final MXDebugLines _debug = new MXDebugLines(MXMessage.class);
    public MXTraceNumber _traceNumber;
    int _port;
    private int _value = -1;
    private int _gate = -1;
    private int _channel = 0;
    protected byte[] _dataBytes = null;
    private boolean _value14bit;
    private final MXMessageTemplate _template;
    private int _metaType;
    public String _metaText;

    public boolean isBinMessage() {
        if (this.createBytes() == null) {
            return false;
        }
        if (this._template.size() == 3) {
            int b = this._dataBytes[0] & 0xFF;
            if (b >= 128 && b <= 255) {
                switch (b) {
                    case 240: 
                    case 247: {
                        return true;
                    }
                }
                return false;
            }
            int c = this._template.get(0);
            if (c == 20480 || c == 20736) {
                return false;
            }
        }
        return true;
    }

    public boolean canPaired14bit() {
        int cc;
        if (this.createBytes() == null) {
            return false;
        }
        if (this.hasValueHiField()) {
            return this.hasGateLowField();
        }
        return this.getCommand() == 176 && (cc = this.getGate()) >= 0 && cc <= 31;
    }

    public boolean isValue14bit() {
        return this._value14bit;
    }

    public void setValue14bit(boolean value14bit) {
        if (this._value14bit != value14bit) {
            int value = this.getValue();
            if (!value14bit && value >= 128) {
                this.setValue(127);
            }
        }
        this._value14bit = value14bit;
    }

    public MXVisitant getVisitant() {
        return this._visitant;
    }

    public void setVisitant(MXVisitant visitant) {
        this._visitant = visitant;
        this._dataBytes = null;
    }

    public byte[] createBytes() {
        if (this._dataBytes != null) {
            return this._dataBytes;
        }
        if (this._template == null) {
            return null;
        }
        this._dataBytes = this._template.makeBytes(this._dataBytes, this);
        return this._dataBytes;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        if (this._port != port) {
            this._port = port;
        }
    }

    public int getStatus() {
        if (this.createBytes() == null) {
            return 0;
        }
        int status = this._dataBytes[0] & 0xFF;
        return status;
    }

    public int getCommand() {
        if (this.createBytes() == null) {
            return 0;
        }
        int status = this._dataBytes[0] & 0xFF;
        if (status >= 128 && status <= 224) {
            return status & 0xF0;
        }
        return status;
    }

    public void setChannel(int channel) {
        if (this._channel != channel) {
            this._dataBytes = null;
            this._channel = channel;
        }
    }

    public int getData1() {
        if (this.createBytes() == null) {
            return 0;
        }
        if (this._dataBytes.length > 1) {
            return this._dataBytes[1] & 0xFF;
        }
        return 0;
    }

    public int getData2() {
        if (this.createBytes() == null) {
            return 0;
        }
        if (this._dataBytes.length > 2) {
            return this._dataBytes[2] & 0xFF;
        }
        return 0;
    }

    public int getChannel() {
        if (this._channel < 0 || this._channel > 15) {
            _debug.println("getAsChannel " + this._channel);
            return 0;
        }
        return this._channel;
    }

    public int getValue() {
        return this._value;
    }

    public void setValue(int value) {
        if (value != this._value) {
            this._value = value;
            this._dataBytes = null;
        }
    }

    public int getGate() {
        return this._gate;
    }

    public void setGate(int gate) {
        if (gate != this._gate) {
            this._gate = gate;
            this._dataBytes = null;
        }
    }

    public int getMetaType() {
        return this._metaType;
    }

    public void setMetaType(int metaCode) {
        if (metaCode != this._metaType) {
            this._metaType = metaCode;
            this._dataBytes = null;
        }
    }

    protected MXMessage(int port, MXTraceNumber traceNumber, MXMessageTemplate template) {
        this(port, traceNumber, template, 0, 0);
    }

    protected MXMessage(int port, MXTraceNumber traceNumber, MXMessageTemplate template, int gate, int value) {
        this._port = port;
        this._template = template;
        this._traceNumber = traceNumber;
        this._gate = gate;
        this._value = value;
        if (this._template != null && this._template.size() > 0 && this._template.get(0) == 255) {
            this._metaType = this._template.get(1);
        }
    }

    protected MXMessage(int port, MXTraceNumber traceNumber, int[] template, int gate, int value) {
        this(port, traceNumber, new MXMessageTemplate(template), gate, value);
        if ((template[0] & 0xFFF0) == 176) {
            int data2;
            int data1 = template[1];
            if ((data1 & 0xFF00) == 0) {
                this._gate = data1;
                template[1] = 1024;
            }
            if (((data2 = template[2]) & 0xFF00) == 0) {
                this._value = data2;
                template[2] = 512;
            }
        }
    }

    public byte[] getDataBytes() {
        this.createBytes();
        return this._dataBytes;
    }

    public boolean isMessageTypeChannel() {
        this.createBytes();
        return !this.isBinMessage() && this.getCommand() >= 128 && this.getCommand() <= 224;
    }

    public boolean isMessageTypeSystemKnown() {
        this.createBytes();
        if (!this.isBinMessage()) {
            if (this.getCommand() >= 128 && this.getCommand() <= 224) {
                return true;
            }
            if (this.getCommand() >= 240 && this.getCommand() <= 254) {
                return true;
            }
        }
        return false;
    }

    public boolean isDataentry() {
        this.createBytes();
        if (this._template.isDataentry()) {
            return true;
        }
        if (!this.isBinMessage() && this.getCommand() == 176) {
            switch (this.getData1()) {
                case 6: 
                case 96: 
                case 97: {
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        String str = this.toStringHeader();
        if (this.getCommand() == 192) {
            return str + "(" + this.getGate() + ")";
        }
        return str + "(" + this.getValue() + ")";
    }

    public String toStringHeader(int min, int max) {
        String str = this.toStringHeader();
        if (min != max) {
            return str + "= Range" + min + " to " + max;
        }
        return str + "= " + max;
    }

    public String toStringHeader() {
        if (this.createBytes() == null) {
            return "";
        }
        int port = this.getPort();
        switch (this._dataBytes[0]) {
            case 255: {
                return "Meta [" + this.getMetaType() + ":" + this._metaText + "]";
            }
            case 240: {
                return "Sysex [" + MXUtil.dumpHexFF(this.getDataBytes()) + "]";
            }
            case 247: {
                return "SysexSpecial [" + MXUtil.dumpHexFF(this.getDataBytes()) + "]";
            }
        }
        if (this.isDataentry()) {
            int r1 = this.toDataroomMSB1();
            int r2 = this.toDataroomLSB2();
            int d1 = this.toDatavalueMSB1();
            int d2 = this.toDatavalueLSB2();
            return ConsoleElement.toSegmentText(r1) + ConsoleElement.toSegmentText(r2) + ConsoleElement.toSegmentText(d1) + ConsoleElement.toSegmentText(d2);
        }
        if (this.isBinMessage()) {
            return "Binary[" + MXUtil.dumpHexFF(this.getDataBytes()) + "]";
        }
        int dword = (this.getStatus() << 8 | this.getData1()) << 8 | this.getData2();
        return ConsoleElement.toSegmentText(dword);
    }

    public String toShortString() {
        Object chname;
        if (this.createBytes() == null) {
            return "";
        }
        if (this.isMessageTypeChannel()) {
            int channel = this.getChannel();
            chname = "" + (channel + 1);
        } else {
            chname = "";
        }
        switch (this._dataBytes[0]) {
            case 240: {
                return "Sys";
            }
            case 247: {
                return "Sys2";
            }
            case 255: {
                return "Meta";
            }
        }
        if (this.isBinMessage()) {
            return "???";
        }
        int command = this.getCommand();
        if (command == 176) {
            int data1 = this.getData1();
            if (data1 == 6 && this._visitant != null) {
                if (this._visitant.isHaveDataentryRPN()) {
                    return (String)chname + "RPN[" + MXUtil.toHexFF(this._visitant.getDataroomMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataroomLSB()) + "]";
                }
                if (this._visitant.isHaveDataentryNRPN()) {
                    return (String)chname + "NRPN[" + MXUtil.toHexFF(this._visitant.getDataroomMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataroomLSB()) + "]";
                }
            } else if (data1 == 96 && this._visitant != null) {
                if (this._visitant.isHaveDataentryRPN()) {
                    return (String)chname + "RPN[" + MXUtil.toHexFF(this._visitant.getDataroomMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataroomLSB()) + "]+";
                }
                if (this._visitant.isHaveDataentryNRPN()) {
                    return (String)chname + "NRPN[" + MXUtil.toHexFF(this._visitant.getDataroomMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataroomLSB()) + "]+";
                }
            } else if (data1 == 97 && this._visitant != null) {
                if (this._visitant.isHaveDataentryRPN()) {
                    return (String)chname + "RPN[" + MXUtil.toHexFF(this._visitant.getDataroomMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataroomLSB()) + "]-";
                }
                if (this._visitant.isHaveDataentryNRPN()) {
                    return (String)chname + "NRPN[" + MXUtil.toHexFF(this._visitant.getDataroomMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataroomLSB()) + "]-";
                }
            }
            return (String)chname + MXUtilMidi.nameOfControlChange(data1);
        }
        if (command == 128) {
            int note = this.getGate();
            int velocity = this.getValue();
            return (String)chname + MXUtilMidi.nameOfNote(note) + "-";
        }
        if (command == 144) {
            int note = this.getGate();
            int velocity = this.getValue();
            return (String)chname + MXUtilMidi.nameOfNote(note);
        }
        if (command == 160) {
            int note = this.getGate();
            int velocity = this.getValue();
            return (String)chname + "PPrs";
        }
        if (command == 192) {
            int program = this.getGate();
            return (String)chname + "PG" + program;
        }
        if (command == 208) {
            return (String)chname + "ChPrs";
        }
        if (command == 224) {
            return (String)chname + "Pitch";
        }
        if (command == 242) {
            return (String)chname + "Pos";
        }
        if (command == 243) {
            return (String)chname + "Song";
        }
        if (this.isMessageTypeChannel()) {
            return (String)chname + MXUtilMidi.nameOfMessage(this.getStatus(), this.getData1(), this.getData2());
        }
        return MXUtilMidi.nameOfMessage(this.getStatus(), this.getData1(), this.getData2());
    }

    public static void main(String[] args) {
        MXMessage message = MXMessageFactory.fromShortMessage(0, new MXTraceNumber(), 144, 64, 127);
        String dtext = message._template.toDText(message);
        MXMessageTemplate template = MXMessageFactory.fromDtext(dtext, message.getChannel());
        MXMessage msg = template.bind(message._traceNumber, message.getPort(), message.getGate(), message.getValue());
        PrintStream output = System.out;
        output.println(message);
        output.println(dtext);
        output.println(msg);
        msg.setPort(6);
        msg.setChannel(2);
        msg.setValue(100);
        output.println(msg);
        output.println("----------------");
        MXMessage message2 = MXMessageFactory.fromShortMessage(0, new MXTraceNumber(), 177, 7, 127);
        output.println(message2);
        String dtext2 = message2._template.toDText(message2);
        MXMessageTemplate template2 = MXMessageFactory.fromDtext(dtext2, message2.getChannel());
        MXMessage msg2 = template.bind(message2._traceNumber, message2.getPort(), message2.getGate(), message2.getValue());
        output.println(dtext2);
        output.println(msg2);
        msg2.setPort(6);
        msg2.setChannel(2);
        msg2.setValue(100);
        output.println(msg2);
        output.println("----------------");
    }

    public void debugDump(String func) {
        PrintStream output = System.out;
        StringBuffer buf = new StringBuffer();
        buf.append(func + " debugDump [template = ");
        buf.append(this._template.toDArray(this));
        buf.append("] bytes = [ ");
        byte[] b = this.getDataBytes();
        for (int i = 0; i < b.length; ++i) {
            buf.append(MXUtil.toHexFF(b[i]) + " ");
        }
        buf.append("]");
        buf.append(" gate = " + this.getGate());
        buf.append(" value = " + this.getValue());
        output.println(buf);
    }

    public String toDumpString() {
        this.createBytes();
        if (this.isMessageTypeChannel()) {
            int channel = this.getChannel();
            String chname = Integer.toString(channel + 1);
        } else {
            String chname = "";
        }
        if (this.isBinMessage() && this._dataBytes[0] == 255) {
            return this._metaText;
        }
        return MXUtil.dumpHexFF(this._dataBytes);
    }

    public int importBytesUseTemplate(MXMessage message) {
        byte[] data = message.createBytes();
        this.createBytes();
        this._template.initFields();
        byte vl = this._template.getBytePosValue() >= 0 ? data[this._template.getBytePosValue()] : (byte)0;
        byte vh = this._template.getBytePosHiValue() >= 0 ? data[this._template.getBytePosHiValue()] : (byte)0;
        byte gl = this._template.getBytePosGate() >= 0 ? data[this._template.getBytePosGate()] : (byte)0;
        byte gh = this._template.getBytePosHiGate() >= 0 ? data[this._template.getBytePosHiGate()] : (byte)0;
        this._value = (vh & 0x7F) << 7 | vl & 0x7F;
        this._gate = (gh & 0x7F) << 7 | gl & 0x7F;
        return this._value;
    }

    public int getDwordCount() {
        if (this.isDataentry()) {
            MXVisitant visit = this.getVisitant();
            if (visit != null) {
                if (visit.isHaveDataentryRPN()) {
                    return 4;
                }
                if (visit.isHaveDataentryNRPN()) {
                    return 4;
                }
            }
            return -1;
        }
        if (this.isBinMessage()) {
            return 0;
        }
        if (this._template == null || this._template.size() == 0) {
            return 0;
        }
        if (this._template.get(0) == 20480 || this._template.get(0) == 20736) {
            return 3;
        }
        if (this.getCommand() == 176 && this.isValue14bit()) {
            return 2;
        }
        return 1;
    }

    public int getAsDword(int column) {
        if (this.isDataentry()) {
            switch (column) {
                case 0: {
                    return this.toDataroomMSB1();
                }
                case 1: {
                    return this.toDataroomLSB2();
                }
                case 2: {
                    return this.toDatavalueMSB1();
                }
                case 3: {
                    return this.toDatavalueLSB2();
                }
            }
            return 0;
        }
        if (!this.isBinMessage()) {
            int status = this.getStatus();
            int data1 = this.getData1();
            int data2 = this.getData2();
            if (this.getCommand() == 176 && this.isValue14bit()) {
                if (column == 0) {
                    data2 = this.getValue() >> 7 & 0x7F;
                } else {
                    data1 += 32;
                    data2 = this.getValue() & 0x7F;
                }
            }
            return status << 16 | data1 << 8 | data2;
        }
        return 0;
    }

    public int toDataroomMSB1() {
        if (this.getVisitant() == null) {
            return 0;
        }
        if (this.getVisitant().isHaveDataentryRPN()) {
            int status = 176 + this.getChannel();
            int data1 = 101;
            int data2 = this.getVisitant().getDataroomMSB();
            return (status << 8 | data1) << 8 | data2;
        }
        if (this.getVisitant().isHaveDataentryNRPN()) {
            int status = 176 + this.getChannel();
            int data1 = 99;
            int data2 = this.getVisitant().getDataroomMSB();
            return (status << 8 | data1) << 8 | data2;
        }
        return 0;
    }

    public int toDataroomLSB2() {
        if (this.getVisitant() == null) {
            return 0;
        }
        if (this.getVisitant().isHaveDataentryRPN()) {
            int status = 176 + this.getChannel();
            int data1 = 100;
            int data2 = this.getVisitant().getDataroomLSB();
            return (status << 8 | data1) << 8 | data2;
        }
        if (this.getVisitant().isHaveDataentryNRPN()) {
            int status = 176 + this.getChannel();
            int data1 = 98;
            int data2 = this.getVisitant().getDataroomLSB();
            return (status << 8 | data1) << 8 | data2;
        }
        return 0;
    }

    public int toDatavalueMSB1() {
        if (this.getVisitant() == null) {
            return 0;
        }
        if (this.getVisitant().isHaveDataentryRPN() || this.getVisitant().isHaveDataentryNRPN()) {
            int status = 176 + this.getChannel();
            int data1 = 6;
            int data2 = this.getVisitant().getDataentryMSB();
            return (status << 8 | data1) << 8 | data2;
        }
        return 0;
    }

    public int toDatavalueLSB2() {
        if (this.getVisitant() == null) {
            return 0;
        }
        if (this.getVisitant().isHaveDataentryRPN() || this.getVisitant().isHaveDataentryNRPN()) {
            int status = 176 + this.getChannel();
            int data1 = 38;
            int data2 = this.getVisitant().getDataentryLSB();
            return (status << 8 | data1) << 8 | data2;
        }
        return 0;
    }

    public String toDText() {
        if (this._template == null) {
            return "";
        }
        return this._template.toDText(this);
    }

    public boolean hasValueHiField() {
        if (this._template == null) {
            return false;
        }
        return this._template.getBytePosHiValue() >= 0;
    }

    public boolean hasValueLowField() {
        if (this._template == null) {
            return false;
        }
        return this._template.getBytePosValue() >= 0;
    }

    public boolean hasGateLowField() {
        if (this._template == null) {
            return false;
        }
        return this._template.getBytePosGate() >= 0;
    }

    public boolean hasGateHiField() {
        if (this._template == null) {
            return false;
        }
        return this._template.getBytePosHiGate() >= 0;
    }

    public boolean isValue14Bit() {
        if (this._template == null) {
            return false;
        }
        return this._template.getBytePosValue() >= 0 && this._template.getBytePosHiValue() >= 0;
    }

    public int getTemplate(int pos) {
        if (this._template == null) {
            return -1;
        }
        return this._template.get(pos);
    }

    public Object clone() {
        MXMessage message = this._template == null ? new MXMessage(this._port, this._traceNumber, null) : new MXMessage(this._port, this._traceNumber, (MXMessageTemplate)this._template.clone());
        message.setValue(this.getValue());
        message.setGate(this.getGate());
        message.setChannel(this.getChannel());
        message.setVisitant(this.getVisitant());
        message.setValue14bit(this.isValue14bit());
        return message;
    }
}

