/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.domino.unreach;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class DOMTest
extends DefaultHandler {
    private static final MXDebugLines _debug = new MXDebugLines(DOMTest.class);

    public static String getChildText(Node node) {
        NodeList childList = node.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node n = childList.item(i);
            short childType = n.getNodeType();
            if (childType != 3) continue;
            return DOMTest.cutspace(n.getNodeValue());
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        MXDebugLines.globalSwitchOn();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new File("c:/java/GMLevel1.xml"));
        Element bookList = document.getDocumentElement();
        ArrayList<Node> process = new ArrayList<Node>();
        process.add(document.getDocumentElement());
        block9: while (process.size() > 0) {
            Node node = (Node)process.get(process.size() - 1);
            process.remove(process.size() - 1);
            String nodeName = node.getNodeName();
            String nodeValue = DOMTest.cutspace(node.getNodeValue());
            short nodeType = node.getNodeType();
            ArrayList<String> path = new ArrayList<String>();
            if (!nodeName.startsWith("#")) {
                path.add(nodeName);
            }
            for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (parent.getNodeName().startsWith("#")) continue;
                path.add(0, parent.getNodeName());
            }
            StringBuffer str = new StringBuffer();
            switch (nodeType) {
                case 10: {
                    break;
                }
                case 1: {
                    String childText;
                    if (nodeValue == null) {
                        str.append(path.toString());
                    } else {
                        str.append(path + " = " + nodeValue);
                    }
                    NamedNodeMap attrList = node.getAttributes();
                    if (attrList != null && attrList.getLength() > 0) {
                        str.append(" Attr{");
                        for (int i = 0; i < attrList.getLength(); ++i) {
                            Node attr = attrList.item(i);
                            str.append("[" + attr.getNodeName() + "]=[" + attr.getNodeValue() + "]");
                        }
                        str.append("}");
                    }
                    if ((childText = DOMTest.getChildText(node)) != null && childText.length() > 0) {
                        str.append("<TEXT>" + childText + "</TEXT>");
                    }
                    _debug.println(str.toString());
                    NodeList childList = node.getChildNodes();
                    for (int x = 0; x < childList.getLength(); ++x) {
                        Node child = childList.item(childList.getLength() - 1 - x);
                        if (child.getNodeType() == 3) continue;
                        process.add(child);
                    }
                    continue block9;
                }
                case 6: {
                    _debug.println("#Entity " + path + " = " + nodeValue);
                    break;
                }
                case 5: {
                    _debug.println("#EntityReference " + path + " = " + nodeValue);
                    break;
                }
                case 12: {
                    _debug.println("#Notation" + path + " = " + nodeValue);
                    break;
                }
                case 7: {
                    _debug.println("#ProcessingInstruction " + path + " = " + nodeValue);
                    break;
                }
                case 3: {
                    if (nodeValue == null || nodeValue.length() <= 0) break;
                    _debug.println("<TEXT>" + nodeValue + "</TEXT>");
                }
            }
        }
    }

    public static String cutspace(String original) {
        if (original == null) {
            return null;
        }
        StringBuffer text = new StringBuffer(original);
        while (text.length() > 0) {
            char c = text.charAt(0);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                text.deleteCharAt(0);
                continue;
            }
            c = text.charAt(text.length() - 1);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeDocument(File file, Document doc) {
        Transformer tf = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            tf = factory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        tf.setOutputProperty("indent", "yes");
        tf.setOutputProperty("encoding", "UTF-8");
        OutputStreamWriter writer = null;
        try {
            StringWriter string = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(string));
            writer = new FileWriter(file);
            writer.write(string.toString());
            writer.close();
            writer = null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException string) {}
                file.delete();
            }
        }
        return true;
    }
}

