/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import jp.synthtarou.midimixer.MXMainWindow;
import jp.synthtarou.midimixer.MXOpening;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.capture.MXMessageCapture;
import jp.synthtarou.midimixer.libs.midi.port.FinalMIDIOut;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInManager;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIOutManager;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.swing.themes.ThemeManager;
import jp.synthtarou.midimixer.mx00playlist.MX00Process;
import jp.synthtarou.midimixer.mx10input.MX10Process;
import jp.synthtarou.midimixer.mx12masterkeys.MX12Process;
import jp.synthtarou.midimixer.mx30controller.MX30Process;
import jp.synthtarou.midimixer.mx40layer.MX40Process;
import jp.synthtarou.midimixer.mx60output.MX60Process;
import jp.synthtarou.midimixer.mx70console.ConsoleElement;
import jp.synthtarou.midimixer.mx70console.MX70Process;

public class MXMain {
    private static MXMain _main = new MXMain();
    private MXMainWindow _mainWindow;
    private MX10Process _mx10inputProcess;
    private MX12Process _mx12masterkeyProcess;
    private MX00Process _mx00playlistProcess;
    private MX30Process _mx30kontrolProcess;
    private MX40Process _mx40layerProcess;
    private MX60Process _mx60outputProcess;
    private MX70Process _mx70CosoleProcess;
    public static MXMessageCapture _capture = null;
    LinkedList<Runnable> _startQueue = new LinkedList();
    private MXWrapList<MXReceiver> _masterToList = null;

    public static MXMain getMain() {
        return _main;
    }

    public MXMainWindow getMainWindow() {
        return this._mainWindow;
    }

    public MX12Process getMasterKeys() {
        return this._mx12masterkeyProcess;
    }

    public static void addOutsideInput(ConsoleElement e) {
        if (MXMain.getMain()._mx70CosoleProcess != null) {
            MXMain.getMain()._mx70CosoleProcess.addOutsideInput(e);
        }
    }

    public static void addInsideInput(MXMessage msg) {
        if (MXMain.getMain()._mx70CosoleProcess != null) {
            MXMain.getMain()._mx70CosoleProcess.addInsideInput(msg);
        }
    }

    public static void addInsideOutput(MXMessage msg) {
        if (MXMain.getMain()._mx70CosoleProcess != null) {
            MXMain.getMain()._mx70CosoleProcess.addInsideOutput(msg);
        }
    }

    public static void addOutsideOutput(ConsoleElement em) {
        if (MXMain.getMain()._mx70CosoleProcess != null) {
            MXMain.getMain()._mx70CosoleProcess.addOutsideOutput(em);
        }
    }

    public static void setCapture(MXMessageCapture capture) {
        _capture = capture;
    }

    public static void main(String[] args) throws Exception {
        try {
            MXDebugLines.initDebugLine(args);
            System.setProperty("awt.useSystemAAFontSettings", "on");
            ThemeManager themeManager = ThemeManager.getInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MXMain.getMain().startUI();
    }

    public void startUI() {
        Runnable run;
        this._mainWindow = new MXMainWindow(this);
        MXOpening winLogo = MXOpening.showAsStartup(this._mainWindow);
        winLogo.setVisible(true);
        MXMIDIInManager.getManager().initWithSetting();
        MXMIDIOutManager.getManager().initWithSetting();
        winLogo.showProgress(0, 10);
        this._mx00playlistProcess = new MX00Process();
        this._mx10inputProcess = new MX10Process();
        this._mx12masterkeyProcess = new MX12Process();
        winLogo.showProgress(1, 10);
        this._mx30kontrolProcess = new MX30Process();
        this._mx40layerProcess = new MX40Process();
        winLogo.showProgress(2, 10);
        this._mx60outputProcess = new MX60Process();
        this._mx70CosoleProcess = new MX70Process();
        this._masterToList = new MXWrapList();
        winLogo.showProgress(3, 10);
        this._masterToList.addNameAndValue("PushBack to " + this._mx10inputProcess.getReceiverName(), this._mx10inputProcess);
        this._masterToList.addNameAndValue(this._mx30kontrolProcess.getReceiverName(), this._mx30kontrolProcess);
        this._masterToList.addNameAndValue(this._mx40layerProcess.getReceiverName(), this._mx40layerProcess);
        this._masterToList.addNameAndValue(this._mx60outputProcess.getReceiverName(), this._mx60outputProcess);
        this._masterToList.addNameAndValue("Direct Output", FinalMIDIOut.getInstance());
        this._mx10inputProcess.setNextReceiver(this._mx30kontrolProcess);
        this._mx10inputProcess.setMasterKeyProcess(this._mx12masterkeyProcess);
        winLogo.showProgress(4, 10);
        this._mx12masterkeyProcess.setNextReceiver(this._mx10inputProcess);
        this._mx30kontrolProcess.setNextReceiver(this._mx40layerProcess);
        this._mx40layerProcess.setNextReceiver(this._mx60outputProcess);
        this._mx60outputProcess.setNextReceiver(FinalMIDIOut.getInstance());
        winLogo.showProgress(5, 10);
        this._mx30kontrolProcess.readSettings();
        this._mx12masterkeyProcess.readSettings();
        this._mx00playlistProcess.readSettings();
        winLogo.showProgress(6, 10);
        this._mx10inputProcess.readSettings();
        this._mx60outputProcess.readSettings();
        this._mx40layerProcess.readSettings();
        this._mx70CosoleProcess.readSettings();
        winLogo.showProgress(7, 10);
        this._mainWindow.setEnabled(false);
        this._mainWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MXUtil.closeOwnerWindow(MXMain.this.getMasterKeys().getReceiverView());
            }

            @Override
            public void windowClosed(WindowEvent e) {
                MXSetting.saveEverySettingToFile();
                MXMIDIInManager.getManager().closeAll();
                MXMIDIOutManager.getManager().closeAll();
                System.exit(0);
            }
        });
        winLogo.showProgress(8, 10);
        ArrayList<MXReceiver> reList = new ArrayList<MXReceiver>();
        reList.add(this._mx00playlistProcess);
        reList.add(this._mx10inputProcess);
        reList.add(this._mx30kontrolProcess);
        reList.add(this._mx40layerProcess);
        reList.add(this._mx60outputProcess);
        this._mainWindow.initLatebind(reList);
        this._mainWindow.setVisible(true);
        this._mainWindow.setEnabled(true);
        winLogo.showProgress(9, 10);
        winLogo.showProgress(10, 10);
        winLogo.setVisible(false);
        while ((run = this.getNextLaunchSequence()) != null) {
            run.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLaunchSequence(Runnable run) {
        MXMain mXMain = this;
        synchronized (mXMain) {
            this._startQueue.add(run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable getNextLaunchSequence() {
        MXMain mXMain = this;
        synchronized (mXMain) {
            if (this._startQueue.isEmpty()) {
                return null;
            }
            return this._startQueue.removeFirst();
        }
    }

    public void openFreeConsole() {
        this._mx70CosoleProcess.createWindow();
    }

    public MXWrapList<MXReceiver> getReceiverList() {
        MXWrapList<MXReceiver> list = new MXWrapList<MXReceiver>();
        list.addAll(this._masterToList);
        return list;
    }

    public void saveEverySettingToFile() {
        MXSetting.saveEverySettingToFile();
    }

    public void exitApp() {
        this._mainWindow.dispatchEvent(new WindowEvent(this._mainWindow, 201));
    }

    public MXReceiver getInputProcess() {
        return this._mx10inputProcess;
    }

    public void sequencerStart() {
        this._mx40layerProcess.resendProgramChange();
    }

    public void dispatchMainPath(MXMessage message) {
        try {
            MXMain.addInsideInput(message);
            if (_capture != null) {
                _capture.process(message);
            }
            this._mx10inputProcess.processMXMessage(message);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

