/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx60output;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.MXMidiLogger;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.recorder.MIDIRecorder;
import jp.synthtarou.midimixer.libs.swing.JTableWithColumnHeader;
import jp.synthtarou.midimixer.libs.swing.JTableWithFooter;
import jp.synthtarou.midimixer.mx60output.MX60Data;
import jp.synthtarou.midimixer.mx60output.MX60MidiOutListPanel;
import jp.synthtarou.midimixer.mx60output.MX60Process;

public class MX60View
extends JPanel {
    MX60Process _process;
    private static final MXDebugConsole _debug = new MXDebugConsole(MX60View.class);
    JTableWithColumnHeader _jTableSkip;
    boolean _useSkipCC = true;
    MXMidiLogger _logger;
    MXWrapList<Integer> _recPortList;
    private JButton jButtonModePopup;
    private JToggleButton jButtonRecPlay;
    private JButton jButtonRecStart;
    private JButton jButtonRecStop;
    private JCheckBox jCheckBoxUseLogging;
    private JCheckBox jCheckBoxUseSkip;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelRecTime;
    private JList<String> jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanelOutputSelect;
    private JRadioButton jRadioSong1;
    private JRadioButton jRadioSong2;
    private JRadioButton jRadioSong3;
    private JRadioButton jRadioSong4;
    private JRadioButton jRadioSong5;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;

    public MX60View(MX60Process process) {
        this._process = process;
        this.initComponents();
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRadioSong1);
        group.add(this.jRadioSong2);
        group.add(this.jRadioSong3);
        group.add(this.jRadioSong4);
        group.add(this.jRadioSong5);
        this.jPanelOutputSelect.add(new MX60MidiOutListPanel());
        this._jTableSkip = new JTableWithFooter(this.jPanel1);
        this.resetTableModel();
        this._jTableSkip.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (MX60View.this._jTableSkip.isEnabled()) {
                    MX60View.this.jTableSkip_MouseClicked(evt);
                }
            }
        });
        DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        tableCellRenderer.setHorizontalAlignment(0);
        for (int i = 1; i < this._jTableSkip.getColumnCount(); ++i) {
            TableColumn col = this._jTableSkip.getColumnModel().getColumn(i);
            col.setCellRenderer(tableCellRenderer);
        }
        this.jCheckBoxUseSkip.setSelected(this._process.isUsingThisRecipe());
        this._jTableSkip.setEnabled(this._process.isUsingThisRecipe());
        this.jPanel2.add(this._process.getPatchBay().getReceiverView());
        this.jCheckBoxUseLogging.setSelected(this._process.isUseLogging());
        this.enableRecButtons();
    }

    private void initComponents() {
        this.jSplitPane2 = new JSplitPane();
        this.jSplitPane1 = new JSplitPane();
        this.jPanelOutputSelect = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jCheckBoxUseSkip = new JCheckBox();
        this.jSplitPane3 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jButtonRecStart = new JButton();
        this.jButtonRecStop = new JButton();
        this.jLabel2 = new JLabel();
        this.jButtonRecPlay = new JToggleButton();
        this.jLabelRecTime = new JLabel();
        this.jRadioSong1 = new JRadioButton();
        this.jRadioSong2 = new JRadioButton();
        this.jRadioSong3 = new JRadioButton();
        this.jRadioSong4 = new JRadioButton();
        this.jRadioSong5 = new JRadioButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jCheckBoxUseLogging = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jButtonModePopup = new JButton();
        this.setLayout(new BoxLayout(this, 2));
        this.jSplitPane2.setDividerLocation(250);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane1.setDividerLocation(300);
        this.jPanelOutputSelect.setBorder(BorderFactory.createTitledBorder("1.Assign Output"));
        this.jPanelOutputSelect.setLayout(new BoxLayout(this.jPanelOutputSelect, 2));
        this.jSplitPane1.setLeftComponent(this.jPanelOutputSelect);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("3.Skip Which"));
        this.jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel1, gridBagConstraints);
        this.jCheckBoxUseSkip.setText("Use This Recipe");
        this.jCheckBoxUseSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jCheckBoxUseSkipActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jCheckBoxUseSkip, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel3);
        this.jSplitPane2.setTopComponent(this.jSplitPane1);
        this.jSplitPane3.setDividerLocation(400);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("2. Port Forwarding"));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.jSplitPane3.setLeftComponent(this.jPanel2);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("3. Quick Recorder"));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jButtonRecStart.setText("Rec");
        this.jButtonRecStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jButtonRecStartActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel5.add((Component)this.jButtonRecStart, gridBagConstraints);
        this.jButtonRecStop.setText("Stop");
        this.jButtonRecStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jButtonRecStopActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonRecStop, gridBagConstraints);
        this.jLabel2.setText("Song");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel5.add((Component)this.jLabel2, gridBagConstraints);
        this.jButtonRecPlay.setText("Play");
        this.jButtonRecPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jButtonRecPlayActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel5.add((Component)this.jButtonRecPlay, gridBagConstraints);
        this.jLabelRecTime.setText("(00m00s)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel5.add((Component)this.jLabelRecTime, gridBagConstraints);
        this.jRadioSong1.setText("1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel5.add((Component)this.jRadioSong1, gridBagConstraints);
        this.jRadioSong2.setText("2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.jPanel5.add((Component)this.jRadioSong2, gridBagConstraints);
        this.jRadioSong3.setText("3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.jPanel5.add((Component)this.jRadioSong3, gridBagConstraints);
        this.jRadioSong4.setText("4");
        this.jPanel5.add((Component)this.jRadioSong4, new GridBagConstraints());
        this.jRadioSong5.setText("5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.jPanel5.add((Component)this.jRadioSong5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel6.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("4. Logging"));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jCheckBoxUseLogging.setText("Use This Recipe");
        this.jCheckBoxUseLogging.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jCheckBoxUseLoggingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel4.add((Component)this.jCheckBoxUseLogging, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jLabel1, gridBagConstraints);
        this.jButtonModePopup.setText("Style");
        this.jButtonModePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jButtonModePopupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.jPanel4.add((Component)this.jButtonModePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel4, gridBagConstraints);
        this.jSplitPane3.setRightComponent(this.jPanel6);
        this.jSplitPane2.setBottomComponent(this.jSplitPane3);
        this.add(this.jSplitPane2);
    }

    private void jCheckBoxUseSkipActionPerformed(ActionEvent evt) {
        this._process.setUsingThisRecipe(this.jCheckBoxUseSkip.isSelected());
        this._jTableSkip.setEnabled(this.jCheckBoxUseSkip.isSelected());
    }

    private void jCheckBoxUseLoggingActionPerformed(ActionEvent evt) {
        this._process.setUseLogging(this.jCheckBoxUseLogging.isSelected());
    }

    private void jButtonModePopupActionPerformed(ActionEvent evt) {
        this._logger.showModePopupMenu(this.jButtonModePopup);
    }

    public void enableRecButtons() {
        MIDIRecorder rec = MIDIRecorder.getInstance();
        boolean doingRec = rec.isRecording();
        boolean haveRec = rec.tickLength() != 0L;
        this.jButtonRecStart.setEnabled(!doingRec);
        this.jButtonRecStop.setEnabled(doingRec);
        this.jButtonRecPlay.setEnabled(doingRec ? false : haveRec);
    }

    private void jButtonRecStartActionPerformed(ActionEvent evt) {
        MIDIRecorder rec = MIDIRecorder.getInstance();
        if (rec.isRecording()) {
            return;
        }
        rec.startRecording();
        this.enableRecButtons();
    }

    private void jButtonRecStopActionPerformed(ActionEvent evt) {
        MIDIRecorder rec = MIDIRecorder.getInstance();
        if (!rec.isRecording()) {
            return;
        }
        rec.stopRecording();
        this.enableRecButtons();
    }

    private void jButtonRecPlayActionPerformed(ActionEvent evt) {
        MIDIRecorder rec = MIDIRecorder.getInstance();
        if (rec.isRecording()) {
            return;
        }
        this.enableRecButtons();
    }

    public synchronized TableModel createSkipTableModel() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model.addColumn("");
        for (int i = 0; i < 16; ++i) {
            model.addColumn(MXUtilMidi.nameOfPort(i));
        }
        int row = 0;
        while (true) {
            MX60Data cfr_ignored_0 = this._process._data;
            if (row >= 10) break;
            Vector<String> line = new Vector<String>();
            MX60Data cfr_ignored_1 = this._process._data;
            line.add(MX60Data.typeNames[row]);
            for (int delivery = 0; delivery < 16; ++delivery) {
                int type = row + 1;
                if (this._process._data.isSkip(delivery, type)) {
                    line.add("Skip");
                    continue;
                }
                line.add("");
            }
            model.addRow(line);
            ++row;
        }
        return model;
    }

    public void setLogger(MXMidiLogger logger) {
        this._logger = logger;
        logger.attach(this.jList1);
    }

    private void jTableSkip_MouseClicked(MouseEvent evt) {
        int row = this._jTableSkip.rowAtPoint(evt.getPoint());
        int column = this._jTableSkip.columnAtPoint(evt.getPoint());
        int type = row + 1;
        int port = column - 1;
        DefaultTableModel model = (DefaultTableModel)this._jTableSkip.getModel();
        if (type >= 1) {
            MX60Data cfr_ignored_0 = this._process._data;
            if (type <= 10 && port >= 0 && port < 16) {
                if (this._process._data.isSkip(port, type)) {
                    this._process._data.setSkip(port, type, false);
                    model.setValueAt("", row, column);
                } else {
                    this._process._data.setSkip(port, type, true);
                    model.setValueAt("Skip", row, column);
                }
            }
        }
    }

    public void resetTableModel() {
        this._jTableSkip.setModel(this.createSkipTableModel());
        this._jTableSkip.getColumnModel().getColumn(0).setMinWidth(150);
    }
}

