/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx40layer;

import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXNoteOffWatcher;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.mx40layer.MX40Group;
import jp.synthtarou.midimixer.mx40layer.MX40Process;

public class MX40Layer {
    private static final MXDebugConsole _debug = new MXDebugConsole(MX40Layer.class);
    public static final int MOD_NONE = 0;
    public static final int MOD_ASFROM = 1;
    public static final int MOD_FIXED = 2;
    public String _title = "New Layer";
    public int _modPort = 1;
    public int _fixedPort;
    public int _modChannel = 1;
    public int _fixedChannel;
    public int _modBank = 0;
    public int _fixedBankMSB;
    public int _fixedBankLSB;
    public int _modProgram = 0;
    public int _fixedProgram;
    public int _modPan = 1;
    public int _fixedPan = 64;
    public int _adjustTranspose;
    public int _adjustVelocity;
    public int _adjustExpression = 100;
    private int _acceptKeyLowest = 0;
    private int _acceptKeyHighest = 127;
    private int _acceptVelocityLowest = 0;
    private int _acceptVelocityHighest = 127;
    public boolean _disabled = false;
    public MX40Group _parentGroup;
    public MX40Process _process;
    private MXNoteOffWatcher _noteOff = new MXNoteOffWatcher();

    public int getAcceptVelocityLowest() {
        return this._acceptVelocityLowest;
    }

    public void setAcceptVelocityLowest(int _acceptVelocityLowest) {
        this._acceptVelocityLowest = _acceptVelocityLowest;
    }

    public int getAcceptVelocityHighest() {
        return this._acceptVelocityHighest;
    }

    public void setAcceptVelocityHighest(int _acceptVelocityHighest) {
        this._acceptVelocityHighest = _acceptVelocityHighest;
    }

    public int getAcceptKeyLowest() {
        return this._acceptKeyLowest;
    }

    public void setAcceptKeyLowest(int _acceptKeyLowest) {
        this._acceptKeyLowest = _acceptKeyLowest;
    }

    public int getAcceptKeyHighest() {
        return this._acceptKeyHighest;
    }

    public void setAcceptKeyHighest(int acceptKeyHighest) {
        this._acceptKeyHighest = acceptKeyHighest;
    }

    public static String modName(int mod) {
        switch (mod) {
            case 0: {
                return "mod-none";
            }
            case 1: {
                return "mod-asfrom";
            }
            case 2: {
                return "mod-fixed";
            }
        }
        return "mod-unknown";
    }

    public static MXWrapList createSendOption(boolean haveNoneOption) {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        list.addNameAndValue("Fixed", 2);
        list.addNameAndValue("AsFrom", 1);
        if (haveNoneOption) {
            list.addNameAndValue("none", 0);
        }
        return list;
    }

    public MX40Layer(MX40Process process, MX40Group parentGroup) {
        this._process = process;
        this._parentGroup = parentGroup;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this._modChannel == 2) {
            str.append("[Channel=").append(MXUtilMidi.nameOfPort(this._fixedPort)).append("/").append(this._fixedChannel + 1).append("]");
        }
        if (this._modBank == 2) {
            str.append("[Bank=").append(MXUtil.toHexFF(this._fixedBankMSB));
            str.append(":").append(MXUtil.toHexFF(this._fixedBankLSB)).append("]");
        } else if (this._modBank == 1) {
            str.append("[Bank=AsFrom]");
        }
        if (this._modProgram == 2) {
            str.append("[Program=").append(this._fixedProgram).append("]");
        } else if (this._modProgram == 1) {
            str.append("[Program=AsFrom]");
        }
        if (this.getAcceptKeyLowest() != 0 || this.getAcceptKeyHighest() != 127) {
            str.append("[Note=");
            str.append(MXUtilMidi.nameOfNote(this.getAcceptKeyLowest()));
            str.append("-");
            str.append(MXUtilMidi.nameOfNote(this.getAcceptKeyHighest()));
            str.append("]");
        }
        if (this.getAcceptVelocityLowest() != 0 || this.getAcceptVelocityHighest() != 127) {
            str.append("[Velocity=");
            str.append(this.getAcceptVelocityLowest());
            str.append("-");
            str.append(this.getAcceptVelocityHighest());
            str.append("]");
        }
        if (this._adjustTranspose != 0) {
            str.append("[Transpose=");
            str.append(this._adjustTranspose);
            str.append("]");
        }
        return str.toString();
    }

    public boolean processByLayer(MXMessage message) {
        if (!message.isMessageTypeChannel()) {
            this._process.sendToNext(message);
            return true;
        }
        boolean changed = false;
        int port = message.getPort();
        int command = message.getCommand();
        int channel = message.getChannel();
        int data1 = message.getData1();
        int data2 = message.getData2();
        if (command == 192) {
            this.processProgramChange(message);
            return true;
        }
        int port_trans = port;
        int command_trans = command;
        int channel_trans = channel;
        int data1_trans = data1;
        int data2_trans = data2;
        if (command == 128) {
            this._noteOff.notifyNoteOffEvent(port, channel, data1, "@2");
            return true;
        }
        if (this._modPort == 2) {
            changed = true;
            port_trans = this._fixedPort;
        }
        if (this._modChannel == 2) {
            changed = true;
            channel_trans = this._fixedChannel;
        }
        if (command == 144 || command == 128 || command == 160) {
            if (this._adjustTranspose != 0) {
                data1_trans = data1 + this._adjustTranspose;
                if (data1_trans < 1) {
                    data1_trans = 0;
                }
                if (data1_trans > 127) {
                    data1_trans = 127;
                }
                changed = true;
            }
            if (command == 144 && this._adjustVelocity != 0) {
                data2_trans = data2 + this._adjustVelocity;
                if (data2_trans < 1) {
                    data2_trans = 1;
                }
                if (data2_trans > 127) {
                    data2_trans = 127;
                }
                changed = true;
            }
        }
        if (command == 144) {
            MXMessage target = MXMessageFactory.fromShortMessage(port_trans, 128 + channel_trans, data1_trans, 0);
            this._noteOff.addListener(message, target, new MXNoteOffWatcher.Handler(){

                @Override
                public void onNoteOffEvent(MXMessage target) {
                    MX40Layer.this._process.sendToNext(target);
                }
            }, "@2");
        }
        if (data1_trans < 0) {
            return true;
        }
        if (data1_trans > 128) {
            return true;
        }
        if (command == 144 || command == 128 || command == 160) {
            if (data1_trans < this.getAcceptKeyLowest()) {
                return true;
            }
            if (data1_trans > this.getAcceptKeyHighest()) {
                return true;
            }
        }
        if (command == 144) {
            if (data2_trans < this.getAcceptVelocityLowest()) {
                return true;
            }
            if (data2_trans > this.getAcceptVelocityHighest()) {
                return true;
            }
        }
        if (command == 176 && message.getGate() == 11 && this._adjustExpression != 100) {
            double exp = message.getValue();
            exp *= (double)this._adjustExpression;
            int iexp = (int)(exp /= 100.0);
            if (iexp < 0) {
                iexp = 0;
            }
            if (iexp > 127) {
                iexp = 127;
            }
            data2_trans = iexp;
            changed = true;
        }
        if (command == 176 && message.getGate() == 10 && this._modPan == 2) {
            int y;
            data2_trans = y = this._fixedPan;
            changed = true;
        }
        if (changed) {
            MXMessage message_trans;
            message = message_trans = MXMessageFactory.fromShortMessage(port_trans, channel_trans + command, data1_trans, data2_trans);
        }
        this._process.sendToNext(message);
        return true;
    }

    public void processProgramChange(MXMessage message) {
        MXMessage message2;
        MXMessage msb;
        int program;
        int channel;
        int port = message.getPort();
        MXVisitant info = this._process._inputInfo.getVisitant(port, channel = message.getChannel());
        int bankMSB = info.isHavingBank() ? info.getBankMSB() : -1;
        int bankLSB = info.isHavingBank() ? info.getBankLSB() : -1;
        int n = program = info.isHavingProgram() ? info.getProgram() : -1;
        if (this._modPort == 2) {
            port = this._fixedPort;
        }
        if (this._modChannel == 2) {
            channel = this._fixedChannel;
        }
        boolean proc = false;
        if (this._modBank == 1) {
            if (bankMSB >= 0 && bankLSB >= 0) {
                msb = MXMessageFactory.fromShortMessage(port, 176 + channel, 0, bankMSB);
                MXMessage lsb = MXMessageFactory.fromShortMessage(port, 176 + channel, 32, bankLSB);
                this._process.sendToNext(msb);
                this._process.sendToNext(lsb);
                proc = true;
            }
        } else if (this._modBank == 2 && this._fixedBankMSB >= 0 && this._fixedBankLSB >= 0) {
            msb = MXMessageFactory.fromShortMessage(port, 176 + channel, 0, this._fixedBankMSB);
            MXMessage lsb = MXMessageFactory.fromShortMessage(port, 176 + channel, 32, this._fixedBankLSB);
            this._process.sendToNext(msb);
            this._process.sendToNext(lsb);
            proc = true;
        }
        if (this._modProgram == 1) {
            program = message.getGate();
            if (program >= 0) {
                message2 = MXMessageFactory.fromShortMessage(port, 192 + channel, program, 0);
                this._process.sendToNext(message2);
                proc = true;
            }
        } else if (this._modProgram == 2 && this._fixedProgram >= 0) {
            message2 = MXMessageFactory.fromShortMessage(port, 192 + channel, this._fixedProgram, 0);
            this._process.sendToNext(message2);
            proc = true;
        }
        if (proc) {
            double exp = info.getInfoExpression();
            exp = exp * (double)this._adjustExpression * 0.01;
            int data2_exp = (int)exp;
            int command = 176;
            int data1_cc = 11;
            if (data2_exp < 0) {
                data2_exp = 0;
            }
            if (data2_exp > 127) {
                data2_exp = 127;
            }
            MXMessage message22 = MXMessageFactory.fromShortMessage(port, command + channel, data1_cc, data2_exp);
            this._process.sendToNext(message22);
            command = 176;
            int data2_value = info.getInfoPan();
            if (this._modPan == 2) {
                data2_value = this._fixedPan;
            }
            if (data2_value < 0) {
                data2_value = 0;
            }
            if (data2_value > 127) {
                data2_value = 127;
            }
            message22 = MXMessageFactory.fromShortMessage(port, command + channel, 10, data2_value);
            this._process.sendToNext(message22);
        }
    }

    public boolean equals(Object o) {
        MX40Layer target = (MX40Layer)o;
        if (!this._title.equals(target._title)) {
            return false;
        }
        if (this._modPort != target._modPort) {
            return false;
        }
        if (this._modPort == 2 && this._fixedPort != target._fixedPort) {
            return false;
        }
        if (this._modChannel != target._modChannel) {
            return false;
        }
        if (this._modChannel == 2 && this._fixedChannel != target._fixedChannel) {
            return false;
        }
        if (this._modBank != target._modBank) {
            return false;
        }
        if (this._modBank == 2 && (this._fixedBankMSB != target._fixedBankMSB || this._fixedBankLSB != target._fixedBankLSB)) {
            return false;
        }
        if (this._modProgram != target._modProgram) {
            return false;
        }
        if (this._modProgram == 2 && this._fixedProgram != target._fixedProgram) {
            return false;
        }
        if (this._modPan != target._modPan) {
            return false;
        }
        if (this._modPan == 2 && this._fixedPan != target._fixedPan) {
            return false;
        }
        return this._fixedPan == target._fixedPan && this._adjustTranspose == target._adjustTranspose && this._adjustVelocity == target._adjustVelocity && this._adjustExpression == target._adjustExpression && this.getAcceptKeyLowest() == target.getAcceptKeyLowest() && this.getAcceptKeyHighest() == target.getAcceptKeyHighest();
    }
}

