/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.mx30controller.MGCircle;
import jp.synthtarou.midimixer.mx30controller.MGPad;
import jp.synthtarou.midimixer.mx30controller.MGSlider;
import jp.synthtarou.midimixer.mx30controller.MGStatus;
import jp.synthtarou.midimixer.mx30controller.MX32MixerProcess;

public class MX32MixerData {
    MX32MixerProcess _process;
    private ArrayList<MGSlider>[] _matrixSliderComponent;
    private ArrayList<MGCircle>[] _matrixCircleComponent;
    private ArrayList<MGPad>[] _matrixDrumComponent;
    private ArrayList<MGStatus>[] _matrixSliderStatus;
    private ArrayList<MGStatus>[] _matrixCircleStatus;
    private ArrayList<MGStatus>[] _matrixDrumStatus;
    ArrayList<MGStatus>[][] _cachedControlChange;
    ArrayList<MGStatus>[][] _cachedChannelMessage;
    ArrayList<MGStatus>[][] _cachedNoteMessage;
    ArrayList<MGStatus> _cachedSystemMessage;
    ArrayList<MGStatus> _cachedDataentry;
    public static final int INIT_TYPE_ZERO = 0;
    public static final int INIT_TYPE_MIXER = 1;
    public static final int INIT_TYPE_GMTOME = 2;
    public static final int INIT_TYPE_DAW = 3;
    public static final int INIT_TYPE_SOUDMODULE = 4;

    public boolean ready() {
        return this._matrixDrumComponent != null;
    }

    protected MX32MixerData(MX32MixerProcess process) {
        this._process = process;
        this.initVolumeMixer();
    }

    public boolean initializeData(int initType) {
        switch (initType) {
            case 1: {
                this.initVolumeMixer();
                break;
            }
            case 3: {
                this.initDaw();
                break;
            }
            case 0: {
                this.initZero();
                break;
            }
            case 2: {
                this.initGMTone();
                break;
            }
            case 4: {
                this.initSoundModule();
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this._process._view, "Not ready", "Sorry", 0);
                return false;
            }
        }
        this._cachedControlChange = null;
        this._cachedChannelMessage = null;
        this._cachedNoteMessage = null;
        this._cachedSystemMessage = null;
        this._cachedDataentry = null;
        return true;
    }

    private void initVolumeMixer() {
        MXMessage message;
        MGStatus status;
        int column;
        int row;
        MX32MixerProcess process = this._process;
        ArrayList[] circleMatrix = new ArrayList[4];
        ArrayList[] sliderMatrix = new ArrayList[1];
        int port = process._port;
        circleMatrix[0] = new ArrayList();
        circleMatrix[1] = new ArrayList();
        circleMatrix[2] = new ArrayList();
        circleMatrix[3] = new ArrayList();
        sliderMatrix[0] = new ArrayList();
        for (row = 0; row < sliderMatrix.length; ++row) {
            column = 0;
            ArrayList slider = sliderMatrix[row];
            while (slider.size() < 17) {
                if (column >= 16) {
                    String text = "F0h, 7Fh, 0gh, 04h, 01h, #VL, #VH, F7h";
                    status = new MGStatus(process._port, 2, row, column);
                    message = MXMessageFactory.fromDtext(text, this._process._port, 0, 0, 16383);
                    status.setMonitoringTarget(text, 0, 0, 16383);
                } else {
                    status = new MGStatus(process._port, 2, row, column);
                    message = MXMessageFactory.fromShortMessage(port, 176 + column, 7, 127);
                    status.setMonitoringTarget(MXMessageFactory.toDText(message), message.getChannel(), message.getGate(), message.getValue());
                }
                slider.add(status);
                ++column;
            }
            sliderMatrix[row] = slider;
        }
        for (row = 0; row < circleMatrix.length; ++row) {
            ArrayList<MGStatus> circle = new ArrayList<MGStatus>();
            column = 0;
            int[] ccCode = new int[]{93, 91, 11, 10};
            while (circle.size() < 17) {
                if (column >= 16) {
                    status = new MGStatus(process._port, 1, row, column);
                    String text = "F0h, 7Fh, 0gh, 04h, 01h, #VL, #VH, F7h";
                    message = MXMessageFactory.fromDtext(text, this._process._port, 0, 0, 16383);
                    status.setMonitoringTarget(text, 0, 0, 16383);
                    circle.add(status);
                    ++column;
                    continue;
                }
                status = new MGStatus(process._port, 1, row, column);
                message = MXMessageFactory.fromShortMessage(port, 176 + column, ccCode[row], 64);
                status.setMonitoringTarget(MXMessageFactory.toDText(message), column, message.getGate(), message.getValue());
                circle.add(status);
                ++column;
            }
            circleMatrix[row] = circle;
        }
        this._matrixSliderStatus = sliderMatrix;
        this._matrixCircleStatus = circleMatrix;
        this._cachedControlChange = null;
        this.initDrumMinMax();
    }

    private void initDaw() {
        MXMessage message;
        MGStatus status;
        int row;
        MX32MixerProcess process = this._process;
        ArrayList[] circleMatrix = new ArrayList[4];
        ArrayList[] sliderMatrix = new ArrayList[1];
        circleMatrix[0] = new ArrayList();
        circleMatrix[1] = new ArrayList();
        circleMatrix[2] = new ArrayList();
        circleMatrix[3] = new ArrayList();
        sliderMatrix[0] = new ArrayList();
        int port = process._port;
        int[] cclist = new int[]{73, 75, 79, 72, 80, 81, 82, 83, 85};
        int[] cclist2 = new int[]{74, 71, 76, 77, 93, 18, 19, 16, 17};
        int column = 0;
        for (row = 0; row < sliderMatrix.length; ++row) {
            ArrayList<MGStatus> slider = new ArrayList<MGStatus>();
            while (slider.size() < 17) {
                status = new MGStatus(process._port, 2, row, column);
                message = column < cclist.length ? MXMessageFactory.fromShortMessage(port, 176 + row, cclist[column], 127) : MXMessageFactory.createDummy();
                status.setMonitoringTarget(MXMessageFactory.toDText(message), 0, message.getGate(), message.getValue());
                slider.add(status);
                ++column;
            }
            sliderMatrix[row] = slider;
        }
        column = 0;
        for (row = 0; row < circleMatrix.length; ++row) {
            ArrayList<MGStatus> circle = new ArrayList<MGStatus>();
            while (circle.size() < 17) {
                status = new MGStatus(process._port, 1, row, column);
                if (column < cclist2.length) {
                    message = MXMessageFactory.fromShortMessage(port, 176 + row, cclist2[column], 127);
                    status.setMonitoringTarget(MXMessageFactory.toDText(message), row, message.getGate(), message.getValue());
                }
                circle.add(status);
                ++column;
            }
            circleMatrix[row] = circle;
        }
        this._matrixSliderStatus = sliderMatrix;
        this._matrixCircleStatus = circleMatrix;
        this._cachedControlChange = null;
        this.initDrumMinMax();
    }

    private void initZero() {
        MGStatus status;
        int row;
        MX32MixerProcess process = this._process;
        ArrayList[] circleMatrix = new ArrayList[4];
        ArrayList[] sliderMatrix = new ArrayList[1];
        circleMatrix[0] = new ArrayList();
        circleMatrix[1] = new ArrayList();
        circleMatrix[2] = new ArrayList();
        circleMatrix[3] = new ArrayList();
        sliderMatrix[0] = new ArrayList();
        int port = process._port;
        int column = 0;
        for (row = 0; row < sliderMatrix.length; ++row) {
            ArrayList<MGStatus> slider = new ArrayList<MGStatus>();
            while (slider.size() < 17) {
                status = new MGStatus(process._port, 2, row, column);
                slider.add(status);
                ++column;
            }
            sliderMatrix[row] = slider;
        }
        column = 0;
        for (row = 0; row < circleMatrix.length; ++row) {
            ArrayList<MGStatus> circle = new ArrayList<MGStatus>();
            while (circle.size() < 17) {
                status = new MGStatus(process._port, 1, row, column);
                circle.add(status);
                ++column;
            }
            circleMatrix[row] = circle;
        }
        this._matrixSliderStatus = sliderMatrix;
        this._matrixCircleStatus = circleMatrix;
        this._cachedControlChange = null;
        this.initDrumMinMax();
    }

    private void initSoundModule() {
        MXMessage message;
        MGStatus status;
        int row;
        MX32MixerProcess process = this._process;
        ArrayList[] circleMatrix = new ArrayList[4];
        ArrayList[] sliderMatrix = new ArrayList[1];
        int port = process._port;
        int[] cclist = new int[]{114, 18, 19, 16, 17, 91, 79, 72};
        int[] cclist2 = new int[]{112, 74, 71, 76, 77, 93, 73, 75};
        int column = 0;
        for (row = 0; row < sliderMatrix.length; ++row) {
            ArrayList<MGStatus> slider = new ArrayList<MGStatus>();
            while (slider.size() < 17) {
                status = new MGStatus(process._port, 2, row, column);
                if (column < cclist.length) {
                    message = MXMessageFactory.fromShortMessage(port, 176 + row, cclist[column], 127);
                    status.setMonitoringTarget(MXMessageFactory.toDText(message), 0, message.getGate(), message.getValue());
                } else {
                    message = MXMessageFactory.createDummy();
                    status.setMonitoringTarget(MXMessageFactory.toDText(message), 0, message.getGate(), message.getValue());
                }
                slider.add(status);
                ++column;
            }
            sliderMatrix[row] = slider;
        }
        for (row = 0; row < circleMatrix.length; ++row) {
            ArrayList<MGStatus> circle = new ArrayList<MGStatus>();
            column = 0;
            while (circle.size() < 17) {
                status = new MGStatus(process._port, 1, row, column);
                if (column < cclist2.length) {
                    message = MXMessageFactory.fromShortMessage(port, 176 + row, cclist2[column], 127);
                    status.setMonitoringTarget(MXMessageFactory.toDText(message), 0, message.getGate(), message.getValue());
                } else {
                    message = MXMessageFactory.createDummy();
                    status.setMonitoringTarget(MXMessageFactory.toDText(message), 0, message.getGate(), message.getValue());
                }
                circle.add(status);
                ++column;
            }
            circleMatrix[row] = circle;
        }
        this._matrixSliderStatus = sliderMatrix;
        this._matrixCircleStatus = circleMatrix;
        this._cachedControlChange = null;
        this.initDrumMinMax();
    }

    private void initGMTone() {
        int i;
        int row;
        MX32MixerProcess process = this._process;
        ArrayList[] circleMatrix = new ArrayList[4];
        ArrayList[] sliderMatrix = new ArrayList[1];
        ArrayList[] padMatrix = new ArrayList[2];
        int port = process._port;
        MXMessage message = null;
        MGStatus status = null;
        for (row = 0; row < sliderMatrix.length; ++row) {
            int column = 0;
            ArrayList<MGStatus> slider = new ArrayList<MGStatus>();
            while (slider.size() < 17) {
                status = new MGStatus(process._port, 2, row, column);
                if (column >= 16) {
                    String text = "F0h, 7Fh, 0gh, 04h, 01h, #VL, #VH, F7h";
                    message = MXMessageFactory.fromDtext(text, this._process._port, 0, 0, 16383);
                    status.setMonitoringTarget(text, 0, 0, 0);
                } else {
                    message = MXMessageFactory.fromShortMessage(port, 176 + column, 11, 127);
                    status.setMonitoringTarget(MXMessageFactory.toDText(message), column, message.getGate(), message.getValue());
                }
                slider.add(status);
                ++column;
            }
            sliderMatrix[row] = slider;
        }
        for (row = 0; row < circleMatrix.length; ++row) {
            ArrayList<MGStatus> circle = new ArrayList<MGStatus>();
            int column = 0;
            int[] ccCode = new int[]{73, 75, 72, 74};
            while (circle.size() < 17) {
                status = new MGStatus(process._port, 1, row, column);
                if (column >= 16) {
                    String text = "F0h, 7Fh, 0gh, 04h, 01h, #VL, #VH, F7h";
                    message = MXMessageFactory.fromDtext(text, this._process._port, 0, 0, 16383);
                    status.setMonitoringTarget(text, 0, 0, 16385);
                } else {
                    message = MXMessageFactory.fromShortMessage(port, 176 + column, ccCode[row], 64);
                    status.setMonitoringTarget(MXMessageFactory.toDText(message), column, message.getGate(), message.getValue());
                }
                circle.add(status);
                ++column;
            }
            circleMatrix[row] = circle;
        }
        int[] proglist = new int[]{-1, 0, 2, 5, 8, 10, 13, 27, 36, 40, 56, 65, 72, 82, 96, 106, 120};
        ArrayList<MGStatus> pad = new ArrayList<MGStatus>();
        for (i = 0; i < 17; ++i) {
            int prog = proglist[i];
            message = prog < 0 ? MXMessageFactory.fromShortMessage(process._port, 176, 1, 127) : MXMessageFactory.fromShortMessage(process._port, 192, prog, 0);
            status = new MGStatus(process._port, 3, 1, i);
            status.setMonitoringTarget(MXMessageFactory.toDText(message), message.getChannel(), message.getGate(), message.getValue());
            pad.add(status);
        }
        padMatrix[0] = pad;
        pad = new ArrayList();
        for (i = 0; i < 17; ++i) {
            int prog = proglist[i];
            message = prog < 0 ? MXMessageFactory.fromShortMessage(process._port, 177, 1, 127) : MXMessageFactory.fromShortMessage(process._port, 193, prog, 0);
            status = new MGStatus(process._port, 3, 1, i);
            status.setMonitoringTarget(MXMessageFactory.toDText(message), message.getChannel(), message.getGate(), message.getValue());
            pad.add(status);
        }
        padMatrix[1] = pad;
        this._matrixSliderStatus = sliderMatrix;
        this._matrixCircleStatus = circleMatrix;
        this._matrixDrumStatus = padMatrix;
    }

    public void fillMaxOfSlider(MGStatus status, int column) {
        MXMessage message = MXMessageFactory.fromClone(this._matrixSliderStatus[0].get(column).toMXMessage());
        int max = 127;
        if (message.hasValueHiField()) {
            max = 16383;
        }
        message.setValue(max);
        status.setMonitoringTarget(MXMessageFactory.toDText(message), message.getChannel(), message.getGate(), max);
        status.setSwitchType(1);
        status.setRangeMin(max);
        status.setRangeMax(max);
        status.setSwitchOutOnTypeOfValue(10);
        status.setSwitchOutOnValueFixed(max);
    }

    public void fillMinOfSlider(MGStatus status, int column) {
        MXMessage message = MXMessageFactory.fromClone(this._matrixSliderStatus[0].get(column).toMXMessage());
        message.setValue(0);
        status.setMonitoringTarget(MXMessageFactory.toDText(message), message.getChannel(), message.getGate(), 0);
        status.setSwitchType(1);
        status.setRangeMin(0);
        status.setRangeMax(0);
        status.setSwitchOutOnTypeOfValue(10);
        status.setSwitchOutOnValueFixed(0);
    }

    public void initDrumMinMax() {
        MX32MixerProcess process = this._process;
        ArrayList<MGStatus>[] sliderMatrix = this._matrixSliderStatus;
        ArrayList[] padMatrix = new ArrayList[]{new ArrayList(), new ArrayList()};
        int column = 0;
        while (padMatrix[0].size() < 17) {
            MGStatus status = new MGStatus(process._port, 3, 0, column);
            this.fillMaxOfSlider(status, column);
            padMatrix[0].add(status);
            status = new MGStatus(process._port, 3, 1, column);
            this.fillMinOfSlider(status, column);
            padMatrix[1].add(status);
            ++column;
        }
        this._matrixDrumStatus = padMatrix;
    }

    public MGSlider getSlider(int row, int column) {
        if (this._matrixSliderComponent == null) {
            return null;
        }
        return this._matrixSliderComponent[row].get(column);
    }

    public MGCircle getCircle(int row, int column) {
        if (this._matrixCircleComponent == null) {
            return null;
        }
        return this._matrixCircleComponent[row].get(column);
    }

    public MGPad getDrumPad(int row, int column) {
        if (this._matrixDrumComponent == null) {
            return null;
        }
        return this._matrixDrumComponent[row].get(column);
    }

    public MGStatus getSliderStatus(int row, int column) {
        return this._matrixSliderStatus[row].get(column);
    }

    public MGStatus getCircleStatus(int row, int column) {
        return this._matrixCircleStatus[row].get(column);
    }

    public MGStatus getDrumPadStatus(int row, int column) {
        return this._matrixDrumStatus[row].get(column);
    }

    public void setSliderStatus(int row, int column, MGStatus status) {
        this._matrixSliderStatus[row].set(column, status);
    }

    public void setCircleStatus(int row, int column, MGStatus status) {
        this._matrixCircleStatus[row].set(column, status);
    }

    public void setDrumPadStatus(int row, int column, MGStatus status) {
        this._matrixDrumStatus[row].set(column, status);
    }

    public void setEveryComponents(ArrayList<MGSlider>[] slider, ArrayList<MGCircle>[] circle, ArrayList<MGPad>[] drum) {
        this._matrixSliderComponent = slider;
        this._matrixCircleComponent = circle;
        this._matrixDrumComponent = drum;
        this._cachedControlChange = null;
    }
}

