/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.swing.MXFocusAble;
import jp.synthtarou.midimixer.mx30controller.DoubleCheck;
import jp.synthtarou.midimixer.mx30controller.MGStatus;
import jp.synthtarou.midimixer.mx30controller.MGStatusConfig;
import jp.synthtarou.midimixer.mx30controller.MX32MixerProcess;

public class MGPad
extends JPanel
implements MXFocusAble {
    private static final MXDebugConsole _debug = new MXDebugConsole(MGPad.class);
    final MX32MixerProcess _process;
    int _row;
    int _column;
    boolean _dispFlag;
    Color highlight = MXUtil.mixedColor(Color.white, Color.blue, 50);
    private JButton jButton1;
    private JLabel jLabel1;

    public MGStatus getStatus() {
        return this._process._data.getDrumPadStatus(this._row, this._column);
    }

    public void setStatus(MGStatus status) {
        this._process._data.setDrumPadStatus(this._row, this._column, status);
    }

    public MGPad(MX32MixerProcess process, int row, int column) {
        this._process = process;
        this._row = row;
        this._column = column;
        this.initComponents();
        this.jButton1.setText(" ");
        for (MouseListener l : this.jButton1.getMouseListeners()) {
            this.jButton1.removeMouseListener(l);
        }
        this.jButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                MGPad.this._process.catchedValueDrum(MGPad.this.getStatus(), true, MGPad.this.getStatus().getSwitchOutOnValueFixed(), null);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                MGPad.this._process.catchedValueDrum(MGPad.this.getStatus(), false, 0, null);
            }
        });
        this.jButton1.setUI(new MyButtonUI());
        this.updateUI();
    }

    public void updateUIOnly(boolean newValue) {
        this._dispFlag = newValue;
        this.jButton1.repaint();
    }

    @Override
    public void updateUI() {
        if (this._process != null && this._process != null) {
            MGStatus status = this.getStatus();
            status.fixRangedValue();
            if (status.getName() == null || status.getName().length() == 0) {
                MXMessage message = status.toMXMessage();
                if (message == null) {
                    this.jLabel1.setText("??");
                } else {
                    this.jLabel1.setText(message.toShortString());
                }
            } else {
                this.jLabel1.setText(status.getName());
            }
        }
        super.updateUI();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("-");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jButton1.setText("-");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGPad.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jButton1, gridBagConstraints);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
    }

    @Override
    public void focusStatusChanged(boolean flag) {
        if (flag && this._process != null) {
            MGStatus status = this.getStatus();
            this._process._parent.showTextForFocus(3, this._process._port, this._row, this._column);
        }
    }

    public void setValueChangeable(boolean using) {
        this.jButton1.setEnabled(using);
    }

    @Override
    public void focusedMousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || this._process._parent._editingControl) {
            this._process._parent.enterEditMode(false);
            this.focusStatusChanged(false);
            this.editContoller();
        }
    }

    @Override
    public void focusChangingValue() {
        this._process._parent.showTextForFocus(3, this._process._port, this._row, this._column);
    }

    public void increment(DoubleCheck already) {
        this._process.catchedValueDrum(this.getStatus(), true, this.getStatus().getSwitchOutOnValueFixed(), null);
    }

    public void decriment(DoubleCheck already) {
        this._process.catchedValueDrum(this.getStatus(), false, 0, null);
    }

    public void editContoller() {
        this._process._parent.enterEditMode(false);
        MGStatusConfig config = new MGStatusConfig(this._process, this.getStatus());
        MXUtil.showAsDialog(this, config, "Enter Edit Pad {row:" + this._row + ", column:" + this._column + "}");
        this._process.notifyCacheBroken();
        if (config._okOption) {
            this.setStatus(config._status);
            this._process.notifyCacheBroken();
            this.updateUI();
        }
    }

    class MyButtonUI
    extends BasicButtonUI {
        @Override
        public void paint(Graphics g, JComponent c) {
            MGStatus status = MGPad.this.getStatus();
            boolean sel = MGPad.this._dispFlag;
            if (sel) {
                Dimension d = c.getSize();
                g.setColor(MGPad.this.highlight);
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            } else {
                super.paint(g, c);
            }
        }
    }
}

