/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx20patchbay;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.JTableWithColumnHeader;
import jp.synthtarou.midimixer.mx20patchbay.MX20Data;
import jp.synthtarou.midimixer.mx20patchbay.MX20Process;

public class MX20View
extends JPanel {
    private static final MXDebugConsole _debug = new MXDebugConsole(MX20View.class);
    MX20Process _process;
    JTableWithColumnHeader jTable;
    JScrollPane jScrollPane;
    private JCheckBox jCheckBoxUseRecipe;
    private JPanel jPanel1;

    public MX20View(MX20Process process) {
        this.initComponents();
        this._process = process;
        this.jTable = new JTableWithColumnHeader();
        TableModel model = this.createTableModel();
        this.jTable.setModel(model);
        this.jTable.setEnabled(this._process.isUsingThisRecipe());
        this.jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX20View.this.jTable_MousePressed(evt);
            }
        });
        this.jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (MX20View.this.jTable.getSelectedRow() < 0) {
                    return;
                }
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    MX20View.this.popupOpenOrClose(MX20View.this.jTable.getSelectedRow());
                }
            }
        });
        TableColumnModel columnModel = this.jTable.getTableHeader().getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(100);
        columnModel.getColumn(0).setMinWidth(100);
        columnModel.getColumn(0).setMaxWidth(100);
        if (process.isTypeInput()) {
            columnModel.getColumn(1).setPreferredWidth(100);
            columnModel.getColumn(1).setMinWidth(100);
            columnModel.getColumn(1).setMaxWidth(100);
        }
        this.jScrollPane = new JScrollPane(this.jTable);
        this.jPanel1.add(this.jScrollPane);
        this.jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int x = 1;
                int y = MX20View.this.jTable.getSelectedRow();
                Rectangle rect = MX20View.this.jTable.getCellRect(y, x, true);
                rect.y += MX20View.this.jTable.getTableHeader().getHeight();
                MX20View.this.jScrollPane.getVerticalScrollBar().scrollRectToVisible(rect);
            }
        });
        this.jCheckBoxUseRecipe.setSelected(process.isUsingThisRecipe());
    }

    private void initComponents() {
        this.jCheckBoxUseRecipe = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jCheckBoxUseRecipe.setText("Use This Recipe");
        this.jCheckBoxUseRecipe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX20View.this.jCheckBoxUseRecipeActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jCheckBoxUseRecipe, gridBagConstraints);
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void jCheckBoxUseRecipeActionPerformed(ActionEvent evt) {
        this._process.setUsingThisRecipe(this.jCheckBoxUseRecipe.isSelected());
    }

    public void setupViewFromModel() {
        TableModel model = this.createTableModel();
        this.jTable.setModel(model);
    }

    public synchronized TableModel createTableModel() {
        String outName;
        String inName;
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        if (this._process.isTypeInput()) {
            inName = "In ";
            outName = "Internal ";
        } else {
            inName = "Internal ";
            outName = "Out ";
        }
        model.addColumn("");
        model.addColumn("to " + outName);
        for (int port = 0; port < 16; ++port) {
            Vector<Object> line = new Vector<Object>();
            line.add(inName + MXUtilMidi.nameOfPort(port));
            StringBuffer text = new StringBuffer();
            for (int delivery = 0; delivery < 16; ++delivery) {
                if (!this._process.getData().isEnabled(port, delivery)) continue;
                if (text.length() != 0) {
                    text.append(", ");
                }
                text.append(MXUtilMidi.nameOfPort(delivery));
            }
            line.add(text.toString());
            model.addRow(line);
        }
        return model;
    }

    public void popupOpenOrClose(int port) {
        try {
            MX20Data data = this._process.getData();
            JPopupMenu jpopup = new JPopupMenu();
            for (int i = 0; i < 16; ++i) {
                boolean using = data.isEnabled(port, i);
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(MXUtilMidi.nameOfPort(i));
                if (using) {
                    item.setSelected(true);
                    item.addActionListener(new ListenerForOpenOrClose(port, i, false));
                } else {
                    item.addActionListener(new ListenerForOpenOrClose(port, i, true));
                }
                jpopup.add(item);
            }
            jpopup.show(this.jTable, this.jTable.getColumnModel().getColumns().nextElement().getWidth(), this.jTable.getRowHeight(0) * (port + 1));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void jTable_MousePressed(MouseEvent evt) {
        int port = this.jTable.rowAtPoint(evt.getPoint());
        int column = this.jTable.columnAtPoint(evt.getPoint());
        if (port >= 0 && column == 1) {
            this.popupOpenOrClose(port);
        }
    }

    public class ListenerForOpenOrClose
    implements ActionListener {
        int portnumber;
        int targetnumber;
        boolean flag;

        public ListenerForOpenOrClose(int from, int target, boolean setflag) {
            this.portnumber = from;
            this.targetnumber = target;
            this.flag = setflag;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MX20Data data = MX20View.this._process.getData();
            data.set(this.portnumber, this.targetnumber, this.flag);
            MX20View.this.setupViewFromModel();
            MX20View.this.jTable.getSelectionModel().setSelectionInterval(this.portnumber, this.portnumber);
        }
    }
}

