/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx11vcurve;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.JTableWithFooter;
import jp.synthtarou.midimixer.libs.swing.SafeSpinnerNumberModel;
import jp.synthtarou.midimixer.mx11vcurve.MX11Data;
import jp.synthtarou.midimixer.mx11vcurve.MX11Process;

public class MX11View
extends JPanel {
    private static final MXDebugConsole _debug = new MXDebugConsole(MX11View.class);
    JTableWithFooter jTableVelocity;
    MX11Process _process;
    private JButton jButton1;
    private JCheckBox jCheckBoxUseRoute;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelVelocityOriginal;
    private JLabel jLabelVelocityPort;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanelChannelMapping;
    private JSpinner jSpinnerVelocityCurve;

    public MX11View(MX11Process process) {
        this._process = process;
        this.initComponents();
        this.setMinimumSize(new Dimension(100, 100));
        this.jTableVelocity = new JTableWithFooter(this.jPanelChannelMapping);
        this.jTableVelocity.setModel(this.createTableModel());
        DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        tableCellRenderer.setHorizontalAlignment(0);
        for (int i = 1; i < this.jTableVelocity.getColumnCount(); ++i) {
            TableColumn col = this.jTableVelocity.getColumnModel().getColumn(i);
            col.setCellRenderer(tableCellRenderer);
        }
        this.jCheckBoxUseRoute.setSelected(this._process.isUsingThisRecipe());
        this.jTableVelocity.setEnabled(this._process.isUsingThisRecipe());
        this.jLabelVelocityPort.setText("-");
        this.jLabelVelocityOriginal.setText("-");
        this.jTableVelocity.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MX11View.this.jTableVelocity_MouseClicked(e);
            }
        });
    }

    private void initComponents() {
        this.jCheckBoxUseRoute = new JCheckBox();
        this.jPanelChannelMapping = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButton1 = new JButton();
        this.jSpinnerVelocityCurve = new JSpinner();
        this.jLabelVelocityPort = new JLabel();
        this.jLabelVelocityOriginal = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel3 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jCheckBoxUseRoute.setText("Use This Recipe");
        this.jCheckBoxUseRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX11View.this.jCheckBoxUseRouteActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jCheckBoxUseRoute, gridBagConstraints);
        this.jPanelChannelMapping.setBorder(BorderFactory.createTitledBorder("Curve / Port"));
        this.jPanelChannelMapping.setLayout(new BoxLayout(this.jPanelChannelMapping, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanelChannelMapping, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Edit"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Original");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("To");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jButton1.setText("Apply");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX11View.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jSpinnerVelocityCurve, gridBagConstraints);
        this.jLabelVelocityPort.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabelVelocityPort, gridBagConstraints);
        this.jLabelVelocityOriginal.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabelVelocityOriginal, gridBagConstraints);
        this.jLabel4.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 2.0;
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private void jCheckBoxUseRouteActionPerformed(ActionEvent evt) {
        this._process.setUsingThisRecipe(this.jCheckBoxUseRoute.isSelected());
        this.jTableVelocity.setEnabled(this.jCheckBoxUseRoute.isSelected());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        MX11Data data = this._process.getData();
        DefaultTableModel model = (DefaultTableModel)this.jTableVelocity.getModel();
        int port = this.jLabelVelocityPort.getText().charAt(0) - 65;
        int velocityOrg = Integer.parseInt(this.jLabelVelocityOriginal.getText());
        int velocity = (Integer)this.jSpinnerVelocityCurve.getValue();
        for (int i = 0; i < data.curveCount(); ++i) {
            if (data.curveDefault(i) != velocityOrg) continue;
            data.setCurveValue(port, i, velocity);
            model.setValueAt(velocity, model.getRowCount() - 1 - i, port + 1);
        }
        this.jTableVelocity.repaint();
    }

    public synchronized TableModel createTableModel() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        String inName = "";
        String outName = "";
        MX11Data data = this._process.getData();
        model.addColumn("");
        for (int port = 0; port < 16; ++port) {
            model.addColumn(outName + MXUtilMidi.nameOfPort(port));
        }
        for (int i = data.curveCount() - 1; i >= 0; --i) {
            Vector<Object> line = new Vector<Object>();
            line.add(inName + data.curveDefault(i));
            for (int port = 0; port < 16; ++port) {
                line.add(data.curveValue(port, i));
            }
            model.addRow(line);
        }
        return model;
    }

    public void jTableVelocity_MouseClicked(MouseEvent evt) {
        int row = this.jTableVelocity.rowAtPoint(evt.getPoint());
        int column = this.jTableVelocity.columnAtPoint(evt.getPoint());
        if (--column >= 0) {
            try {
                MX11Data data = this._process.getData();
                int curveId = data.curveCount() - 1 - row;
                int port = column;
                int base = data.curveDefault(curveId);
                int set = data.curveValue(port, curveId);
                this.jLabelVelocityPort.setText(MXUtilMidi.nameOfPort(port));
                this.jLabelVelocityOriginal.setText(String.valueOf(base));
                this.jSpinnerVelocityCurve.setModel(new SafeSpinnerNumberModel(set, 0, 127, 1));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

