/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx10input;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIIn;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInManager;
import jp.synthtarou.midimixer.libs.swing.CheckBoxListCellRenderer;

public class MX10MidiInListPanel
extends JPanel {
    private static final MXDebugConsole _debug = new MXDebugConsole(MX10MidiInListPanel.class);
    private JScrollPane jScrollPane4;
    private JTable jTableDevice;
    public CheckBoxListCellRenderer _inputBox;
    public CheckBoxListCellRenderer _outputBox;

    public MX10MidiInListPanel() {
        this.initComponents();
        MXMIDIInManager manager = MXMIDIInManager.getManager();
        this.jTableDevice = new JTable();
        this.jScrollPane4 = new JScrollPane(this.jTableDevice);
        this.jTableDevice.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX10MidiInListPanel.this.jTableDeviceMousePressed(evt);
            }
        });
        this.jTableDevice.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MX10MidiInListPanel.this.jTableDeviceKeyPressed(evt);
            }
        });
        this.add(this.jScrollPane4);
        this.refreshList();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.setLayout(new BoxLayout(this, 2));
    }

    public void refreshList() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MX10MidiInListPanel.this.refreshList();
                }
            });
            return;
        }
        MXMIDIInManager manager = MXMIDIInManager.getManager();
        manager.reloadDeviceList();
        this.jTableDevice.setModel(this.createDeviceModel());
        this.jTableDevice.getColumnModel().getColumn(1).setMaxWidth(50);
        this.jTableDevice.getColumnModel().getColumn(2).setMaxWidth(50);
    }

    public TableModel createDeviceModel() {
        MXWrapList<MXMIDIIn> allInput = MXMIDIInManager.getManager().listAllInput();
        MXMIDIInManager manager = MXMIDIInManager.getManager();
        DefaultTableModel tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        tableModel.addColumn("Port");
        tableModel.addColumn("Assign");
        tableModel.addColumn("Open");
        tableModel.addColumn("To Master");
        for (MXMIDIIn input : allInput.valueList()) {
            tableModel.addRow(new Object[]{input.getName(), MXUtilMidi.nameOfPort(input.assigned()), input.isOpen() ? "o" : "-", input.textForMasterChannel()});
        }
        return tableModel;
    }

    public void updateDeviceTable() {
        DefaultTableModel model = (DefaultTableModel)this.jTableDevice.getModel();
        TableModel newModel = this.createDeviceModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            String name = (String)model.getValueAt(i, 0);
            String value = (String)model.getValueAt(i, 1);
            String opened = (String)model.getValueAt(i, 2);
            String master = (String)model.getValueAt(i, 3);
            String newName = (String)newModel.getValueAt(i, 0);
            String newValue = (String)newModel.getValueAt(i, 1);
            String newOpen = (String)newModel.getValueAt(i, 2);
            String newMaster = (String)newModel.getValueAt(i, 3);
            if (!name.equals(newName)) {
                _debug.println("any troubole?");
                break;
            }
            model.setValueAt(newValue, i, 1);
            model.setValueAt(newOpen, i, 2);
            model.setValueAt(newMaster, i, 3);
        }
    }

    public void popupInputPortSelect(int row) {
        JPopupMenu menu = this.createPopupMenuForPort(row);
        menu.show(this.jTableDevice, this.jTableDevice.getColumnModel().getColumns().nextElement().getWidth(), this.jTableDevice.getRowHeight(0) * (row + 1));
    }

    public JPopupMenu createPopupMenuForPort(final int row) {
        JPopupMenu popup = new JPopupMenu();
        for (int i = -1; i < 16; ++i) {
            JMenuItem item = i < 0 ? popup.add("(none)") : popup.add(MXUtilMidi.nameOfPort(i));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    JMenuItem item = (JMenuItem)arg0.getSource();
                    String itemText = item.getText();
                    int newAssign = itemText.startsWith("(") ? -1 : MXUtilMidi.valueOfPortName(itemText);
                    MXMIDIInManager manager = MXMIDIInManager.getManager();
                    DefaultTableModel model = null;
                    model = (DefaultTableModel)MX10MidiInListPanel.this.jTableDevice.getModel();
                    String text = (String)model.getValueAt(row, 0);
                    MXMIDIIn input = manager.listAllInput().valueOfName(text);
                    MXMIDIInManager.getManager().reserveInput(input, newAssign);
                    if (newAssign >= 0 && !input.open()) {
                        JOptionPane.showMessageDialog(MX10MidiInListPanel.this, "Couldn't open " + text);
                    }
                    MX10MidiInListPanel.this.updateDeviceTable();
                }
            });
        }
        return popup;
    }

    private void jTableDeviceKeyPressed(KeyEvent evt) {
        if (evt.getKeyChar() == ' ' || evt.getKeyChar() == '\n') {
            this.popupInputPortSelect(this.jTableDevice.getSelectedRow());
        }
    }

    private void jTableDeviceMousePressed(MouseEvent evt) {
        int row = this.jTableDevice.rowAtPoint(evt.getPoint());
        int col = this.jTableDevice.columnAtPoint(evt.getPoint());
        if (col == 1) {
            this.popupInputPortSelect(row);
        }
        if (col == 2) {
            this.toggleOpen(row);
        }
        if (col == 3) {
            this.popupSetMaster(row);
        }
    }

    public void toggleOpen(int row) {
        DefaultTableModel model = null;
        model = (DefaultTableModel)this.jTableDevice.getModel();
        String text = (String)model.getValueAt(row, 0);
        MXMIDIIn input = MXMIDIInManager.getManager().listAllInput().valueOfName(text);
        try {
            if (input.isOpen()) {
                input.close();
            } else {
                input.open();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateDeviceTable();
    }

    public void popupSetMaster(int row) {
        try {
            DefaultTableModel model = null;
            model = (DefaultTableModel)this.jTableDevice.getModel();
            String text = (String)model.getValueAt(row, 0);
            MXMIDIIn input = MXMIDIInManager.getManager().listAllInput().valueOfName(text);
            JPopupMenu jpopup = new JPopupMenu();
            for (int ch = 0; ch < 16; ++ch) {
                boolean sel = input.isToMaster(ch);
                String portName = "";
                if (input.assigned() >= 0) {
                    portName = MXUtilMidi.nameOfPort(input.assigned());
                }
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(portName + Integer.toString(ch + 1));
                if (sel) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.addActionListener(new ListenerForSetMaster(input, ch));
                jpopup.add(item);
            }
            int target = 3;
            int width = 0;
            for (int x = 0; x < target; ++x) {
                TableColumn col = this.jTableDevice.getColumnModel().getColumn(x);
                width += col.getWidth();
            }
            jpopup.show(this.jTableDevice, width, this.jTableDevice.getRowHeight(0) * (row + 1));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public class ListenerForSetMaster
    implements ActionListener {
        MXMIDIIn _input;
        int _channel;

        public ListenerForSetMaster(MXMIDIIn from, int channel) {
            this._input = from;
            this._channel = channel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._input.isToMaster(this._channel)) {
                this._input.setToMaster(this._channel, false);
            } else {
                this._input.setToMaster(this._channel, true);
            }
            MX10MidiInListPanel.this.updateDeviceTable();
        }
    }
}

