/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;

public class MXPianoComponent
extends JComponent {
    Handler _handler;
    ArrayList<KeyRect> _whiteKeysList = new ArrayList();
    ArrayList<KeyRect> _blackKeysList = new ArrayList();
    int _mouseNoteOn = -1;
    boolean[] _sequenceNoteOn;
    boolean _sequenceSustainGlobal;
    boolean[] _sequenceSustain;
    BufferedImage _bufferedImage = null;
    Graphics _bufferedImageGraphics = null;
    Rectangle _bufferedRect = null;
    private int _rootNote = 36;
    private int _keyboardOctave = 4;
    static int[] whiteNote = new int[]{0, 2, 4, 5, 7, 9, 11};
    static int[] blackNoteLow = new int[]{1, 3};
    static int[] blackNoteHi = new int[]{6, 8, 10};
    static Color pushedColor = MXUtil.mixedColor(MXUtil.mixedColor(Color.WHITE, Color.yellow, 80), Color.blue, 10);
    static Color centerColor = MXUtil.mixedColor(MXUtil.mixedColor(Color.WHITE, Color.yellow, 20), Color.green, 20);
    static Color selectedColor = MXUtil.mixedColor(MXUtil.mixedColor(Color.WHITE, Color.yellow, 20), Color.red, 40);
    static Color sustainColor = new Color(135, 206, 235);
    static Comparator<KeyRect> noteComp = new Comparator<KeyRect>(){

        @Override
        public int compare(KeyRect o1, KeyRect o2) {
            if (o1._note < o2._note) {
                return -1;
            }
            if (o1._note > o2._note) {
                return 1;
            }
            return 0;
        }
    };
    private boolean _allowMultiSelect = false;
    boolean[] _selectedNote = new boolean[256];

    public boolean isAllowMultiSelect() {
        return this._allowMultiSelect;
    }

    public void setAllowMultiSelect(boolean allowMultiSelect) {
        this._allowMultiSelect = allowMultiSelect;
    }

    public void setHandler(Handler handler) {
        this._handler = handler;
    }

    public MXPianoComponent() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MXPianoComponent.this.releaseNoteByMouse();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MXPianoComponent.this.pushNoteByMouse(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MXPianoComponent.this.releaseNoteByMouse();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                MXPianoComponent.this.pushNoteByMouse(e.getPoint());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.setSize(new Dimension(100, 30));
        this._sequenceNoteOn = new boolean[256];
        this._sequenceSustain = new boolean[256];
    }

    public void setNoteRange(int rootNote, int octave) {
        this._rootNote = rootNote;
        this._keyboardOctave = octave;
    }

    private void makeWhiteAndBlack1Oct(int rootNote, double offset, double width, double height, Collection<KeyRect> noteListWhite, Collection<KeyRect> noteListBlack, double whiteWidth) {
        double whiteHeight = height;
        int count = 0;
        for (int i = 0; i < 7; ++i) {
            KeyRect key;
            double fromX = width * (double)i / 7.0 + offset;
            double fromY = 0.0;
            if (!(key = new KeyRect(whiteNote[count++] + rootNote)).isValid()) continue;
            key._rect.setBounds((int)fromX, (int)fromY, (int)whiteWidth, (int)whiteHeight);
            noteListWhite.add(key);
        }
        double blackLeftWidth = width * 3.0 / 7.0;
        double blackHeight = height * 5.0 / 7.0;
        double blackKeyWidth = blackLeftWidth / 6.0;
        count = 0;
        for (int i = 0; i < 6; ++i) {
            KeyRect key;
            if (i != 2 && i != 4) continue;
            double fromX = (int)(blackLeftWidth * (double)i / 6.0 - blackKeyWidth / 2.0 + offset);
            double fromY = 0.0;
            if (!(key = new KeyRect(blackNoteLow[count++] + rootNote)).isValid()) continue;
            key._rect.setBounds((int)fromX, (int)fromY, (int)blackKeyWidth, (int)blackHeight);
            noteListBlack.add(key);
        }
        double blackRightWidth = width * 4.0 / 7.0;
        double rightOffset = blackLeftWidth;
        count = 0;
        for (int i = 0; i < 8; ++i) {
            KeyRect key;
            if (i != 2 && i != 4 && i != 6) continue;
            double fromX = blackRightWidth * (double)i / 8.0 + rightOffset - blackKeyWidth / 2.0 + offset;
            double fromY = 0.0;
            if (!(key = new KeyRect(blackNoteHi[count++] + rootNote)).isValid()) continue;
            key._rect.setBounds((int)fromX, (int)fromY, (int)blackKeyWidth, (int)blackHeight);
            noteListBlack.add(key);
        }
    }

    private void makeWhiteAndBlack(int rootNote, Rectangle target, Collection<KeyRect> noteListWhite, Collection<KeyRect> noteListBlack) {
        int whiteKeyCount = this._keyboardOctave * 7 + 1;
        if (whiteKeyCount >= 75) {
            whiteKeyCount = 75;
        }
        double whiteKeyWidth = (double)target.width * 1.0 / (double)whiteKeyCount;
        for (int i = 0; i < this._keyboardOctave; ++i) {
            this.makeWhiteAndBlack1Oct(rootNote + i * 12, (double)target.x + (double)i * whiteKeyWidth * 7.0, whiteKeyWidth * 7.0, target.height, noteListWhite, noteListBlack, whiteKeyWidth);
        }
        int whiteLastX = 0;
        for (KeyRect key : noteListWhite) {
            int whiteLastNext = key._rect.x + key._rect.width;
            if (whiteLastX >= whiteLastNext) continue;
            whiteLastX = whiteLastNext;
        }
        KeyRect key = new KeyRect(rootNote + 12 * this._keyboardOctave);
        key._rect.setBounds(whiteLastX, target.y, (int)whiteKeyWidth, target.height);
        noteListWhite.add(key);
    }

    public int getAdjustedHeight(int width) {
        int heightAll = this.getHeight();
        int widthOne = width / this._whiteKeysList.size();
        return widthOne * 5;
    }

    public synchronized void paintOnGraphics(Graphics g, Rectangle rect) {
        Color color;
        Rectangle fill;
        Rectangle whiteRect = rect;
        for (KeyRect key : this._whiteKeysList) {
            fill = key._rect;
            if (rect != null && !fill.intersects(rect)) continue;
            color = key._note == this._mouseNoteOn ? Color.PINK : (this.isSelectedNote(key._note) ? selectedColor : (this._sequenceNoteOn[key._note] ? pushedColor : (this._sequenceSustain[key._note] ? sustainColor : (key._note == 60 ? centerColor : Color.WHITE))));
            g.setColor(color);
            g.fillRect(fill.x + 1, fill.y + 1, fill.width - 2, fill.height - 2);
            g.setColor(Color.BLACK);
            g.drawRect(fill.x, fill.y, fill.width, fill.height);
            if (whiteRect == null) continue;
            whiteRect = whiteRect.union(fill);
        }
        rect = whiteRect;
        for (KeyRect key : this._blackKeysList) {
            fill = key._rect;
            if (rect != null && !fill.intersects(rect)) continue;
            color = key._note == this._mouseNoteOn ? Color.PINK : (this.isSelectedNote(key._note) ? selectedColor : (this._sequenceNoteOn[key._note] ? pushedColor : (this._sequenceSustain[key._note] ? sustainColor : Color.BLACK)));
            g.setColor(color);
            g.fillRoundRect(fill.x + 1, fill.y + 1, fill.width - 2, fill.height - 2, 10, 10);
            g.setColor(Color.GRAY);
            g.drawRoundRect(fill.x, fill.y, fill.width, fill.height, 10, 10);
        }
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        Rectangle rect;
        int widthAll = this.getWidth();
        int heightAll = this.getHeight();
        Rectangle bounds = g.getClipBounds();
        if (this._bufferedImage != null && (widthAll != this._bufferedImage.getWidth() || heightAll != this._bufferedImage.getHeight())) {
            this._bufferedImage = null;
        }
        if (this._bufferedImage == null) {
            this.paintOnBuffer(null);
            bounds = new Rectangle(this._bufferedImage.getWidth(), this._bufferedImage.getHeight());
        }
        if ((rect = this._bufferedRect) == null && bounds == null) {
            rect = new Rectangle(widthAll, heightAll);
        }
        if (rect == null) {
            rect = bounds;
        } else if (bounds != null) {
            rect = rect.union(bounds);
        }
        this._bufferedRect = null;
        g.drawImage(this._bufferedImage, rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, this);
    }

    @Override
    public void invalidate() {
        this._bufferedImage = null;
        super.invalidate();
    }

    public synchronized void paintOnBuffer(Rectangle rect) {
        int widthAll = this.getWidth();
        int heightAll = this.getHeight();
        if (this._bufferedImage != null && (widthAll != this._bufferedImage.getWidth() || heightAll != this._bufferedImage.getHeight())) {
            this._bufferedImage = null;
        }
        if (this._bufferedImage == null) {
            TreeSet<KeyRect> whiteKeys = new TreeSet<KeyRect>(noteComp);
            TreeSet<KeyRect> blackKeys = new TreeSet<KeyRect>(noteComp);
            this.makeWhiteAndBlack(this._rootNote, new Rectangle(0, 0, widthAll, heightAll), whiteKeys, blackKeys);
            this._whiteKeysList = new ArrayList<KeyRect>(whiteKeys);
            this._blackKeysList = new ArrayList<KeyRect>(blackKeys);
            if (this._bufferedImageGraphics != null) {
                this._bufferedImageGraphics.dispose();
            }
            this._bufferedImage = new BufferedImage(widthAll, heightAll, 5);
            this._bufferedImageGraphics = this._bufferedImage.getGraphics();
            this.paintOnGraphics(this._bufferedImageGraphics, null);
            this._bufferedRect = new Rectangle(0, 0, widthAll, heightAll);
        } else {
            this.paintOnGraphics(this._bufferedImageGraphics, rect);
            Rectangle a = this._bufferedRect;
            if (rect == null) {
                rect = new Rectangle(widthAll, heightAll);
            }
            a = a == null ? rect : a.union(rect);
            this._bufferedRect = a;
        }
    }

    public void noteOn(int note) {
        this._sequenceNoteOn[note] = true;
        if (this._sequenceSustainGlobal) {
            this._sequenceSustain[note] = true;
        }
        this.orderRedrawNote(note);
    }

    public void noteOff(int note) {
        this._sequenceNoteOn[note] = false;
        this.orderRedrawNote(note);
    }

    public void allNoteOff() {
        this._sequenceSustainGlobal = false;
        for (int note = 0; note < this._sequenceNoteOn.length; ++note) {
            this._sequenceNoteOn[note] = false;
        }
        this.orderRedrawNote(-1);
    }

    public void sustain(int pedal) {
        if (pedal >= 20) {
            this._sequenceSustainGlobal = true;
            for (int i = 0; i < this._sequenceSustain.length; ++i) {
                this._sequenceSustain[i] = this._sequenceNoteOn[i];
            }
        } else {
            int i;
            this._sequenceSustainGlobal = false;
            int count = 0;
            for (i = 0; i < this._sequenceSustain.length; ++i) {
                if (!this._sequenceSustain[i] && !this._sequenceNoteOn[i]) continue;
                ++count;
            }
            if (count == 1) {
                for (i = 0; i < this._sequenceSustain.length; ++i) {
                    if (!this._sequenceSustain[i] && !this._sequenceNoteOn[i]) continue;
                    this._sequenceSustain[i] = false;
                    this.orderRedrawNote(i);
                }
            } else if (count == 0) {
                return;
            }
            for (i = 0; i < this._sequenceSustain.length; ++i) {
                if (!this._sequenceSustain[i]) continue;
                this._sequenceSustain[i] = false;
            }
            this.orderRedrawNote(-1);
        }
    }

    public void pushNoteByMouse(Point p) {
        for (KeyRect key : this._blackKeysList) {
            if (!key.isValid() || !key._rect.contains(p)) continue;
            int prevNote = this._mouseNoteOn;
            if (prevNote != key._note) {
                this.releaseNoteByMouse();
                this._mouseNoteOn = key._note;
                this.toggleNoteSelected(key._note);
                if (this._handler != null) {
                    this._handler.noteOn(key._note);
                }
                this.orderRedrawNote(prevNote);
                this.orderRedrawNote(key._note);
            }
            return;
        }
        for (KeyRect key : this._whiteKeysList) {
            if (!key.isValid() || !key._rect.contains(p)) continue;
            int prevNote = this._mouseNoteOn;
            if (prevNote != key._note) {
                this.releaseNoteByMouse();
                this._mouseNoteOn = key._note;
                this.toggleNoteSelected(key._note);
                if (this._handler != null) {
                    this._handler.noteOn(key._note);
                }
                this.orderRedrawNote(prevNote);
                this.orderRedrawNote(key._note);
            }
            return;
        }
    }

    public void releaseNoteByMouse() {
        if (this._mouseNoteOn >= 0) {
            int note = this._mouseNoteOn;
            this._mouseNoteOn = -1;
            this.orderRedrawNote(note);
            if (this._handler != null) {
                this._handler.noteOff(note);
            }
        }
    }

    public KeyRect findRectByNote(ArrayList<KeyRect> list, int note) {
        int from = 0;
        int to = list.size() - 1;
        while (from <= to) {
            int x = (to - from) / 2 + from;
            KeyRect o = list.get(x);
            if (o._note < note) {
                from = x + 1;
                continue;
            }
            if (note < o._note) {
                to = x - 1;
                continue;
            }
            return o;
        }
        return null;
    }

    public void orderRedrawNote(final int note) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MXPianoComponent.this.orderRedrawNote(note);
                }
            });
            return;
        }
        if (note >= 0) {
            KeyRect key = this.findRectByNote(this._whiteKeysList, note);
            if (key == null) {
                key = this.findRectByNote(this._blackKeysList, note);
            }
            if (key != null && key.isValid()) {
                this.paintOnBuffer(key._rect);
                this.repaint(key._rect);
            }
        } else {
            this.paintOnBuffer(null);
            this.repaint();
        }
    }

    public static void main(String[] args) {
        MXDebugConsole.globalSwitchOn();
        JFrame win = new JFrame("Piano");
        win.setDefaultCloseOperation(3);
        Insets ins = win.getInsets();
        win.setSize(600 + ins.left + ins.right, 500 + ins.top + ins.bottom);
        win.setLayout(new GridLayout(7, 1));
        int i = 1;
        while (i <= 7) {
            MXPianoComponent comp = new MXPianoComponent();
            if (i == 0) {
                comp.setAllowMultiSelect(true);
            }
            comp._keyboardOctave = i++;
            win.add(comp);
        }
        win.setVisible(true);
    }

    public boolean isSelectedNote(int note) {
        if (this._allowMultiSelect) {
            return this._selectedNote[note];
        }
        return false;
    }

    public void selectNote(int note, boolean flag) {
        if (this._allowMultiSelect) {
            this._selectedNote[note] = flag;
            this._handler.selectionChanged();
        }
    }

    public void toggleNoteSelected(int note) {
        if (this._allowMultiSelect) {
            boolean bl = this._selectedNote[note] = !this._selectedNote[note];
            if (this._handler != null) {
                this._handler.selectionChanged();
            }
        }
    }

    public int[] listMultiSelected() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this._selectedNote.length; ++i) {
            if (!this._selectedNote[i]) continue;
            list.add(i);
        }
        int[] ret = new int[list.size()];
        int x = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            ret[x++] = n;
        }
        return ret;
    }

    public static interface Handler {
        public void noteOn(int var1);

        public void noteOff(int var1);

        public void selectionChanged();
    }

    public static class KeyRect {
        Rectangle _rect = new Rectangle();
        final int _note;

        public KeyRect(int note) {
            this._note = note;
        }

        public boolean isValid() {
            return this._note >= 0 && this._note < 128;
        }
    }
}

