/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.swing;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.settings.MXSettingUtil;

public class MXFileOpenChooser
extends JFileChooser {
    static File currentDir = MXSettingUtil.getAppBaseDirectory().getAbsoluteFile();

    public static File getStartDirectory() {
        return currentDir;
    }

    public MXFileOpenChooser(File dir) {
        super(dir);
    }

    public MXFileOpenChooser() {
        this(currentDir);
    }

    @Override
    public void approveSelection() {
        if (this.getDialogType() == 0) {
            File[] selectedFilesList = this.getSelectedFiles();
            if (selectedFilesList.length == 0) {
                File selectedFile = this.getSelectedFile();
                if (selectedFile == null) {
                    JOptionPane.showMessageDialog(this, "Please select file.");
                    return;
                }
                selectedFilesList = new File[]{selectedFile};
            }
            ArrayList<File> notFound = new ArrayList<File>();
            for (int i = 0; i < selectedFilesList.length; ++i) {
                if (selectedFilesList[i].exists()) continue;
                notFound.add(selectedFilesList[i]);
            }
            if (notFound.size() > 0) {
                JOptionPane.showMessageDialog(this, "File not found.\n" + notFound);
            }
            currentDir = this.getCurrentDirectory();
        }
        super.approveSelection();
    }

    public static File getExistFileRecursive(File file) {
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        return file;
    }

    public static File getExistDirectoryRecursive(File file) {
        while (!(file == null || file.exists() && file.isDirectory())) {
            file = file.getParentFile();
        }
        return file;
    }

    public static void main(String[] args) {
        MXDebugConsole.globalSwitchOn();
        MXFileOpenChooser chooser = new MXFileOpenChooser();
        chooser.setFileSelectionMode(2);
        if (chooser.showOpenDialog(null) == 0) {
            JOptionPane.showMessageDialog(null, "Selected file " + chooser.getSelectedFile().getPath());
        }
    }

    public void addExtension(final String ext, final String desc) {
        this.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isFile()) {
                    String lower = pathname.getName().toLowerCase();
                    return lower.endsWith(ext);
                }
                return true;
            }

            @Override
            public String getDescription() {
                return desc;
            }
        });
    }
}

