/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.settings;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingException;
import jp.synthtarou.midimixer.libs.settings.MXSettingUtil;
import jp.synthtarou.midimixer.libs.settings.Path;

public class MXSettingNode {
    private static final MXDebugConsole _debug = new MXDebugConsole(MXSettingNode.class);
    protected MXSetting _setting;
    private final Path _path;
    public String _value;
    public ArrayList<MXSettingNode> _children = new ArrayList();

    public String toString() {
        return "[" + this._path + "=" + this._value + "(" + this._children.size() + ")]";
    }

    public void register(String name) {
        try {
            Path p = this._path.clone();
            p.addAll(Path.parsePath(name));
            this._setting.register(p);
        }
        catch (MXSettingException e) {
            e.printStackTrace();
        }
    }

    public boolean isRegistered(String name) {
        try {
            Path p = this._path.clone();
            p.addAll(Path.parsePath(name));
            return this._setting.isRegistered(p);
        }
        catch (MXSettingException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Path getPath() {
        return this._path;
    }

    public String getName() {
        if (this._path.size() > 0) {
            return (String)this._path.get(this._path.size() - 1);
        }
        return null;
    }

    public boolean isInteger() {
        if (this._path.size() > 0) {
            return MXSettingUtil.isInteger((String)this._path.get(this._path.size() - 1));
        }
        return false;
    }

    public MXSettingNode(MXSetting setting, Path path, String name) {
        this._setting = setting;
        this._path = new Path();
        if (path != null) {
            this._path.addAll(path);
        }
        if (name != null) {
            this._path.add(name);
        }
    }

    public int size() {
        return this._children.size();
    }

    protected MXSettingNode childByIndex(int index) {
        if (this._children.size() >= index - 1) {
            return this._children.get(index);
        }
        return null;
    }

    protected MXSettingNode childByKey(String name) {
        for (MXSettingNode e : this._children) {
            if (!name.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    public boolean isEmpty() {
        if (this._setting.isRegistered(this._path) && this._value != null) {
            return false;
        }
        for (MXSettingNode node : this._children) {
            if (node.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clearValues() {
        this._value = null;
        this._children = new ArrayList();
    }

    public MXSettingNode findNode(String name) {
        try {
            Path path = Path.parsePath(name);
            MXSettingNode node = this;
            for (String text : path) {
                MXSettingNode e = node.childByKey(text);
                if (e == null) {
                    return null;
                }
                node = e;
            }
            return node;
        }
        catch (MXSettingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<MXSettingNode> findNumbers() {
        ArrayList<MXSettingNode> retList = new ArrayList<MXSettingNode>();
        for (MXSettingNode node : this._children) {
            if (!node.isInteger()) continue;
            retList.add(node);
        }
        return retList;
    }

    public String getSetting(String name) {
        MXSettingNode node = this.findNode(name);
        if (node != null) {
            return node._value;
        }
        return null;
    }

    public int getSettingAsInt(String name, int defval) {
        MXSettingNode node = this.findNode(name);
        if (node != null) {
            String text = node._value;
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return defval;
            }
        }
        return defval;
    }

    public boolean getSettingAsBoolean(String name, boolean defval) {
        if (defval) {
            return this.getSettingAsInt(name, 1) != 0;
        }
        return this.getSettingAsInt(name, 0) != 0;
    }

    public boolean setSetting(String name, String value) throws MXSettingException {
        if (!this.isRegistered(name)) {
            throw new MXSettingException("setSetting Not registered " + name + " = " + value);
        }
        Path child = Path.parsePath(name);
        Path current = this._path;
        MXSettingNode node = this;
        for (String text : child) {
            MXSettingNode e = node.childByKey(text);
            if (e == null) {
                e = new MXSettingNode(this._setting, current, text);
                node._children.add(e);
            }
            node = e;
            current = e._path;
        }
        node._value = value;
        return true;
    }

    public boolean havingName(String name) {
        return this.childByKey(name) != null;
    }

    protected void recuesiveDump(Writer writer) throws IOException {
        TreeSet reg = new TreeSet();
        this.recuesiveDump(writer, 0, reg);
    }

    protected void recuesiveDump(Writer writer, int indent, TreeSet registered) throws IOException {
        StringBuffer text = new StringBuffer();
        boolean wasnum = false;
        boolean first = true;
        for (String string : this._path) {
            if (MXSettingUtil.isInteger(string)) {
                if (wasnum) {
                    // empty if block
                }
                text.append("[" + string + "]");
                wasnum = true;
                first = false;
                continue;
            }
            if (!first) {
                if (wasnum) {
                    text.append(".");
                } else {
                    text.append(".");
                }
            }
            text.append(string);
            wasnum = false;
            first = false;
        }
        if (this._setting.isRegistered(this._path)) {
            if (this._value == null) {
                writer.write(text + "=\n");
            } else {
                writer.write(text + "=" + this._value + "\n");
            }
        } else if (this._value != null) {
            _debug.println("not registered " + text + "=" + this._value);
        }
        for (MXSettingNode mXSettingNode : this._children) {
            mXSettingNode.recuesiveDump(writer, indent + 1, registered);
        }
    }
}

