/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.smf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import jp.synthtarou.midimixer.libs.midi.smf.SMFFileInfo;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessage;
import jp.synthtarou.midimixer.libs.midi.smf.SMFParser;
import jp.synthtarou.midimixer.libs.midi.smf.SMFPlayerCallback;
import jp.synthtarou.midimixer.libs.midi.smf.SMFTempoTable;

public class SMFPlayer {
    private SMFParser _parser;
    private SMFFileInfo _info;
    private int _position;
    boolean _continueRun;
    private SMFPlayerCallback callback;

    public SMFParser getParser() {
        return this._parser;
    }

    public void setParser(SMFParser _parser) {
        this._parser = _parser;
    }

    public SMFFileInfo getInfo() {
        return this._info;
    }

    public void open(File file) throws IOException {
        this.setParser(new SMFParser(file));
        this._info = this.getParser().getFileInfo();
    }

    public SMFPlayer(SMFParser listMessage) {
        this._parser = listMessage;
        this._info = this._parser.getFileInfo();
    }

    public SMFPlayer(File file) throws IOException {
        this._parser = new SMFParser(file);
        this._info = this._parser.getFileInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void playWithSMPTE(int smpteFormat, int fileResolution) throws InvalidMidiDataException {
        long elapsed;
        long elapsedTicks;
        double frameRate = smpteFormat;
        if (smpteFormat == 29) {
            frameRate = 29.97;
        }
        double tickPerMilliSecond = frameRate * (double)fileResolution / 1000.0;
        int pos = this._position;
        System.out.println("playWithSMPTE from " + pos);
        boolean didProgChange = false;
        ArrayList<SMFMessage> list = this.getParser().getMessageList().listAll();
        while (pos < list.size()) {
            SMFMessage smf = list.get(pos);
            int command = smf.getStatus() & 0xF0;
            if (command == 192) {
                this.callback.playingSMFNote(smf);
                didProgChange = true;
                ++pos;
                continue;
            }
            if (command == 176 && (smf.getData1() == 0 || smf.getData1() == 32)) {
                this.callback.playingSMFNote(smf);
                didProgChange = true;
                ++pos;
                continue;
            }
            if (smf.getStatus() != 255) break;
            ++pos;
        }
        if (didProgChange) {
            System.out.println("did prog change");
            try {
                Thread.sleep(500L);
            }
            catch (Exception smf) {
                // empty catch block
            }
        }
        long stopWatch = System.currentTimeMillis();
        long alreadySpent = (long)((double)list.get((int)pos)._tick * tickPerMilliSecond) / 1000L;
        stopWatch -= alreadySpent;
        while (pos < list.size() && this._continueRun && (elapsedTicks = (long)((double)(elapsed = System.currentTimeMillis() - stopWatch) * tickPerMilliSecond)) >= 0L) {
            while (list.get(pos).getTick() <= elapsedTicks && this._continueRun) {
                this._position = pos;
                SMFMessage currentEvent = list.get(pos++);
                this.callback.playingSMFNote(currentEvent);
                if (pos < list.size()) continue;
                break;
            }
            SMFPlayer sMFPlayer = this;
            synchronized (sMFPlayer) {
                try {
                    if (pos >= list.size()) {
                        break;
                    }
                    long nextTick = list.get(pos).getTick();
                    int nextMillis = (int)((double)nextTick / tickPerMilliSecond - (double)System.currentTimeMillis());
                    if (nextMillis >= 10) {
                        this.wait(nextMillis - 5);
                    } else {
                        this.wait(1L);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void playWithTempo() throws InvalidMidiDataException {
        long elapsed;
        long elapsedTicks;
        SMFTempoTable tempo = new SMFTempoTable(this.getParser(), this.getInfo().getResolution());
        int pos = this._position;
        System.out.println("playWithTempo from " + pos);
        boolean didProgChange = false;
        ArrayList<SMFMessage> list = this.getParser().getMessageList().listAll();
        while (pos < list.size()) {
            SMFMessage smf = (SMFMessage)list.get(pos);
            int command = smf.getStatus() & 0xF0;
            if (command == 192) {
                this.callback.playingSMFNote(smf);
                didProgChange = true;
                ++pos;
                continue;
            }
            if (command == 176 && (smf.getData1() == 0 || smf.getData1() == 32)) {
                this.callback.playingSMFNote(smf);
                didProgChange = true;
                ++pos;
                continue;
            }
            if (smf.getStatus() != 255) break;
            ++pos;
        }
        if (didProgChange) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception smf) {
                // empty catch block
            }
        }
        long stopWatch = System.currentTimeMillis();
        long alreadySpent = tempo.TicksToMicroseconds(((SMFMessage)list.get((int)pos))._tick) / 1000L;
        stopWatch -= alreadySpent;
        while (pos < list.size() && this._continueRun && (elapsedTicks = tempo.MicrosecondsToTicks(elapsed = (System.currentTimeMillis() - stopWatch) * 1000L)) >= 0L) {
            while (((SMFMessage)list.get(pos)).getTick() <= elapsedTicks && this._continueRun) {
                this._position = pos;
                SMFMessage currentEvent = (SMFMessage)list.get(pos++);
                this.callback.playingSMFNote(currentEvent);
                if (pos < list.size()) continue;
                break;
            }
            SMFPlayer sMFPlayer = this;
            synchronized (sMFPlayer) {
                try {
                    if (pos >= list.size()) {
                        break;
                    }
                    long nextTick = ((SMFMessage)list.get(pos)).getTick();
                    long nextMillis = tempo.TicksToMicroseconds(nextTick) / 1000L;
                    long differ = nextMillis - (System.currentTimeMillis() - stopWatch);
                    if (differ >= 10L) {
                        this.wait(differ - 5L);
                    } else {
                        this.wait(1L);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    public SMFPlayerCallback getCallback() {
        return this.callback;
    }

    public void setCallback(SMFPlayerCallback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws InvalidMidiDataException {
        this.stop();
        this._continueRun = true;
        try {
            if (this.getPosition() == 0) {
                for (int i = 0; i < 16; ++i) {
                    Object message = new SMFMessage(0L, 176 + i, 64, 0);
                    this.callback.playingSMFNote((SMFMessage)message);
                    message = new SMFMessage(0L, 176 + i, 123, 127);
                    this.callback.playingSMFNote((SMFMessage)message);
                    message = new SMFMessage(0L, 176 + i, 11, 127);
                    this.callback.playingSMFNote((SMFMessage)message);
                    message = new SMFMessage(0L, 176 + i, 7, 127);
                    this.callback.playingSMFNote((SMFMessage)message);
                }
            }
            if (this.getInfo().getSmpteFormat() > 0) {
                this.playWithSMPTE(this.getInfo().getSmpteFormat(), this.getInfo().getResolution());
            } else {
                this.playWithTempo();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this._continueRun = false;
            SMFPlayer sMFPlayer = this;
            synchronized (sMFPlayer) {
                this.notifyAll();
            }
        }
        this.stop();
    }

    public synchronized void stop() {
        this._continueRun = false;
        for (int i = 0; i < 16; ++i) {
            SMFMessage message = new SMFMessage(0L, 176 + i, 64, 0);
            this.callback.playingSMFNote(message);
            message = new SMFMessage(0L, 176 + i, 123, 127);
            this.callback.playingSMFNote(message);
            message = new SMFMessage(0L, 176 + i, 120, 127);
            this.callback.playingSMFNote(message);
        }
        this.notifyAll();
    }

    public synchronized boolean isRunning() {
        return this._continueRun;
    }

    public int getPosition() {
        return this._position;
    }

    public void setPosition(int pos) {
        if (pos > this.getLength()) {
            throw new IllegalArgumentException("timeing error pos = " + pos + " length " + this.getLength());
        }
        this._position = pos;
    }

    public int getLength() {
        return this.getParser().getMessageList().size();
    }
}

