/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.util.ArrayList;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MultiThreadQueue;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXNoteOffWatcher;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInForPlayer;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInManager;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant16;

public class MXMIDIIn {
    private static final MXDebugConsole _debug = new MXDebugConsole(MXMIDIIn.class);
    public static final MXMIDIInForPlayer INTERNAL_PLAYER = new MXMIDIInForPlayer();
    private boolean _isopen = false;
    private String _name;
    private MidiDevice _device;
    private MXNoteOffWatcher _noteOff = new MXNoteOffWatcher();
    protected int _assigned;
    private boolean[] _isToMaster = new boolean[16];
    private MXVisitant16 _visitant16 = new MXVisitant16();
    static Thread _prioritySetFlag = null;
    static MultiThreadQueue<MXMessage> _queue;
    static Thread _thread;

    public boolean isOpen() {
        return this._isopen;
    }

    public void pushInput(MXMessage message) {
        Thread t = Thread.currentThread();
        if (t != _prioritySetFlag) {
            _prioritySetFlag = t;
            try {
                t.setPriority(10);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this._assigned >= 0 && this._isopen) {
            MXMain.getMain().startMainPath(this, message);
        }
    }

    public MXMIDIIn(String name, MidiDevice device) {
        this._name = name;
        this._assigned = -1;
        this._device = device;
    }

    public int assigned() {
        return this._assigned;
    }

    public boolean isToMaster(int channel) {
        return this._isToMaster[channel];
    }

    public void setToMaster(int channel, boolean toMaster) {
        this._isToMaster[channel] = toMaster;
    }

    public String getMasterList() {
        StringBuffer str = new StringBuffer();
        for (int ch = 0; ch < 16; ++ch) {
            if (!this.isToMaster(ch)) continue;
            if (str.length() == 0) {
                str.append(Integer.toString(ch));
                continue;
            }
            str.append(",");
            str.append(Integer.toString(ch));
        }
        return str.toString();
    }

    public void setMasterList(String text) {
        if (text == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        MXUtil.split(text, list, ',');
        this._isToMaster = new boolean[16];
        for (String x : list) {
            int ch = MXUtil.parseTextForNumber(x);
            if (ch < 0) continue;
            this._isToMaster[ch] = true;
        }
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    public void processMidiIn(MXMessage message) {
        boolean _needDebugTrace = false;
        _queue.push(message);
    }

    public void processMidiInInternal(MXMessage message) {
        if (message.isMessageTypeChannel()) {
            int channel = message.getChannel();
            if (message.getCommand() == 128) {
                this._noteOff.notifyNoteOffEvent(this._assigned, channel, message.getNoteNumberFromBytes(), "@7");
                return;
            }
            if (message.getCommand() == 144 && message.getVelocityFromBytes() == 0) {
                this._noteOff.notifyNoteOffEvent(this._assigned, channel, message.getNoteNumberFromBytes(), "@6");
                return;
            }
            if (message.getCommand() == 144) {
                int note = message.getNoteNumberFromBytes();
                MXMessage msg2 = MXMessageFactory.fromShortMessage(this._assigned, 128 + channel, note, 0);
                this._noteOff.addListener(message, msg2, new MXNoteOffWatcher.Handler(){

                    @Override
                    public void onNoteOffEvent(MXMessage target) {
                        MXMIDIIn.this.pushInput(target);
                    }
                });
            } else if (message.getCommand() == 176 && message.getGate() == 123) {
                this._noteOff.allNoteOff();
            } else if (message.getCommand() == 176 && message.getGate() == 120) {
                this._noteOff.allNoteOff();
            }
        }
        try {
            this.pushInput(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MXMIDIInManager manager;
        MXMIDIInManager mXMIDIInManager = manager = MXMIDIInManager.getManager();
        synchronized (mXMIDIInManager) {
            this.allNoteOff();
            if (this instanceof MXMIDIInForPlayer) {
                this._isopen = false;
                return;
            }
            if (this._isopen) {
                MXMIDIInManager.getManager().onClose(this);
                if (this._device != null) {
                    this._device.close();
                }
                this._isopen = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        MXMIDIInManager manager;
        if (this._assigned < 0) {
            return false;
        }
        MXMIDIInManager mXMIDIInManager = manager = MXMIDIInManager.getManager();
        synchronized (mXMIDIInManager) {
            if (this._isopen) {
                return true;
            }
            if (this instanceof MXMIDIInForPlayer) {
                this._isopen = true;
                return true;
            }
            try {
                this._device.open();
                this._isopen = true;
                this._device.getTransmitter().setReceiver(new Receiver(){

                    @Override
                    public void send(MidiMessage midi, long timeStamp) {
                        try {
                            MXMessage message = MXMessageFactory.fromJavaMessage(MXMIDIIn.this._assigned, midi);
                            if (message.isMessageTypeChannel()) {
                                boolean worked = false;
                                int port = message.getPort();
                                int ch = message.getChannel();
                                int command = message.getCommand();
                                int gate = message.getGate();
                                MXVisitant visit = MXMIDIIn.this._visitant16.get(ch);
                                if (MXVisitant.isMesssageHaveVisitant(message)) {
                                    worked = visit.updateChannelVisitant(message);
                                }
                                if (worked) {
                                    if (command == 176) {
                                        if (gate == 0 || gate == 32) {
                                            if (visit.isHavingBank()) {
                                                message = MXMessageFactory.fromShortMessage(port, command + ch, 0, 0);
                                                message.setVisitant(visit);
                                                MXMIDIIn.this.processMidiIn(message);
                                            }
                                            return;
                                        }
                                        if (gate == 6 || gate == 38 || gate == 100 || gate == 101 || gate == 98 || gate == 99) {
                                            if (visit.isHaveDataentryRPN()) {
                                                message = MXMessageFactory.fromDataentryRPN(port, ch, visit._dataroomMSB, visit._dataroomLSB, visit._dataentryMSB << 7 | visit._dataentryLSB);
                                                message.setVisitant(visit);
                                                MXMIDIIn.this.processMidiIn(message);
                                            } else if (visit.isHaveDataentryNRPN()) {
                                                message = MXMessageFactory.fromDataentryNRPN(port, ch, visit._dataroomMSB, visit._dataroomLSB, visit._dataentryMSB << 7 | visit._dataentryLSB);
                                                message.setVisitant(visit);
                                                MXMIDIIn.this.processMidiIn(message);
                                            }
                                            return;
                                        }
                                    }
                                } else {
                                    if (visit.isIncompleteBankInfo() && (command != 176 || gate != 0 && gate != 32)) {
                                        visit.forceCompleteBankInfo();
                                    }
                                    if (visit.isIncomplemteDataentry() && (command != 176 || gate != 6 && gate != 38)) {
                                        visit.forceCompleteBankDataentry();
                                    }
                                    if (visit.isIncomplemteDataroom() && (command != 176 || gate != 100 && gate != 101 && gate != 98 && gate != 99)) {
                                        visit.forceCompleteBankDataroom();
                                    }
                                }
                                visit.attachChannelVisitantToMessage(message);
                            }
                            MXMIDIIn.this.processMidiIn(message);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void close() {
                        MXMIDIIn.this.close();
                    }
                });
                return true;
            }
            catch (MidiUnavailableException e) {
                this.close();
                return false;
            }
        }
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        MXMIDIIn in = (MXMIDIIn)o;
        return in._name == this._name;
    }

    public void allNoteOff() {
        this._noteOff.allNoteOff();
    }

    public String textForMasterChannel() {
        StringBuffer masterMark = new StringBuffer();
        for (int ch = 0; ch < 16; ++ch) {
            if (!this.isToMaster(ch)) continue;
            if (masterMark.length() != 0) {
                masterMark.append(", ");
            }
            masterMark.append((Object)(ch + 1));
        }
        return masterMark.toString();
    }

    public int parseMasteredText(String text) {
        if (text == null) {
            return 0;
        }
        String[] array = text.split("[ ,]+");
        int hit = 0;
        for (int i = 0; i < array.length; ++i) {
            int ch1;
            String parts = array[i];
            if (parts.length() < 1 || (ch1 = parts.charAt(0) - 48) < 0 || ch1 > 9) continue;
            if (parts.length() >= 2) {
                int ch2 = parts.charAt(2) - 48;
                if (ch2 < 0 || ch2 > 9) continue;
                ch1 = ch1 * 10 + ch2;
            }
            if (ch1 >= 1 && ch1 <= 16) {
                this.setToMaster(ch1 - 1, true);
            }
            ++hit;
        }
        return hit;
    }

    static {
        _thread = new Thread(){

            @Override
            public void run() {
                MXMessage message;
                while ((message = _queue.pop()) != null) {
                    try {
                        MXMIDIIn input = MXMIDIInManager.getManager().findMIDIInput(message.getPort());
                        input.processMidiInInternal(message);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        _queue = new MultiThreadQueue();
        _thread.setPriority(10);
        _thread.start();
    }
}

