/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.capture;

import java.util.TreeMap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.capture.GateInfomation;
import jp.synthtarou.midimixer.libs.midi.capture.TextInformation;

public class MXMessageCapture {
    TreeMap<String, TextInformation> _captureData = new TreeMap();
    public int age = 0;

    public void clear() {
        this._captureData = new TreeMap();
        this.age = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MXMessage message) {
        int channel = message.getChannel();
        int gate = message.getGate();
        int value = message.getValue();
        String dtext = MXMessageFactory.toDText(message);
        MXMessageCapture mXMessageCapture = this;
        synchronized (mXMessageCapture) {
            GateInfomation gateNode;
            TextInformation textNode = this._captureData.get(dtext + channel);
            if (textNode == null) {
                textNode = new TextInformation();
                textNode.dtext = dtext;
                textNode.command = message.getCommand();
                textNode.channel = message.getChannel();
                ++this.age;
                this._captureData.put(dtext + message.getChannel(), textNode);
            }
            if ((gateNode = textNode.listGateValues.get(gate)) == null) {
                gateNode = new GateInfomation();
                gateNode._gate = gate;
                gateNode._maxValue = value;
                gateNode._minValue = value;
                gateNode._parent = textNode;
                textNode.listGateValues.put(gate, gateNode);
                ++this.age;
                return;
            }
            if (gateNode._minValue > value) {
                gateNode._minValue = value;
                ++this.age;
            }
            if (gateNode._maxValue < value) {
                gateNode._maxValue = value;
                ++this.age;
            }
            this.notifyAll();
        }
    }

    public int getAge() {
        return this.age;
    }

    public String nameOf(GateInfomation gate) {
        TextInformation text = gate._parent;
        int port = 0;
        MXMessage message = MXMessageFactory.fromDtext(text.dtext, port, gate._parent.channel, gate._gate, gate._maxValue);
        return message.toStringHeader(gate._minValue, gate._maxValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MXWrapList<GateInfomation> createListModel() {
        MXMessageCapture mXMessageCapture = this;
        synchronized (mXMessageCapture) {
            MXWrapList<GateInfomation> list = new MXWrapList<GateInfomation>();
            TreeMap<String, TextInformation> capture = this._captureData;
            for (TextInformation text : capture.values()) {
                for (GateInfomation gate : text.listGateValues.values()) {
                    list.addNameAndValue(this.nameOf(gate), gate);
                }
            }
            return list;
        }
    }
}

