/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.domino;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.synthtarou.midimixer.libs.MXDOMElement;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.domino.DTextFolder;
import jp.synthtarou.midimixer.libs.domino.DTextMessage;
import jp.synthtarou.midimixer.libs.domino.DTextMessageList;
import jp.synthtarou.midimixer.libs.domino.DTextPicker;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDBank;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDDrumSet;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFile;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDMap;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDModule;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDProgram;
import jp.synthtarou.midimixer.libs.midi.programlist.database.ProgramPicker;
import org.xml.sax.SAXException;

public class DTextXML
implements PDFile {
    private static final MXDebugConsole _debug = new MXDebugConsole(DTextXML.class);
    static boolean _DEBUG = false;
    File _file;
    String _fileCreator;
    String _fileVersion;
    String _folder;
    String _name;
    String _priority;
    String _webSite;
    PDModule _module;
    PDModule _drumSet;
    DTextMessageList _ccList;
    String RhythmTrackDefault_Gate;
    String ExclusiveEventDefault_Data;
    String ProgramChangeEventPropertyDlg_AutoPreviewDelay;
    String ControlChangeEventDefault_ID;
    MXDOMElement _part2;

    @Override
    public String getName() {
        return this.getFile().getName();
    }

    public File getFile() {
        return this._file;
    }

    @Override
    public PDModule getModule() {
        return this._module;
    }

    @Override
    public PDModule getDrumSet() {
        return this._drumSet;
    }

    @Override
    public DTextMessageList getCCList() {
        return this._ccList;
    }

    public DTextXML(MXDOMElement e) {
        TreeSet<String> folderAfter = new TreeSet<String>();
        TreeMap<String, MXDOMElement> _idedFolders = new TreeMap<String, MXDOMElement>();
        ArrayList<MXDOMElement> seeking = new ArrayList<MXDOMElement>();
        seeking.add(e);
        ArrayList<MXDOMElement> instElement = new ArrayList<MXDOMElement>();
        ArrayList<MXDOMElement> drumElement = new ArrayList<MXDOMElement>();
        MXDOMElement ccElement = null;
        this._fileCreator = e.getAttributeValue("FileCreator");
        this._fileVersion = e.getAttributeValue("FileVersion");
        this._folder = e.getAttributeValue("Folder");
        this._name = e.getAttributeValue("Name");
        this._priority = e.getAttributeValue("Priority");
        this._webSite = e.getAttributeValue("WebSite");
        while (seeking.size() > 0) {
            String id;
            MXDOMElement element = (MXDOMElement)seeking.remove(seeking.size() - 1);
            String nodeName = element.getNodeName();
            String text = element.getText();
            List<String> path = element.getNodePath();
            List<MXDOMElement> child = element.getChildElements();
            if (child.size() > 0) {
                for (int x = child.size() - 1; x >= 0; --x) {
                    seeking.add(child.get(x));
                }
            }
            if (nodeName.equalsIgnoreCase("Folder") && (id = element.getAttributeValue("ID")) != null && id.length() > 0) {
                _idedFolders.put(id, element);
            }
            if (nodeName.equalsIgnoreCase("Folder") || nodeName.equalsIgnoreCase("FolderLink")) {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < path.size() - 1; ++i) {
                    if (i != 0) {
                        buffer.append(",");
                    }
                    buffer.append(path.get(i));
                }
                folderAfter.add(buffer.toString());
            }
            ArrayList<String> pathRecalc = new ArrayList<String>();
            for (String step : path) {
                if (step.equalsIgnoreCase("Folder") || step.equalsIgnoreCase("FolderLink")) continue;
                pathRecalc.add(step);
            }
            path = pathRecalc;
            if (nodeName.equalsIgnoreCase("Folder")) continue;
            if (this.pathEndWith(path, "InstrumentList,Map")) {
                instElement.add(element);
                continue;
            }
            if (this.pathEndWith(path, "DrumSetList,Map")) {
                drumElement.add(element);
                continue;
            }
            if (nodeName.equalsIgnoreCase("TemplateList")) {
                MXDOMElement _templateElement = element;
                continue;
            }
            if (nodeName.equalsIgnoreCase("DefaultData")) {
                MXDOMElement _defaultDataElement = element;
                continue;
            }
            if (this.pathEndWith(path, "ModuleData") || this.pathEndWith(path, "ModuleData,InstrumentList") || this.pathEndWith(path, "ModuleData,InstrumentList,Map") || this.pathEndWith(path, "ModuleData,InstrumentList,Map,PC") || this.pathEndWith(path, "ModuleData,InstrumentList,Map,PC,Bank") || this.pathEndWith(path, "ModuleData,DrumSetList") || this.pathEndWith(path, "ModuleData,DrumSetList,Map") || this.pathEndWith(path, "ModuleData,DrumSetList,Map,PC") || this.pathEndWith(path, "ModuleData,DrumSetList,Map,PC,Bank") || this.pathEndWith(path, "ModuleData,DrumSetList,Map,PC,Bank,Tone")) continue;
            if (this.pathEndWith(path, "ModuleData,ControlChangeMacroList")) {
                ccElement = element;
                continue;
            }
            if (this.pathEndWith(path, "ModuleData,ControlChangeMacroList,Memo") || this.pathEndWith(path, "ModuleData,ControlChangeMacroList,Table") || this.pathEndWith(path, "ModuleData,ControlChangeMacroList,Table,Entry") || this.pathEndWith(path, "ModuleData,ControlChangeMacroList,CCMLink") || this.pathEndWith(path, "ModuleData,ControlChangeMacroList,CCM") || this.pathEndWith(path, "ModuleData,ControlChangeMacroList,CCM,Memo") || this.pathEndWith(path, "ModuleData,ControlChangeMacroList,CCM,Gate") || this.pathEndWith(path, "ModuleData,ControlChangeMacroList,CCM,Gate,Entry") || this.pathEndWith(path, "ModuleData,ControlChangeMacroList,CCM,Data") || this.pathEndWith(path, "ModuleData,ControlChangeMacroList,CCM,Value") || this.pathEndWith(path, "ModuleData,ControlChangeMacroList,CCM,Value,Entry") || this.pathEndWith(path, "ModuleData,TemplateList,Template") || this.pathEndWith(path, "ModuleData,TemplateList,Template,PC") || this.pathEndWith(path, "ModuleData,TemplateList,Template,CC") || this.pathEndWith(path, "ModuleData,TemplateList,Template,Comment") || this.pathEndWith(path, "ModuleData,TemplateList,Template,Memo") || this.pathEndWith(path, "ModuleData,DefaultData,Track") || this.pathEndWith(path, "ModuleData,DefaultData,Mark") || this.pathEndWith(path, "ModuleData,DefaultData,Track,CC") || this.pathEndWith(path, "ModuleData,DefaultData,Track,TimeSignature") || this.pathEndWith(path, "ModuleData,DefaultData,Track,Comment") || this.pathEndWith(path, "ModuleData,DefaultData,Track,Mark") || this.pathEndWith(path, "ModuleData,DefaultData,Track,EOT") || this.pathEndWith(path, "ModuleData,DefaultData,Track,PC") || this.pathEndWith(path, "ModuleData,DefaultData,Track,Tempo") || this.pathEndWith(path, "ModuleData,DefaultData,Track,Template")) continue;
            if (nodeName.equalsIgnoreCase("RhythmTrackDefault") && this.RhythmTrackDefault_Gate == null) {
                this.RhythmTrackDefault_Gate = element.getAttributeValue("Gate");
                continue;
            }
            if (nodeName.equalsIgnoreCase("ExclusiveEventDefault") && this.ExclusiveEventDefault_Data == null) {
                this.ExclusiveEventDefault_Data = element.getAttributeValue("Data");
                continue;
            }
            if (nodeName.equalsIgnoreCase("ProgramChangeEventPropertyDlg") && this.ProgramChangeEventPropertyDlg_AutoPreviewDelay == null) {
                this.ProgramChangeEventPropertyDlg_AutoPreviewDelay = element.getAttributeValue("AutoPreviewDelay");
                continue;
            }
            if (nodeName.equalsIgnoreCase("ControlChangeEventDefault") && this.ControlChangeEventDefault_ID == null) {
                this.ControlChangeEventDefault_ID = element.getAttributeValue("ID");
                continue;
            }
            _debug.println("unknown <" + path + "/" + nodeName + ">");
            if (text != null && text.length() > 0) {
                _debug.print("text = " + text);
            }
            if (element.countAttributes() > 0) {
                _debug.print("{");
                for (int i = 0; i < element.countAttributes(); ++i) {
                    String name = element.getAttributeName(i);
                    String value = element.getAttributeValue(i);
                    if (i > 0) {
                        _debug.print(",");
                    }
                    _debug.print(name + "=" + value);
                }
                _debug.print("}");
            }
            _debug.println();
        }
        if (_DEBUG) {
            for (String pos : folderAfter) {
                _debug.println("Folders@ " + pos);
            }
        }
        this._module = DTextXML.parseInstrument(instElement, false);
        this._drumSet = DTextXML.parseInstrument(drumElement, true);
        this._ccList = DTextXML.praseControlChangeList(ccElement);
    }

    public static void main(String[] args) throws Exception {
        MXDebugConsole.globalSwitchOn();
        DTextXML trial1 = DTextXML.fromFile(new File("C:/Domino144/Module/GMLevel1.xml"));
        DTextXML trial2 = DTextXML.fromFile(new File("C:/Domino144/Module/ok_GSm.xml"));
        DTextXML trial3 = DTextXML.fromFile(new File("C:/Domino144/Module/SC-88Pro.xml"));
        DTextXML trial4 = DTextXML.fromFile(new File("C:/Domino144/Module/SC-8850.xml"));
        DTextXML trial5 = DTextXML.fromFile(new File("C:/Domino144/Module/ok_XGb.xml"));
        DTextXML trial7 = DTextXML.fromFile(new File("C:/Domino144/Module/X50_v010.xml"));
        DTextPicker picker = new DTextPicker();
        picker.add(trial1);
        picker.add(trial2);
        picker.add(trial3);
        picker.add(trial4);
        picker.add(trial5);
        picker.add(trial7);
        MXUtil.showAsDialog(null, picker, "CC Picker");
        ProgramPicker browser = new ProgramPicker();
        browser.add(trial1);
        browser.add(trial2);
        browser.add(trial3);
        browser.add(trial4);
        browser.add(trial5);
        browser.add(trial7);
        MXUtil.showAsDialog(null, browser, "Program Browser");
        System.exit(0);
    }

    public static DTextMessageList praseControlChangeList(MXDOMElement elem) {
        DTextMessageList list = new DTextMessageList();
        if (elem.getNodeName().equalsIgnoreCase("ControlChangeMacroList")) {
            DTextXML.parseChildren(list, elem.getChildElements());
        }
        return list;
    }

    public static PDModule parseInstrument(ArrayList<MXDOMElement> listMaps, boolean isDrumKit) {
        PDModule database = new PDModule();
        for (MXDOMElement e1 : listMaps) {
            String mapName = e1.getAttributeValue("name");
            if (mapName == null) continue;
            PDMap map = database.smartReserve(mapName);
            for (MXDOMElement e2 : e1.getChildElements("PC")) {
                String name = e2.getAttributeValue("name");
                String pc = e2.getAttributeValue("PC");
                int number = MXUtil.parseTextForNumber(pc);
                PDProgram prog = map.smartReserve(number, name);
                for (MXDOMElement e3 : e2.getChildElements("Bank")) {
                    String bankName = e3.getAttributeValue("Name");
                    String msb = e3.getAttributeValue("MSB");
                    String lsb = e3.getAttributeValue("LSB");
                    int msbNumber = MXUtil.parseTextForNumber(msb);
                    int lsbNumber = MXUtil.parseTextForNumber(lsb);
                    PDBank bank = prog.smartReserve(msbNumber, lsbNumber, bankName);
                    if (!isDrumKit) continue;
                    for (MXDOMElement e4 : e3.getChildElements("Tone")) {
                        String toneName = e4.getAttributeValue("Name");
                        String toneKey = e4.getAttributeValue("Key");
                        int key = MXUtil.parseTextForNumber(toneKey);
                        if (key < 0) continue;
                        PDDrumSet dtone = bank.smartReserve(new PDDrumSet());
                        if (dtone.getNote(key) == null) {
                            dtone.addNote(key, toneName);
                            continue;
                        }
                        _debug.println("drum\u3092\u591a\u91cd\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093");
                    }
                }
            }
        }
        return database;
    }

    public static DTextXML fromFile(File file) throws SAXException {
        MXDOMElement e = MXDOMElement.fromFile(file);
        if (e == null) {
            return null;
        }
        DTextXML t = new DTextXML(e);
        t._file = file;
        return t;
    }

    public boolean pathEndWith(List<String> happen, String hopeText) {
        int hopeSize;
        String[] hope = hopeText.split(",");
        int happenSize = happen.size();
        if (happenSize < (hopeSize = hope.length)) {
            return false;
        }
        int offset = happenSize - hopeSize;
        for (int i = 0; i < happen.size() && i < hope.length; ++i) {
            if (happen.get(i + offset).equalsIgnoreCase(hope[i])) continue;
            return false;
        }
        return true;
    }

    public boolean pathStartWith(List<String> happen, String hopeText) {
        int hopeSize;
        String[] hope = hopeText.split(",");
        int happenSize = happen.size();
        if (happenSize < (hopeSize = hope.length)) {
            return false;
        }
        for (int i = 0; i < happen.size() && i < hope.length; ++i) {
            if (happen.get(i).equalsIgnoreCase(hope[i])) continue;
            return false;
        }
        return true;
    }

    public static void parseChildren(DTextMessageList list, List<MXDOMElement> children) {
        for (MXDOMElement e1 : children) {
            List<MXDOMElement> listData;
            List<MXDOMElement> list2;
            List<MXDOMElement> listGate;
            String nodeName = e1.getNodeName();
            if (nodeName.equalsIgnoreCase("Folder")) {
                String name = e1.getAttributeValue("Name");
                String id = e1.getAttributeValue("ID");
                DTextFolder folder = new DTextFolder(name);
                list.addFolder(folder);
                folder._id = id;
                DTextXML.parseChildren(folder._list, e1.getChildElements());
                continue;
            }
            if (!nodeName.equalsIgnoreCase("CCM")) continue;
            String txtId = e1.getAttributeValue("ID");
            int id = MXUtil.parseTextForNumber(txtId);
            String name = e1.getAttributeValue("Name");
            String txtColor = e1.getAttributeValue("Color");
            Color color = Color.black;
            String txtSync = e1.getAttributeValue("Sync");
            int sync = 0;
            if (txtSync != null) {
                if (txtSync.equalsIgnoreCase("Last")) {
                    sync = 1;
                } else if (txtSync.equalsIgnoreCase("LastEachGate")) {
                    sync = 2;
                }
            }
            String txtMuteSync = e1.getAttributeValue("MuteSync");
            boolean muteSync = false;
            if (txtMuteSync != null && MXUtil.parseTextForNumber(txtMuteSync) > 0) {
                muteSync = true;
            }
            if (txtColor != null && txtColor.startsWith("#") && txtColor.length() == 7) {
                String txt = txtColor.substring(1);
                String r = "0x" + txt.substring(0, 2);
                String g = "0x" + txt.substring(2, 4);
                String string = "0x" + txt.substring(4, 6);
                color = new Color(MXUtil.parseTextForNumber(r), MXUtil.parseTextForNumber(g), MXUtil.parseTextForNumber(string));
            }
            if (MXUtil.parseTextForNumber(txtMuteSync) > 0) {
                muteSync = true;
            }
            DTextMessage cc = new DTextMessage(id, name);
            cc._color = color;
            cc._sync = sync;
            cc._muteSync = muteSync;
            List<MXDOMElement> listValue = e1.getChildElements("Value");
            if (listValue != null) {
                for (MXDOMElement mXDOMElement : listValue) {
                    cc.valueDefault = mXDOMElement.getAttributeValue("Default");
                    cc.valueMin = mXDOMElement.getAttributeValue("Min");
                    cc.valueMax = mXDOMElement.getAttributeValue("Max");
                    cc.valueOffset = mXDOMElement.getAttributeValue("Offset");
                    cc.valueName = mXDOMElement.getAttributeValue("Name");
                    cc.valueType = mXDOMElement.getAttributeValue("Type");
                    cc.valueTableID = mXDOMElement.getAttributeValue("TableID");
                    cc.valueEntry = mXDOMElement.getChildElements("Entry");
                }
            }
            if ((listGate = e1.getChildElements("Gate")) != null) {
                for (Object e22 : listGate) {
                    cc.gateDefault = ((MXDOMElement)e22).getAttributeValue("Default");
                    cc.gateMin = ((MXDOMElement)e22).getAttributeValue("Min");
                    cc.gateMax = ((MXDOMElement)e22).getAttributeValue("Max");
                    cc.gateOffset = ((MXDOMElement)e22).getAttributeValue("Offset");
                    cc.gateName = ((MXDOMElement)e22).getAttributeValue("Name");
                    cc.gateType = ((MXDOMElement)e22).getAttributeValue("Type");
                    cc.gateTableID = ((MXDOMElement)e22).getAttributeValue("TableID");
                    cc.gateEntry = ((MXDOMElement)e22).getChildElements("Entry");
                }
            }
            if ((list2 = e1.getChildElements("Memo")) != null) {
                Object e22;
                cc._memoText = "";
                e22 = list2.iterator();
                while (e22.hasNext()) {
                    MXDOMElement e2 = (MXDOMElement)e22.next();
                    String text = e2.getText();
                    if (cc._memoText.length() > 0) {
                        cc._memoText = cc._memoText + "\n";
                    }
                    cc._memoText = cc._memoText + text;
                }
            }
            if ((listData = e1.getChildElements("Data")) != null) {
                for (MXDOMElement e2 : listData) {
                    cc._dataText = e2.getText();
                }
            }
            list.addMessage(cc);
        }
    }
}

