/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.console;

import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.console.MXConsoleRenderer;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIOut;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;

public class MXConsoleMidiRenderer
extends MXConsoleRenderer {
    public static final int MODE_SHORT = 1;
    public static final int MODE_BINARY = 2;
    public static final int MODE_DTEXT = 3;
    public static final int MODE_FORMAT = 4;
    String _title;
    int _mode = 1;

    public static synchronized MXWrapList<Integer> getModeDataModel() {
        MXWrapList<Integer> model = new MXWrapList<Integer>();
        model.addNameAndValue("Binary", 2);
        model.addNameAndValue("Short", 1);
        model.addNameAndValue("D-Text", 3);
        model.addNameAndValue("Binary + Short", 4);
        return model;
    }

    public synchronized void setMode(int mode) {
        this._mode = mode;
    }

    public MXConsoleMidiRenderer(String title) {
        this._title = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public String format(Object value) {
        ArrayList<String> dump;
        Object bit;
        String shortText;
        String title;
        String portText;
        Object dtext;
        block27: {
            String text = "";
            MXMessage message = (MXMessage)value;
            ArrayList<String> darray = message.toDArray();
            dtext = darray.toString();
            if (darray.contains("#GL") || darray.contains("#GH")) {
                dtext = (String)dtext + " gate=" + message.getGate();
            }
            if (darray.contains("#VL") || darray.contains("#VH")) {
                dtext = (String)dtext + " value=" + message.getValue();
            }
            portText = "[" + MXUtilMidi.nameOfPort(message.getPort());
            if (message.isMessageTypeChannel()) {
                portText = portText + message.getChannel();
            }
            portText = portText + "] ";
            title = this._title + " ";
            shortText = message.toString();
            bit = "";
            if (message.isValue14bit()) {
                bit = (String)bit + " - 14bit";
            }
            dump = new ArrayList<String>();
            boolean isDataentry = false;
            if (message.isMessageTypeDataentry()) {
                if (message.getVisitant() != null) {
                    MXVisitant visit = message.getVisitant();
                    if (visit.isHaveDataentryRPN()) {
                        bit = (String)bit + "RPN [" + MXUtil.toHexFF(visit.getDataentryMSB()) + ":" + MXUtil.toHexFF(visit.getDataentryLSB()) + "]";
                    } else if (visit.isHaveDataentryNRPN()) {
                        bit = (String)bit + "NRPN [" + MXUtil.toHexFF(visit.getDataentryMSB()) + ":" + MXUtil.toHexFF(visit.getDataentryLSB()) + "]";
                    }
                }
                isDataentry = true;
            }
            try {
                if (isDataentry) {
                    MidiMessage msg1 = MXMessageFactory.toJavaDataroomMSB1(message);
                    MidiMessage msg2 = MXMessageFactory.toJavaDataroomLSB2(message);
                    MidiMessage data1 = MXMessageFactory.toJavaDatavalueMSB1(message);
                    MidiMessage data2 = MXMessageFactory.toJavaDatavalueLSB2(message);
                    Class<MXMIDIOut> clazz = MXMIDIOut.class;
                    // MONITORENTER : jp.synthtarou.midimixer.libs.midi.port.MXMIDIOut.class
                    if (msg1 != null && msg2 != null) {
                        dump.add(MXUtil.dumpHexFF(msg1.getMessage()));
                        dump.add(MXUtil.dumpHexFF(msg2.getMessage()));
                    }
                    if (data1 != null) {
                        dump.add(MXUtil.dumpHexFF(data1.getMessage()));
                    }
                    if (data2 != null) {
                        dump.add(MXUtil.dumpHexFF(data2.getMessage()));
                    }
                    // MONITOREXIT : clazz
                    break block27;
                }
                if (message.getCommand() == 176 && message.isValue14bit()) {
                    ShortMessage data1 = new ShortMessage(176 + message.getChannel(), message.getGate(), message.getValue() >> 7 & 0x7F);
                    ShortMessage data2 = new ShortMessage(176 + message.getChannel(), message.getGate() + 32, message.getValue() & 0x7F);
                    Class<MXMIDIOut> clazz = MXMIDIOut.class;
                    // MONITORENTER : jp.synthtarou.midimixer.libs.midi.port.MXMIDIOut.class
                    dump.add(MXUtil.dumpHexFF(data1.getMessage()));
                    dump.add(MXUtil.dumpHexFF(data2.getMessage()));
                    // MONITOREXIT : clazz
                    break block27;
                }
                MidiMessage msg = MXMessageFactory.toJavaMessage(message);
                if (msg != null) {
                    dump.add(MXUtil.dumpHexFF(msg.getMessage()));
                }
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
        switch (this._mode) {
            case 1: {
                return title + shortText + (String)bit;
            }
            case 2: {
                return title + portText + " " + dump.toString() + " " + (String)bit;
            }
            case 3: {
                return title + portText + (String)dtext + (String)bit;
            }
            case 4: {
                return title + portText + " '" + dump.toString() + "' = " + shortText + (String)bit;
            }
        }
        return "ERROR";
    }
}

