/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.console.MXConsoleMidiRenderer;
import jp.synthtarou.midimixer.libs.console.MXConsoleModel;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;

public class MXMidiLogger
extends MXReceiver {
    MXConsoleModel _console;
    String _name;

    public MXMidiLogger(String name) {
        this._name = name;
        this._console = new MXConsoleModel(name, 500);
    }

    public void attach(JList list) {
        this._console.installConsole(list);
        list.setModel(this._console);
    }

    public void showModePopupMenu(JComponent where) {
        JPopupMenu menu = new JPopupMenu();
        MXWrapList<Integer> menuModel = MXConsoleMidiRenderer.getModeDataModel();
        for (int i = 0; i < menuModel.getSize(); ++i) {
            MXWrap e = (MXWrap)menuModel.get(i);
            JMenuItem item = new JMenuItem(e.name);
            item.addActionListener(new FireMenu((Integer)e.value));
            menu.add(item);
        }
        menu.show(where, 0, where.getHeight());
    }

    @Override
    public String getReceiverName() {
        return this._name;
    }

    @Override
    public JComponent getReceiverView() {
        return null;
    }

    @Override
    public void processMXMessage(MXMessage message) {
        if (this.isUsingThisRecipe()) {
            this._console.addConsoleMessage(message);
        }
        if (this.getNextReceiver() != null) {
            this.sendToNext(message);
        }
    }

    public class FireMenu
    implements ActionListener {
        int _mode;

        public FireMenu(int mode) {
            this._mode = mode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MXMidiLogger.this._console.getRenderer().setMode(this._mode);
            MXMidiLogger.this._console.fireRepaint();
        }
    }
}

