/*
 * Decompiled with CFR 0.152.
 */
package coins.sym;

import coins.HasStringObject;
import coins.IoRoot;
import coins.MachineParam;
import coins.SourceLanguage;
import coins.SymRoot;
import coins.ir.IrList;
import coins.ir.IrListImpl;
import coins.ir.SourceInf;
import coins.ir.SourceInfImpl;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.VarNode;
import coins.sym.BaseType;
import coins.sym.BaseTypeImpl;
import coins.sym.BoolConst;
import coins.sym.CharConst;
import coins.sym.CharConstImpl;
import coins.sym.Const;
import coins.sym.DefinedType;
import coins.sym.DefinedTypeImpl;
import coins.sym.Elem;
import coins.sym.ElemImpl;
import coins.sym.EnumType;
import coins.sym.EnumTypeImpl;
import coins.sym.FlagBox;
import coins.sym.FlagBoxImpl;
import coins.sym.FloatConst;
import coins.sym.FloatConstImpl;
import coins.sym.FlowAnalSym;
import coins.sym.IntConst;
import coins.sym.IntConstImpl;
import coins.sym.Label;
import coins.sym.LabelImpl;
import coins.sym.NamedConst;
import coins.sym.NamedConstImpl;
import coins.sym.Param;
import coins.sym.ParamImpl;
import coins.sym.PointerType;
import coins.sym.PointerTypeImpl;
import coins.sym.RegionType;
import coins.sym.RegionTypeImpl;
import coins.sym.StringConst;
import coins.sym.StructType;
import coins.sym.StructTypeImpl;
import coins.sym.Subp;
import coins.sym.SubpImpl;
import coins.sym.SubpType;
import coins.sym.SubpTypeImpl;
import coins.sym.Sym;
import coins.sym.SymInf;
import coins.sym.SymTable;
import coins.sym.SymTableEntry;
import coins.sym.Type;
import coins.sym.TypeImpl;
import coins.sym.UnionType;
import coins.sym.UnionTypeImpl;
import coins.sym.Var;
import coins.sym.VarImpl;
import coins.sym.VectorType;
import coins.sym.VectorTypeImpl;
import java.util.ListIterator;

public class SymImpl
implements Sym,
HasStringObject,
Cloneable {
    public final SymRoot symRoot;
    public Sym fUniqueNameSym = null;
    protected String fName = null;
    protected int fKind = 0;
    protected Type fType = null;
    protected SymTable fRecordedIn;
    protected Sym fDefinedIn = null;
    protected Sym fNextSym = null;
    protected FlagBox fFlagBox;
    protected SymInf fSymInf = null;
    protected SourceInf fSourceInf = null;
    protected Object fWork;
    protected static MachineParam machineParam;
    protected static SourceLanguage sourceLanguage;
    protected final int fDbgLevel;

    public SymImpl() {
        this.symRoot = null;
        this.fFlagBox = new FlagBoxImpl();
        this.fDbgLevel = 0;
    }

    public SymImpl(SymRoot pSymRoot) {
        this.symRoot = pSymRoot;
        this.fFlagBox = new FlagBoxImpl();
        this.fDbgLevel = this.symRoot.ioRoot.dbgSym.getLevel();
    }

    public SymImpl(SymRoot pSymRoot, String pInternedName) {
        this.symRoot = pSymRoot;
        this.fKind = 1;
        this.fName = pInternedName;
        this.fFlagBox = new FlagBoxImpl();
        this.fDbgLevel = this.symRoot.ioRoot.dbgSym.getLevel();
    }

    public void setParameters(MachineParam pMachineParam, SourceLanguage pSourceLanguage) {
        machineParam = pMachineParam;
        sourceLanguage = pSourceLanguage;
    }

    public BoolConst boolConst(boolean pTrueFalse) {
        if (pTrueFalse) {
            return this.symRoot.boolConstTrue;
        }
        return this.symRoot.boolConstFalse;
    }

    public CharConst charConst(String pInternedName, Type pType) {
        CharConst lCharConst = (CharConst)this.symRoot.symTableConst.searchOrAdd(pInternedName, 3, null, true, true);
        ((CharConstImpl)lCharConst).fType = pType;
        return lCharConst;
    }

    public CharConst charConst(char pChar, Type pType) {
        CharConst lCharConst = (CharConst)this.symRoot.symTableConst.searchOrAdd(String.valueOf(pChar), 3, null, true, true);
        ((CharConstImpl)lCharConst).fType = pType;
        ((CharConstImpl)lCharConst).fType = pType;
        return lCharConst;
    }

    public CharConst charConst(int pCharCode, Type pType) {
        CharConst lCharConst = (CharConst)this.symRoot.symTableConst.searchOrAdd(String.valueOf(pCharCode).intern(), 3, null, true, true);
        ((CharConstImpl)lCharConst).fType = pType;
        return lCharConst;
    }

    public IntConst intConst(String pInternedName, Type pType) {
        String lName = SourceLanguage.makeIntConstString(pInternedName, pType);
        IntConst lIntConst = (IntConst)this.symRoot.symTableConst.searchOrAdd(lName, 4, null, true, true);
        ((IntConstImpl)lIntConst).fType = pType;
        return lIntConst;
    }

    public IntConst intConst(long pIntValue, Type pType) {
        String lIntString = String.valueOf(pIntValue).intern();
        String lName = SourceLanguage.makeIntConstString(lIntString, pType);
        IntConst lIntConst = (IntConst)this.symRoot.symTableConst.searchOrAdd(lName, 4, null, true, true);
        ((IntConstImpl)lIntConst).fType = pType;
        return lIntConst;
    }

    public FloatConst floatConst(String pInternedName, Type pType) {
        String lName = SourceLanguage.makeFloatConstString(pInternedName, pType);
        FloatConst lFloatConst = (FloatConst)this.symRoot.symTableConst.searchOrAdd(lName, 5, null, true, true);
        ((FloatConstImpl)lFloatConst).fType = pType;
        return lFloatConst;
    }

    public FloatConst floatConst(double pFloatValue, Type pType) {
        String lFloatString = String.valueOf(pFloatValue).intern();
        String lName = SourceLanguage.makeFloatConstString(lFloatString, pType);
        FloatConst lFloatConst = (FloatConst)this.symRoot.symTableConst.searchOrAdd(lName, 5, null, true, true);
        ((FloatConstImpl)lFloatConst).fType = pType;
        return lFloatConst;
    }

    public StringConst stringConst(String pInternedName) {
        int lLeng = pInternedName.length();
        String lStringBody = lLeng <= 0 ? "" : this.symRoot.sourceLanguage.makeStringBody(pInternedName);
        StringConst lStringConst = (StringConst)this.symRoot.symTableConst.searchOrAdd(('\"' + lStringBody + '\"').intern(), 6, null, true, true);
        lStringConst.setStringBody(lStringBody);
        VectorType lType = this.symRoot.sym.vectorType(this.symRoot.getCharType(), this.symRoot.sourceLanguage.getStringLength(lStringBody));
        lStringConst.setSymType(lType);
        return lStringConst;
    }

    public StringConst stringConstFromQuotedString(String pInternedName) {
        String lStringBody;
        int lLeng = pInternedName.length();
        if (lLeng > 2 && pInternedName.charAt(0) == '\"' && pInternedName.charAt(lLeng - 1) == '\"') {
            String lString = pInternedName.substring(1, lLeng - 1);
            lStringBody = this.symRoot.sourceLanguage.makeStringBody(lString);
        } else if (lLeng == 2 && pInternedName.charAt(0) == '\"' && pInternedName.charAt(1) == '\"') {
            String lString = "";
            lStringBody = "";
        } else {
            this.symRoot.ioRoot.msgRecovered.put(1016, "stringConstFromQuotedString param has no quote " + pInternedName);
            String lString = pInternedName;
            lStringBody = pInternedName;
        }
        StringConst lStringConst = (StringConst)this.symRoot.symTableConst.searchOrAdd(('\"' + lStringBody + '\"').intern(), 6, null, true, true);
        lStringConst.setStringBody(lStringBody);
        VectorType lType = this.symRoot.sym.vectorType(this.symRoot.getCharType(), this.symRoot.sourceLanguage.getStringLength(lStringBody));
        lStringConst.setSymType(lType);
        return lStringConst;
    }

    public StringConst bareStringConst(String pInternedName) {
        int lLeng = pInternedName.length();
        String lStringBody = lLeng <= 0 ? "" : pInternedName;
        StringConst lStringConst = (StringConst)this.symRoot.symTableConst.searchOrAdd(lStringBody.intern(), 6, null, true, true);
        lStringConst.setStringBody(lStringBody);
        VectorType lType = this.symRoot.sym.vectorType(this.symRoot.getCharType(), lLeng);
        lStringConst.setSymType(lType);
        return lStringConst;
    }

    public String makeJavaString(String pStringBody) {
        String lString1 = new String();
        if (pStringBody == null || pStringBody.length() <= 0) {
            return "\"\"";
        }
        StringBuffer lString = new StringBuffer("\"");
        block10: for (int i = 0; i < pStringBody.length(); ++i) {
            char lChar = pStringBody.charAt(i);
            switch (lChar) {
                case '\n': {
                    lString.append("\\n");
                    continue block10;
                }
                case '\t': {
                    lString.append("\\t");
                    continue block10;
                }
                case '\'': {
                    lString.append("\\'");
                    continue block10;
                }
                case '\"': {
                    lString.append('\\');
                    lString.append('\"');
                    continue block10;
                }
                case '\f': {
                    lString.append("\\f");
                    continue block10;
                }
                case '\b': {
                    lString.append("\\b");
                    continue block10;
                }
                case '\r': {
                    lString.append("\\r");
                    continue block10;
                }
                case '\\': {
                    lString.append('\\');
                    lString.append('\\');
                    continue block10;
                }
                default: {
                    if (lChar <= '\u001b') {
                        char lCharCode = lChar;
                        int lOct1 = lCharCode / 8;
                        int lOct2 = lCharCode - lOct1 * 8;
                        lString.append('\\');
                        lString.append("0");
                        lString.append(Character.forDigit(lOct1, 8));
                        lString.append(Character.forDigit(lOct2, 8));
                        continue block10;
                    }
                    lString.append(lChar);
                }
            }
        }
        lString = lString.append("\"");
        lString1 = lString.toString();
        return lString1.intern();
    }

    public String makeCstring(String pStringBody) {
        return this.symRoot.sourceLanguage.makeCstring(pStringBody);
    }

    public String makeCstringWithTrailing0(String pStringBody) {
        return this.symRoot.sourceLanguage.makeCstringWithTrailing0(pStringBody);
    }

    public NamedConst namedConst(String pInternedName, Const pConst) {
        NamedConst lNamedConst = (NamedConst)this.symRoot.symTableConst.searchOrAdd(pInternedName, 7, null, true, true);
        ((NamedConstImpl)lNamedConst).fType = pConst.getSymType();
        ((NamedConstImpl)lNamedConst).fConstValue = pConst;
        ((NamedConstImpl)lNamedConst).fIndexValue = pConst.longValue();
        return lNamedConst;
    }

    public NamedConst namedConst(String pInternedName, int pIndex, Type pType) {
        NamedConst lNamedConst = (NamedConst)this.symRoot.symTableConst.searchOrAdd(pInternedName, 7, null, true, true);
        ((NamedConstImpl)lNamedConst).fType = pType;
        ((NamedConstImpl)lNamedConst).fIndexValue = pIndex;
        ((NamedConstImpl)lNamedConst).fConstValue = this.symRoot.sym.intConst(pIndex, this.symRoot.typeInt);
        return lNamedConst;
    }

    public Integer intObject(int pIntValue) {
        return Integer.valueOf(Integer.toString(pIntValue, 10), 10);
    }

    public Var defineVar(String pInternedName, Type pType) {
        Var lVar = this.defineVar(pInternedName, pType, this.symRoot.symTableCurrent.getOwner());
        return lVar;
    }

    public Var defineVar(String pInternedName, Type pType, Sym pDefinedIn) {
        Var lVar = (Var)this.symRoot.symTableCurrent.defineUnique(pInternedName, 8, pDefinedIn);
        if (lVar != null) {
            ((VarImpl)lVar).fType = pType;
            if (this.symRoot.symTableCurrent == this.symRoot.symTableRoot) {
                lVar.setStorageClass(6);
            }
        }
        return lVar;
    }

    public Var defineRegionVar(String pInternedName, RegionType pType) {
        Var lVar;
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(6, "defineRegionVar", pInternedName);
        }
        if ((lVar = (Var)this.symRoot.symTableRoot.defineUnique(pInternedName, 8, null)) != null) {
            ((VarImpl)lVar).fType = pType;
        } else {
            lVar = (Var)this.symRoot.symTableRoot.searchLocal(pInternedName, 8, true);
        }
        return lVar;
    }

    public Param defineParam(String pInternedName, Type pType) {
        Param lParam = (Param)this.symRoot.symTableCurrent.defineUnique(pInternedName, 9, this.symRoot.symTableCurrent.getOwner());
        if (lParam != null) {
            ((ParamImpl)lParam).fType = pType;
        }
        return lParam;
    }

    public Elem defineElem(String pInternedName, Type pType) {
        Elem lElem = (Elem)this.symRoot.symTableCurrent.defineUnique(pInternedName, 10, this.symRoot.symTableCurrent.getOwner());
        if (lElem != null) {
            ((ElemImpl)lElem).fType = pType;
        }
        return lElem;
    }

    public Subp defineSubp(String pInternedName, Type pType) {
        Subp lSubp = (Subp)this.symRoot.symTableCurrent.searchOrAdd(pInternedName, 12, this.symRoot.symTableCurrent.getOwner(), true, true);
        lSubp.setReturnValueType(pType);
        return lSubp;
    }

    public Label defineLabel(String pInternedName) {
        Label lLabel = (Label)this.symRoot.symTableCurrentSubp.defineUnique(pInternedName, 14, this.symRoot.symTableCurrent.getOwner());
        if (lLabel != null) {
            ((LabelImpl)lLabel).fType = this.symRoot.typeVoid;
            ((SubpImpl)this.symRoot.subpCurrent).addToLabelDefList(lLabel);
        }
        return lLabel;
    }

    public BaseType baseType(String pInternedName, int pTypeKind) {
        SymTableEntry lEntry = this.symRoot.symTableRoot.searchOrAddEntry(pInternedName, 13, null, true, true);
        BaseType lType = (BaseType)lEntry.getEntrySym();
        if (lType == null) {
            lType = new BaseTypeImpl(this.symRoot, pInternedName, pTypeKind);
            lEntry.setEntrySym(lType);
            this.symRoot.symTableRoot.linkSym(lType);
            int lSize = machineParam.evaluateSize(pTypeKind);
            if (pTypeKind != 4 && pTypeKind != 14) {
                lType.setSizeValue(lSize);
            }
        }
        return lType;
    }

    public VectorType vectorType(Type pElemType, long pElemCount) {
        VectorTypeImpl vec = new VectorTypeImpl(this.symRoot, pElemType, pElemCount);
        SymTable tbl = this.symRoot.symTableCurrent.searchTableHaving(pElemType);
        if (tbl == null) {
            this.symRoot.ioRoot.msgError.put(1013, "Element type of VectorType not found");
        }
        VectorType lType = (VectorType)tbl.searchOrAddSym(vec);
        return lType;
    }

    public VectorType vectorType(Type pElemType, Exp pElemCountExp) {
        long lElemCount = pElemCountExp != null ? pElemCountExp.evaluateAsLong() : 0L;
        VectorTypeImpl vec = new VectorTypeImpl(this.symRoot, this.makeVectorTypeName(pElemType, lElemCount), pElemType, 0L, pElemCountExp, 0L, null);
        SymTable tbl = this.symRoot.symTableCurrent.searchTableHaving(pElemType);
        if (tbl == null) {
            this.symRoot.ioRoot.msgError.put(1013, "Element type of VectorType not found");
        }
        VectorType lType = (VectorType)tbl.searchOrAddSym(vec);
        return lType;
    }

    public VectorType vectorType(String pTypeName, Type pElemType, long pElemCount, long pLowerBound) {
        VectorTypeImpl vec = new VectorTypeImpl(this.symRoot, pTypeName, pElemType, pElemCount, null, pLowerBound, null);
        SymTable tbl = this.symRoot.symTableCurrent.searchTableHaving(pElemType);
        if (tbl == null) {
            this.symRoot.ioRoot.msgError.put(1013, "Element type of VectorType not found");
        }
        VectorType lType = (VectorType)tbl.searchOrAddSym(vec);
        return lType;
    }

    public VectorType vectorType(String pTypeName, Type pElemType, Exp pElemCountExp, Exp pLowerBoundExp) {
        VectorTypeImpl vec = new VectorTypeImpl(this.symRoot, pTypeName, pElemType, 0L, pElemCountExp, 0L, pLowerBoundExp);
        SymTable tbl = this.symRoot.symTableCurrent.searchTableHaving(pElemType);
        if (tbl == null) {
            this.symRoot.ioRoot.msgError.put(1013, "Element type of VectorType not found");
        }
        VectorType lType = (VectorType)tbl.searchOrAddSym(vec);
        return lType;
    }

    public VectorType vectorTypeUnfixed(Type pElemType, long pLowerBound) {
        VectorTypeImpl vec = new VectorTypeImpl(this.symRoot, this.makeVectorTypeName(pElemType, 0L), pElemType, 0L, null, pLowerBound, null);
        vec.setFlag(17, true);
        SymTable tbl = this.symRoot.symTableCurrent.searchTableHaving(pElemType);
        if (tbl == null) {
            this.symRoot.ioRoot.msgError.put(1013, "Element type of VectorType not found");
        }
        VectorType lType = (VectorType)tbl.searchOrAddSym(vec);
        lType.setFlag(17, true);
        return lType;
    }

    public VectorType vectorTypeUnfixed(Type pElemType, Exp pLowerBoundExp) {
        VectorTypeImpl vec = new VectorTypeImpl(this.symRoot, this.makeVectorTypeName(pElemType, 0L), pElemType, 0L, null, 0L, pLowerBoundExp);
        vec.setFlag(17, true);
        SymTable tbl = this.symRoot.symTableCurrent.searchTableHaving(pElemType);
        if (tbl == null) {
            this.symRoot.ioRoot.msgError.put(1013, "Element type of VectorType not found");
        }
        VectorType lType = (VectorType)tbl.searchOrAddSym(vec);
        lType.setFlag(17, true);
        return lType;
    }

    public PointerType pointerType(Type pPointedType) {
        return this.pointerType(pPointedType, this.symRoot.symTableCurrent);
    }

    public PointerType pointerType(Type pPointedType, SymTable pSymTable) {
        SymTable lSymTable = pSymTable;
        if (lSymTable == null) {
            lSymTable = this.symRoot.symTableCurrent;
        }
        lSymTable = lSymTable.searchTableHaving(pPointedType);
        String lName = "<PTR " + pPointedType.getName() + ">";
        SymTableEntry lEntry = lSymTable.searchOrAddEntry(lName = lName.intern(), 13, lSymTable.getOwner(), true, true);
        PointerType lType = (PointerType)lEntry.getEntrySym();
        if (lType == null) {
            lType = new PointerTypeImpl(this.symRoot, lName, pPointedType);
            lEntry.setEntrySym(lType);
            lSymTable.linkSym(lType);
        }
        return lType;
    }

    public PointerType pointerType(String pInternedName, Type pPointedType, Sym pDefinedIn) {
        String lName;
        SymTable lSymTable = this.symRoot.symTableCurrent;
        lSymTable = lSymTable.searchTableHaving(pPointedType);
        if (pInternedName == null) {
            lName = "<PTR " + pPointedType.getName() + ">";
            lName = lName.intern();
        } else {
            lName = pInternedName;
        }
        SymTableEntry lEntry = lSymTable.searchOrAddEntry(lName, 13, pDefinedIn, true, true);
        PointerType lType = (PointerType)lEntry.getEntrySym();
        if (lType == null) {
            lType = new PointerTypeImpl(this.symRoot, lName, pPointedType);
            lEntry.setEntrySym(lType);
            lSymTable.linkSym(lType);
        }
        return lType;
    }

    public PointerType pointerType(Type pPointedType, long pElemCount) {
        return this.pointerType(pPointedType, pElemCount, 0L);
    }

    public PointerType pointerType(Type pPointedType, long pElemCount, long pLowerBound) {
        SymTable lSymTable = this.symRoot.symTableCurrent;
        lSymTable = lSymTable.searchTableHaving(pPointedType);
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("<PTR ");
        lBuffer.append(Long.toString(pElemCount, 10));
        lBuffer.append(" ");
        lBuffer.append(Long.toString(pLowerBound, 10));
        lBuffer.append(" ");
        lBuffer.append(pPointedType.getName());
        lBuffer.append(">");
        String lName = lBuffer.toString().intern();
        SymTableEntry lEntry = lSymTable.searchOrAddEntry(lName, 13, lSymTable.getOwner(), true, true);
        PointerType lType = (PointerType)lEntry.getEntrySym();
        if (lType == null) {
            lType = new PointerTypeImpl(this.symRoot, pPointedType, pElemCount, pLowerBound);
            lEntry.setEntrySym(lType);
            lSymTable.linkSym(lType);
        }
        return lType;
    }

    public StructType structType(IrList pElemList, Sym pTag) {
        StructType lType;
        Sym lTag = pTag != null && pTag.getSymKind() == 11 ? pTag : this.symRoot.symTableCurrent.generateTag();
        String lName = ("<STRUCT " + lTag.getName() + ">").intern();
        SymTableEntry lEntry = this.symRoot.symTableCurrent.searchOrAddEntry(lName, 13, this.symRoot.symTableCurrent.getOwner(), true, true);
        Sym lSym = lEntry.getEntrySym();
        if (lSym == null) {
            lType = new StructTypeImpl(this.symRoot, lName, pElemList);
            lEntry.setEntrySym(lType);
            this.symRoot.symTableCurrent.linkSym(lType);
        } else {
            if (this.fDbgLevel > 3) {
                this.symRoot.ioRoot.dbgSym.print(6, "structType", lSym.getName() + " kind " + lSym.getSymKindName());
            }
            lType = (StructType)lEntry.getEntrySym();
        }
        lType.setDefinedIn(this.symRoot.symTableCurrent.getOwner());
        lType.setTag(lTag);
        return lType;
    }

    public StructType structType(String pInternedName, IrList pElemList, Sym pTag) {
        StructType lType;
        String lName = pInternedName;
        SymTableEntry lEntry = this.symRoot.symTableCurrent.searchOrAddEntry(lName, 13, this.symRoot.symTableCurrent.getOwner(), true, true);
        Sym lSym = lEntry.getEntrySym();
        if (lSym == null) {
            lType = new StructTypeImpl(this.symRoot, lName, pElemList);
            lEntry.setEntrySym(lType);
            this.symRoot.symTableCurrent.linkSym(lType);
        } else {
            if (this.fDbgLevel > 3) {
                this.symRoot.ioRoot.dbgSym.print(6, "structType", lSym.getName() + " kind " + lSym.getSymKindName());
            }
            lType = (StructType)lEntry.getEntrySym();
        }
        if (pTag != null && pTag.getSymKind() == 11) {
            lType.setTag(pTag);
        }
        return lType;
    }

    public UnionType unionType(IrList pElemList, Sym pTag) {
        UnionType lType;
        Sym lTag = pTag != null && pTag.getSymKind() == 11 ? pTag : this.symRoot.symTableCurrent.generateTag();
        String lName = ("<UNION " + lTag.getName() + ">").intern();
        SymTableEntry lEntry = this.symRoot.symTableCurrent.searchOrAddEntry(lName, 13, this.symRoot.symTableCurrent.getOwner(), true, true);
        Sym lSym = lEntry.getEntrySym();
        if (lSym == null) {
            lType = new UnionTypeImpl(this.symRoot, lName, pElemList);
            lEntry.setEntrySym(lType);
            this.symRoot.symTableCurrent.linkSym(lType);
        } else {
            if (this.fDbgLevel > 3) {
                this.symRoot.ioRoot.dbgSym.print(6, "unionType", lSym.getName() + " kind " + lSym.getSymKindName());
            }
            lType = (UnionType)lEntry.getEntrySym();
        }
        lType.setDefinedIn(this.symRoot.symTableCurrent.getOwner());
        lType.setTag(lTag);
        return lType;
    }

    public UnionType unionType(String pInternedName, IrList pElemList, Sym pTag) {
        String lName = pInternedName;
        SymTableEntry lEntry = this.symRoot.symTableCurrent.searchOrAddEntry(lName, 13, this.symRoot.symTableCurrent.getOwner(), true, true);
        UnionType lType = (UnionType)lEntry.getEntrySym();
        if (lType == null) {
            lType = new UnionTypeImpl(this.symRoot, lName, pElemList);
            lEntry.setEntrySym(lType);
            this.symRoot.symTableCurrent.linkSym(lType);
        }
        if (pTag != null && pTag.getSymKind() == 11) {
            lType.setTag(pTag);
        }
        return lType;
    }

    public RegionType regionType(String pRegionNameString, int pStorageClass) {
        RegionType lType;
        String lRegionNameString;
        if (pRegionNameString == null || pRegionNameString.intern() == "" || pRegionNameString.charAt(0) == ' ') {
            Sym lTag = this.symRoot.symTableRoot.generateSym(this.symRoot.typeRegion, 13, machineParam.blankRegionName(), this.symRoot.symTableRoot.getOwner());
            lRegionNameString = lTag.getName();
        } else {
            lRegionNameString = pRegionNameString;
        }
        String lName = ("<REGION " + lRegionNameString + ">").intern();
        SymTableEntry lEntry = this.symRoot.symTableRoot.searchOrAddEntry(lName, 13, this.symRoot.symTableCurrent.getOwner(), true, true);
        Sym lSym = lEntry.getEntrySym();
        if (lSym == null) {
            lType = new RegionTypeImpl(this.symRoot, lRegionNameString, pStorageClass);
            lEntry.setEntrySym(lType);
            this.symRoot.symTableRoot.linkSym(lType);
        } else {
            lType = (RegionType)lEntry.getEntrySym();
        }
        lType.setDefinedIn(this.symRoot.symTableRoot.getOwner());
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(6, "regionType", lType.toString());
        }
        return lType;
    }

    public RegionType regionType(String pRegionNameString) {
        return this.regionType(pRegionNameString, 6);
    }

    public EnumType enumType(IrList pElemList, Sym pTag) {
        EnumType lType;
        Sym lTag = pTag != null && pTag.getSymKind() == 11 ? pTag : this.symRoot.symTableCurrent.generateTag();
        String lName = ("<ENUM " + lTag.getName() + ">").intern();
        SymTableEntry lEntry = this.symRoot.symTableCurrent.searchOrAddEntry(lName, 13, this.symRoot.symTableCurrent.getOwner(), true, true);
        Sym lSym = lEntry.getEntrySym();
        if (lSym == null) {
            lType = new EnumTypeImpl(this.symRoot, lName, pElemList);
            lEntry.setEntrySym(lType);
            this.symRoot.symTableCurrent.linkSym(lType);
        } else {
            if (this.fDbgLevel > 3) {
                this.symRoot.ioRoot.dbgSym.print(6, "enumType", lSym.getName() + " kind " + lSym.getSymKindName());
            }
            lType = (EnumType)lEntry.getEntrySym();
        }
        lType.setDefinedIn(this.symRoot.symTableCurrent.getOwner());
        lType.setTag(lTag);
        return lType;
    }

    public EnumType enumType(String pInternedName, IrList pEnumList, Sym pTag) {
        EnumType lType;
        String lName = pInternedName;
        SymTableEntry lEntry = this.symRoot.symTableCurrent.searchOrAddEntry(lName, 13, this.symRoot.symTableCurrent.getOwner(), true, true);
        Sym lSym = lEntry.getEntrySym();
        if (lSym == null) {
            lType = new EnumTypeImpl(this.symRoot, lName, pEnumList);
            lEntry.setEntrySym(lType);
            this.symRoot.symTableCurrent.linkSym(lType);
        } else {
            if (this.fDbgLevel > 3) {
                this.symRoot.ioRoot.dbgSym.print(6, "enumType", lSym.getName() + " kind " + lSym.getSymKindName());
            }
            lType = (EnumType)lEntry.getEntrySym();
        }
        lType.setDefinedIn(this.symRoot.symTableCurrent.getOwner());
        if (pTag != null && pTag.getSymKind() == 11) {
            lType.setTag(pTag);
        }
        return lType;
    }

    public DefinedType definedType(String pInternedName, Type pOriginalType) {
        DefinedType lType;
        String lName;
        SymTableEntry lEntry;
        Sym lSym;
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(4, "definedType", pInternedName + " " + pOriginalType.getName());
        }
        if ((lSym = (lEntry = this.symRoot.symTableCurrent.searchOrAddEntry(lName = ("<TYPEDEF " + pInternedName + ">").intern(), 13, this.symRoot.symTableCurrent.getOwner(), true, true)).getEntrySym()) == null) {
            lType = new DefinedTypeImpl(this.symRoot, lName, pOriginalType);
            lEntry.setEntrySym(lType);
            this.symRoot.symTableCurrent.linkSym(lType);
        } else {
            lType = (DefinedType)lSym;
        }
        return lType;
    }

    public DefinedType definedType(String pInternedName, Type pOriginalType, Sym pDefinedIn) {
        DefinedType lType;
        String lName;
        SymTableEntry lEntry;
        Sym lSym;
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(4, "definedType", pInternedName + " " + pOriginalType.getName());
        }
        if ((lSym = (lEntry = this.symRoot.symTableCurrent.searchOrAddEntry(lName = ("<TYPEDEF " + pInternedName + ">").intern(), 13, pDefinedIn, true, true)).getEntrySym()) == null) {
            lType = new DefinedTypeImpl(this.symRoot, lName, pOriginalType);
            lEntry.setEntrySym(lType);
            this.symRoot.symTableCurrent.linkSym(lType);
        } else {
            lType = (DefinedType)lSym;
        }
        return lType;
    }

    public SubpType subpType(Type pReturnType, IrList pParamList, boolean pOptionalParam, Sym pDefinedIn) {
        return this.subpType(pReturnType, pParamList, pOptionalParam, false, pDefinedIn);
    }

    public SubpType subpType(Type pReturnType, IrList pParamList, boolean pOptionalParam, boolean pNoParamSpec, Sym pDefinedIn) {
        String lSubpTypeName = this.symRoot.sym.makeSubpTypeName(pReturnType, pParamList, pOptionalParam, pNoParamSpec).intern();
        SymTableEntry lEntry = this.symRoot.symTableCurrent.searchOrAddEntry(lSubpTypeName.intern(), 13, pDefinedIn, true, true);
        SubpType lType = (SubpType)lEntry.getEntrySym();
        if (lType == null) {
            lType = new SubpTypeImpl(this.symRoot, lSubpTypeName, pReturnType, pParamList, pOptionalParam, pNoParamSpec);
            lEntry.setEntrySym(lType);
            this.symRoot.symTableCurrent.linkSym(lType);
        }
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(4, "subpType", lType.getName());
        }
        return lType;
    }

    public Sym symbol(String pInternedName, Type pType, Sym pDefinedIn) {
        Sym lSym = this.symRoot.symTableCurrent.searchOrAdd(pInternedName, 1, pDefinedIn, true, false);
        ((SymImpl)lSym).fType = pType;
        return lSym;
    }

    public Sym derivedSym() {
        if (this.symRoot.symTableCurrentSubp != null) {
            return this.symRoot.symTableCurrentSubp.generateDerivedSym(this);
        }
        return this.symRoot.symTableCurrent.generateDerivedSym(this);
    }

    public String makeVectorTypeName(Type pElemType, long pElemCount) {
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("<VECT ");
        lBuffer.append(Long.toString(pElemCount, 10));
        lBuffer.append(" 0 ");
        lBuffer.append(pElemType.getName());
        lBuffer.append(">");
        return lBuffer.toString().intern();
    }

    public String makeVectorTypeName(Type pElemType, long pElemCount, long pLowerBound) {
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("<VECT ");
        lBuffer.append(Long.toString(pElemCount, 10));
        lBuffer.append(" ");
        lBuffer.append(Long.toString(pLowerBound, 10));
        lBuffer.append(" ");
        lBuffer.append(pElemType.getName());
        lBuffer.append(">");
        return lBuffer.toString().intern();
    }

    public String makeVectorTypeName(Type pElemType, Exp pElemCountExp, long pElemCount, Exp pLowerBoundExp, long pLowerBound) {
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("<VECT ");
        if (pElemCountExp != null) {
            lBuffer.append(this.makeExpString(pElemCountExp));
        } else {
            lBuffer.append(Long.toString(pElemCount, 10));
        }
        lBuffer.append(" ");
        if (pLowerBoundExp != null) {
            lBuffer.append(this.makeExpString(pLowerBoundExp));
        } else {
            lBuffer.append(Long.toString(pLowerBound, 10));
        }
        lBuffer.append(" ");
        lBuffer.append(pElemType.getName());
        lBuffer.append(">");
        return lBuffer.toString().intern();
    }

    public String makeExpString(Exp pExp) {
        StringBuffer lBuffer = new StringBuffer();
        if (pExp instanceof VarNode) {
            Sym lVar = ((VarNode)pExp).getSymNodeSym();
            lBuffer.append(lVar.getName());
        } else if (pExp instanceof ConstNode) {
            lBuffer.append(((ConstNode)pExp).getIntValue());
        } else if (pExp.getOperator() == 68 && pExp.getChild1() instanceof VarNode) {
            lBuffer.append(this.makeExpString((Exp)pExp.getChild1()));
        } else {
            lBuffer.append(pExp.toStringWithChildren());
        }
        return lBuffer.toString().intern();
    }

    public String makeStructUnionTypeName(boolean pStruct, IrList pElemList) {
        StringBuffer lBuffer = new StringBuffer();
        if (pStruct) {
            lBuffer.append("<STRUCT ");
        } else {
            lBuffer.append("<UNION ");
        }
        if (pElemList != null) {
            lBuffer.append(TypeImpl.getElemListString(pElemList));
        }
        lBuffer.append(">");
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(6, "makeStructUnionTypeName", lBuffer.toString());
        }
        return lBuffer.toString().intern();
    }

    public String makeEnumTypeName(IrList pElemList) {
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("<ENUM ");
        if (pElemList != null) {
            lBuffer.append(TypeImpl.getEnumListString(pElemList));
        }
        lBuffer.append(">");
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(6, "makeEnumTypeName", lBuffer.toString());
        }
        return lBuffer.toString().intern();
    }

    public String makeSubpTypeName(Type pReturnType, IrList pParamList, boolean pOptionalParam) {
        return this.makeSubpTypeName(pReturnType, pParamList, pOptionalParam, false);
    }

    public String makeSubpTypeName(Type pReturnType, IrList pParamList, boolean pOptionalParam, boolean pNoParamSpec) {
        if (this.fDbgLevel > 3) {
            IoRoot cfr_ignored_0 = this.symRoot.ioRoot;
            this.symRoot.ioRoot.dbgSym.print(6, "makeSubpTypeName", "ReturnType " + pReturnType.getName() + " " + IoRoot.toStringObject(pParamList));
        }
        StringBuffer lBuffer = new StringBuffer();
        IrListImpl lParamTypeList = new IrListImpl(this.symRoot.getHirRoot());
        if (pParamList != null) {
            ListIterator lParamIterator = pParamList.iterator();
            while (lParamIterator.hasNext()) {
                Sym lParamListSym = (Sym)lParamIterator.next();
                if (lParamListSym.getSymKind() == 13) {
                    lParamTypeList.add((Type)lParamListSym);
                    continue;
                }
                if (lParamListSym.getSymKind() != 9) continue;
                lParamTypeList.add(((Param)lParamListSym).getSymType());
            }
        }
        lBuffer.append("<SUBP <").append(((Object)lParamTypeList).toString());
        lBuffer.append("> ").append(String.valueOf(pOptionalParam)).append(" ").append(String.valueOf(pNoParamSpec)).append(" ").append(pReturnType.getName());
        lBuffer.append(">");
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(6, lBuffer.toString());
        }
        return lBuffer.toString().intern();
    }

    public String getSymKindName() {
        return Sym.KIND_NAME[this.fKind];
    }

    public void linkSym(Sym pNextSym) {
        ((SymImpl)pNextSym).fNextSym = this.fNextSym;
        this.fNextSym = pNextSym;
    }

    public String getName() {
        if (this.fName != null) {
            if (this.getFlag(3)) {
                return this.fName.substring(1);
            }
            return this.fName;
        }
        return "";
    }

    public String getPureName() {
        if (this.fName != null) {
            return this.fName;
        }
        return "";
    }

    public String getNameOrNull(Sym pSym) {
        if (pSym == null) {
            return "null";
        }
        return pSym.getName();
    }

    public Sym getNextSym() {
        Sym lNextSym = this.fNextSym;
        while (lNextSym != null && lNextSym.isRemoved()) {
            lNextSym = ((SymImpl)lNextSym).fNextSym;
        }
        return lNextSym;
    }

    public String getUniqueName() {
        if (this.fUniqueNameSym != null) {
            return this.fUniqueNameSym.getName();
        }
        return this.getName();
    }

    public void setUniqueNameSym(Sym pUniqueNameSym) {
        this.fUniqueNameSym = pUniqueNameSym;
        ((SymImpl)pUniqueNameSym).setOriginalSym(this);
    }

    public Sym getOriginalSym() {
        if (this.fSymInf == null) {
            return this;
        }
        if (this.fSymInf.getOriginalSym() == null) {
            return this;
        }
        return this.fSymInf.getOriginalSym();
    }

    public void setOriginalSym(Sym pOriginalSym) {
        if (this.fSymInf == null) {
            this.fSymInf = new SymInf();
        }
        this.fSymInf.setOriginalSym(pOriginalSym);
    }

    public Sym getOriginalSym(String pName) {
        Sym lUniqueSym = this.symRoot.symTableUnique.search(pName);
        if (lUniqueSym != null) {
            return this.getOriginalSym();
        }
        Sym lSym = this.symRoot.symTableCurrent.search(pName);
        if (lSym != null) {
            return lSym.getOriginalSym();
        }
        return null;
    }

    public Sym getDefinedIn() {
        return this.fDefinedIn;
    }

    public void setDefinedIn(Sym pDefiningSym) {
        this.fDefinedIn = pDefiningSym;
    }

    public String getDefinedInName() {
        if (this.fDefinedIn != null) {
            return this.fDefinedIn.getName();
        }
        return "";
    }

    public SymTable getRecordedIn() {
        return this.fRecordedIn;
    }

    public void setRecordedIn(SymTable pSymTable) {
        this.fRecordedIn = pSymTable;
    }

    public int getSymKind() {
        return this.fKind;
    }

    public void setSymKind(int pSymKind) {
        if (this.fKind == 1 || pSymKind == 0) {
            this.fKind = pSymKind;
        }
    }

    public Type getSymType() {
        return this.fType;
    }

    public void setSymType(Type pSymType) {
        this.fType = pSymType;
    }

    public boolean getFlag(int pFlagNumber) {
        return this.fFlagBox.getFlag(pFlagNumber);
    }

    public void setFlag(int pFlagNumber, boolean pYesNo) {
        this.fFlagBox.setFlag(pFlagNumber, pYesNo);
    }

    public boolean isGlobal() {
        return this.getDefinedIn() == null;
    }

    public void remove() {
        if (this.fDbgLevel > 2) {
            this.symRoot.ioRoot.dbgSym.print(3, "remove", this.getName());
        }
        this.fKind = 0;
    }

    public boolean isRemoved() {
        return this.getSymKind() == 0;
    }

    public SymInf getInf() {
        return this.fSymInf;
    }

    public SymInf getOrAddInf() {
        if (this.fSymInf == null) {
            this.fSymInf = new SymInf();
        }
        return this.fSymInf;
    }

    public SourceInf getSourceInf() {
        return this.fSourceInf;
    }

    public void setSourceInf(SourceInf pInf) {
        this.fSourceInf = pInf;
    }

    public String getDefinedFile() {
        if (this.fSourceInf != null) {
            return this.fSourceInf.getDefinedFile();
        }
        return null;
    }

    public void setDefinedFile(String pDefinedFile) {
        if (this.fSourceInf == null) {
            this.fSourceInf = new SourceInfImpl();
        }
        this.fSourceInf.setDefinedFile(pDefinedFile);
    }

    public int getDefinedLine() {
        if (this.fSourceInf != null) {
            return this.fSourceInf.getDefinedLine();
        }
        return 0;
    }

    public void setDefinedLine(int pDefinedLine) {
        if (this.fSourceInf == null) {
            this.fSourceInf = new SourceInfImpl();
        }
        this.fSourceInf.setDefinedLine(pDefinedLine);
    }

    public int getDefinedColumn() {
        if (this.fSourceInf != null) {
            return this.fSourceInf.getDefinedColumn();
        }
        return 0;
    }

    public Object getWork() {
        return this.fWork;
    }

    public void setWork(Object pWork) {
        this.fWork = pWork;
    }

    public boolean isSym() {
        return true;
    }

    public boolean isHIR() {
        return false;
    }

    public String toString() {
        String symString = this.fName;
        if (this instanceof FlowAnalSym) {
            symString = symString + " " + ((FlowAnalSym)((Object)this)).getIndex();
        }
        return symString;
    }

    public String toStringShort() {
        return this.fName;
    }

    public String toStringDetail() {
        String lDefinedIn;
        String lString = this.getSymKindName() + " " + this.toString();
        if (this.fType != null && this.fKind != 13) {
            lString = lString + " " + this.fType.getName();
        }
        if (this.fUniqueNameSym != null) {
            lString = lString + " unq:" + this.fUniqueNameSym.getName();
        }
        if ((lDefinedIn = this.getDefinedInName()) != "") {
            lString = lString + " in " + lDefinedIn;
        }
        if (this.fSourceInf != null && this.fSourceInf.getDefinedFile() != null) {
            lString = lString + " " + ((Object)this.fSourceInf).toString();
        }
        if (!this.fFlagBox.allFalse()) {
            lString = lString + ((Object)this.fFlagBox).toString();
        }
        return lString;
    }

    public void print(int pIndent) {
        String lString = this.getSymKindName() + " " + this.toString();
        this.symRoot.ioRoot.printOut.print(" " + lString);
    }

    public void print(int pIndent, boolean pDetail) {
        String lString = pDetail ? this.getSymKindName() + " " + this.toStringDetail() : this.getSymKindName() + " " + this.toString();
        this.symRoot.ioRoot.printOut.print(" " + lString);
    }
}

