/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Function;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.sym.Label;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;

class Util {
    private SsaEnvironment env;
    private Function f;

    Util(SsaEnvironment e, Function function) {
        this.env = e;
        this.f = function;
    }

    LirNode makeNewJump(BasicBlk blk, LirLabelRef labelRef) {
        LirNode newJump = this.env.lir.operator(49, 0, labelRef, ImList.Empty);
        BiLink q = blk.instrList().last();
        q.addBefore(newJump);
        q.unlink();
        blk.maintEdges();
        this.f.flowGraph().touch();
        return newJump;
    }

    BiList findTargetLir(LirNode root, int opCode, BiList l) {
        if (root != null) {
            if (root.opCode == opCode) {
                l.add(root);
            }
            for (int i = 0; i < root.nKids(); ++i) {
                l = this.findTargetLir(root.kid(i), opCode, l);
            }
        }
        return l;
    }

    void changeLabelRef(boolean isTranslate) {
        FlowGraph g = this.f.flowGraph();
        BasicBlk entry = g.entryBlk();
        BiLink p = g.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                switch (node.opCode) {
                    case 49: {
                        LirNode newLabel = isTranslate ? this.env.lir.labelRefVariant(((LirLabelRef)node.kid((int)0)).label) : this.env.lir.labelRef(((LirLabelRef)node.kid((int)0)).label);
                        node.setKid(0, newLabel);
                        break;
                    }
                    case 50: {
                        LirNode newLabel;
                        for (int i = 1; i < node.nKids(); ++i) {
                            newLabel = isTranslate ? this.env.lir.labelRefVariant(((LirLabelRef)node.kid((int)i)).label) : this.env.lir.labelRef(((LirLabelRef)node.kid((int)i)).label);
                            node.setKid(i, newLabel);
                        }
                        break;
                    }
                    case 51: {
                        LirNode newLabel;
                        for (int i = 0; i < node.kid(1).nKids(); ++i) {
                            newLabel = isTranslate ? this.env.lir.labelRefVariant(((LirLabelRef)node.kid((int)1).kid((int)i).kid((int)1)).label) : this.env.lir.labelRef(((LirLabelRef)node.kid((int)1).kid((int)i).kid((int)1)).label);
                            node.kid(1).kid(i).setKid(1, newLabel);
                        }
                        LirNode newLabel2 = isTranslate ? this.env.lir.labelRefVariant(((LirLabelRef)node.kid((int)2)).label) : this.env.lir.labelRef(((LirLabelRef)node.kid((int)2)).label);
                        node.setKid(2, newLabel2);
                        break;
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    BiList predEdges(BasicBlk blk, boolean getPredBlk) {
        BiList edges = new BiList();
        BiLink p = blk.predList().first();
        while (!p.atEnd()) {
            BasicBlk pred = (BasicBlk)p.elem();
            Label[] target = ((LirNode)pred.instrList().last().elem()).getTargets();
            for (int i = 0; i < target.length; ++i) {
                if (blk.label().basicBlk() != target[i].basicBlk()) continue;
                if (getPredBlk) {
                    edges.add(pred);
                    continue;
                }
                edges.add(target[i]);
            }
            p = p.next();
        }
        return edges;
    }

    LirNode makePhiInst(Symbol s, BasicBlk blk) {
        BiList edges = this.predEdges(blk, false);
        BiList preds = this.predEdges(blk, true);
        LirNode[] args = new LirNode[edges.length() + 1];
        int argNum = 0;
        args[argNum] = this.env.lir.symRef(6, s.type, s, ImList.Empty);
        ++argNum;
        BiLink p = preds.first();
        while (!p.atEnd()) {
            int j;
            boolean isOK;
            BasicBlk pred = (BasicBlk)p.elem();
            LirNode[] anArg = new LirNode[3];
            anArg[0] = this.env.lir.symRef(6, s.type, s, ImList.Empty);
            anArg[1] = this.env.lir.labelRefVariant(pred.label());
            Label targetLabel = blk.label();
            LirNode predJump = (LirNode)pred.instrList().last().elem();
            if (predJump.opCode == 49) {
                LirLabelRef labelRef = (LirLabelRef)predJump.kid(0);
                if (targetLabel.basicBlk() == labelRef.label.basicBlk()) {
                    boolean isOK2 = true;
                    for (int i = 1; i < argNum; ++i) {
                        if (args[i].kid(2) == null || ((LirLabelRef)args[i].kid((int)2)).variant != labelRef.variant) continue;
                        isOK2 = false;
                    }
                    if (isOK2) {
                        anArg[2] = labelRef;
                    }
                }
            } else if (predJump.opCode == 50) {
                boolean isFound = false;
                for (int i = 1; i < predJump.nKids(); ++i) {
                    LirLabelRef labelRef = (LirLabelRef)predJump.kid(i);
                    if (targetLabel.basicBlk() != labelRef.label.basicBlk()) continue;
                    isOK = true;
                    for (j = 1; j < argNum; ++j) {
                        if (args[j].kid(2) == null || ((LirLabelRef)args[j].kid((int)2)).variant != labelRef.variant) continue;
                        isOK = false;
                    }
                    if (!isOK) continue;
                    isFound = true;
                    anArg[2] = labelRef;
                }
            } else if (predJump.opCode == 51) {
                boolean isFound = false;
                for (int i = 0; i < predJump.kid(1).nKids(); ++i) {
                    LirLabelRef labelRef = (LirLabelRef)predJump.kid(1).kid(i).kid(1);
                    if (targetLabel.basicBlk() != labelRef.label.basicBlk()) continue;
                    isOK = true;
                    for (j = 1; j < argNum; ++j) {
                        if (args[j].kid(2) == null || ((LirLabelRef)args[j].kid((int)2)).variant != labelRef.variant) continue;
                        isOK = false;
                    }
                    if (!isOK) continue;
                    isFound = true;
                    anArg[2] = labelRef;
                }
                if (!isFound) {
                    LirLabelRef labelRef = (LirLabelRef)predJump.kid(2);
                    if (targetLabel.basicBlk() == labelRef.label.basicBlk()) {
                        boolean isOK3 = true;
                        for (int i = 1; i < argNum; ++i) {
                            if (args[i].kid(2) == null || ((LirLabelRef)args[i].kid((int)2)).variant != labelRef.variant) continue;
                            isOK3 = false;
                        }
                        if (isOK3) {
                            anArg[2] = labelRef;
                        }
                    }
                }
            } else {
                System.err.println("TranslateToSsa.java : Unexpected LIR node : " + predJump);
                System.exit(1);
            }
            args[argNum] = this.env.lir.operator(61, 0, anArg, ImList.Empty);
            ++argNum;
            p = p.next();
        }
        LirNode phiInst = this.env.lir.operator(59, s.type, args, ImList.Empty);
        return phiInst;
    }
}

