/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Op;
import coins.backend.Type;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import java.io.IOException;
import java.io.OutputStreamWriter;

class SsaGraphNode {
    public final BasicBlk belong;
    public final int opCode;
    public final LirNode node;
    public final SsaGraphNode[] parents;
    private SsaEnvironment env;
    private Symbol symbol;

    public SsaGraphNode(SsaEnvironment e, LirNode n, BasicBlk blk, int numOfParents) {
        this.env = e;
        this.belong = blk;
        this.node = n;
        this.opCode = n.opCode;
        this.parents = new SsaGraphNode[numOfParents];
        this.symbol = null;
    }

    Symbol symbol() {
        return this.symbol;
    }

    void setSymbol(Symbol s) {
        this.symbol = s;
    }

    public String toString() {
        String str = "(" + Op.toName(this.opCode) + " " + Type.toString(this.node.type);
        if (this.symbol != null) {
            str = str + " (" + this.symbol.name + ")";
        }
        switch (this.node.opCode) {
            case 2: {
                str = str + " (" + ((LirIconst)this.node).value + ")";
                break;
            }
            case 3: {
                str = str + " (" + ((LirFconst)this.node).value + ")";
            }
        }
        str = str + " (block " + this.belong.id + "))";
        return str;
    }

    LirNode apply(BiList nodeList) {
        int i;
        LirNode returnNode = null;
        LirNode[] args = new LirNode[this.parents.length];
        for (i = 0; i < this.parents.length; ++i) {
            if (this.parents[i] == null) continue;
            Symbol s = this.parents[i].symbol();
            args[i] = s == null ? this.parents[i].apply(nodeList) : this.env.lir.symRef(s);
        }
        switch (this.opCode) {
            case 54: {
                break;
            }
            case 53: {
                LirNode[] retValList;
                this.node.setKid(0, args[0]);
                LirNode[] argList = new LirNode[args.length - 1];
                for (int i2 = 0; i2 < argList.length; ++i2) {
                    argList[i2] = args[i2 + 1].makeCopy(this.env.lir);
                }
                LirNode arg = this.env.lir.operator(61, 0, argList, ImList.Empty);
                this.node.setKid(1, arg);
                if (this.symbol != null) {
                    retValList = new LirNode[]{this.env.lir.symRef(this.symbol)};
                } else {
                    BiList bList = new BiList();
                    boolean hasArg = false;
                    BiLink p = nodeList.first();
                    while (!p.atEnd()) {
                        SsaGraphNode n = (SsaGraphNode)p.elem();
                        for (int j = 0; j < n.parents.length; ++j) {
                            if (n.parents[j] != this) continue;
                            hasArg = true;
                            n.parents[j] = null;
                            bList.add(n.apply(nodeList));
                        }
                        p = p.next();
                    }
                    if (hasArg) {
                        retValList = new LirNode[bList.length()];
                        p = bList.first();
                        for (int i3 = 0; i3 < retValList.length; ++i3) {
                            retValList[i3] = ((LirNode)p.elem()).makeCopy(this.env.lir);
                            p = p.next();
                        }
                    } else {
                        retValList = new LirNode[]{};
                    }
                }
                LirNode retVal = this.env.lir.operator(61, 0, retValList, ImList.Empty);
                this.node.setKid(2, retVal);
                returnNode = this.node;
                break;
            }
            case 55: {
                for (i = 0; i < args.length; ++i) {
                    this.node.setKid(i + 1, args[i].makeCopy(this.env.lir));
                }
                returnNode = this.node;
                break;
            }
            case 59: {
                args[0] = this.env.lir.symRef(this.symbol);
                if (!this.node.kid(0).equals(args[0])) {
                    this.node.setKid(0, args[0].makeCopy(this.env.lir));
                }
                for (i = 1; i < args.length; ++i) {
                    if (args[i].equals(this.node.kid(i).kid(0))) continue;
                    this.node.kid(i).setKid(0, args[i].makeCopy(this.env.lir));
                }
                returnNode = this.node;
                break;
            }
            case 47: {
                LirNode definedNode;
                LirNode self = this.env.lir.operator(this.opCode, this.node.type, args[0].makeCopy(this.env.lir), this.node.opt);
                if (this.symbol == null) {
                    returnNode = self;
                    if (args[1] == null) break;
                    this.env.output.println(args[1]);
                    break;
                }
                if (args[1] == null) {
                    definedNode = this.env.lir.symRef(this.symbol);
                    returnNode = this.env.lir.operator(48, this.node.type, definedNode, self, this.node.opt);
                    break;
                }
                returnNode = this.env.lir.operator(48, args[1].type, self, args[1].makeCopy(this.env.lir), this.node.opt);
                break;
            }
            case 49: {
                returnNode = this.node;
                break;
            }
            case 50: {
                switch (args[0].opCode) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: {
                        this.node.setKid(0, args[0].makeCopy(this.env.lir));
                        break;
                    }
                    default: {
                        LirNode zeroNode = this.env.lir.iconst(args[0].type, 0L, ImList.Empty);
                        LirNode tstNode = this.env.lir.operator(36, args[0].type, args[0], zeroNode, this.node.opt);
                        this.node.setKid(0, tstNode);
                    }
                }
                returnNode = this.node;
                break;
            }
            case 51: {
                this.node.setKid(0, args[0].makeCopy(this.env.lir));
                returnNode = this.node;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                if (args[0].type == this.node.type) {
                    if (this.symbol == null) {
                        returnNode = args[0];
                        break;
                    }
                    LirNode definedNode = this.env.lir.symRef(this.symbol);
                    returnNode = this.env.lir.operator(48, this.node.type, definedNode, args[0].makeCopy(this.env.lir), this.node.opt);
                    break;
                }
            }
            case 9: 
            case 30: {
                LirNode self = this.env.lir.operator(this.opCode, this.node.type, args[0].makeCopy(this.env.lir), this.node.opt);
                if (this.symbol == null) {
                    returnNode = self;
                    break;
                }
                LirNode definedNode = this.env.lir.symRef(this.symbol);
                returnNode = this.env.lir.operator(48, this.node.type, definedNode, self, ImList.Empty);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                LirNode self = this.env.lir.operator(this.opCode, this.node.type, args[0].makeCopy(this.env.lir), args[1].makeCopy(this.env.lir), this.node.opt);
                if (this.symbol == null) {
                    returnNode = self;
                    break;
                }
                LirNode definedNode = this.env.lir.symRef(this.symbol);
                returnNode = this.env.lir.operator(48, this.node.type, definedNode, self, ImList.Empty);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                if (this.symbol == null) {
                    returnNode = this.node;
                    break;
                }
                LirNode definedNode = this.env.lir.symRef(this.symbol);
                returnNode = this.env.lir.operator(48, this.node.type, definedNode, this.node.makeCopy(this.env.lir), ImList.Empty);
            }
        }
        return returnNode;
    }

    void printGraph(OutputStreamWriter output, BiList list) {
        try {
            output.write(list.whereIs(this) + " [fontsize=10,label=\"\\l ");
        }
        catch (IOException e) {
            System.out.print(list.whereIs(this) + " [fontsize=10,label=\"\\l ");
        }
        if (this.symbol != null) {
            try {
                output.write("def : " + this.symbol.name + "\\l ");
            }
            catch (IOException e) {
                System.out.print("def : " + this.symbol.name + " \\l");
            }
        }
        switch (this.opCode) {
            case 2: {
                try {
                    output.write("value : " + ((LirIconst)this.node).value + " \\l");
                }
                catch (IOException e) {
                    System.out.print("value : " + ((LirIconst)this.node).value + " \\l");
                }
                break;
            }
            case 3: {
                try {
                    output.write("value : " + ((LirFconst)this.node).value + " \\l");
                }
                catch (IOException e) {
                    System.out.print("value : " + ((LirFconst)this.node).value + " \\l");
                }
                break;
            }
            case 4: 
            case 5: {
                try {
                    output.write("value : " + ((LirSymRef)this.node).symbol.name + " \\l");
                }
                catch (IOException e) {
                    System.out.print("value : " + ((LirSymRef)this.node).symbol.name + " \\l");
                }
                break;
            }
            case 8: {
                try {
                    output.write("value : " + ((LirLabelRef)this.node).label.name() + " \\l");
                }
                catch (IOException e) {
                    System.out.print("value : " + ((LirLabelRef)this.node).label.name() + " \\l");
                }
                break;
            }
            default: {
                try {
                    output.write("value : " + Op.toName(this.opCode) + " \\l");
                    break;
                }
                catch (IOException e) {
                    System.out.print("value : " + Op.toName(this.opCode) + " \\l");
                }
            }
        }
        try {
            output.write("block : " + this.belong.id + " \\l");
        }
        catch (IOException e) {
            System.out.print("block : " + this.belong.id + " \\l");
        }
        try {
            output.write("\"]\n");
        }
        catch (IOException e) {
            System.out.print("\"]\n");
        }
        for (int i = 0; i < this.parents.length; ++i) {
            if (list.whereIs(this.parents[i]) == -1) continue;
            try {
                output.write(list.whereIs(this) + " -> " + list.whereIs(this.parents[i]) + "\n");
                continue;
            }
            catch (IOException e) {
                System.out.println(list.whereIs(this) + " -> " + list.whereIs(this.parents[i]));
            }
        }
    }
}

