/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.ssa.BitVector;
import coins.ssa.Int;
import java.util.Hashtable;

public class RankTable {
    private int rankSize;
    private int fBitLength;
    private Hashtable vecPool;
    private BitVector aVec;
    private Hashtable refCountPool;
    private int fShiftMax;

    public RankTable(int size) {
        this.rankSize = size;
        BitVector v = new BitVector(size);
        this.fBitLength = v.getBitLength();
        this.fShiftMax = this.fBitLength - 1;
        this.vecPool = new Hashtable();
        this.refCountPool = new Hashtable();
    }

    public void insert(Object target, int rank) {
        BitVector vec = (BitVector)this.vecPool.get(target);
        if (vec == null) {
            vec = new BitVector(this.rankSize);
            Int refCount = new Int(1);
            this.refCountPool.put(target + "," + rank, refCount);
            vec.setBit(rank);
            this.vecPool.put(target, vec);
        } else {
            Int refCount = (Int)this.refCountPool.get(target + "," + rank);
            if (refCount == null) {
                refCount = new Int(1);
                this.refCountPool.put(target + "," + rank, refCount);
                vec.setBit(rank);
            } else {
                ++refCount.intValue;
            }
        }
    }

    public void insert(int rank) {
        if (this.aVec == null) {
            this.aVec = new BitVector(this.rankSize);
            Int refCount = new Int(1);
            this.refCountPool.put("" + rank, refCount);
            this.aVec.setBit(rank);
        } else {
            Int refCount = (Int)this.refCountPool.get("" + rank);
            if (refCount == null) {
                refCount = new Int(1);
                this.refCountPool.put("" + rank, refCount);
                this.aVec.setBit(rank);
            } else {
                ++refCount.intValue;
            }
        }
    }

    public void remove(Object target, int rank) {
        Int refCount;
        BitVector vec = (BitVector)this.vecPool.get(target);
        if (vec != null && (refCount = (Int)this.refCountPool.get(target + "," + rank)) != null) {
            if (refCount.intValue == 1) {
                this.refCountPool.remove(target + "," + rank);
                vec.resetBit(rank);
            } else {
                --refCount.intValue;
            }
        }
    }

    public void remove(int rank) {
        Int refCount;
        if (this.aVec != null && (refCount = (Int)this.refCountPool.get("" + rank)) != null) {
            if (refCount.intValue == 1) {
                this.refCountPool.remove("" + rank);
                this.aVec.resetBit(rank);
            } else {
                --refCount.intValue;
            }
        }
    }

    public boolean check(Object target, int lower, int upper) {
        int head = lower + 1;
        int tail = upper - 1;
        if (head > tail) {
            return false;
        }
        BitVector vec = (BitVector)this.vecPool.get(target);
        if (vec == null) {
            return false;
        }
        long[] fVectorWord = vec.getVectorWord();
        int hWord = head / this.fBitLength;
        int hInx = head - hWord * this.fBitLength;
        int tWord = tail / this.fBitLength;
        int tInx = tail - tWord * this.fBitLength;
        long hMask = hInx == 0 ? -1L : -1L << this.fShiftMax - hInx + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        long tMask = -1L << this.fShiftMax - tInx;
        if (hWord == tWord) {
            return (fVectorWord[hWord] & hMask & tMask) != 0L;
        }
        if (tWord > hWord) {
            if ((fVectorWord[hWord] & hMask) != 0L) {
                return true;
            }
            if ((fVectorWord[tWord] & tMask) != 0L) {
                return true;
            }
            if (tWord > hWord + 1) {
                for (int i = hWord + 1; i < tWord; ++i) {
                    if (fVectorWord[i] == 0L) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean check(int lower, int upper) {
        int head = lower + 1;
        int tail = upper - 1;
        if (head > tail) {
            return false;
        }
        if (this.aVec == null) {
            return false;
        }
        long[] fVectorWord = this.aVec.getVectorWord();
        int hWord = head / this.fBitLength;
        int hInx = head - hWord * this.fBitLength;
        int tWord = tail / this.fBitLength;
        int tInx = tail - tWord * this.fBitLength;
        long hMask = hInx == 0 ? -1L : -1L << this.fShiftMax - hInx + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        long tMask = -1L << this.fShiftMax - tInx;
        if (hWord == tWord) {
            return (fVectorWord[hWord] & hMask & tMask) != 0L;
        }
        if (tWord > hWord) {
            if ((fVectorWord[hWord] & hMask) != 0L) {
                return true;
            }
            if ((fVectorWord[tWord] & tMask) != 0L) {
                return true;
            }
            if (tWord > hWord + 1) {
                for (int i = hWord + 1; i < tWord; ++i) {
                    if (fVectorWord[i] == 0L) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

