/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Type;
import coins.backend.ana.DFST;
import coins.backend.ana.Dominators;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import coins.ssa.SsaGraph;
import coins.ssa.SsaGraphNode;
import coins.ssa.SsaSymTab;
import java.util.Hashtable;
import java.util.Stack;

class OperatorStrengthReduction
implements LocalTransformer {
    private final String osrSymName = "_osr";
    private SsaEnvironment env;
    private SsaSymTab sstab;
    private SsaGraph ssaGraph;
    private int nextDFSnum = 0;
    private Stack dfsStack;
    private Hashtable nodeMap;
    private Function f;
    private OsrLookUpTable osrLookUp;
    public static final int THR = 2000;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "OperatorStrengthReduction";
    }

    public String subject() {
        return "Operator Strength Reduction for inductin variables.";
    }

    public OperatorStrengthReduction(SsaEnvironment e, SsaSymTab symtab, SsaGraph graph) {
        this.env = e;
        this.sstab = symtab;
        this.ssaGraph = graph;
    }

    public boolean doIt(Function function, ImList args) {
        this.env.println("****************** doing OSR to " + function.symbol.name, 1000);
        this.f = function;
        this.dfsStack = new Stack();
        this.nodeMap = new Hashtable();
        this.osrLookUp = new OsrLookUpTable();
        BiLink p = this.ssaGraph.nodeList().first();
        while (!p.atEnd()) {
            SsaGraphNode node = (SsaGraphNode)p.elem();
            if (this.nodeMap.get(node) == null) {
                this.DFS(node);
            }
            p = p.next();
        }
        if (!this.env.opt.isSet("ssa-no-lftr")) {
            this.LFTR();
        }
        this.env.println("", 2000);
        return true;
    }

    private void LFTR() {
        this.env.println("OSR : doing LFTR", 2000);
        BiLink p = this.ssaGraph.nodeList().first();
        while (!p.atEnd()) {
            SsaGraphNode n = (SsaGraphNode)p.elem();
            switch (n.opCode) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    int i;
                    SsaGraphNode[] applied;
                    this.env.println("LFTR : candidate " + n.parents[0] + " " + n.parents[1], 2000);
                    OsrData pareData0 = (OsrData)this.nodeMap.get(n.parents[0]);
                    OsrData pareData1 = (OsrData)this.nodeMap.get(n.parents[1]);
                    if (pareData0.header != null && this.RegionConst(n.parents[1], pareData0.header)) {
                        applied = this.tstReplace(n.parents[0], n.parents[1], n);
                        if (applied == null) break;
                        n.parents[0] = applied[0];
                        n.parents[1] = applied[1];
                        this.env.println("LFTR : replace " + n, 2000);
                        for (i = 0; i < n.parents.length; ++i) {
                            this.env.println("LFTR    " + n.parents[i], 2000);
                        }
                    } else {
                        if (pareData1.header == null || !this.RegionConst(n.parents[0], pareData1.header) || (applied = this.tstReplace(n.parents[1], n.parents[0], n)) == null) break;
                        n.parents[1] = applied[0];
                        n.parents[0] = applied[1];
                        this.env.println("LFTR : replace " + n, 2000);
                        for (i = 0; i < n.parents.length; ++i) {
                            this.env.println("LFTR    " + n.parents[i], 2000);
                        }
                    }
                    break;
                }
            }
            p = p.next();
        }
    }

    private SsaGraphNode[] tstReplace(SsaGraphNode iv, SsaGraphNode rc, SsaGraphNode org) {
        if (iv != null && rc != null) {
            if (iv.opCode == 54 ? (rc.opCode == 54 ? Type.tag(iv.symbol().type) != 2 || Type.tag(rc.symbol().type) != 2 : Type.tag(iv.symbol().type) != 2 || Type.tag(rc.node.type) != 2) : (rc.opCode == 54 ? Type.tag(iv.node.type) != 2 || Type.tag(rc.symbol().type) != 2 : Type.tag(iv.node.type) != 2 || Type.tag(rc.node.type) != 2)) {
                return null;
            }
            SsaGraphNode[] applied = this.osrLookUp.applyEdges(iv, rc, org.belong);
            if (applied[0] != null && applied[1] != null) {
                return applied;
            }
        }
        return null;
    }

    private void DFS(SsaGraphNode node) {
        OsrData nodeData = new OsrData(this.nextDFSnum++);
        this.nodeMap.put(node, nodeData);
        this.dfsStack.push(node);
        for (int i = 0; i < node.parents.length; ++i) {
            SsaGraphNode o = node.parents[i];
            if (o == null) continue;
            OsrData oData = (OsrData)this.nodeMap.get(o);
            if (oData == null) {
                this.DFS(o);
                oData = (OsrData)this.nodeMap.get(o);
                if (nodeData.low > oData.low) {
                    nodeData.low = oData.low;
                }
            }
            if (oData.DFSnum >= nodeData.DFSnum || !this.dfsStack.contains(o) || oData.DFSnum >= nodeData.low) continue;
            nodeData.low = oData.DFSnum;
        }
        if (nodeData.low == nodeData.DFSnum) {
            BiList SCC = new BiList();
            SsaGraphNode x = null;
            do {
                x = (SsaGraphNode)this.dfsStack.pop();
                SCC.add(x);
            } while (x != node);
            this.ProcessSCC(SCC);
        }
    }

    private void ProcessSCC(BiList SCC) {
        if (SCC.length() == 1) {
            SsaGraphNode n = (SsaGraphNode)SCC.first().elem();
            this.reduction(n);
        } else {
            this.ClassifyIV(SCC);
        }
    }

    private void reduction(SsaGraphNode n) {
        OsrData nData = (OsrData)this.nodeMap.get(n);
        switch (n.opCode) {
            case 10: 
            case 12: {
                OsrData lData = (OsrData)this.nodeMap.get(n.parents[0]);
                OsrData rData = (OsrData)this.nodeMap.get(n.parents[1]);
                if (lData.iv && this.RegionConst(n.parents[1], lData.header)) {
                    this.env.println("OSR : " + n.parents[0] + " is IV and " + n.parents[1] + " is RC (OP " + n + ")", 2000);
                    this.Replace(n, n.parents[0], n.parents[1]);
                    break;
                }
                if (rData.iv && this.RegionConst(n.parents[0], rData.header)) {
                    this.env.println("OSR : " + n.parents[1] + " is IV and " + n.parents[0] + " is RC (OP " + n + ")", 2000);
                    this.Replace(n, n.parents[1], n.parents[0]);
                    break;
                }
                nData.header = null;
                break;
            }
            case 11: 
            case 31: 
            case 32: {
                OsrData lData = (OsrData)this.nodeMap.get(n.parents[0]);
                OsrData rData = (OsrData)this.nodeMap.get(n.parents[1]);
                if (lData.iv && this.RegionConst(n.parents[1], lData.header)) {
                    this.env.println("OSR : " + n.parents[0] + " is IV and " + n.parents[1] + " is RC (OP " + n + ")", 2000);
                    this.Replace(n, n.parents[0], n.parents[1]);
                    break;
                }
                nData.header = null;
                break;
            }
            default: {
                nData.header = null;
            }
        }
    }

    private void ClassifyIV(BiList SCC) {
        SsaGraphNode n;
        boolean inductionVariable = true;
        DFST dfst = (DFST)this.f.require(DFST.analyzer);
        BasicBlk header = null;
        BiLink p = SCC.first();
        while (!p.atEnd()) {
            n = (SsaGraphNode)p.elem();
            OsrData nData = (OsrData)this.nodeMap.get(n);
            if (header == null || dfst.dfn[header.id] > dfst.dfn[n.belong.id]) {
                header = n.belong;
            }
            p = p.next();
        }
        p = SCC.first();
        while (!p.atEnd()) {
            n = (SsaGraphNode)p.elem();
            switch (n.opCode) {
                case 10: 
                case 11: 
                case 59: {
                    break;
                }
                default: {
                    inductionVariable = false;
                }
            }
            for (int i = 0; i < n.parents.length; ++i) {
                SsaGraphNode o = n.parents[i];
                if (o == null || SCC.contains(o) || this.RegionConst(o, header)) continue;
                inductionVariable = false;
                break;
            }
            if (!inductionVariable) break;
            p = p.next();
        }
        if (inductionVariable) {
            p = SCC.first();
            while (!p.atEnd()) {
                n = (SsaGraphNode)p.elem();
                OsrData nData = (OsrData)this.nodeMap.get(n);
                nData.header = header;
                nData.iv = true;
                this.env.println("OSR : " + n + " is induction variable", 2000);
                p = p.next();
            }
        } else {
            p = SCC.first();
            while (!p.atEnd()) {
                n = (SsaGraphNode)p.elem();
                this.reduction(n);
                p = p.next();
            }
        }
    }

    private boolean isConst(SsaGraphNode node) {
        switch (node.opCode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private boolean RegionConst(SsaGraphNode name, BasicBlk header) {
        if (this.isConst(name)) {
            this.env.println("OSR : " + name + " is region constant", 2000);
            return true;
        }
        switch (name.opCode) {
            case 49: 
            case 50: 
            case 51: {
                return false;
            }
        }
        if (header == null) {
            return false;
        }
        if (name.belong == header) {
            return false;
        }
        Dominators dom = (Dominators)this.f.require(Dominators.analyzer);
        if (!dom.dominates(name.belong, header)) {
            return false;
        }
        this.env.println("OSR : " + name + " is region constant(" + header.id + ")", 2000);
        return true;
    }

    private void Replace(SsaGraphNode node, SsaGraphNode iv, SsaGraphNode rc) {
        SsaGraphNode result = this.Reduce(node, iv, rc, iv.belong);
        if (result != null) {
            OsrData nodeData = (OsrData)this.nodeMap.get(node);
            OsrData ivData = (OsrData)this.nodeMap.get(iv);
            OsrData resultData = (OsrData)this.nodeMap.get(result);
            nodeData.header = ivData.header;
            resultData.header = ivData.header;
            this.ssaGraph.setSymbol(node.symbol(), result);
            this.env.println("OSR : replace " + node + " to " + result, 2000);
            this.env.println("OSR : " + result + " is new IV as a result", 2000);
        }
    }

    private SsaGraphNode Reduce(SsaGraphNode node, SsaGraphNode iv, SsaGraphNode rc, BasicBlk belong) {
        if (node.node.type != iv.node.type) {
            return null;
        }
        if (rc != null && (rc.opCode == 54 ? node.node.type != rc.symbol().type : node.node.type != rc.node.type)) {
            return null;
        }
        SsaGraphNode result = this.osrLookUp.search(node, iv, rc);
        if (result == null) {
            Symbol s = this.sstab.newSsaSymbol("_osr", node.node.type);
            SsaGraphNode newDef = new SsaGraphNode(this.env, iv.node.makeCopy(this.env.lir), iv.belong, iv.parents.length);
            for (int i = 0; i < newDef.parents.length; ++i) {
                newDef.parents[i] = iv.parents[i];
            }
            this.ssaGraph.setSymbol(s, newDef);
            BiLink pos = this.ssaGraph.nodeList().locate(iv);
            pos.addAfter(newDef);
            OsrData ivData = (OsrData)this.nodeMap.get(iv);
            OsrData newDefData = new OsrData(this.nextDFSnum++);
            newDefData.header = ivData.header;
            newDefData.iv = ivData.iv;
            this.nodeMap.put(newDef, newDefData);
            this.env.println("OSR : Make " + newDef + " to new IV(original " + iv + ")", 2000);
            result = newDef;
            this.osrLookUp.add(node, iv, rc, result, true);
            for (int i = 0; i < newDef.parents.length; ++i) {
                SsaGraphNode applied;
                SsaGraphNode o = newDef.parents[i];
                if (o == null) continue;
                OsrData oData = (OsrData)this.nodeMap.get(o);
                if (oData.header == ivData.header) {
                    SsaGraphNode reduced;
                    newDef.parents[i] = reduced = this.Reduce(node, o, rc, o.belong);
                    continue;
                }
                if (node.opCode != 12 && node.opCode != 31 && node.opCode != 32 && newDef.opCode != 59 || (applied = this.Apply(node, o, rc, newDefData.header)) == null) continue;
                newDef.parents[i] = applied;
            }
        }
        return result;
    }

    private SsaGraphNode Apply(SsaGraphNode opcode, SsaGraphNode op1, SsaGraphNode op2, BasicBlk belong) {
        int opcodeType = opcode.node.type;
        if (op1.opCode == 54 || op1.opCode == 53 ? (op2.opCode == 54 || op2.opCode == 53 ? op1.symbol().type != opcodeType || op2.symbol().type != opcodeType : op1.symbol().type != opcodeType || op2.node.type != opcodeType) : (op2.opCode == 54 || op2.opCode == 53 ? op1.node.type != opcodeType || op2.symbol().type != opcodeType : op1.node.type != opcodeType || op2.node.type != opcodeType)) {
            return null;
        }
        SsaGraphNode result = this.osrLookUp.search(opcode, op1, op2);
        if (result == null) {
            OsrData op1Data = (OsrData)this.nodeMap.get(op1);
            OsrData op2Data = (OsrData)this.nodeMap.get(op2);
            if (op1Data.header != null && this.RegionConst(op2, op1Data.header)) {
                result = this.Reduce(opcode, op1, op2, op1.belong);
            } else if (op2Data.header != null && this.RegionConst(op1, op2Data.header)) {
                result = this.Reduce(opcode, op2, op1, op1.belong);
            } else {
                result = this.calc(opcode, op1, op2, belong);
                if (result == null) {
                    return null;
                }
                this.osrLookUp.add(opcode, op1, op2, result, false);
                OsrData resultData = (OsrData)this.nodeMap.get(result);
                resultData.header = null;
                resultData.iv = false;
            }
        }
        return result;
    }

    private SsaGraphNode calc(SsaGraphNode opcode, SsaGraphNode op1, SsaGraphNode op2, BasicBlk belong) {
        SsaGraphNode result = null;
        LirNode newNode = null;
        if (op1.opCode == 2 && op2.opCode == 2) {
            newNode = this.env.lir.operator(opcode.opCode, opcode.node.type, op1.node.makeCopy(this.env.lir), op2.node.makeCopy(this.env.lir), ImList.Empty);
            newNode = this.env.lir.foldConstant(newNode);
            result = new SsaGraphNode(this.env, newNode, this.f.flowGraph().entryBlk(), 0);
        } else if (opcode.opCode != 31 && opcode.opCode != 32 && op1.opCode == 3 && op2.opCode == 3) {
            newNode = this.env.lir.operator(opcode.opCode, opcode.node.type, op1.node.makeCopy(this.env.lir), op2.node.makeCopy(this.env.lir), ImList.Empty);
            newNode = this.env.lir.foldConstant(newNode);
            result = new SsaGraphNode(this.env, newNode, this.f.flowGraph().entryBlk(), 0);
        } else {
            LirNode newOp1 = null;
            LirNode newOp2 = null;
            boolean isNewOp1 = false;
            boolean isNewOp2 = false;
            Symbol ss = op1.symbol();
            if (ss == null || op1.opCode == 2 || op1.opCode == 3) {
                newOp1 = op1.node.makeCopy(this.env.lir);
                op1 = new SsaGraphNode(this.env, newOp1, this.f.flowGraph().entryBlk(), 0);
                isNewOp1 = true;
            } else {
                newOp1 = this.env.lir.symRef(ss);
            }
            ss = op2.symbol();
            if (ss == null || op2.opCode == 2 || op2.opCode == 3) {
                newOp2 = op2.node.makeCopy(this.env.lir);
                op2 = new SsaGraphNode(this.env, newOp2, this.f.flowGraph().entryBlk(), 0);
                isNewOp2 = true;
            } else {
                newOp2 = this.env.lir.symRef(ss);
            }
            BasicBlk blk = this.whichBlk(op1, op2, belong);
            if (blk == null) {
                return null;
            }
            newNode = this.env.lir.operator(opcode.opCode, opcode.node.type, newOp1, newOp2, ImList.Empty);
            if (isNewOp1) {
                this.ssaGraph.nodeList().add(op1);
            }
            if (isNewOp2) {
                this.ssaGraph.nodeList().add(op2);
            }
            result = new SsaGraphNode(this.env, newNode, blk, 2);
            Symbol s = this.sstab.newSsaSymbol("_osr", opcode.node.type);
            this.ssaGraph.setSymbol(s, result);
            result.parents[0] = op1;
            result.parents[1] = op2;
        }
        this.env.println("OSR : Insert " + result, 2000);
        BiLink pos = this.ssaGraph.nodeList().locate(op1);
        pos.addAfter(result);
        OsrData resultData = new OsrData(this.nextDFSnum++);
        this.nodeMap.put(result, resultData);
        return result;
    }

    private BasicBlk whichBlk(SsaGraphNode op1, SsaGraphNode op2, BasicBlk belong) {
        BasicBlk blk = null;
        Symbol os1 = op1.symbol();
        Symbol os2 = op2.symbol();
        int opc1 = op1.opCode;
        int opc2 = op2.opCode;
        if (!(os1 != null && opc1 != 2 && opc1 != 3 || os2 != null && opc2 != 2 && opc2 != 3)) {
            blk = this.f.flowGraph().entryBlk();
        } else if (os1 != null && opc1 != 2 && opc1 != 3 && (os2 == null || opc2 == 2 || opc2 == 3)) {
            blk = op1.belong;
        } else if ((os1 == null || opc1 == 2 || opc1 == 3) && os2 != null && opc2 != 2 && opc2 != 3) {
            blk = op2.belong;
        } else if (!this.RegionConst(op1, belong) || !this.RegionConst(op2, belong)) {
            this.env.output.println("no place to insert a new expression 1");
            blk = null;
        } else {
            Dominators dom = (Dominators)this.f.require(Dominators.analyzer);
            if (dom.dominates(op1.belong, op2.belong)) {
                blk = op2.belong;
            } else if (dom.dominates(op2.belong, op1.belong)) {
                blk = op1.belong;
            } else {
                blk = null;
                this.env.output.println("no place to insert a new expression 2");
            }
        }
        return blk;
    }

    private class OsrData {
        final int DFSnum;
        BasicBlk header;
        int low;
        boolean iv;

        OsrData(int dfsNum) {
            this.low = this.DFSnum = dfsNum;
            this.header = null;
            this.iv = false;
        }
    }

    private class OsrLookUpTable {
        final BiList tables = new BiList();
        final Hashtable resultMap = new Hashtable();
        final Hashtable lftrMap = new Hashtable();

        OsrLookUpTable() {
        }

        SsaGraphNode search(SsaGraphNode code, SsaGraphNode op1, SsaGraphNode op2) {
            BiLink p = this.tables.first();
            while (!p.atEnd()) {
                Object[] t = (Object[])p.elem();
                if (code.opCode == ((SsaGraphNode)t[0]).opCode && t[1] == op1 && (!OperatorStrengthReduction.this.isConst(op2) ? op2.symbol() != null && ((SsaGraphNode)t[2]).symbol() != null && op2.symbol() == ((SsaGraphNode)t[2]).symbol() : ((SsaGraphNode)t[2]).node.equals(op2.node))) {
                    return (SsaGraphNode)this.resultMap.get(t);
                }
                p = p.next();
            }
            return null;
        }

        void add(SsaGraphNode code, SsaGraphNode op1, SsaGraphNode op2, SsaGraphNode result, boolean isOp1IV) {
            Object[] t = new Object[]{code, op1, op2};
            if (isOp1IV) {
                LftrData tmp = (LftrData)this.lftrMap.get(op1);
                LftrData lftrData = new LftrData(code, op1, op2, result);
                this.lftrMap.put(op1, lftrData);
            }
            this.tables.add(t);
            this.resultMap.put(t, result);
        }

        SsaGraphNode[] applyEdges(SsaGraphNode iv, SsaGraphNode rc, BasicBlk belong) {
            SsaGraphNode[] result = new SsaGraphNode[]{null, null};
            LftrData lftrData = (LftrData)this.lftrMap.get(iv);
            if (lftrData != null) {
                do {
                    result[0] = lftrData.result;
                    SsaGraphNode trc = OperatorStrengthReduction.this.calc(lftrData.op, rc, lftrData.rc, belong);
                    if (trc == null) break;
                    rc = trc;
                } while ((lftrData = (LftrData)this.lftrMap.get(lftrData.result)) != null);
                result[1] = rc;
            }
            return result;
        }
    }

    private class LftrData {
        private final SsaGraphNode op;
        private final SsaGraphNode iv;
        private final SsaGraphNode rc;
        private final SsaGraphNode result;

        LftrData(SsaGraphNode o, SsaGraphNode i, SsaGraphNode r, SsaGraphNode res) {
            this.op = o;
            this.iv = i;
            this.rc = r;
            this.result = res;
        }
    }
}

