/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.ana.ControlDependences;
import coins.backend.ana.LoopAnalysis;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Label;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import coins.ssa.Util;
import java.util.Hashtable;
import java.util.Stack;

class DeadCodeElimination
implements LocalTransformer {
    private Util util;
    private Hashtable defineMap;
    private Stack Work;
    private BiList Live;
    private Function f;
    private BiList availBlk;
    private SsaEnvironment env;
    public static final int THR = 2000;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "DeadCodeElimination";
    }

    public String subject() {
        return "Dead code elimination on SSA form.";
    }

    public DeadCodeElimination(SsaEnvironment e) {
        this.env = e;
        this.env.println("  Dead Code Elimination on SSA form", 100);
    }

    public boolean doIt(Function function, ImList args) {
        LirNode node;
        BiLink p;
        BasicBlk blk;
        LirNode jumpExp;
        ControlDependences cdep;
        this.env.println("****************** doing DCE to " + function.symbol.name, 1000);
        this.f = function;
        FlowGraph g = this.f.flowGraph();
        this.defineMap = new Hashtable();
        this.Work = new Stack();
        this.Live = new BiList();
        this.availBlk = new BiList();
        this.util = new Util(this.env, this.f);
        BiList visited = new BiList();
        BasicBlk entryBlk = g.entryBlk();
        Stack<BasicBlk> stack = new Stack<BasicBlk>();
        stack.push(entryBlk);
        LoopAnalysis loop = (LoopAnalysis)this.f.require(LoopAnalysis.analyzer);
        BiLink p2 = g.basicBlkList.first();
        while (!p2.atEnd()) {
            BasicBlk blk2 = (BasicBlk)p2.elem();
            if (loop.isLoop[blk2.id]) {
                if (loop.hasExit[blk2.id]) {
                    LirNode lastCond = (LirNode)blk2.instrList().last().elem();
                    this.Live.add(lastCond);
                    this.availBlk.addNew(blk2);
                    this.Work.push(new Datas(blk2, lastCond));
                } else {
                    cdep = (ControlDependences)this.f.require(ControlDependences.analyzer);
                    BiLink q = cdep.frontiers[blk2.id].first();
                    while (!q.atEnd()) {
                        BasicBlk cdepBlk = (BasicBlk)q.elem();
                        jumpExp = (LirNode)cdepBlk.instrList().last().elem();
                        if (!this.Live.contains(jumpExp)) {
                            this.Live.add(jumpExp);
                            this.availBlk.addNew(cdepBlk);
                            this.Work.push(new Datas(cdepBlk, jumpExp));
                        }
                        q = q.next();
                    }
                }
            }
            p2 = p2.next();
        }
        while (!stack.empty()) {
            blk = (BasicBlk)stack.pop();
            if (visited.contains(blk)) continue;
            visited.add(blk);
            p = blk.instrList().first();
            while (!p.atEnd()) {
                node = (LirNode)p.elem();
                switch (node.opCode) {
                    case 54: {
                        BiList list = this.util.findTargetLir(node, 6, new BiList());
                        BiLink q = list.first();
                        while (!q.atEnd()) {
                            LirSymRef regNode = (LirSymRef)q.elem();
                            this.defineMap.put(regNode.symbol, new Datas(blk, node));
                            q = q.next();
                        }
                        this.Live.add(node);
                        this.availBlk.addNew(blk);
                        this.Work.push(new Datas(blk, node));
                        break;
                    }
                    case 53: {
                        if (node.kid(2).nKids() > 0 && node.kid((int)2).kid((int)0).opCode == 6) {
                            this.defineMap.put(((LirSymRef)node.kid((int)2).kid((int)0)).symbol, new Datas(blk, node));
                        }
                    }
                    case 55: {
                        this.Live.add(node);
                        this.availBlk.addNew(blk);
                        this.Work.push(new Datas(blk, node));
                        break;
                    }
                    case 48: 
                    case 59: {
                        if (node.kid((int)0).opCode == 6) {
                            this.defineMap.put(((LirSymRef)node.kid((int)0)).symbol, new Datas(blk, node));
                            break;
                        }
                        this.Live.add(node);
                        this.availBlk.addNew(blk);
                        this.Work.push(new Datas(blk, node));
                        break;
                    }
                    case 49: {
                        stack.push(((LirLabelRef)node.kid((int)0)).label.basicBlk());
                        break;
                    }
                    case 50: {
                        for (int i = 1; i < node.nKids(); ++i) {
                            stack.push(((LirLabelRef)node.kid((int)i)).label.basicBlk());
                        }
                        break;
                    }
                    case 51: {
                        for (int i = 0; i < node.kid(1).nKids(); ++i) {
                            stack.push(((LirLabelRef)node.kid((int)1).kid((int)i).kid((int)1)).label.basicBlk());
                        }
                        stack.push(((LirLabelRef)node.kid((int)2)).label.basicBlk());
                    }
                }
                p = p.next();
            }
        }
        while (!this.Work.empty()) {
            Datas S = (Datas)this.Work.pop();
            BiList regs = this.util.findTargetLir(S.node, 6, new BiList());
            BiLink p3 = regs.first();
            while (!p3.atEnd()) {
                LirSymRef reg = (LirSymRef)p3.elem();
                Datas defineData = (Datas)this.defineMap.get(reg.symbol);
                if (defineData != null && !this.Live.contains(defineData.node)) {
                    this.Work.push(defineData);
                    this.Live.add(defineData.node);
                    this.availBlk.addNew(defineData.blk);
                }
                p3 = p3.next();
            }
            cdep = (ControlDependences)this.f.require(ControlDependences.analyzer);
            if (((Datas)S).node.opCode == 59) {
                for (int i = 1; i < S.node.nKids(); ++i) {
                    LirNode arg = S.node.kid(i);
                    BasicBlk pred = ((LirLabelRef)arg.kid((int)1)).label.basicBlk();
                    BiLink p4 = cdep.frontiers[pred.id].first();
                    while (!p4.atEnd()) {
                        BasicBlk cdepBlk = (BasicBlk)p4.elem();
                        LirNode jumpExp2 = (LirNode)cdepBlk.instrList().last().elem();
                        if (!this.Live.contains(jumpExp2)) {
                            this.Live.add(jumpExp2);
                            this.availBlk.addNew(cdepBlk);
                            this.Work.push(new Datas(cdepBlk, jumpExp2));
                        }
                        p4 = p4.next();
                    }
                }
                Hashtable<BasicBlk, LirNode> table = new Hashtable<BasicBlk, LirNode>();
                for (int i = 1; i < S.node.nKids(); ++i) {
                    LirNode jumpExp3;
                    LirNode cnst2;
                    LirNode cnst1;
                    LirNode arg = S.node.kid(i);
                    BasicBlk pred = ((LirLabelRef)arg.kid((int)1)).label.basicBlk();
                    LirNode lnode = (LirNode)table.get(pred);
                    if (lnode == null) {
                        table.put(pred, arg.kid(0));
                        continue;
                    }
                    boolean keepJump = false;
                    if (arg.kid(1) instanceof LirSymRef) {
                        LirSymRef ref1 = (LirSymRef)arg.kid(1);
                        if (lnode instanceof LirSymRef) {
                            LirSymRef ref2 = (LirSymRef)lnode;
                            if (ref1.symbol != ref2.symbol) {
                                keepJump = true;
                            }
                        }
                    } else if (arg.kid(1) instanceof LirIconst) {
                        cnst1 = (LirIconst)arg.kid(1);
                        if (lnode instanceof LirIconst) {
                            cnst2 = (LirIconst)lnode;
                            if (cnst1.value != cnst2.value) {
                                keepJump = true;
                            }
                        }
                    } else if (arg.kid(1) instanceof LirFconst) {
                        cnst1 = (LirFconst)arg.kid(1);
                        if (lnode instanceof LirFconst) {
                            cnst2 = (LirFconst)lnode;
                            if (((LirFconst)cnst1).value != ((LirFconst)cnst2).value) {
                                keepJump = true;
                            }
                        }
                    }
                    if (!keepJump || this.Live.contains(jumpExp3 = (LirNode)pred.instrList().last().elem())) continue;
                    this.Live.add(jumpExp3);
                    this.availBlk.addNew(pred);
                    this.Work.push(new Datas(pred, jumpExp3));
                }
            }
            BiLink p5 = cdep.frontiers[((Datas)S).blk.id].first();
            while (!p5.atEnd()) {
                BasicBlk cdepBlk = (BasicBlk)p5.elem();
                jumpExp = (LirNode)cdepBlk.instrList().last().elem();
                if (!this.Live.contains(jumpExp)) {
                    this.Live.add(jumpExp);
                    this.availBlk.addNew(cdepBlk);
                    this.Work.push(new Datas(cdepBlk, jumpExp));
                }
                p5 = p5.next();
            }
        }
        visited = new BiList();
        stack = new Stack();
        stack.push(entryBlk);
        while (!stack.empty()) {
            blk = (BasicBlk)stack.pop();
            if (visited.contains(blk)) continue;
            visited.add(blk);
            p = blk.instrList().first();
            while (!p.atEnd()) {
                node = (LirNode)p.elem();
                if (!this.Live.contains(node)) {
                    switch (node.opCode) {
                        case 49: {
                            Label lab = ((LirLabelRef)node.kid((int)0)).label;
                            if (!this.reachToAvailBlk(lab.basicBlk(), new BiList())) {
                                this.env.println("DCE : remove " + node + " in block " + blk.id, 2000);
                                p.unlink();
                                blk.maintEdges();
                                break;
                            }
                            this.availBlk.addNew(blk);
                            break;
                        }
                        case 50: {
                            boolean changed = false;
                            for (int i = 1; i < 3; ++i) {
                                LirLabelRef lNode = (LirLabelRef)node.kid(i);
                                if (!this.reachToAvailBlk(lNode.label.basicBlk(), new BiList())) continue;
                                this.availBlk.addNew(blk);
                                LirNode lab = this.env.lir.labelRefVariant(lNode.label);
                                this.util.makeNewJump(blk, (LirLabelRef)lab);
                                blk.maintEdges();
                                changed = true;
                                break;
                            }
                            if (changed) break;
                            System.err.println("DCE : no avail successor of " + node);
                            System.exit(2);
                            break;
                        }
                        case 51: {
                            boolean changed = false;
                            Label defaultLabel = ((LirLabelRef)node.kid((int)2)).label;
                            if (this.reachToAvailBlk(defaultLabel.basicBlk(), new BiList())) {
                                this.availBlk.addNew(blk);
                                LirNode lab = this.env.lir.labelRefVariant(defaultLabel);
                                this.util.makeNewJump(blk, (LirLabelRef)lab);
                                break;
                            }
                            for (int i = 0; i < node.kid(1).nKids(); ++i) {
                                LirLabelRef lNode = (LirLabelRef)node.kid(1).kid(i).kid(1);
                                if (!this.reachToAvailBlk(lNode.label.basicBlk(), new BiList())) continue;
                                this.availBlk.addNew(blk);
                                LirNode lab = this.env.lir.labelRefVariant(lNode.label);
                                this.util.makeNewJump(blk, (LirLabelRef)lab);
                                changed = true;
                                break;
                            }
                            if (changed) break;
                            System.err.println("DCE : no avail successor of " + node);
                            System.exit(2);
                            break;
                        }
                        default: {
                            this.env.println("DCE : remove " + node + " in block " + blk.id, 2000);
                            p.unlink();
                        }
                    }
                    g.touch();
                }
                switch (node.opCode) {
                    case 49: {
                        stack.push(((LirLabelRef)node.kid((int)0)).label.basicBlk());
                        break;
                    }
                    case 50: {
                        for (int i = 1; i < node.nKids(); ++i) {
                            stack.push(((LirLabelRef)node.kid((int)i)).label.basicBlk());
                        }
                        break;
                    }
                    case 51: {
                        for (int i = 0; i < node.kid(1).nKids(); ++i) {
                            stack.push(((LirLabelRef)node.kid((int)1).kid((int)i).kid((int)1)).label.basicBlk());
                        }
                        stack.push(((LirLabelRef)node.kid((int)2)).label.basicBlk());
                    }
                }
                p = p.next();
            }
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            p = this.f.flowGraph().basicBlkList.first();
            while (!p.atEnd()) {
                BasicBlk blk3 = (BasicBlk)p.elem();
                blk3.maintEdges();
                if (blk3 != entryBlk && blk3.predList().length() == 0 && blk3.dummyPredList().length() == 0) {
                    this.env.println("DCE : remove block " + blk3.id, 2000);
                    blk3.clearEdges();
                    p.unlink();
                    this.f.touch();
                    changed = true;
                }
                p = p.next();
            }
        }
        this.env.println("", 2000);
        return true;
    }

    boolean reachToAvailBlk(BasicBlk blk, BiList visited) {
        if (this.availBlk.contains(blk)) {
            return true;
        }
        if (visited.contains(blk)) {
            return false;
        }
        visited.addNew(blk);
        BiLink p = blk.succList().first();
        while (!p.atEnd()) {
            BasicBlk succ = (BasicBlk)p.elem();
            if (!visited.contains(succ) && this.reachToAvailBlk(succ, visited)) {
                this.availBlk.addNew(succ);
                return true;
            }
            p = p.next();
        }
        return false;
    }

    private class Datas {
        private final BasicBlk blk;
        private final LirNode node;

        private Datas(BasicBlk b, LirNode n) {
            this.blk = b;
            this.node = n;
        }
    }
}

