/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Function;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import coins.ssa.PREQP;
import coins.ssa.RankTable;
import coins.ssa.SsaEnvironment;
import coins.ssa.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class DDCopyPropagation {
    private SsaEnvironment env;
    public static final int THR = 2000;
    private RankTable expRankMap;
    private RankTable phiRankMap;
    private int[] rank;
    private Function function;
    private Util util;
    Hashtable variableMap;
    private FlowGraph g;
    private Hashtable occurMap;
    private Hashtable phiMap;
    private Hashtable rPhiMap;
    private PREQP pre;

    public DDCopyPropagation(SsaEnvironment e, Function func, PREQP preEqp) {
        this.function = func;
        this.env = e;
        this.pre = preEqp;
        this.util = new Util(this.env, this.function);
        this.g = this.function.flowGraph();
        this.variableMap = new Hashtable();
        BiLink p = this.g.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                Stack<LirNode> stack = new Stack<LirNode>();
                stack.push(node);
                while (!stack.empty()) {
                    LirNode n = (LirNode)stack.pop();
                    for (int i = 0; i < n.nKids(); ++i) {
                        if (n.kid((int)i).opCode == 6) {
                            Symbol ref = ((LirSymRef)n.kid((int)i)).symbol;
                            Hashtable<String, Object[]> v = (Hashtable<String, Object[]>)this.variableMap.get(ref.name);
                            if (v == null) {
                                v = new Hashtable<String, Object[]>();
                                this.variableMap.put(ref.name, v);
                            }
                            if (v.get(this.makeBNKey(blk, node)) != null) continue;
                            Object[] pair = new Object[]{blk, q};
                            v.put(this.makeBNKey(blk, node), pair);
                            continue;
                        }
                        stack.push(n.kid(i));
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    String makeBNKey(BasicBlk blk, LirNode n) {
        return blk.id + "," + n.id;
    }

    public void doIt(BasicBlk blk, LirNode node) {
        Vector<Object[]> postCpy = new Vector<Object[]>();
        Symbol dst = ((LirSymRef)node.kid((int)0)).symbol;
        Hashtable v = (Hashtable)this.variableMap.get(dst.name);
        if (v == null) {
            v = new Hashtable();
        }
        Enumeration varEnum = v.elements();
        while (varEnum.hasMoreElements()) {
            LirNode newNode;
            int i;
            Object[] bn = (Object[])varEnum.nextElement();
            BasicBlk bk = (BasicBlk)bn[0];
            LirNode nd = (LirNode)((BiLink)bn[1]).elem();
            Stack<LirNode> stack = new Stack<LirNode>();
            stack.push(nd);
            boolean mod = false;
            LirNode oldNd = nd.makeCopy(this.env.lir);
            while (!stack.empty()) {
                LirNode n = (LirNode)stack.pop();
                for (i = 0; i < n.nKids(); ++i) {
                    if (n.kid((int)i).opCode == 6) {
                        Symbol s = ((LirSymRef)n.kid((int)i)).symbol;
                        if (s != dst) continue;
                        mod = true;
                        this.env.println("ACPYP : in " + node + " in block " + blk.id, 2000);
                        this.env.print("ACPYP : " + n.kid(i) + " ---> ", 2000);
                        newNode = node.kid(1).makeCopy(this.env.lir);
                        n.setKid(i, newNode);
                        this.env.println(n.kid(i).toString(), 2000);
                        this.g.touch();
                        continue;
                    }
                    stack.push(n.kid(i));
                }
            }
            switch (nd.opCode) {
                case 59: {
                    if (nd.kid((int)0).opCode != 6) {
                        System.out.println(nd.kid(0).toString());
                    }
                    boolean allSameArgs = true;
                    for (i = 1; i < nd.nKids(); ++i) {
                        if (nd.kid((int)i).kid((int)0).opCode != 6) {
                            allSameArgs = false;
                            break;
                        }
                        if (((LirSymRef)nd.kid((int)1).kid((int)0)).symbol == ((LirSymRef)nd.kid((int)i).kid((int)0)).symbol) continue;
                        allSameArgs = false;
                        break;
                    }
                    if (allSameArgs) {
                        LirNode left = this.env.lir.symRef(((LirSymRef)nd.kid((int)0)).symbol);
                        LirNode right = nd.kid(1).kid(0).makeCopy(this.env.lir);
                        newNode = this.env.lir.operator(48, nd.type, left, right, ImList.Empty);
                        Object[] pair = new Object[]{bk, newNode};
                        postCpy.add(pair);
                        this.pre.maintainTableDeletePhi(oldNd, nd, bk);
                        ((BiLink)bn[1]).unlink();
                    }
                    if (!mod) break;
                    this.pre.maintainTableReplacePhi(oldNd, nd, bk);
                    break;
                }
                case 48: {
                    if (nd.kid((int)0).opCode != 6 || nd.kid((int)1).opCode == 2 || nd.kid((int)1).opCode == 3 || nd.kid((int)1).opCode == 6 || nd.kid((int)1).opCode == 53 || nd.kid((int)1).opCode == 57 || nd.kid((int)1).opCode == 58 || !mod) break;
                    this.pre.maintainTableReplaceExp(oldNd, nd, bk);
                }
            }
        }
        this.variableMap.remove(dst.name);
        if (node.kid((int)1).opCode == 6) {
            Symbol src = ((LirSymRef)node.kid((int)1)).symbol;
            Hashtable cCnt = (Hashtable)this.variableMap.get(src.name);
            if (cCnt != null) {
                v.putAll(cCnt);
            }
            this.variableMap.put(src.name, v);
        }
        Enumeration postCpyE = postCpy.elements();
        while (postCpyE.hasMoreElements()) {
            Object[] pair = (Object[])postCpyE.nextElement();
            this.doIt((BasicBlk)pair[0], (LirNode)pair[1]);
        }
    }
}

