/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import coins.ssa.Util;
import java.util.Hashtable;
import java.util.Stack;

class ConstantPropagation
implements LocalTransformer {
    private SsaEnvironment env;
    public static final int THR = 2000;
    private Function f;
    private Hashtable symbols;
    private Stack FlowWork;
    private Stack SSAWork;
    private BiList availEdge;
    private Util util;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "ConstantPropagation";
    }

    public String subject() {
        return "Constant propagation on SSA form.";
    }

    public ConstantPropagation(SsaEnvironment e) {
        this.env = e;
        this.env.println("  Constant Propagation", 100);
    }

    public boolean doIt(Function function, ImList args) {
        this.env.println("****************** doing CSTP to " + function.symbol.name, 1000);
        this.f = function;
        this.util = new Util(this.env, this.f);
        FlowGraph g = function.flowGraph();
        boolean phiChanged = true;
        while (phiChanged) {
            phiChanged = false;
            this.symbols = new Hashtable();
            BiLink p = this.f.localSymtab.symbols().first();
            while (!p.atEnd()) {
                Symbol s = (Symbol)p.elem();
                if (!this.symbols.containsKey(s)) {
                    this.symbols.put(s, new VariableData(s));
                }
                p = p.next();
            }
            BiList visited = new BiList();
            BasicBlk entryBlk = g.entryBlk();
            Stack<BasicBlk> stack = new Stack<BasicBlk>();
            stack.push(entryBlk);
            while (!stack.empty()) {
                BasicBlk blk = (BasicBlk)stack.pop();
                if (visited.contains(blk)) continue;
                visited.add(blk);
                BiLink p2 = blk.instrList().first();
                while (!p2.atEnd()) {
                    BiList list;
                    LirNode node = (LirNode)p2.elem();
                    if (node.opCode == 54) {
                        BiList list2 = this.util.findTargetLir(node, 6, new BiList());
                        BiLink q = list2.first();
                        while (!q.atEnd()) {
                            LirSymRef regNode = (LirSymRef)q.elem();
                            VariableData data = this.getVariableData(regNode);
                            data.overdefine = true;
                            data.defineNode = node;
                            q = q.next();
                        }
                    } else if (node.opCode == 48 || node.opCode == 59) {
                        if (node.kid((int)0).opCode != 6) {
                            BiList list3 = this.util.findTargetLir(node, 6, new BiList());
                            this.setUse(blk, node, list3);
                        } else {
                            LirSymRef regNode = (LirSymRef)node.kid(0);
                            VariableData data = this.getVariableData(regNode);
                            data.defineNode = node;
                            for (int i = 1; i < node.nKids(); ++i) {
                                list = this.util.findTargetLir(node.kid(i), 6, new BiList());
                                this.setUse(blk, node, list);
                            }
                        }
                    } else if (node.opCode == 53) {
                        if (node.kid(2).nKids() > 0 && node.kid((int)2).kid((int)0).opCode == 6) {
                            LirSymRef regNode = (LirSymRef)node.kid(2).kid(0);
                            VariableData data = this.getVariableData(regNode);
                            data.undefine = false;
                            data.overdefine = true;
                            data.defineNode = node;
                        } else {
                            BiList rvals = this.util.findTargetLir(node.kid(2), 6, new BiList());
                            BiLink pp = rvals.first();
                            while (!pp.atEnd()) {
                                LirNode arg3 = (LirNode)pp.elem();
                                list = this.util.findTargetLir(arg3, 6, new BiList());
                                this.setUse(blk, node, list);
                                pp = pp.next();
                            }
                        }
                        for (int i = 0; i < 2; ++i) {
                            BiList list4 = this.util.findTargetLir(node.kid(i), 6, new BiList());
                            this.setUse(blk, node, list4);
                        }
                    } else {
                        BiList list5 = this.util.findTargetLir(node, 6, new BiList());
                        this.setUse(blk, node, list5);
                        if (node.opCode == 49) {
                            stack.push(((LirLabelRef)node.kid((int)0)).label.basicBlk());
                        } else if (node.opCode == 50) {
                            for (int i = 1; i < node.nKids(); ++i) {
                                stack.push(((LirLabelRef)node.kid((int)i)).label.basicBlk());
                            }
                        } else if (node.opCode == 51) {
                            for (int i = 0; i < node.kid(1).nKids(); ++i) {
                                stack.push(((LirLabelRef)node.kid((int)1).kid((int)i).kid((int)1)).label.basicBlk());
                            }
                            stack.push(((LirLabelRef)node.kid((int)2)).label.basicBlk());
                        }
                    }
                    p2 = p2.next();
                }
            }
            this.FlowWork = new Stack();
            this.SSAWork = new Stack();
            this.availEdge = new BiList();
            BiList availBlk = new BiList();
            LirLabelRef entry = (LirLabelRef)this.env.lir.labelRefVariant(entryBlk.label());
            this.FlowWork.push(entry);
            while (!this.FlowWork.empty() || !this.SSAWork.empty()) {
                BiLink p3;
                while (!this.FlowWork.empty()) {
                    LirNode node;
                    LirLabelRef lab = (LirLabelRef)this.FlowWork.pop();
                    if (this.availEdge.contains(lab)) continue;
                    this.availEdge.add(lab);
                    BasicBlk blk = lab.label.basicBlk();
                    p3 = blk.instrList().first();
                    while (!p3.atEnd()) {
                        node = (LirNode)p3.elem();
                        if (node.opCode != 59) break;
                        this.evalPhiExp(node);
                        p3 = p3.next();
                    }
                    if (!availBlk.contains(blk)) {
                        availBlk.add(blk);
                        this.env.println("CSTP : block " + blk.id + " is available", 2000);
                        p3 = blk.instrList().first();
                        while (!p3.atEnd()) {
                            node = (LirNode)p3.elem();
                            if (node.opCode != 59) {
                                this.evalExp(node);
                            }
                            p3 = p3.next();
                        }
                    }
                    if (((LirNode)blk.instrList().last().elem()).opCode != 49) continue;
                    LirNode node2 = (LirNode)blk.instrList().last().elem();
                    this.FlowWork.push(node2.kid(0));
                }
                while (!this.SSAWork.empty()) {
                    Symbol s = (Symbol)this.SSAWork.pop();
                    VariableData data = this.getVariableData(s);
                    p3 = data.useList.first();
                    while (!p3.atEnd()) {
                        Object[] obj = (Object[])p3.elem();
                        if (availBlk.contains(obj[0])) {
                            if (((LirNode)obj[1]).opCode == 59) {
                                this.evalPhiExp((LirNode)obj[1]);
                            } else {
                                this.evalExp((LirNode)obj[1]);
                            }
                        }
                        p3 = p3.next();
                    }
                }
            }
            stack = new Stack();
            stack.push(entryBlk);
            visited = new BiList();
            while (!stack.empty()) {
                BasicBlk blk = (BasicBlk)stack.pop();
                if (visited.contains(blk)) continue;
                visited.add(blk);
                BiLink p4 = blk.instrList().first();
                while (!p4.atEnd()) {
                    LirLabelRef lab;
                    LirNode node = (LirNode)p4.elem();
                    if ((node.opCode == 48 || node.opCode == 59) && node.kid((int)0).opCode == 6 || node.opCode == 53 && node.kid(2).nKids() > 0 && node.kid((int)2).kid((int)0).opCode == 6) {
                        VariableData data = null;
                        switch (node.opCode) {
                            case 53: {
                                data = this.getVariableData((LirSymRef)node.kid(2).kid(0));
                                break;
                            }
                            default: {
                                data = this.getVariableData((LirSymRef)node.kid(0));
                            }
                        }
                        if (data != null && !data.overdefine) {
                            if (data.undefine) {
                                this.env.println("CSTP : remove because unavailable " + node + " in block " + blk.id, 2000);
                                p4.unlink();
                                g.touch();
                            } else {
                                data.canReplace = true;
                                BiLink q = data.useList.first();
                                while (!q.atEnd()) {
                                    Object[] o = (Object[])q.elem();
                                    if (availBlk.contains(o[0])) {
                                        this.simplePropagate((LirNode)o[1]);
                                    }
                                    q = q.next();
                                }
                                this.env.println("CSTP : remove because constant " + node + " in block " + blk.id, 2000);
                                p4.unlink();
                                g.touch();
                            }
                        } else {
                            this.simplePropagate(node);
                            this.folding(node);
                        }
                    } else {
                        this.simplePropagate(node);
                        this.folding(node);
                    }
                    if (node.opCode == 49) {
                        LirLabelRef lab2 = (LirLabelRef)node.kid(0);
                        stack.push(lab2.label.basicBlk());
                    } else if (node.opCode == 50) {
                        for (int i = 1; i < node.nKids(); ++i) {
                            lab = (LirLabelRef)node.kid(i);
                            stack.push(lab.label.basicBlk());
                        }
                    } else if (node.opCode == 51) {
                        for (int i = 0; i < node.kid(1).nKids(); ++i) {
                            lab = (LirLabelRef)node.kid(1).kid(i).kid(1);
                            stack.push(lab.label.basicBlk());
                        }
                        LirLabelRef lab3 = (LirLabelRef)node.kid(2);
                        stack.push(lab3.label.basicBlk());
                    }
                    p4 = p4.next();
                }
            }
            BiLink p5 = this.f.flowGraph().basicBlkList.first();
            while (!p5.atEnd()) {
                BasicBlk blk = (BasicBlk)p5.elem();
                LirNode node = (LirNode)blk.instrList().last().elem();
                switch (node.opCode) {
                    case 49: {
                        if (availBlk.contains(blk)) break;
                        LirLabelRef lRef = (LirLabelRef)node.kid(0);
                        BasicBlk succ = lRef.label.basicBlk();
                        if (!availBlk.contains(succ)) break;
                        boolean chk = this.eliminateLabelFromSuccPhi(succ, lRef);
                        if (phiChanged || !chk) break;
                        phiChanged = true;
                        break;
                    }
                    case 50: {
                        boolean chk;
                        if (!availBlk.contains(blk)) {
                            LirLabelRef lRef = (LirLabelRef)node.kid(1);
                            BasicBlk succ = lRef.label.basicBlk();
                            if (availBlk.contains(succ)) {
                                chk = this.eliminateLabelFromSuccPhi(succ, lRef);
                                if (!phiChanged && chk) {
                                    phiChanged = true;
                                }
                            }
                            lRef = (LirLabelRef)node.kid(2);
                            succ = lRef.label.basicBlk();
                            if (!availBlk.contains(succ)) break;
                            chk = this.eliminateLabelFromSuccPhi(succ, lRef);
                            if (phiChanged || !chk) break;
                            phiChanged = true;
                            break;
                        }
                        LirNode n = this.evaluate(node.kid(0));
                        if (n == null) break;
                        long v = ((LirIconst)n).value;
                        this.util.makeNewJump(blk, (LirLabelRef)node.kid((int)(2L - v)));
                        LirLabelRef lRef = null;
                        switch ((int)v) {
                            case 0: {
                                lRef = (LirLabelRef)node.kid(1);
                                break;
                            }
                            default: {
                                lRef = (LirLabelRef)node.kid(2);
                            }
                        }
                        BasicBlk succ = lRef.label.basicBlk();
                        if (!availBlk.contains(succ)) break;
                        boolean chk2 = this.eliminateLabelFromSuccPhi(succ, lRef);
                        if (phiChanged || !chk2) break;
                        phiChanged = true;
                        break;
                    }
                    case 51: {
                        if (!availBlk.contains(blk)) {
                            for (int i = 0; i < node.kid(1).nKids(); ++i) {
                                LirNode n = node.kid(1).kid(i);
                                LirLabelRef lRef = (LirLabelRef)n.kid(1);
                                BasicBlk succ = lRef.label.basicBlk();
                                if (!availBlk.contains(succ)) continue;
                                boolean chk = this.eliminateLabelFromSuccPhi(succ, lRef);
                                if (phiChanged || !chk) continue;
                                phiChanged = true;
                            }
                            BasicBlk succ = ((LirLabelRef)node.kid((int)2)).label.basicBlk();
                            if (!availBlk.contains(succ)) break;
                            boolean chk = this.eliminateLabelFromSuccPhi(succ, (LirLabelRef)node.kid(2));
                            if (phiChanged || !chk) break;
                            phiChanged = true;
                            break;
                        }
                        if (node.kid((int)0).opCode != 2) break;
                        long arg0 = ((LirIconst)node.kid((int)0)).value;
                        boolean changed = false;
                        for (int i = 0; i < node.kid(1).nKids(); ++i) {
                            LirNode n = node.kid(1).kid(i);
                            long arg = ((LirIconst)n.kid((int)0)).value;
                            if (arg0 == arg && !changed) {
                                this.util.makeNewJump(blk, (LirLabelRef)n.kid(1));
                                changed = true;
                                continue;
                            }
                            BasicBlk succ = ((LirLabelRef)n.kid((int)1)).label.basicBlk();
                            if (!availBlk.contains(succ)) continue;
                            boolean chk = this.eliminateLabelFromSuccPhi(succ, (LirLabelRef)n.kid(1));
                            if (phiChanged || !chk) continue;
                            phiChanged = true;
                        }
                        if (!changed) {
                            this.util.makeNewJump(blk, (LirLabelRef)node.kid(2));
                            break;
                        }
                        BasicBlk succ = ((LirLabelRef)node.kid((int)2)).label.basicBlk();
                        if (!availBlk.contains(succ)) break;
                        boolean chk = this.eliminateLabelFromSuccPhi(succ, (LirLabelRef)node.kid(2));
                        if (phiChanged || !chk) break;
                        phiChanged = true;
                    }
                }
                p5 = p5.next();
            }
            p5 = this.f.flowGraph().basicBlkList.first();
            while (!p5.atEnd()) {
                BasicBlk blk = (BasicBlk)p5.elem();
                if (!availBlk.contains(blk) && ((LirNode)blk.instrList().last().elem()).opCode != 55) {
                    this.env.println("CSTP : remove block " + blk.id + "(" + blk.label() + ")", 2000);
                    blk.clearEdges();
                    blk.clearDummyEdges();
                    p5.unlink();
                    this.f.flowGraph().touch();
                }
                p5 = p5.next();
            }
        }
        this.env.println("", 2000);
        return true;
    }

    private boolean eliminateLabelFromSuccPhi(BasicBlk succ, LirLabelRef lRef) {
        boolean changed = false;
        BiLink p = succ.instrList().first();
        while (!p.atEnd()) {
            LirNode node = (LirNode)p.elem();
            if (node.opCode != 59) break;
            BiList newPhiParam = new BiList();
            for (int i = 1; i < node.nKids(); ++i) {
                if (lRef.equals(node.kid(i).kid(2))) continue;
                newPhiParam.add(node.kid(i));
            }
            if (newPhiParam.length() + 1 != node.nKids()) {
                LirNode[] args = new LirNode[newPhiParam.length() + 1];
                args[0] = node.kid(0);
                BiLink qq = newPhiParam.first();
                for (int i = 1; i < args.length; ++i) {
                    args[i] = (LirNode)qq.elem();
                    qq = qq.next();
                }
                LirNode newPhi = this.env.lir.operator(59, node.type, args, ImList.Empty);
                p.addBefore(newPhi);
                p.unlink();
                this.f.flowGraph().touch();
                changed = true;
            }
            p = p.next();
        }
        return changed;
    }

    private void evalPhiExp(LirNode phiInst) {
        this.simplePropagate(phiInst);
        VariableData data = this.getVariableData((LirSymRef)phiInst.kid(0));
        if (!data.overdefine) {
            for (int i = 1; i < phiInst.nKids(); ++i) {
                LirNode newValue;
                LirLabelRef edge = (LirLabelRef)phiInst.kid(i).kid(2);
                if (!this.availEdge.contains(edge)) continue;
                LirNode node = phiInst.kid(i).kid(0);
                if (node instanceof LirSymRef) {
                    VariableData arg = this.getVariableData((LirSymRef)node);
                    if (arg.overdefine) {
                        data.overdefine = true;
                        this.SSAWork.push(((LirSymRef)phiInst.kid((int)0)).symbol);
                        break;
                    }
                    if (arg.undefine) continue;
                    if (data.undefine) {
                        data.value = arg.value;
                        data.undefine = false;
                        this.SSAWork.push(((LirSymRef)phiInst.kid((int)0)).symbol);
                        continue;
                    }
                    if (data.value.equals(arg.value)) continue;
                    data.overdefine = true;
                    this.SSAWork.push(((LirSymRef)phiInst.kid((int)0)).symbol);
                    break;
                }
                if (node instanceof LirIconst) {
                    long value = ((LirIconst)node).value;
                    newValue = this.env.lir.iconst(node.type, value, ImList.Empty);
                    if (data.undefine) {
                        data.value = newValue;
                        data.undefine = false;
                        this.SSAWork.push(((LirSymRef)phiInst.kid((int)0)).symbol);
                        continue;
                    }
                    if (data.value.equals(newValue)) continue;
                    data.overdefine = true;
                    this.SSAWork.push(((LirSymRef)phiInst.kid((int)0)).symbol);
                    break;
                }
                if (!(node instanceof LirFconst)) continue;
                double value = ((LirFconst)node).value;
                newValue = this.env.lir.fconst(node.type, value, ImList.Empty);
                if (data.undefine) {
                    data.value = newValue;
                    data.undefine = false;
                    this.SSAWork.push(((LirSymRef)phiInst.kid((int)0)).symbol);
                    continue;
                }
                if (data.value.equals(newValue)) continue;
                data.overdefine = true;
                this.SSAWork.push(((LirSymRef)phiInst.kid((int)0)).symbol);
                break;
            }
        }
    }

    private void evalExp(LirNode exp) {
        this.simplePropagate(exp);
        this.folding(exp);
        if (exp.opCode == 48 && exp.kid((int)0).opCode == 6) {
            VariableData data = this.getVariableData((LirSymRef)exp.kid(0));
            if (!data.overdefine) {
                int targetCode = exp.kid((int)1).opCode;
                if (targetCode == 2) {
                    data.undefine = false;
                    data.value = exp.kid(1).makeCopy(this.env.lir);
                    data.canReplace = true;
                    this.SSAWork.push(((LirSymRef)exp.kid((int)0)).symbol);
                } else if (targetCode == 3) {
                    data.undefine = false;
                    data.value = exp.kid(1).makeCopy(this.env.lir);
                    data.canReplace = true;
                    this.SSAWork.push(((LirSymRef)exp.kid((int)0)).symbol);
                } else {
                    boolean ov = this.setOverdefine(47, data, exp);
                    if (!ov) {
                        ov = this.setOverdefine(53, data, exp);
                    }
                    if (!ov) {
                        ov = this.setOverdefine(58, data, exp);
                    }
                    if (!ov) {
                        ov = this.setOverdefine(4, data, exp);
                    }
                    if (!ov) {
                        ov = this.setOverdefine(5, data, exp);
                    }
                    if (!ov) {
                        boolean isUndefine = false;
                        block4: for (int i = 1; i < exp.nKids(); ++i) {
                            BiList list = this.util.findTargetLir(exp.kid(i), 6, new BiList());
                            BiLink p = list.first();
                            while (!p.atEnd()) {
                                LirSymRef regNode = (LirSymRef)p.elem();
                                VariableData temp = this.getVariableData(regNode);
                                if (temp.overdefine) {
                                    data.overdefine = true;
                                    this.SSAWork.push(((LirSymRef)exp.kid((int)0)).symbol);
                                    continue block4;
                                }
                                if (temp.undefine) {
                                    isUndefine = true;
                                    continue block4;
                                }
                                p = p.next();
                            }
                        }
                        if (!isUndefine && !data.overdefine) {
                            LirNode value = this.evaluate(exp.kid(1));
                            if (value != null) {
                                data.value = value;
                                data.undefine = false;
                            } else {
                                data.overdefine = true;
                            }
                        }
                    }
                }
            }
        } else if (exp.opCode == 50) {
            LirNode tstResult = this.evaluate(exp.kid(0));
            if (tstResult == null) {
                this.FlowWork.push(exp.kid(1));
                this.FlowWork.push(exp.kid(2));
            } else {
                long v = ((LirIconst)tstResult).value;
                this.FlowWork.push(exp.kid((int)(2L - v)));
            }
        } else if (exp.opCode == 51) {
            LirNode value = null;
            switch (exp.kid((int)0).opCode) {
                case 6: {
                    VariableData tst = this.getVariableData((LirSymRef)exp.kid(0));
                    if (tst.undefine || tst.overdefine) break;
                    value = tst.value;
                    break;
                }
                case 2: {
                    value = this.env.lir.iconst(exp.type, ((LirIconst)exp.kid((int)0)).value, ImList.Empty);
                }
            }
            if (value != null) {
                long v = ((LirIconst)value).value;
                boolean isFind = false;
                for (int i = 0; i < exp.kid(1).nKids(); ++i) {
                    long nodeVal = ((LirIconst)exp.kid((int)1).kid((int)i).kid((int)0)).value;
                    if (v != nodeVal) continue;
                    this.FlowWork.push(exp.kid(1).kid(i).kid(1));
                    isFind = true;
                    break;
                }
                if (!isFind) {
                    this.FlowWork.push(exp.kid(2));
                }
            } else {
                for (int i = 0; i < exp.kid(1).nKids(); ++i) {
                    this.FlowWork.push(exp.kid(1).kid(i).kid(1));
                }
                this.FlowWork.push(exp.kid(2));
            }
        }
    }

    private LirNode evaluate(LirNode node) {
        LirNode value = this.env.lir.evalTree(node);
        LirNode[] args = new LirNode[node.nKids()];
        for (int i = 0; i < node.nKids(); ++i) {
            args[i] = this.evaluate(node.kid(i));
            if (args[i] != null) continue;
            return null;
        }
        switch (node.opCode) {
            case 2: 
            case 3: {
                value = node.makeCopy(this.env.lir);
                break;
            }
            case 6: {
                VariableData data = this.getVariableData((LirSymRef)node);
                if (data.undefine || data.overdefine) break;
                value = data.value.makeCopy(this.env.lir);
                break;
            }
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: {
                if (args[0] == null) break;
                value = this.env.lir.operator(node.opCode, node.type, args[0], ImList.Empty);
                value = this.env.lir.foldConstant(value);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                if (args[0] == null || args[1] == null || args[1].opCode != 2 || ((LirIconst)args[1]).value == 0L) break;
                value = this.env.lir.operator(node.opCode, node.type, args[0], args[1], ImList.Empty);
                value = this.env.lir.foldConstant(value);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                if (args[0] == null || args[1] == null) break;
                value = this.env.lir.operator(node.opCode, node.type, args[0], args[1], ImList.Empty);
                value = this.env.lir.foldConstant(value);
                break;
            }
            default: {
                value = null;
            }
        }
        if (value != null && value.opCode != 2 && value.opCode != 3) {
            value = null;
        }
        return value;
    }

    private boolean setOverdefine(int opCode, VariableData data, LirNode exp) {
        for (int i = 1; i < exp.nKids(); ++i) {
            BiList list = this.util.findTargetLir(exp.kid(i), opCode, new BiList());
            if (list.length() <= 0) continue;
            data.overdefine = true;
            this.SSAWork.push(((LirSymRef)exp.kid((int)0)).symbol);
            return true;
        }
        return false;
    }

    private void simplePropagate(LirNode n) {
        Stack<LirNode> stack = new Stack<LirNode>();
        stack.push(n);
        while (!stack.empty()) {
            LirNode node = (LirNode)stack.pop();
            for (int i = 0; i < node.nKids(); ++i) {
                if (i == 0 && (node.opCode == 59 || node.opCode == 48) && node.kid((int)i).opCode == 6) continue;
                if (node.kid((int)i).opCode == 6) {
                    LirNode cnst;
                    VariableData data = this.getVariableData((LirSymRef)node.kid(i));
                    if (data.undefine || data.overdefine || !data.canReplace) continue;
                    if (((VariableData)data).value.opCode == 2) {
                        cnst = data.value.makeCopy(this.env.lir);
                        node.setKid(i, cnst);
                        continue;
                    }
                    if (((VariableData)data).value.opCode != 3) continue;
                    cnst = data.value.makeCopy(this.env.lir);
                    node.setKid(i, cnst);
                    continue;
                }
                stack.push(node.kid(i));
            }
        }
    }

    private void folding(LirNode node) {
        if (node.opCode != 59) {
            this.env.lir.evalTree(node);
        }
    }

    private VariableData getVariableData(LirSymRef reg) {
        Symbol s = reg.symbol;
        return this.getVariableData(s);
    }

    private VariableData getVariableData(Symbol s) {
        VariableData data = (VariableData)this.symbols.get(s);
        if (data == null) {
            data = new VariableData(s);
            this.symbols.put(s, data);
        }
        return data;
    }

    private void setUse(BasicBlk blk, LirNode useNode, BiList list) {
        BiLink p = list.first();
        while (!p.atEnd()) {
            LirSymRef regNode = (LirSymRef)p.elem();
            VariableData data = this.getVariableData(regNode);
            Object[] obj = new Object[]{blk, useNode};
            data.useList.addNew(obj);
            p = p.next();
        }
    }

    private class VariableData {
        private Symbol s;
        private boolean undefine;
        private boolean canReplace;
        private boolean overdefine;
        private BiList useList;
        private LirNode defineNode;
        private LirNode value;

        VariableData(Symbol sym) {
            this.s = sym;
            this.undefine = true;
            this.overdefine = false;
            this.canReplace = false;
            this.useList = new BiList();
            this.defineNode = null;
            this.value = null;
        }

        void print() {
            ((ConstantPropagation)ConstantPropagation.this).env.output.println(" +++++++ about " + this.s);
            ((ConstantPropagation)ConstantPropagation.this).env.output.println("    undefined : " + this.undefine);
            ((ConstantPropagation)ConstantPropagation.this).env.output.println("  overdefined : " + this.overdefine);
            ((ConstantPropagation)ConstantPropagation.this).env.output.println("  can replace : " + this.canReplace);
            if (!this.undefine && !this.overdefine) {
                ((ConstantPropagation)ConstantPropagation.this).env.output.println("        value : " + this.value);
            }
            ((ConstantPropagation)ConstantPropagation.this).env.output.println("  define node : " + this.defineNode);
            BiLink p = this.useList.first();
            while (!p.atEnd()) {
                ((ConstantPropagation)ConstantPropagation.this).env.output.print("     use node : ");
                Object[] obj = (Object[])p.elem();
                ((ConstantPropagation)ConstantPropagation.this).env.output.println(((BasicBlk)obj[0]).label() + " -- " + obj[1]);
                p = p.next();
            }
            ((ConstantPropagation)ConstantPropagation.this).env.output.println();
        }
    }
}

