/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

public class BitVector {
    private final int fLongWordLength;
    private final int fBitLength;
    private final int fShiftMax;
    private long[] fVectorWord;

    BitVector(int elementsNum) {
        this.fBitLength = 64;
        this.fShiftMax = this.fBitLength - 1;
        this.fLongWordLength = elementsNum / this.fBitLength + 1;
        this.fVectorWord = new long[this.fLongWordLength];
        this.vectorReset();
    }

    void setBit(int pInx) {
        int lWord = pInx / this.fBitLength;
        int lInx = pInx - lWord * this.fBitLength;
        this.fVectorWord[lWord] = this.fVectorWord[lWord] | 1L << this.fShiftMax - lInx;
    }

    void resetBit(int pInx) {
        int lWord = pInx / this.fBitLength;
        int lInx = pInx - lWord * this.fBitLength;
        long lMask = 1L << this.fShiftMax - lInx ^ 0xFFFFFFFFFFFFFFFFL;
        this.fVectorWord[lWord] = this.fVectorWord[lWord] & lMask;
    }

    int getBit(int pInx) {
        int lWord = pInx / this.fBitLength;
        int lInx = pInx - lWord * this.fBitLength;
        int lBit = (int)(this.fVectorWord[lWord] >> this.fShiftMax - lInx & 1L);
        return lBit;
    }

    void vectorAnd(BitVector pOperand2, BitVector pResult) {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            pResult.fVectorWord[i] = this.fVectorWord[i] & pOperand2.fVectorWord[i];
        }
    }

    void vectorOr(BitVector pOperand2, BitVector pResult) {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            pResult.fVectorWord[i] = this.fVectorWord[i] | pOperand2.fVectorWord[i];
        }
    }

    void vectorXor(BitVector pOperand2, BitVector pResult) {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            pResult.fVectorWord[i] = this.fVectorWord[i] ^ pOperand2.fVectorWord[i];
        }
    }

    void vectorNot(BitVector pResult) {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            pResult.fVectorWord[i] = this.fVectorWord[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    void vectorSub(BitVector pOperand2, BitVector pResult) {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            pResult.fVectorWord[i] = this.fVectorWord[i] & (pOperand2.fVectorWord[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    void vectorCopy(BitVector pResult) {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            pResult.fVectorWord[i] = this.fVectorWord[i];
        }
    }

    boolean vectorEqual(BitVector pOperand2) {
        boolean lResult = false;
        int i = 0;
        do {
            boolean bl = lResult = this.fVectorWord[i] != pOperand2.fVectorWord[i];
        } while (++i < this.fLongWordLength && !lResult);
        return !lResult;
    }

    void vectorReset() {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            this.fVectorWord[i] = 0L;
        }
    }

    boolean isEmpty() {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            if (this.fVectorWord[i] == 0L) continue;
            return false;
        }
        return true;
    }

    int getBitLength() {
        return this.fBitLength;
    }

    int getWordLength() {
        return this.fLongWordLength;
    }

    long[] getVectorWord() {
        return this.fVectorWord;
    }

    private void print() {
        for (int j = 0; j < 32; ++j) {
            System.out.print(this.getBit(j) + " ");
        }
        System.out.println("");
    }
}

