/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.ana.Dominators;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirBinOp;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNaryOp;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.lir.LirUnaOp;
import coins.backend.lir.LirVisitor;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import coins.ssa.SsaSymTab;
import coins.ssa.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

class BackTranslateFromSsaBriggs
implements LocalTransformer {
    public static final int THR = 10000;
    private final boolean extended;
    private SsaEnvironment env;
    private PrintWriter output;
    private Function func;
    private SsaSymTab ssatab;
    private Hashtable arrayOfStack = new Hashtable();
    private Hashtable used_by_another = new Hashtable();
    private Hashtable map = new Hashtable();
    private Hashtable exmap = new Hashtable();
    private Hashtable phi_define_dest = new Hashtable();
    private Hashtable cut = new Hashtable();
    private BiList registers = new BiList();
    private FlowGraph cfg;
    private Dominators dominators;
    private LiveVariableAnalysis liveness;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "BackTranslateFromSsaBriggs";
    }

    public String subject() {
        return "Back translation from SSA form using Briggs' method.";
    }

    public BackTranslateFromSsaBriggs(SsaEnvironment enviroment, SsaSymTab ssasymtab, boolean ex) {
        this.env = enviroment;
        this.output = this.env.output;
        this.ssatab = ssasymtab;
        this.extended = ex;
        this.env.println("  SSA back translation : BRIGGS", 100);
    }

    public boolean doIt(Function function, ImList args) {
        this.env.println("****************** Back Translate from SSA form to " + function.symbol.name, 1000);
        this.func = function;
        if (this.extended) {
            this.checkWeak(this.func);
        }
        this.replace_phi_nodes(this.func);
        Util util = new Util(this.env, this.func);
        util.changeLabelRef(false);
        this.func.flowGraph().touch();
        return true;
    }

    private void replace_phi_nodes(Function function) {
        this.func = function;
        this.cfg = this.func.flowGraph();
        this.dominators = (Dominators)this.func.require(Dominators.analyzer);
        this.liveness = (LiveVariableAnalysis)this.func.require(LiveVariableSlotwise.analyzer);
        this.setRegisters2();
        this.initializeTables();
        this.insert_copies(this.cfg.entryBlk());
        this.removePhiNodes();
    }

    private void insert_copies(BasicBlk block) {
        BiList pushed = new BiList();
        Iterator regiterator = this.registers.iterator();
        while (regiterator.hasNext()) {
            Stack stack;
            LirNode u = (LirNode)regiterator.next();
            if (!this.arrayOfStack.containsKey(u)) {
                this.env.println("error1: insert_copies", 10000);
            }
            if ((stack = (Stack)this.arrayOfStack.get(u)).empty()) continue;
            LirNode stacks_u = (LirNode)stack.peek();
            this.searchReplace(u, stacks_u, block);
        }
        this.schedule_copies(block, pushed);
        Iterator childiterator = this.dominators.children(block);
        while (childiterator.hasNext()) {
            BasicBlk child = (BasicBlk)childiterator.next();
            this.insert_copies(child);
        }
        pushed.toString();
        this.stackClean(pushed);
    }

    private void schedule_copies(BasicBlk block, BiList pushed) {
        LirNode dest;
        Couple current;
        LirNode src;
        LirNode jumpInst = (LirNode)block.instrList().last().elem();
        CoupleSet copy_set = new CoupleSet();
        CoupleSet worklist = new CoupleSet();
        BiList succlist = block.succList();
        Iterator succiterator = succlist.iterator();
        while (succiterator.hasNext()) {
            BasicBlk s = (BasicBlk)succiterator.next();
            BiList phinodes = this.getPhiNodes(s);
            Iterator phiiterator = phinodes.iterator();
            while (phiiterator.hasNext()) {
                LirNode phinode = (LirNode)phiiterator.next();
                LirNode dest2 = this.getPhiDest(phinode);
                src = this.getJthOperand(block, phinode);
                Couple couple = new Couple(src, dest2);
                copy_set.addNewCouple(couple);
                this.updateHash(this.map, src, src);
                this.updateHash(this.map, dest2, dest2);
                this.updateHash(this.used_by_another, src, new Boolean(true));
            }
        }
        BiList dummy1 = copy_set.getCoupleSet().copy();
        Iterator dumIter1 = dummy1.iterator();
        while (dumIter1.hasNext()) {
            current = (Couple)dumIter1.next();
            dest = current.getDest();
            if (!this.used_by_another.containsKey(dest)) {
                this.env.println("error: insert_copies", 10000);
            }
            if (((Boolean)this.used_by_another.get(dest)).booleanValue()) continue;
            worklist.addNewCouple(current);
            BiLink l = copy_set.removeCouple(current);
            if (l != null) continue;
            this.env.println("error2: insert_copies", 10000);
        }
        while (!worklist.isEmpty() || !copy_set.isEmpty()) {
            LirSymRef t;
            Symbol tsym;
            Symbol destsym;
            while (!worklist.isEmpty()) {
                BasicBlk defining;
                LirBinOp copy1;
                Couple picked = worklist.pickRemove();
                dest = (LirSymRef)picked.getDest();
                destsym = ((LirSymRef)dest).symbol;
                if (this.extended) {
                    if (this.liveness.isLiveAtExit(destsym, block) && ((LirSymRef)dest).id != ((LirSymRef)picked.getSrc()).id) {
                        tsym = this.ssatab.newSsaSymbol(destsym);
                        t = (LirSymRef)this.env.lir.symRef(tsym);
                        this.updateHash(this.map, t, t);
                        copy1 = (LirBinOp)this.env.lir.operator(48, t.type, t, dest, ImList.Empty);
                        if (!this.phi_define_dest.containsKey(dest)) {
                            this.env.println("error1 : schedule_copies", 10000);
                        }
                        defining = (BasicBlk)this.phi_define_dest.get(dest);
                        this.insertCopyAtHead(defining, copy1);
                        this.env.println("copy1", 10000);
                        this.pushStack(t, dest, pushed);
                    }
                } else if (this.liveness.isLiveAtExit(destsym, block)) {
                    tsym = this.ssatab.newSsaSymbol(destsym);
                    t = (LirSymRef)this.env.lir.symRef(tsym);
                    this.updateHash(this.map, t, t);
                    copy1 = (LirBinOp)this.env.lir.operator(48, t.type, t, dest, ImList.Empty);
                    if (!this.phi_define_dest.containsKey(dest)) {
                        this.env.println("error1 : schedule_copies", 10000);
                    }
                    defining = (BasicBlk)this.phi_define_dest.get(dest);
                    this.insertCopyAtHead(defining, copy1);
                    this.env.println("copy1", 10000);
                    this.pushStack(t, dest, pushed);
                    if (this.asUse(dest, jumpInst)) {
                        this.replaceNode(dest, t, jumpInst);
                        this.cfg.touch();
                    }
                } else if (this.asUse(dest, jumpInst)) {
                    tsym = this.ssatab.newSsaSymbol(destsym);
                    t = (LirSymRef)this.env.lir.symRef(tsym);
                    this.updateHash(this.map, t, t);
                    LirBinOp copy4 = (LirBinOp)this.env.lir.operator(48, t.type, t, dest, ImList.Empty);
                    if (!this.phi_define_dest.containsKey(dest)) {
                        this.env.println("error1 : schedule_copies", 10000);
                    }
                    defining = (BasicBlk)this.phi_define_dest.get(dest);
                    this.insertCopyAtHead(defining, copy4);
                    this.env.println("copy4", 10000);
                    this.replaceNode(dest, t, jumpInst);
                    this.cfg.touch();
                }
                if (!this.map.containsKey(src = picked.getSrc())) {
                    this.env.println("error2 : schedule_copies", 10000);
                }
                LirNode map_src = (LirNode)this.map.get(src);
                LirBinOp copy2 = (LirBinOp)this.env.lir.operator(48, map_src.type, dest, map_src, ImList.Empty);
                this.insertCopyAtTail(block, copy2);
                this.updateHash(this.map, src, dest);
                this.updateHash(this.exmap, src, dest);
                BiList dummy2 = copy_set.getCoupleSet();
                Iterator dumIterator2 = dummy2.iterator();
                while (dumIterator2.hasNext()) {
                    Couple current2 = (Couple)dumIterator2.next();
                    LirNode destination = current2.getDest();
                    if (!src.equals(destination)) continue;
                    BiLink l = copy_set.removeCouple(current2);
                    if (l == null) {
                        this.env.println("error2: schedule_copies", 10000);
                    }
                    Couple couple = (Couple)l.elem();
                    worklist.addNewCouple(couple);
                }
            }
            if (copy_set.isEmpty()) continue;
            current = copy_set.pickRemove();
            dest = (LirSymRef)current.getDest();
            destsym = ((LirSymRef)dest).symbol;
            tsym = this.ssatab.newSsaSymbol(destsym);
            t = (LirSymRef)this.env.lir.symRef(tsym);
            this.updateHash(this.map, t, t);
            this.updateHash(this.exmap, t, t);
            LirBinOp copy3 = (LirBinOp)this.env.lir.operator(48, t.type, t, dest, ImList.Empty);
            this.insertCopyAtTail(block, copy3);
            this.updateHash(this.map, dest, t);
            this.updateHash(this.exmap, dest, t);
            worklist.addNewCouple(current);
        }
        if (this.extended) {
            this.jumpRepair(block);
        }
        this.exmap.clear();
    }

    private void setRegisters2() {
        PickingRegister visitor = new PickingRegister();
        Iterator blockiterator = this.cfg.basicBlkIterator();
        while (blockiterator.hasNext()) {
            BasicBlk block = (BasicBlk)blockiterator.next();
            Iterator nodelistiterator = block.instrList().iterator();
            while (nodelistiterator.hasNext()) {
                LirNode node = (LirNode)nodelistiterator.next();
                this.walkPreorder(visitor, node);
            }
        }
        this.registers = visitor.getRegisterlist();
    }

    private void initializeTables() {
        Iterator regiterator = this.registers.iterator();
        while (regiterator.hasNext()) {
            LirNode node = (LirNode)regiterator.next();
            this.arrayOfStack.put(node, new Stack());
            this.used_by_another.put(node, new Boolean(false));
        }
        Iterator blockiterator = this.cfg.basicBlkIterator();
        while (blockiterator.hasNext()) {
            BasicBlk block = (BasicBlk)blockiterator.next();
            this.cut.put(block, new BiList());
            Iterator instriterator = block.instrList().iterator();
            while (instriterator.hasNext()) {
                LirNode instr = (LirNode)instriterator.next();
                if (instr.opCode != 59) continue;
                LirNode dest = this.getPhiDest(instr);
                this.phi_define_dest.put(dest, block);
            }
        }
    }

    private void searchReplace(LirNode old, LirNode node, BasicBlk block) {
        Iterator nodeIterator = block.instrList().iterator();
        ReplaceVisitor visitor = new ReplaceVisitor(old, new Hashtable());
        while (nodeIterator.hasNext()) {
            LirNode current = (LirNode)nodeIterator.next();
            this.walkPreorder(visitor, current);
        }
        Hashtable children = visitor.children;
        Enumeration e = children.keys();
        while (e.hasMoreElements()) {
            LirNode current = (LirNode)e.nextElement();
            BiList srclist = (BiList)children.get(current);
            Iterator srciterator = srclist.iterator();
            while (srciterator.hasNext()) {
                int i = (Integer)srciterator.next();
                current.setKid(i, node);
                this.cfg.touch();
            }
        }
    }

    BiList getPhiNodes(BasicBlk block) {
        BiList phinodes = new BiList();
        Iterator instriterator = block.instrList().iterator();
        while (instriterator.hasNext()) {
            LirNode current = (LirNode)instriterator.next();
            if (current.opCode != 59) continue;
            phinodes.addNew(current);
        }
        return phinodes;
    }

    LirNode getPhiDest(LirNode phinode) {
        if (phinode.opCode != 59) {
            this.env.println(" error1: getPhiDest", 10000);
        }
        if (!this.isReg(phinode.kid(0))) {
            this.env.println("error2: getPhiDest", 10000);
        }
        return phinode.kid(0);
    }

    LirNode getJthOperand(BasicBlk block, LirNode phinode) {
        if (phinode.opCode != 59) {
            this.env.println(" error1: getJthOperand", 10000);
        }
        for (int i = 0; i < phinode.nKids(); ++i) {
            if (i == 0) {
                if (this.isReg(phinode.kid(i))) continue;
                this.env.println("error2: getJthOperand", 10000);
                continue;
            }
            LirNode param = phinode.kid(i);
            LirNode labelnode = param.kid(1);
            if (!(labelnode instanceof LirLabelRef)) {
                this.env.println("error4: getJthOperand", 10000);
            }
            if (((LirLabelRef)labelnode).label.basicBlk() != block) continue;
            if (!this.isReg(param.kid(0))) {
                this.env.println("error5: getJthOperand", 10000);
                this.env.println(param.kid(0).toString(), 10000);
            }
            return param.kid(0);
        }
        this.env.println("error6: getJthOperand", 10000);
        this.env.println(phinode.toString(), 10000);
        this.env.println(block.label().toString(), 10000);
        return null;
    }

    boolean isReg(LirNode node) {
        return node.opCode == 6 || node.opCode == 7 && node.kid((int)0).opCode == 6;
    }

    void updateHash(Hashtable hashtable, Object key, Object elem) {
        if (!hashtable.containsKey(key)) {
            hashtable.put(key, elem);
        } else {
            hashtable.remove(key);
            hashtable.put(key, elem);
        }
    }

    void insertCopyAtHead(BasicBlk block, LirNode node) {
        BiList instrlist = block.instrList();
        BiLink l = instrlist.first();
        while (!l.atEnd()) {
            LirNode instr = (LirNode)l.elem();
            if (instr.opCode != 59) {
                l.addBefore(node);
                break;
            }
            l = l.next();
        }
        if (instrlist.isEmpty()) {
            this.env.println("error1 : insertHead", 10000);
        }
        if (instrlist.length() == this.getPhiNodes(block).length() && instrlist.length() != 0) {
            this.env.println("error2 : insertHead", 10000);
        }
        this.cfg.touch();
    }

    void insertCopyAtTail(BasicBlk block, LirNode node) {
        BiList instrlist = block.instrList();
        if (instrlist.isEmpty()) {
            this.env.println("error1 : insertAtTail", 10000);
        }
        BiLink tail = instrlist.last();
        LirNode instr = (LirNode)tail.elem();
        if (instr.opCode != 49 && instr.opCode != 50 && instr.opCode != 51) {
            this.env.println("error2 : insertAtTail", 10000);
            this.env.println(instr.toString(), 10000);
        }
        tail.addBefore(node);
        this.cfg.touch();
    }

    private void pushStack(LirNode temp, LirNode dest, BiList pushed) {
        if (!this.arrayOfStack.containsKey(dest)) {
            this.env.println("error1: pushStack", 10000);
        }
        Stack stack = (Stack)this.arrayOfStack.get(dest);
        stack.push(temp);
        pushed.addNew(dest);
    }

    private void stackClean(BiList pushed) {
        Iterator pushediterator = pushed.iterator();
        while (pushediterator.hasNext()) {
            Stack stack;
            LirNode elem = (LirNode)pushediterator.next();
            if (!this.arrayOfStack.containsKey(elem)) {
                this.env.println("error1: stackClean", 10000);
            }
            if (!(stack = (Stack)this.arrayOfStack.get(elem)).empty()) {
                LirNode on_stack = (LirNode)stack.pop();
                continue;
            }
            this.env.println("error2: stackClean", 10000);
        }
        pushed.clear();
    }

    void removePhiNodes() {
        Iterator blockiterator = this.cfg.basicBlkIterator();
        while (blockiterator.hasNext()) {
            BasicBlk block = (BasicBlk)blockiterator.next();
            BiList instrlist = block.instrList();
            BiList dummy = instrlist.copy();
            Iterator dumIter = dummy.iterator();
            while (dumIter.hasNext()) {
                BiLink l;
                LirNode instr = (LirNode)dumIter.next();
                if (instr.opCode != 59 || (l = instrlist.remove(instr)) != null) continue;
                this.env.println("error1: removePhiNodes", 10000);
            }
        }
    }

    void checkWeak(Function func) {
        this.cfg = func.flowGraph();
        BiLink p = this.cfg.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                this.liveness = (LiveVariableAnalysis)func.require(LiveVariableSlotwise.analyzer);
                LirNode node = (LirNode)q.elem();
                if (node.opCode == 59 && this.isNeedCopy(node, blk)) {
                    this.phiNodeModify(node, blk);
                    this.cfg.touch();
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    boolean isNeedCopy(LirNode node, BasicBlk block) {
        if (node.opCode != 59) {
            this.env.println("error: isNeedCopy", 10000);
        }
        Symbol destsym = ((LirSymRef)node.kid((int)0)).symbol;
        Iterator pIter = block.predList().iterator();
        while (pIter.hasNext()) {
            BasicBlk pred = (BasicBlk)pIter.next();
            if (!this.liveness.isLiveAtExit(destsym, pred)) continue;
            return true;
        }
        return false;
    }

    void phiNodeModify(LirNode node, BasicBlk block) {
        LirSymRef dest = (LirSymRef)node.kid(0);
        Symbol destsym = dest.symbol;
        Symbol tsym = this.ssatab.newSsaSymbol(destsym);
        LirSymRef t = (LirSymRef)this.env.lir.symRef(tsym);
        LirBinOp copy = (LirBinOp)this.env.lir.operator(48, t.type, dest, t, ImList.Empty);
        node.setKid(0, t);
        this.insertCopyAtHead(block, copy);
        System.out.println("copy5");
    }

    void printList(BiList target) {
        Iterator tIter = target.iterator();
        while (tIter.hasNext()) {
            LirNode t = (LirNode)tIter.next();
            this.env.println(t.toString(), 10000);
        }
    }

    void travel(BasicBlk block, LirNode dest, BiList candidates) {
        BiList templist;
        this.env.println("trabel at --- " + block.id, 10000);
        this.env.println("candidates:", 10000);
        this.printList(candidates);
        boolean transp = false;
        Iterator insIter = block.instrList().iterator();
        while (insIter.hasNext()) {
            this.env.println("", 10000);
            LirNode instr = (LirNode)insIter.next();
            this.env.println("For " + instr.toString(), 10000);
            this.env.println("before --", 10000);
            this.printList(candidates);
            if (this.isCopy(instr)) {
                this.env.println("invoke cuttingCopy()", 10000);
                BiList templist2 = candidates.copy();
                Iterator temIter = templist2.iterator();
                while (temIter.hasNext()) {
                    LirNode current = (LirNode)temIter.next();
                    LirNode source = this.cuttingCopy(current, dest, instr);
                    if (source == null) continue;
                    if (source.id != current.id) {
                        this.env.println("candidates++ " + source.toString(), 10000);
                        candidates.add(source);
                        break;
                    }
                    BiLink q = candidates.removeEqual(instr.kid(0));
                }
            } else {
                Iterator canIter = candidates.iterator();
                while (canIter.hasNext()) {
                    LirNode current = (LirNode)canIter.next();
                    this.cutting(current, dest, instr);
                }
                templist = candidates.copy();
                Iterator temIter = templist.iterator();
                while (temIter.hasNext()) {
                    BiLink p;
                    LirNode temp = (LirNode)temIter.next();
                    if (!this.asDest(temp, instr) || (p = candidates.removeEqual(temp)) != null) continue;
                    this.env.println("error3: liveRangeCutting", 10000);
                }
            }
            this.env.println("after --", 10000);
            this.printList(candidates);
            if (!candidates.isEmpty()) continue;
            transp = true;
            break;
        }
        if (!transp) {
            if (candidates.isEmpty()) {
                this.env.println("error4: liveRangeCutting", 10000);
            }
            Iterator childIter = this.dominators.children(block);
            while (childIter.hasNext()) {
                BasicBlk child = (BasicBlk)childIter.next();
                templist = candidates.copy();
                if (!this.inSucc(block, child)) continue;
                this.travel(child, dest, templist);
            }
        }
    }

    boolean isCopy(LirNode node) {
        return node.opCode == 48 && node.kid((int)0).opCode == 6 && node.kid((int)1).opCode == 6;
    }

    boolean inSucc(BasicBlk block, BasicBlk child) {
        Iterator sucIter = block.succList().iterator();
        while (sucIter.hasNext()) {
            BasicBlk succ = (BasicBlk)sucIter.next();
            if (succ.id != child.id) continue;
            return true;
        }
        return false;
    }

    void replaceNode(LirNode node1, LirNode node2, LirNode instr) {
        switch (instr.opCode) {
            case 48: {
                for (int i = 1; i < instr.nKids(); ++i) {
                    if (instr.kid((int)i).opCode != 6 || instr.kid((int)i).id != node1.id) continue;
                    instr.setKid(i, node2);
                }
                break;
            }
            case 53: {
                for (int i = 0; i < instr.kid(1).nKids(); ++i) {
                    if (instr.kid((int)1).kid((int)i).opCode != 6 || node1.id != instr.kid((int)1).kid((int)i).id) continue;
                    instr.kid(1).setKid(i, node2);
                }
                break;
            }
            default: {
                for (int i = 0; i < instr.nKids(); ++i) {
                    if (instr.kid((int)i).opCode == 6) {
                        if (instr.kid((int)i).id != node1.id) continue;
                        instr.setKid(i, node2);
                        continue;
                    }
                    this.replaceNode(node1, node2, instr.kid(i));
                }
            }
        }
    }

    boolean asUse(LirNode node, LirNode instr) {
        switch (instr.opCode) {
            case 48: {
                for (int i = 1; i < instr.nKids(); ++i) {
                    if (instr.kid((int)i).opCode != 6 || instr.kid((int)i).id != node.id) continue;
                    return true;
                }
                break;
            }
            case 53: {
                for (int i = 0; i < instr.kid(1).nKids(); ++i) {
                    if (instr.kid((int)1).kid((int)i).opCode != 6 || node.id != instr.kid((int)1).kid((int)i).id) continue;
                    return true;
                }
                break;
            }
            default: {
                for (int i = 0; i < instr.nKids(); ++i) {
                    if (!(instr.kid((int)i).opCode == 6 ? instr.kid((int)i).id == node.id : this.asUse(node, instr.kid(i)))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    boolean asDest(LirNode src, LirNode instr) {
        switch (instr.opCode) {
            case 48: {
                if (instr.kid((int)0).opCode != 6 || src.id != instr.kid((int)0).id) break;
                return true;
            }
            case 53: {
                for (int i = 0; i < instr.kid(2).nKids(); ++i) {
                    if (instr.kid((int)2).kid((int)i).opCode != 6 || src.id != instr.kid((int)2).kid((int)i).id) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    void cutting(LirNode src, LirNode dest, LirNode instr) {
        switch (instr.opCode) {
            case 48: {
                for (int i = 1; i < instr.nKids(); ++i) {
                    if (instr.kid((int)i).opCode == 6) {
                        if (instr.kid((int)i).id != src.id) continue;
                        instr.setKid(i, dest);
                        this.cfg.touch();
                        continue;
                    }
                    this.cutting(src, dest, instr.kid(i));
                }
                break;
            }
            case 53: {
                for (int i = 0; i < instr.kid(1).nKids(); ++i) {
                    if (instr.kid((int)1).kid((int)i).opCode != 6 || src.id != instr.kid((int)1).kid((int)i).id) continue;
                    instr.kid(1).setKid(i, dest);
                    this.cfg.touch();
                }
                break;
            }
            default: {
                for (int i = 0; i < instr.nKids(); ++i) {
                    if (instr.kid((int)i).opCode == 6) {
                        if (instr.kid((int)i).id != src.id) continue;
                        instr.setKid(i, dest);
                        this.cfg.touch();
                        continue;
                    }
                    this.cutting(src, dest, instr.kid(i));
                }
            }
        }
    }

    LirNode cuttingCopy(LirNode src, LirNode dest, LirNode copy) {
        if (!this.isCopy(copy)) {
            this.env.println("error1: cuttingCopy", 10000);
        }
        LirNode destination = copy.kid(0);
        LirNode source = copy.kid(1);
        if (src.id == source.id) {
            copy.setKid(1, dest);
            this.cfg.touch();
            return destination;
        }
        return null;
    }

    void jumpRepair(BasicBlk block) {
        LirNode instr = (LirNode)block.instrList().last().elem();
        if (instr.opCode == 50 || instr.opCode == 51) {
            this.repair(instr, block);
        }
    }

    void repair(LirNode instr, BasicBlk block) {
        block3: for (int i = 0; i < instr.nKids(); ++i) {
            switch (instr.kid((int)i).opCode) {
                case 6: {
                    LirSymRef s2;
                    LirSymRef s1;
                    if (!(instr.kid(i) instanceof LirSymRef)) {
                        this.env.println("error1: repair", 10000);
                    }
                    if (!this.exmap.containsKey(s1 = (LirSymRef)instr.kid(i)) || s1.equals(s2 = (LirSymRef)this.exmap.get(s1))) continue block3;
                    if ((LirNode)this.exmap.get(s1) == null) {
                        this.env.println("error2: repair", 10000);
                    }
                    instr.setKid(i, s2);
                    this.cfg.touch();
                    continue block3;
                }
                default: {
                    this.repair(instr.kid(i), block);
                }
            }
        }
    }

    boolean isLiveAtSuccEntry(Symbol s, BasicBlk block) {
        Iterator sIter = block.succList().iterator();
        while (sIter.hasNext()) {
            BasicBlk succ = (BasicBlk)sIter.next();
            if (!this.liveness.isLiveAtEntry(s, succ)) continue;
            return true;
        }
        return false;
    }

    boolean removeUselessCopy() {
        Iterator bIter = this.cfg.basicBlkIterator();
        while (bIter.hasNext()) {
            BiList rmlist = new BiList();
            this.liveness = (LiveVariableAnalysis)this.func.require(LiveVariableSlotwise.analyzer);
            BasicBlk block = (BasicBlk)bIter.next();
            Iterator oiter = this.liveness.liveOut(block).iterator();
            while (oiter.hasNext()) {
                Symbol s = (Symbol)oiter.next();
            }
            Iterator iIter = block.instrList().iterator();
            while (iIter.hasNext()) {
                LirNode instr = (LirNode)iIter.next();
                if (this.isCopy(instr)) {
                    LirSymRef dest = (LirSymRef)instr.kid(0);
                    if (!this.liveness.isLiveAtExit(dest.symbol, block)) {
                        rmlist.addNew(instr);
                    }
                }
                BiLink q = rmlist.first();
                while (!q.atEnd()) {
                    LirNode rm = (LirNode)q.elem();
                    if (this.asUse(rm.kid(0), instr)) {
                        q.unlink();
                    }
                    q = q.next();
                }
            }
            Iterator rmIter = rmlist.iterator();
            while (rmIter.hasNext()) {
                LirNode rm = (LirNode)rmIter.next();
                BiLink q = block.instrList().first();
                while (!q.atEnd()) {
                    LirNode instr = (LirNode)q.elem();
                    if (this.isCopy(instr) && rm.kid((int)0).id == instr.kid((int)0).id && rm.kid((int)1).id == instr.kid((int)1).id) {
                        q.unlink();
                        this.cfg.touch();
                        return true;
                    }
                    q = q.next();
                }
            }
        }
        return false;
    }

    boolean removeUselessCopyBEFORE() {
        Iterator bIter = this.cfg.basicBlkIterator();
        while (bIter.hasNext()) {
            LirNode rm;
            BiList rmlist = new BiList();
            this.liveness = (LiveVariableAnalysis)this.func.require(LiveVariableSlotwise.analyzer);
            BasicBlk block = (BasicBlk)bIter.next();
            this.env.println("Trace at " + block.id, 10000);
            this.env.println("Live Out +++", 10000);
            Iterator oiter = this.liveness.liveOut(block).iterator();
            while (oiter.hasNext()) {
                Symbol s = (Symbol)oiter.next();
                this.env.println(s.name, 10000);
            }
            this.env.println("+++", 10000);
            Iterator iIter = block.instrList().iterator();
            while (iIter.hasNext()) {
                LirNode instr = (LirNode)iIter.next();
                this.env.print("rmlist - ", 10000);
                this.env.println(instr.toString(), 10000);
                this.printList(rmlist);
                this.env.println("", 10000);
                if (this.isCopy(instr)) {
                    LirSymRef dest = (LirSymRef)instr.kid(0);
                    if (!this.liveness.isLiveAtExit(dest.symbol, block)) {
                        this.env.println("add rmlist " + dest.toString(), 10000);
                        rmlist.addNew(instr);
                    }
                }
                BiLink q = rmlist.first();
                while (!q.atEnd()) {
                    LirNode rm2 = (LirNode)q.elem();
                    if (this.asUse(rm2.kid(0), instr)) {
                        this.env.println("rem rmlist " + rm2.toString(), 10000);
                        q.unlink();
                    }
                    q = q.next();
                }
            }
            Iterator rmIter = rmlist.iterator();
            while (rmIter.hasNext()) {
                rm = (LirBinOp)rmIter.next();
                BiList c = (BiList)this.cut.get(block);
                BiLink q = c.first();
                while (!q.atEnd()) {
                    LirBinOp current = (LirBinOp)q.elem();
                    if (((LirBinOp)rm).equals(current)) {
                        this.env.println("kohama", 10000);
                        q.unlink();
                    }
                    q = q.next();
                }
            }
            rmIter = rmlist.iterator();
            while (rmIter.hasNext()) {
                rm = (LirNode)rmIter.next();
                this.env.println("Trace2", 10000);
                BiLink q = block.instrList().first();
                while (!q.atEnd()) {
                    LirNode instr = (LirNode)q.elem();
                    this.env.println("=== " + instr.toString(), 10000);
                    if (this.isCopy(instr) && rm.kid((int)0).id == instr.kid((int)0).id && rm.kid((int)1).id == instr.kid((int)1).id) {
                        q.unlink();
                        this.cfg.touch();
                        return true;
                    }
                    q = q.next();
                }
            }
        }
        return false;
    }

    void walkPreorder(LirVisitor v, LirNode node) {
        node.accept(v);
        int n = node.nKids();
        for (int i = 0; i < n; ++i) {
            this.walkPreorder(v, node.kid(i));
        }
    }

    class CoupleSet {
        private BiList couplelist = new BiList();

        public BiList getCoupleSet() {
            return this.couplelist;
        }

        public void addNewCouple(Couple couple) {
            this.couplelist.addNew(couple);
        }

        public BiLink removeCouple(Couple couple) {
            BiLink l = this.couplelist.remove(couple);
            return l;
        }

        public Couple pickRemove() {
            BiLink picked = this.couplelist.first();
            picked.unlink();
            return (Couple)picked.elem();
        }

        public boolean isEmpty() {
            return this.couplelist.isEmpty();
        }

        public Iterator iterator() {
            return this.couplelist.iterator();
        }
    }

    class Couple {
        private LirNode src;
        private LirNode dest;

        public Couple(LirNode src, LirNode dest) {
            this.src = src;
            this.dest = dest;
        }

        public LirNode getSrc() {
            return this.src;
        }

        public LirNode getDest() {
            return this.dest;
        }
    }

    class PickingRegister
    implements LirVisitor {
        private BiList reglist = new BiList();

        PickingRegister() {
        }

        public BiList getRegisterlist() {
            return this.reglist;
        }

        public void visit(LirFconst node) {
        }

        public void visit(LirIconst node) {
        }

        public void visit(LirSymRef node) {
            if (node.opCode == 6 || node.opCode == 7 && node.kid((int)0).opCode == 6) {
                this.reglist.addNew(node);
            }
        }

        public void visit(LirLabelRef node) {
        }

        public void visit(LirUnaOp node) {
        }

        public void visit(LirBinOp node) {
        }

        public void visit(LirNaryOp node) {
        }
    }

    class ReplaceVisitor
    implements LirVisitor {
        public LirNode old;
        public Hashtable children;

        public ReplaceVisitor(LirNode node, Hashtable table) {
            this.old = node;
            this.children = table;
        }

        public void visit(LirFconst node) {
        }

        public void visit(LirIconst node) {
        }

        public void visit(LirSymRef node) {
        }

        public void visit(LirLabelRef node) {
        }

        public void visit(LirUnaOp node) {
            for (int i = 0; i < node.nKids(); ++i) {
                BiList numbers;
                LirNode child = node.kid(i);
                if (!this.old.equals(child)) continue;
                if (!this.children.containsKey(node)) {
                    numbers = new BiList();
                    numbers.addNew(new Integer(i));
                    this.children.put(node, numbers);
                    continue;
                }
                numbers = (BiList)this.children.get(node);
                numbers.addNew(new Integer(i));
            }
        }

        public void visit(LirBinOp node) {
            for (int i = 0; i < node.nKids(); ++i) {
                BiList numbers;
                LirNode child = node.kid(i);
                if (!this.old.equals(child)) continue;
                if (!this.children.containsKey(node)) {
                    numbers = new BiList();
                    numbers.addNew(new Integer(i));
                    this.children.put(node, numbers);
                    continue;
                }
                numbers = (BiList)this.children.get(node);
                numbers.addNew(new Integer(i));
            }
        }

        public void visit(LirNaryOp node) {
            for (int i = 0; i < node.nKids(); ++i) {
                BiList numbers;
                LirNode child = node.kid(i);
                if (!this.old.equals(child)) continue;
                if (!this.children.containsKey(node)) {
                    numbers = new BiList();
                    numbers.addNew(new Integer(i));
                    this.children.put(node, numbers);
                    continue;
                }
                numbers = (BiList)this.children.get(node);
                numbers.addNew(new Integer(i));
            }
        }
    }
}

