/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.Storage;
import coins.backend.SyntaxError;
import coins.backend.Type;
import coins.backend.lir.LirBinOp;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNaryOp;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.lir.LirUnaOp;
import coins.backend.sym.Symbol;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.simd.CleanUpLir;
import coins.simd.ContigMemAccess;
import coins.simd.LirBoneList;
import coins.simd.LirBoneList_x86;
import coins.simd.LirBopList;
import coins.simd.LirBopList_x86;
import coins.simd.LirDefUseRel;
import coins.simd.LirOrder;
import coins.simd.LirRearrange;
import coins.simd.LirUtil;
import coins.simd.RegGroups;
import coins.simd.ReplaceRegNames;
import coins.simd.SimdOptException;
import coins.simd.Util;
import java.util.HashMap;
import java.util.Vector;

public class SimdOpt {
    private static final int MAX_ENV_SIZE = 33;
    public static final int MAX_SIMD_PARALLEL = 16;
    public boolean messageFlag = false;
    private ImList liveRegList;
    private Function func;
    private LirFactory newLir;
    private LirBopList bopList;
    private LirBoneList boneList;
    private static int tmpgen = 0;
    private int tmpReg = 0;
    private RegGroups rgroups;
    private ContigMemAccess cma;
    private Vector front;
    private Vector back;
    private Vector paraRegs;
    private HashMap constantTable;
    private int simdRegIndexMax = 2;
    private static final int typeI32 = SimdOpt.decode("I32");
    private static final int[] simdRegType = new int[]{SimdOpt.decode("I64"), SimdOpt.decode("I128")};
    private final String[][] simdRegStr = new String[][]{{"MM0", "MM1", "MM2", "MM3", "MM4", "MM5", "MM6", "MM7", "MM8", "MM9", "MM10", "MM11", "MM12", "MM13", "MM14", "MM15", "MM16", "MM17", "MM18", "MM19", "MM20", "MM21", "MM22", "MM23", "MM24", "MM25", "MM26", "MM27", "MM28", "MM29", "MM30", "MM31"}, {"XMM0", "XMM1", "XMM2", "XMM3", "XMM4", "XMM5", "XMM6", "XMM7", "XMM8", "XMM9", "XMM10", "XMM11", "XMM12", "XMM13", "XMM14", "XMM15", "XMM16", "XMM17", "XMM18", "XMM19", "XMM20", "XMM21", "XMM22", "XMM23", "XMM24", "XMM25", "XMM26", "XMM27", "XMM28", "XMM29", "XMM30", "XMM31"}};
    private final Symbol[][] simdReg = new Symbol[][]{new Symbol[32], new Symbol[32]};
    private Vector[][] simdRegUsed = new Vector[][]{new Vector[this.simdReg[0].length], new Vector[this.simdReg[1].length]};
    private static final int storageREG = SimdOpt.storageDecode("REG");

    private boolean traceOK(String tag, int thval) {
        return this.messageFlag;
    }

    public SimdOpt(Function f) {
        this.func = f;
        this.newLir = f.newLir;
        this.bopList = new LirBopList_x86(f);
        this.boneList = new LirBoneList_x86(f);
        this.initSimdReg();
        this.paraRegs = new Vector();
        this.cma = new ContigMemAccess(f, this.paraRegs);
        this.constantTable = new HashMap();
        ++tmpgen;
    }

    public Vector invoke(BiList live, Vector in, ReplaceRegNames rrn) throws SimdOptException {
        int i;
        this.liveRegList = LirUtil.btoim(live);
        Vector is = new Vector();
        this.front = new Vector();
        this.back = new Vector();
        if (this.traceOK("SIMD", 1)) {
            System.out.println("SimdOpt");
        }
        if (in.size() == 0) {
            return in;
        }
        if (this.traceOK("SIMD", 1)) {
            for (i = 0; i < in.size(); ++i) {
                System.out.println(((LirNode)in.elementAt(i)).toString());
            }
        }
        is = this.preprocess(in);
        if (this.traceOK("SIMD", 1)) {
            System.out.println("decompose");
        }
        is = this.decompose(is);
        if (this.traceOK("SIMD", 1)) {
            for (i = 0; i < is.size(); ++i) {
                System.out.println(((LirNode)is.elementAt(i)).toString());
            }
        }
        if (this.traceOK("SIMD", 1)) {
            System.out.println("collect Mem Access");
        }
        is = this.cma.collectMemAccess(is);
        if (this.traceOK("SIMD", 1)) {
            for (i = 0; i < is.size(); ++i) {
                System.out.println(((LirNode)is.elementAt(i)).toString());
            }
        }
        if (this.traceOK("SIMD", 1)) {
            System.out.println("combine");
        }
        this.rgroups = new RegGroups(is);
        is = this.combineSimd(is);
        if (this.traceOK("SIMD", 1)) {
            for (i = 0; i < is.size(); ++i) {
                System.out.println(((LirNode)is.elementAt(i)).toString());
            }
        }
        if (this.traceOK("SIMD", 1)) {
            System.out.println("rearrange");
        }
        LirRearrange rearrange = new LirRearrange();
        is = rearrange.invoke(is, rrn);
        if (this.traceOK("SIMD", 1)) {
            for (i = 0; i < is.size(); ++i) {
                System.out.println(((LirNode)is.elementAt(i)).toString());
            }
        }
        if (this.traceOK("SIMD", 1)) {
            System.out.println("replaceToOldReg");
        }
        rrn.toOldName(is);
        if (this.traceOK("SIMD", 1)) {
            for (i = 0; i < is.size(); ++i) {
                System.out.println(((LirNode)is.elementAt(i)).toString());
            }
        }
        if (this.traceOK("SIMD", 1)) {
            System.out.println("restrict 1");
        }
        is = this.restrictInst(is);
        if (this.traceOK("SIMD", 1)) {
            for (i = 0; i < is.size(); ++i) {
                System.out.println(((LirNode)is.elementAt(i)).toString());
            }
        }
        if (this.traceOK("SIMD", 1)) {
            System.out.println("restrict 2");
        }
        is = this.restrictInst(is);
        if (this.traceOK("SIMD", 1)) {
            for (i = 0; i < is.size(); ++i) {
                System.out.println(((LirNode)is.elementAt(i)).toString());
            }
        }
        if (this.traceOK("SIMD", 1)) {
            System.out.println("restrict 3");
        }
        is = this.restrictInst(is);
        if (this.traceOK("SIMD", 1)) {
            for (i = 0; i < is.size(); ++i) {
                System.out.println(((LirNode)is.elementAt(i)).toString());
            }
        }
        if (this.traceOK("SIMD", 1)) {
            System.out.println("allocate");
        }
        is = this.allocateSimdReg(is);
        if (this.traceOK("SIMD", 1)) {
            for (i = 0; i < is.size(); ++i) {
                System.out.println(((LirNode)is.elementAt(i)).toString());
            }
        }
        if (this.traceOK("SIMD", 1)) {
            System.out.println("cleanup");
        }
        CleanUpLir clup = new CleanUpLir(is);
        clup.invoke();
        if (this.traceOK("SIMD", 1)) {
            for (i = 0; i < is.size(); ++i) {
                System.out.println(((LirNode)is.elementAt(i)).toString());
            }
        }
        is = this.postprocess(is);
        return is;
    }

    private Vector preprocess(Vector in) {
        Vector<LirNode> out = new Vector<LirNode>();
        block4: for (int i = 0; i < in.size(); ++i) {
            LirNode inst = (LirNode)in.elementAt(i);
            switch (inst.opCode) {
                case 54: {
                    this.front.addElement(inst);
                    continue block4;
                }
                case 49: 
                case 55: {
                    this.back.addElement(inst);
                    continue block4;
                }
                default: {
                    out.addElement(inst);
                }
            }
        }
        return out;
    }

    private Vector postprocess(Vector in) {
        int i;
        Vector out = new Vector();
        for (i = 0; i < this.front.size(); ++i) {
            out.addElement(this.front.elementAt(i));
        }
        for (i = 0; i < in.size(); ++i) {
            out.addElement(in.elementAt(i));
        }
        for (i = 0; i < this.back.size(); ++i) {
            out.addElement(this.back.elementAt(i));
        }
        return out;
    }

    public Vector decompose(Vector in) throws SimdOptException {
        int i;
        Vector<LirNode> var = new Vector<LirNode>();
        Vector<LirNode> val = new Vector<LirNode>();
        Vector<LirNode> org = new Vector<LirNode>();
        Vector<LirNode> out = new Vector<LirNode>();
        for (i = 0; i < in.size(); ++i) {
            LirNode inst = (LirNode)in.elementAt(i);
            if (inst.opCode != 48) {
                out.addElement(inst);
                continue;
            }
            LirNode v = inst.kid(0);
            if (v.opCode != 6 && (v.opCode != 47 || v.opCode == 47 && (inst.kid((int)1).opCode == 47 || inst.kid((int)1).opCode == 6))) {
                var.addElement(inst.kid(0));
                val.addElement(inst.kid(1));
                org.addElement(inst.kid(0));
                continue;
            }
            if (inst.kid((int)1).opCode == 2 || inst.kid((int)1).opCode == 3) {
                var.addElement(inst.kid(0));
                val.addElement(inst.kid(1));
                org.addElement(inst);
                continue;
            }
            LirNode r = this.decompose1(inst.kid(1), var, val, org);
            if (r.opCode == 5) {
                var.addElement(this.newReg(r.type));
                val.addElement(r);
                org.addElement(r);
                continue;
            }
            if (r.opCode == 6) {
                if (var.size() > 0) {
                    if (r.equals(var.lastElement()) && inst.kid((int)0).opCode != 47) {
                        var.setElementAt(inst.kid(0), var.size() - 1);
                        continue;
                    }
                    var.addElement(inst.kid(0));
                    val.addElement(r);
                    org.addElement(inst.kid(1));
                    continue;
                }
                out.addElement(inst);
                continue;
            }
            Util.assert2(r.opCode == 2, "r.car()==intconstCell");
            var.addElement(this.newReg(r.type));
            val.addElement(r);
            org.addElement(r);
        }
        for (i = 0; i < var.size(); ++i) {
            out.addElement(this.newLir.operator(48, ((LirNode)var.elementAt((int)i)).type, (LirNode)var.elementAt(i), (LirNode)val.elementAt(i), ImList.Empty));
        }
        return out;
    }

    private LirNode decompose1(LirNode e, Vector var, Vector val, Vector org) throws SimdOptException {
        int i;
        for (i = 0; i < var.size(); ++i) {
            if (!e.equals((LirNode)org.elementAt(i))) continue;
            return (LirNode)var.elementAt(i);
        }
        if (e.opCode == 2 || e.opCode == 3) {
            LirNode v = (LirNode)this.constantTable.get(e);
            if (v == null) {
                v = this.newReg(e.type);
                this.constantTable.put(e, v);
            }
            var.addElement(v);
            val.addElement(e);
            org.addElement(e);
            return (LirNode)var.lastElement();
        }
        if (e.opCode == 5 || e.opCode == 6 || e.opCode == 4) {
            return e;
        }
        if (e.opCode == 47) {
            var.addElement(this.newReg(e.type));
            val.addElement(e);
            org.addElement(e);
            return (LirNode)var.lastElement();
        }
        LirNode[] env = new LirNode[33];
        for (i = 0; i < 33; ++i) {
            env[i] = null;
        }
        LirNode b = this.bopList.find(e, env);
        Util.assert2(b != null, "b!=null  " + e);
        LirNode[] operand = new LirNode[33];
        for (i = 0; i < 33; ++i) {
            if (env[i] == null) continue;
            operand[i] = this.decompose1(env[i], var, val, org);
        }
        var.addElement(this.newReg(b.type));
        val.addElement(this.bopList.replace(b, operand));
        org.addElement(e);
        return (LirNode)var.lastElement();
    }

    public Vector combineSimd(Vector in) throws SimdOptException {
        int i;
        int n = in.size();
        Object[] ia = new LirNode[n];
        in.copyInto(ia);
        LirDefUseRel duRel = new LirDefUseRel();
        duRel.mkDefUseRel(in);
        LirOrder order = new LirOrder();
        order.put(duRel.getRelation());
        order.saturate();
        for (i = 0; i < n; ++i) {
            int j;
            if (ia[i] == null || ((LirNode)ia[i]).opCode == 56 || ((LirNode)ia[i]).opCode != 48) continue;
            LirNode[] env = new LirNode[33];
            for (j = 0; j < 33; ++j) {
                env[j] = null;
            }
            ImList b = this.boneList.find((LirNode)ia[i], env);
            if (b == null) continue;
            int[] a = new int[16];
            int k = this.pickupWithBone((LirNode[])ia, i, b, env, a, order);
            if (k == 0) {
                LirNode[] tmpArray = new LirNode[]{ia[i]};
                ia[i] = this.newLir.operator(56, 0, tmpArray, ImList.Empty);
                continue;
            }
            if (k < 1) continue;
            LirNode[] instArray = new LirNode[k + 1];
            for (j = 0; j < k; ++j) {
                instArray[k - 1 - j] = ia[a[j]];
            }
            instArray[k] = ia[i];
            int lpos = i;
            if (k > 0) {
                lpos = a[k - 1];
            }
            if (this.hasReference(instArray)) continue;
            for (int m = 0; m < k; ++m) {
                ia[a[m]] = null;
            }
            ia[i] = null;
            LirNode inst = this.newLir.operator(56, 0, instArray, ImList.Empty);
            if (!this.isDefined(inst, (LirNode[])ia, i + 1, lpos)) {
                ia[i] = inst;
                continue;
            }
            if (!this.isUsed(inst, (LirNode[])ia, i + 1, lpos)) {
                ia[lpos] = inst;
                continue;
            }
            ia[i] = inst;
        }
        Vector<Object> out = new Vector<Object>();
        for (i = 0; i < n; ++i) {
            if (ia[i] == null) continue;
            out.addElement(ia[i]);
        }
        return out;
    }

    private int pickupWithBone(LirNode[] ia, int i, ImList b, LirNode[] env, int[] a, LirOrder order) throws SimdOptException {
        Vector defseq;
        int[] a1;
        int k1;
        int k = 0;
        for (int j = i + 1; j < ia.length; ++j) {
            if (ia[j] == null) continue;
            if (k >= a.length) break;
            if (!this.boneList.chkBoneCnstr(b, ia[j], env, this.rgroups) || this.existUsePath(order, ia, a, k, ia[j])) continue;
            a[k++] = j;
        }
        if ((k1 = this.chkParaRegs(ia, i, b, env, a, k, a1 = new int[a.length], defseq = new Vector())) > 0) {
            this.paraRegs.add(defseq);
            for (int n = 0; n < a.length; ++n) {
                a[n] = a1[n];
            }
            k = k1;
        }
        ImList cnts = this.boneList.boneParacnts(b);
        while (!cnts.atEnd()) {
            int m = (Integer)cnts.elem();
            if (k >= m - 1) {
                return m - 1;
            }
            cnts = cnts.next();
        }
        return -1;
    }

    private boolean existUsePath(LirOrder order, LirNode[] ia, int[] a, int k, LirNode e) {
        for (int i = 0; i < k; ++i) {
            if (order.compare(ia[a[i]], e) != -1) continue;
            return true;
        }
        return false;
    }

    private boolean hasReference(LirNode[] lirs) throws SimdOptException {
        Vector left = new Vector();
        Vector right = new Vector();
        for (int i = 0; i < lirs.length; ++i) {
            if (lirs[i].opCode != 48) continue;
            LirUtil.pickupReferent(lirs[i].kid(0), left);
            LirUtil.pickupReferent(lirs[i].kid(1), right);
        }
        boolean res = false;
        for (int i = 0; i < left.size(); ++i) {
            if (!right.contains(left.elementAt(i))) continue;
            return true;
        }
        return res;
    }

    private int chkParaRegs(LirNode[] ia, int i, ImList b, LirNode[] env, int[] a, int k, int[] newa, Vector outseq) throws SimdOptException {
        int n;
        Vector[] regseqs = new Vector[33];
        for (int j = 1; j < env.length; ++j) {
            if (env[j] == null || env[j].opCode != 6) continue;
            regseqs[j] = this.findRegSeq(env[j]);
        }
        int newk = 0;
        LirNode[][] localenv = new LirNode[k + 1][];
        for (int n2 = 0; n2 < k + 1; ++n2) {
            LirNode[] lenv = new LirNode[33];
            localenv[n2] = lenv;
        }
        LirNode bb = this.boneList.boneBody(b);
        boolean matched = this.boneList.match(bb, ia[i], localenv[0]);
        for (int n3 = 0; n3 < k; ++n3) {
            matched = this.boneList.match(bb, ia[a[n3]], localenv[n3 + 1]);
            if (matched) continue;
            throw new SimdOptException("CombineSimd:Unmatched inst.!\ninst:  " + ia[i] + "\nunmatched:  " + ia[a[n3]]);
        }
        int[] idx = new int[k];
        for (n = 0; n < k; ++n) {
            idx[n] = -1;
        }
        for (int j = 1; j < 33; ++j) {
            int n4;
            if (regseqs[j] == null) continue;
            for (n4 = 0; n4 < k && regseqs[j].size() > n4 + 1; ++n4) {
                int n1;
                for (n1 = 0; n1 < k && regseqs[j].elementAt(n4 + 1) != localenv[n1 + 1][j]; ++n1) {
                }
                if (n1 >= k) continue;
                if (idx[n4] == -1) {
                    idx[n4] = n1;
                }
                if (idx[n4] == n1) continue;
                throw new SimdOptException("CombineSimd:Unmatched regsister!");
            }
            newk = n4;
        }
        for (n = 0; n < newk; ++n) {
            if (idx[n] == -1) {
                return 0;
            }
            newa[n] = a[idx[n]];
        }
        outseq.addElement(localenv[0][0]);
        for (n = 0; n < newk; ++n) {
            outseq.addElement(localenv[idx[n] + 1][0]);
        }
        return newk;
    }

    private Vector findRegSeq(LirNode e) {
        if (e.opCode != 6) {
            return null;
        }
        for (int i = 0; i < this.paraRegs.size(); ++i) {
            Vector regs = (Vector)this.paraRegs.elementAt(i);
            if (regs == null || (LirNode)regs.elementAt(0) != e) continue;
            return regs;
        }
        return null;
    }

    private boolean isUsed(LirNode inst, LirNode[] ia, int fpos, int lpos) {
        Vector vars = new Vector();
        this.addDefVar(inst, vars);
        if (vars.size() == 0) {
            return false;
        }
        if (lpos < fpos || ia.length < lpos) {
            return false;
        }
        for (int i = 0; i < vars.size(); ++i) {
            for (int j = fpos; j < lpos; ++j) {
                if (ia[j] == null || !this.used((Symbol)vars.elementAt(i), ia[j])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDefined(LirNode inst, LirNode[] ia, int fpos, int lpos) {
        Vector vars = new Vector();
        this.addUsedVar(inst, vars);
        if (vars.size() == 0) {
            return false;
        }
        if (lpos < fpos || ia.length < lpos) {
            return false;
        }
        for (int i = 0; i < vars.size(); ++i) {
            for (int j = fpos; j < lpos; ++j) {
                if (ia[j] == null || !this.defined((Symbol)vars.elementAt(i), ia[j])) continue;
                return true;
            }
        }
        return false;
    }

    public Vector restrictInst(Vector in) throws SimdOptException {
        Vector<LirNode> out = new Vector<LirNode>();
        Vector<LirNode> oldReg = new Vector<LirNode>();
        Vector<LirNode> newReg = new Vector<LirNode>();
        Vector live = this.liveReg(in);
        for (int i = 0; i < in.size(); ++i) {
            LirNode inst = (LirNode)in.elementAt(i);
            if (inst.opCode != 56) {
                LirNode newinst = this.changeReg(inst, oldReg, newReg);
                if (newinst == null) {
                    newinst = inst;
                }
                out.addElement(newinst);
                continue;
            }
            ImList b = this.boneList.find(inst.kid(0));
            if (b == null) {
                LirNode newinst = this.changeReg(inst, oldReg, newReg);
                if (newinst == null) {
                    newinst = inst;
                }
                out.addElement(newinst);
                continue;
            }
            LirNode[][] operand = new LirNode[16][];
            int k = 0;
            for (int j = 0; j < inst.nKids(); ++j) {
                operand[k] = new LirNode[33];
                boolean f = this.boneList.match(this.boneList.boneBody(b), inst.kid(j), operand[k++]);
                Util.assert2(f, "f");
            }
            Vector<LirNode> prepare = new Vector<LirNode>();
            for (int j = 0; j < k; ++j) {
                for (int n = 0; n < 33; ++n) {
                    int r;
                    if (operand[j][n] == null || (r = oldReg.indexOf(operand[j][n])) < 0) continue;
                    operand[j][n] = (LirNode)newReg.elementAt(r);
                }
                int d = Integer.parseInt(this.boneList.boneHolenum(b));
                if (d == 0 || operand[j][d].equals(operand[j][0])) continue;
                Util.assert2(!oldReg.contains(operand[j][0]), "!oldReg.contains(operand[j][0])");
                if (operand[j][d].opCode == 6) {
                    Vector lv = (Vector)live.elementAt(i + 1);
                    if (operand[j][2] != null && lv.contains(((LirSymRef)operand[j][d]).symbol)) {
                        if (!this.boneList.boneChng(b).equals("nil") && d <= 2) {
                            LirNode t = operand[j][1];
                            operand[j][1] = operand[j][2];
                            operand[j][2] = t;
                        }
                        if (operand[j][d].opCode == 6 && !lv.contains(((LirSymRef)operand[j][d]).symbol)) {
                            oldReg.addElement(operand[j][0]);
                            newReg.addElement(operand[j][d]);
                            operand[j][0] = operand[j][d];
                            continue;
                        }
                        prepare.add(0, this.genSetLir(operand[j][0], operand[j][d]));
                        operand[j][d] = operand[j][0];
                        continue;
                    }
                    oldReg.addElement(operand[j][0]);
                    newReg.addElement(operand[j][d]);
                    operand[j][0] = operand[j][d];
                    continue;
                }
                System.out.println("operand[" + j + "][" + d + "]=" + operand[j][d]);
                Util.assert2(operand[j][d].opCode == 2, "operand[j][d].car()==intconstCell");
                prepare.add(0, this.genLoadConst(operand[j][0], operand[j][d]));
                operand[j][d] = operand[j][0];
            }
            if (prepare.size() > 0) {
                if (this.isRegTrans(prepare)) {
                    for (int px = 0; px < prepare.size(); ++px) {
                        out.addElement((LirNode)prepare.elementAt(px));
                    }
                } else {
                    Object[] prepareArray = new LirNode[prepare.size()];
                    prepare.copyInto(prepareArray);
                    LirNode newinst = this.newLir.operator(56, 0, (LirNode[])prepareArray, ImList.Empty);
                    out.addElement(newinst);
                }
            }
            if (this.boneList.boneReplnum(b).equals("nil")) {
                LirNode[] instSrc = new LirNode[k];
                for (int j = 0; j < k; ++j) {
                    instSrc[k - 1 - j] = this.boneList.replace(this.boneList.boneBody(b), operand[j]);
                }
                LirNode newinst = this.newLir.operator(56, 0, instSrc, ImList.Empty);
                out.addElement(newinst);
                continue;
            }
            int n = Integer.parseInt(this.boneList.boneReplnum(b));
            ImList r = this.boneList.rewriteList[n];
            while (!r.atEnd()) {
                LirNode[] instSrc = new LirNode[k];
                for (int j = 0; j < k; ++j) {
                    instSrc[k - 1 - j] = this.boneList.replace((LirNode)r.elem(), operand[j]);
                }
                LirNode newinst = this.newLir.operator(56, 0, instSrc, ImList.Empty);
                out.addElement(newinst);
                r = r.next();
            }
        }
        return out;
    }

    private boolean isRegTrans(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            LirNode inst = (LirNode)v.elementAt(i);
            if (this.isRegReg(inst)) continue;
            return false;
        }
        return true;
    }

    private boolean isRegReg(LirNode inst) {
        return inst.opCode == 48 && inst.kid((int)0).opCode == 6 && inst.kid((int)1).opCode == 6;
    }

    private LirNode changeReg(LirNode e, Vector onames, Vector nnames) {
        switch (e.opCode) {
            case 6: {
                int r = onames.indexOf(e);
                if (r < 0) {
                    return null;
                }
                return (LirNode)nnames.elementAt(r);
            }
            case 2: {
                return null;
            }
        }
        LirNode[] newkids = new LirNode[e.nKids()];
        boolean tf = false;
        for (int i = 0; i < e.nKids(); ++i) {
            newkids[i] = this.changeReg(e.kid(i), onames, nnames);
            if (newkids[i] != null) {
                tf = true;
                continue;
            }
            newkids[i] = e.kid(i);
        }
        if (!tf) {
            return null;
        }
        return LirUtil.operator(this.newLir, e.opCode, e.type, newkids, e.opt);
    }

    public Vector allocateSimdReg(Vector in) throws SimdOptException {
        Vector<LirNode> out = new Vector<LirNode>();
        Vector live = this.liveReg(in);
        for (int i = 0; i < in.size(); ++i) {
            int n;
            Vector lv;
            LirNode inst0;
            LirNode inst = (LirNode)in.elementAt(i);
            if (inst.opCode != 56) {
                out.addElement(inst);
                continue;
            }
            int p = inst.nKids();
            int idx = this.simdRegIndex(p, inst.kid((int)0).type);
            ImList b = this.boneList.find(inst);
            if (b != null) {
                inst0 = inst;
                p = 1;
            } else {
                inst0 = inst.kid(0);
                b = this.boneList.find(inst0);
            }
            if (b == null) {
                out.addElement(inst);
                continue;
            }
            LirNode[] regAssign = new LirNode[33];
            ImList simdgroups = this.boneList.boneSubgroups(b);
            if (p < 2 && simdgroups != ImList.Empty) {
                LirSymRef sc;
                LirNode tc;
                LirNode[] operand1 = new LirNode[33];
                boolean f = this.boneList.match(this.boneList.boneBody(b), inst0, operand1);
                Util.assert2(f, "f");
                while (!simdgroups.atEnd()) {
                    int r;
                    ImList holenums = (ImList)simdgroups.elem();
                    Util.assert2(!holenums.atEnd(), "Illegal Bone info:Empty simdgroup!");
                    Vector hnv = LirUtil.imlistToVector(holenums);
                    int hn = Integer.parseInt((String)hnv.elementAt(0));
                    for (r = 0; !(r >= this.simdReg[idx].length || this.simdRegUsed[idx][r] != null && this.simdRegUsed[idx][r].contains(((LirSymRef)operand1[hn]).symbol)); ++r) {
                    }
                    if (r == this.simdReg[idx].length) {
                        r = this.getSimdReg(idx);
                        Vector<Symbol> v = new Vector<Symbol>();
                        for (int j = 0; j < hnv.size(); ++j) {
                            Util.assert2(operand1[Integer.parseInt((String)hnv.elementAt(j))] instanceof LirSymRef, "operand : not reg.");
                            LirSymRef symref = (LirSymRef)operand1[Integer.parseInt((String)hnv.elementAt(j))];
                            v.addElement(symref.symbol);
                        }
                        this.simdRegUsed[idx][r] = v;
                    }
                    Util.sorry(this.simdRegUsed[idx][r].size() != hnv.size(), "size:simdRegUsed[r]!=hnv");
                    for (int j = 0; j < hnv.size(); ++j) {
                        Util.sorry(this.simdRegUsed[idx][r].elementAt(j) != ((LirSymRef)operand1[Integer.parseInt((String)((String)hnv.elementAt((int)j)))]).symbol, "simdRegUsed[r]!=hnv");
                    }
                    this.mkSubregs(regAssign, this.simdReg[idx][r], hnv, simdRegType[idx], operand1[hn].type);
                    simdgroups = simdgroups.next();
                }
                block5: for (int r = 0; r < this.simdReg[idx].length; ++r) {
                    if (this.simdRegUsed[idx][r] == null) continue;
                    for (int u = 0; u < this.simdRegUsed[idx][r].size(); ++u) {
                        Vector lv2 = (Vector)live.elementAt(i + 1);
                        if (lv2.contains((Symbol)this.simdRegUsed[idx][r].elementAt(u))) continue block5;
                    }
                    this.simdRegUsed[idx][r] = null;
                }
                LirNode[] instSrc = new LirNode[1];
                this.mergeMatchedValue(regAssign, operand1);
                instSrc[0] = this.boneList.replace(this.boneList.boneBody(b), regAssign);
                LirNode newinst = instSrc[0].opCode == 56 ? instSrc[0] : this.newLir.operator(56, 0, instSrc, ImList.Empty);
                Vector sv = new Vector();
                Vector tv = new Vector();
                boolean torf = this.boneList.matchReg((LirNode)in.elementAt(i), newinst, sv, tv);
                if (torf) {
                    Vector usedregs = this.usedReg((LirNode)in.elementAt(i));
                    for (int cnt = 0; cnt < tv.size(); ++cnt) {
                        tc = (LirNode)tv.elementAt(cnt);
                        sc = (LirSymRef)sv.elementAt(cnt);
                        if (tv.elementAt(cnt) == null || tc.opCode != 7 || !(lv = (Vector)live.elementAt(i)).contains(sc.symbol) || !usedregs.contains(sc.symbol)) continue;
                        out.addElement(this.newLir.operator(48, tc.type, tc, sc, ImList.Empty));
                    }
                }
                Vector adjinsts = this.adjustAlignment(newinst);
                for (int adjcnt = 0; adjcnt < adjinsts.size(); ++adjcnt) {
                    out.addElement((LirNode)adjinsts.elementAt(adjcnt));
                }
                if (!torf) continue;
                for (int cnt = 0; cnt < tv.size(); ++cnt) {
                    tc = (LirNode)tv.elementAt(cnt);
                    sc = (LirSymRef)sv.elementAt(cnt);
                    if (tv.elementAt(cnt) == null || tc.opCode != 7 || !(lv = (Vector)live.elementAt(i + 1)).contains(sc.symbol)) continue;
                    out.addElement(this.newLir.operator(48, sc.type, sc, tc, ImList.Empty));
                }
                continue;
            }
            LirNode[][] operand = new LirNode[p][];
            int k = 0;
            for (int j = 0; j < inst.nKids(); ++j) {
                operand[k] = new LirNode[33];
                boolean f = this.boneList.match(this.boneList.boneBody(b), inst.kid(j), operand[k++]);
                Util.assert2(f, "f");
            }
            LirNode[][] reg = new LirNode[p][];
            for (int j = 0; j < p; ++j) {
                reg[j] = new LirNode[33];
            }
            for (int n2 = 0; n2 < 33; ++n2) {
                int j;
                int j2;
                if (operand[0][n2] == null) continue;
                if (this.boneList.boneNosubsthnum(b) != ImList.Empty && this.isMem(n2, this.boneList.boneNosubsthnum(b))) {
                    for (int j3 = 0; j3 < p; ++j3) {
                        reg[j3][n2] = operand[j3][n2];
                    }
                    continue;
                }
                boolean mflag = true;
                for (j2 = 0; j2 < p; ++j2) {
                    if (operand[j2][n2].opCode == 47) continue;
                    mflag = false;
                    break;
                }
                if (mflag) {
                    for (j2 = 0; j2 < p; ++j2) {
                        reg[j2][n2] = operand[j2][n2];
                    }
                    continue;
                }
                mflag = true;
                for (j2 = 0; j2 < p; ++j2) {
                    if (operand[j2][n2].opCode == 2) continue;
                    mflag = false;
                    break;
                }
                if (mflag) {
                    for (j2 = 0; j2 < p; ++j2) {
                        reg[j2][n2] = operand[j2][n2];
                    }
                    continue;
                }
                for (j2 = 0; j2 < k; ++j2) {
                    Util.assert2(operand[j2][n2].opCode == 6, "operand[" + j2 + "][" + n2 + "].car()==regCell");
                }
                Vector<Symbol> v = new Vector<Symbol>();
                for (j = 0; j < k; ++j) {
                    v.addElement(((LirSymRef)operand[j][n2]).symbol);
                }
                int r = this.findSimdReg(this.simdRegUsed[idx], v, this.simdReg[idx].length);
                if (r == this.simdReg[idx].length) {
                    r = this.getSimdReg(idx);
                    this.simdRegUsed[idx][r] = v;
                }
                for (j = 1; j < k; ++j) {
                    Util.sorry(!this.simdRegUsed[idx][r].contains(((LirSymRef)operand[j][n2]).symbol), "Bad combination.");
                }
                LirNode rr = this.newLir.symRef(6, simdRegType[idx], this.simdReg[idx][r], ImList.Empty);
                for (int j4 = 0; j4 < p; ++j4) {
                    LirNode iconst = this.newLir.iconst(typeI32, j4, ImList.Empty);
                    reg[j4][n2] = this.newLir.operator(7, operand[0][n2].type, rr, iconst, ImList.Empty);
                }
            }
            block22: for (int r = 0; r < this.simdReg[idx].length; ++r) {
                if (this.simdRegUsed[idx][r] == null) continue;
                for (int u = 0; u < this.simdRegUsed[idx][r].size(); ++u) {
                    Vector lv3 = (Vector)live.elementAt(i + 1);
                    if (lv3.contains((Symbol)this.simdRegUsed[idx][r].elementAt(u))) continue block22;
                }
                this.simdRegUsed[idx][r] = null;
            }
            if (this.boneList.boneReplnum(b).equals("nil")) {
                LirNode[] instSrc = new LirNode[p];
                for (int j = p - 1; j >= 0; --j) {
                    instSrc[j] = this.boneList.replace(this.boneList.boneBody(b), reg[j]);
                }
                LirNode newinst = this.newLir.operator(56, 0, instSrc, ImList.Empty);
                Vector sv = new Vector();
                Vector tv = new Vector();
                boolean torf = this.boneList.matchReg((LirNode)in.elementAt(i), newinst, sv, tv);
                if (torf) {
                    for (int cnt = 0; cnt < tv.size(); ++cnt) {
                        LirNode target = (LirNode)tv.elementAt(cnt);
                        LirNode source = (LirNode)sv.elementAt(cnt);
                        if (target == null || target.opCode != 7 || !(lv = (Vector)live.elementAt(i)).contains(((LirSymRef)source).symbol)) continue;
                        out.addElement(this.newLir.operator(48, target.type, target, source, ImList.Empty));
                    }
                }
                Vector adjinsts = this.adjustAlignment(newinst);
                for (int adjcnt = 0; adjcnt < adjinsts.size(); ++adjcnt) {
                    out.addElement((LirNode)adjinsts.elementAt(adjcnt));
                }
                if (!torf) continue;
                for (int cnt = 0; cnt < tv.size(); ++cnt) {
                    Vector lv4;
                    LirNode target = (LirNode)tv.elementAt(cnt);
                    LirNode source = (LirNode)sv.elementAt(cnt);
                    if (target == null || target.opCode != 7 || !(lv4 = (Vector)live.elementAt(i + 1)).contains(((LirSymRef)source).symbol)) continue;
                    out.addElement(this.newLir.operator(48, source.type, source, target, ImList.Empty));
                }
                continue;
            }
            LirNode[] reg1 = new LirNode[33];
            for (n = 0; n < 10; ++n) {
                if (reg[0][n] == null) continue;
                reg1[n] = reg[0][n];
            }
            n = Integer.parseInt(this.boneList.boneReplnum(b));
            out.addElement(this.boneList.replace((LirNode)this.boneList.rewriteList[n].elem(), reg1));
        }
        return out;
    }

    private void mergeMatchedValue(LirNode[] assign, LirNode[] origs) {
        for (int i = 0; i < assign.length; ++i) {
            if (assign[i] != null) continue;
            assign[i] = origs[i];
        }
    }

    private void mkSubregs(LirNode[] assign, Symbol regname, Vector hnv, int regtyp, int subregtyp) {
        LirNode rr = this.newLir.symRef(6, regtyp, regname, ImList.Empty);
        for (int j = 0; j < hnv.size(); ++j) {
            int k = Integer.parseInt((String)hnv.elementAt(j));
            LirNode iconst = this.newLir.iconst(typeI32, j, ImList.Empty);
            assign[k] = this.newLir.operator(7, subregtyp, rr, iconst, ImList.Empty);
        }
    }

    private Vector usedReg(LirNode x) {
        Vector v = new Vector();
        if (x.opCode == 56) {
            for (int i = 0; i < x.nKids(); ++i) {
                if (x.kid((int)i).opCode != 48) continue;
                this.addUsedReg(x.kid(i).kid(1), v);
            }
        } else if (x.opCode == 48) {
            this.addUsedReg(x.kid(1), v);
        }
        return v;
    }

    private Vector defReg(LirNode x) {
        Vector<Symbol> v = new Vector<Symbol>();
        if (x.opCode == 56) {
            for (int i = 0; i < x.nKids(); ++i) {
                if (x.kid((int)i).opCode != 48 || x.kid((int)i).kid((int)0).opCode != 6) continue;
                v.addElement(((LirSymRef)x.kid((int)i).kid((int)0)).symbol);
            }
        } else if (x.opCode == 48 && x.kid((int)0).opCode == 6) {
            v.addElement(((LirSymRef)x.kid((int)0)).symbol);
        }
        return v;
    }

    private boolean isMem(int x, ImList ys) {
        while (!ys.atEnd()) {
            if (x == Integer.parseInt((String)ys.elem())) {
                return true;
            }
            ys = ys.next();
        }
        return false;
    }

    private Vector adjustAlignment(LirNode inst) {
        Vector<LirNode> out = new Vector<LirNode>();
        LirNode[] env = new LirNode[33];
        for (int i = 0; i < 33; ++i) {
            env[i] = null;
        }
        ImList b = this.boneList.find(inst, env);
        if (b == null || this.boneList.boneReplnum(b).equals("nil")) {
            out.addElement(inst);
            return out;
        }
        ImList instlist = this.boneList.rewriteList[Integer.parseInt(this.boneList.boneReplnum(b))];
        while (!instlist.atEnd()) {
            LirNode c = this.genAndReplace((LirNode)instlist.elem(), env);
            if (c.opCode == 56 || c.opCode == 48) {
                out.addElement(c);
            }
            instlist = instlist.next();
        }
        return out;
    }

    private LirNode genAndReplace(LirNode e, LirNode[] env) {
        if (e.opCode == 1) {
            int i = (int)((LirIconst)e.kid((int)0)).value;
            LirNode r = env[i];
            if (r != null) {
                return r;
            }
            if (e.type == typeI32) {
                LirNode nreg;
                env[i] = nreg = this.newReg(typeI32);
                return nreg;
            }
        }
        if (e instanceof LirIconst) {
            return e;
        }
        if (e instanceof LirFconst) {
            return e;
        }
        if (e instanceof LirLabelRef) {
            return e;
        }
        if (e instanceof LirSymRef) {
            return e;
        }
        if (e instanceof LirUnaOp) {
            LirNode operand0 = this.genAndReplace(e.kid(0), env);
            return this.newLir.operator(e.opCode, e.type, operand0, ImList.Empty);
        }
        if (e instanceof LirBinOp) {
            LirNode operand0 = this.genAndReplace(e.kid(0), env);
            LirNode operand1 = this.genAndReplace(e.kid(1), env);
            return this.newLir.operator(e.opCode, e.type, operand0, operand1, ImList.Empty);
        }
        if (e instanceof LirNaryOp) {
            LirNode[] operands = new LirNode[e.nKids()];
            for (int i = 0; i < e.nKids(); ++i) {
                operands[i] = this.genAndReplace(e.kid(i), env);
            }
            return this.newLir.operator(e.opCode, e.type, operands, ImList.Empty);
        }
        return e;
    }

    public Vector liveReg(Vector in) {
        Vector<Object> live = new Vector<Object>();
        ImList c = this.liveRegList;
        while (!c.atEnd()) {
            live.addElement(c.elem());
            c = c.next();
        }
        return this.liveReg(in, live);
    }

    public Vector liveReg(Vector in, Vector live) {
        Vector<Object> out = new Vector<Object>();
        out.addElement(live.clone());
        int i = in.size();
        while (i > 0) {
            LirNode inst = (LirNode)in.elementAt(--i);
            switch (inst.opCode) {
                case 56: {
                    int j;
                    for (j = 0; j < inst.nKids(); ++j) {
                        if (inst.kid((int)j).kid((int)0).opCode != 6) continue;
                        live.removeElement(((LirSymRef)inst.kid((int)j).kid((int)0)).symbol);
                    }
                    for (j = 0; j < inst.nKids(); ++j) {
                        this.addUsedReg(inst.kid(j).kid(1), live);
                    }
                    break;
                }
                case 48: {
                    if (inst.kid((int)0).opCode == 6) {
                        live.removeElement(((LirSymRef)inst.kid((int)0)).symbol);
                    }
                    this.addUsedReg(inst.kid(1), live);
                    break;
                }
                default: {
                    int j;
                    for (j = 0; j < inst.nKids(); ++j) {
                        this.addUsedReg(inst.kid(j), live);
                    }
                }
            }
            out.insertElementAt(live.clone(), 0);
        }
        return out;
    }

    private void addUsedReg(LirNode e, Vector v) {
        if (e instanceof LirIconst) {
            return;
        }
        if (e instanceof LirFconst) {
            return;
        }
        if (e instanceof LirLabelRef) {
            return;
        }
        if (e instanceof LirSymRef) {
            if (e.opCode == 6 && !v.contains(((LirSymRef)e).symbol)) {
                v.addElement(((LirSymRef)e).symbol);
            }
            return;
        }
        for (int i = 0; i < e.nKids(); ++i) {
            this.addUsedReg(e.kid(i), v);
        }
    }

    private void addUsedVar(LirNode e, Vector v) {
        if (e.opCode == 48) {
            this.addUsedReg(e.kid(1), v);
        }
        if (e.opCode == 56) {
            for (int i = 0; i < e.nKids(); ++i) {
                this.addUsedReg(e.kid(i), v);
            }
        }
    }

    private void addDefVar(LirNode e, Vector v) {
        block4: {
            block2: {
                block3: {
                    if (e.opCode != 48) break block2;
                    if (e.kid((int)0).opCode != 6 || v.contains(((LirSymRef)e.kid((int)0)).symbol)) break block3;
                    v.addElement(((LirSymRef)e.kid((int)0)).symbol);
                    break block4;
                }
                if (e.kid((int)0).opCode != 7 || e.kid((int)0).kid((int)1).opCode != 6 || v.contains(((LirSymRef)e.kid((int)0).kid((int)1)).symbol)) break block4;
                v.addElement(((LirSymRef)e.kid((int)0).kid((int)1)).symbol);
                break block4;
            }
            if (e.opCode == 56) {
                for (int i = 0; i < e.nKids(); ++i) {
                    this.addDefVar(e.kid(i), v);
                }
            }
        }
    }

    private static int decode(String s) {
        try {
            return Type.decode(s);
        }
        catch (SyntaxError e) {
            return -1;
        }
    }

    private int simdRegIndex(int cnt, int typ) {
        int nType = cnt * LirUtil.typeNum(typ);
        if (nType == 64) {
            return 0;
        }
        if (nType == 128) {
            return 1;
        }
        return 0;
    }

    private void initSimdReg() {
        for (int idx = 0; idx < this.simdRegIndexMax; ++idx) {
            for (int i = 0; i < this.simdReg[idx].length; ++i) {
                String name = this.simdRegStr[idx][i];
                Symbol sym = this.func.localSymtab.get(name);
                if (sym == null && (sym = this.func.module.globalSymtab.get(name)) == null) {
                    sym = this.func.localSymtab.addSymbol(name, storageREG, simdRegType[idx], LirUtil.calcBoundary(simdRegType[idx]), 0, ImList.Empty);
                }
                String regset = this.getRegset(idx);
                sym.setOpt(ImList.list("&regset", regset));
                this.simdReg[idx][i] = sym;
            }
        }
    }

    private String getRegset(int idx) {
        if (idx == 0) {
            return "*reg-simd-I64*";
        }
        if (idx == 1) {
            return "*reg-simd-I128*";
        }
        return "*reg-simd-I128*";
    }

    private int findSimdReg(Vector[] regnames, Vector v, int length) {
        int r;
        for (r = 0; r < length; ++r) {
            if (regnames[r] == null) continue;
            boolean b = true;
            for (int i = 0; i < regnames[r].size() && i < v.size(); ++i) {
                if (regnames[r].elementAt(i) == v.elementAt(i)) continue;
                b = false;
                break;
            }
            if (b) break;
        }
        return r;
    }

    private int getSimdReg(int idx) throws SimdOptException {
        for (int r = 0; r < this.simdReg[idx].length; ++r) {
            if (this.simdRegUsed[idx][r] != null) continue;
            return r;
        }
        Util.sorry(true, "No registers.");
        return -1;
    }

    private LirNode genLoadConst(LirNode r, LirNode c) {
        return this.newLir.operator(48, r.type, r, c, ImList.Empty);
    }

    private LirNode genSetLir(LirNode d, LirNode s) {
        return this.newLir.operator(48, d.type, d, s, ImList.Empty);
    }

    private LirNode newReg(int t) {
        Symbol newregsym = this.mkSym(t, "sv$" + tmpgen + "b" + this.tmpReg++ + "%");
        return this.newLir.symRef(6, t, newregsym, ImList.Empty);
    }

    private static int storageDecode(String s) {
        try {
            return Storage.decode(s);
        }
        catch (SyntaxError e) {
            return -1;
        }
    }

    private Symbol mkSym(int t, String s) {
        Symbol sym = this.func.localSymtab.get(s);
        if (sym == null && (sym = this.func.module.globalSymtab.get(s)) == null) {
            sym = this.func.localSymtab.addSymbol(s, storageREG, t, LirUtil.calcBoundary(t), 0, ImList.Empty);
        }
        return sym;
    }

    public boolean defined(Symbol var, LirNode inst) {
        if (inst.opCode == 48) {
            LirNode dest = inst.kid(0);
            if (dest.opCode == 6) {
                LirSymRef reg = (LirSymRef)dest;
                return reg.symbol.equals(var);
            }
            if (dest.opCode == 7 && dest.kid((int)1).opCode == 6) {
                LirSymRef reg = (LirSymRef)dest.kid(1);
                return reg.symbol.equals(var);
            }
            return false;
        }
        if (inst.opCode == 56) {
            for (int i = 0; i < inst.nKids(); ++i) {
                if (!this.defined(var, inst.kid(i))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean used(Symbol var, LirNode inst) {
        if (inst.opCode == 48) {
            return inst.kid((int)0).opCode == 47 && this.used1(var, inst.kid(0).kid(0)) || this.used1(var, inst.kid(1));
        }
        if (inst.opCode == 56) {
            for (int i = 0; i < inst.nKids(); ++i) {
                if (!this.used(var, inst.kid(i))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean used1(Symbol var, LirNode e) {
        if (e instanceof LirIconst) {
            return false;
        }
        if (e instanceof LirFconst) {
            return false;
        }
        if (e instanceof LirLabelRef) {
            return false;
        }
        if (e instanceof LirSymRef) {
            if (e.opCode == 6) {
                LirSymRef reg = (LirSymRef)e;
                return reg.symbol.equals(var);
            }
            return false;
        }
        for (int i = 0; i < e.nKids(); ++i) {
            if (!this.used1(var, e.kid(i))) continue;
            return true;
        }
        return false;
    }

    private void printSimdRegUsed() {
        System.out.println("simdRegUsed:");
        for (int idx = 0; idx < this.simdRegIndexMax; ++idx) {
            for (int i = 0; i < this.simdReg[idx].length; ++i) {
                if (this.simdRegUsed[idx][i] == null) continue;
                for (int j = 0; j < this.simdRegUsed[idx][i].size(); ++j) {
                    if (this.simdRegUsed[idx][i].elementAt(j) == null) continue;
                    System.out.println("  simdRegUsed[" + i + "].elementAt(" + j + ")=" + this.simdRegUsed[idx][i].elementAt(j).toString());
                }
            }
        }
    }
}

