/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirBinOp;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.lir.LirUnaOp;
import coins.backend.sym.SymAuto;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import coins.simd.Name;
import coins.simd.ReversibleMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ReplaceRegNames {
    Name name;
    Function func;
    LirFactory newLir;
    ReversibleMap rmap = new ReversibleMap();
    HashMap ntmap = new HashMap();

    ReplaceRegNames(Function f) {
        this.name = new Name();
        this.func = f;
        this.newLir = this.func.newLir;
    }

    public void toNewName(BasicBlk blk) {
        if (blk == null) {
            System.out.println("blk : null");
        }
        if (blk.instrList() == null) {
            System.out.println("instrList : null");
        }
        if (blk.instrList().first() == null) {
            System.out.println("lir : null");
        }
        BiLink lir = blk.instrList().first();
        while (!lir.atEnd()) {
            LirNode ins = (LirNode)lir.elem();
            LirNode nins = (LirNode)this.rmap.get(ins);
            if (nins != null) {
                lir.setElem(nins);
                return;
            }
            if (ins.opCode == 48) {
                LirNode r = this.replRight(ins.kid(1));
                LirNode l = this.replLeft(ins.kid(0));
                LirBinOp newins = new LirBinOp(ins.id, 48, ins.type, l, r, ins.opt);
                this.rmap.put(ins, newins);
                lir.setElem(newins);
            }
            lir = lir.next();
        }
    }

    public void toNewName(Vector in) {
        for (int i = 0; i < in.size(); ++i) {
            LirNode ins = (LirNode)in.elementAt(i);
            LirNode newins = (LirNode)this.rmap.get(ins);
            if (newins != null) {
                in.setElementAt(newins, i);
                return;
            }
            if (ins.opCode != 48) continue;
            LirNode r = this.replRight(ins.kid(1));
            LirNode l = this.replLeft(ins.kid(0));
            newins = new LirBinOp(ins.id, 48, ins.type, l, r, ins.opt);
            this.rmap.put(ins, newins);
            in.setElementAt(newins, i);
        }
    }

    private LirNode replRight(LirNode lexp) {
        LirNode nlexp = (LirNode)this.rmap.get(lexp);
        if (nlexp != null) {
            return nlexp;
        }
        switch (lexp.opCode) {
            case 6: {
                LirSymRef reg = (LirSymRef)lexp;
                SymAuto sym = (SymAuto)reg.symbol;
                String symname = sym.name;
                String s = this.name.refName(symname);
                if (s == null) {
                    s = this.name.newName(symname);
                }
                Symbol nsym = this.func.addSymbol(s, sym.storage, sym.type, sym.boundary, sym.offset(), sym.opt());
                nlexp = new LirSymRef(reg.id, 6, reg.type, nsym, reg.opt);
                this.rmap.put(lexp, nlexp);
                this.putNtmap(lexp, nlexp);
                return nlexp;
            }
            case 7: {
                LirBinOp olexp = (LirBinOp)lexp;
                LirNode arg0 = this.replRight(olexp.kid(0));
                nlexp = new LirBinOp(olexp.id, olexp.opCode, olexp.type, arg0, olexp.kid(1), olexp.opt);
                this.rmap.put(lexp, nlexp);
                this.putNtmap(lexp, nlexp);
                return nlexp;
            }
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 47: {
                LirUnaOp olexp = (LirUnaOp)lexp;
                LirNode arg0 = this.replRight(olexp.kid(0));
                nlexp = new LirUnaOp(olexp.id, olexp.opCode, olexp.type, arg0, olexp.opt);
                this.rmap.put(lexp, nlexp);
                return nlexp;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                LirBinOp olexp = (LirBinOp)lexp;
                LirNode arg0 = this.replRight(olexp.kid(0));
                LirNode arg1 = this.replRight(olexp.kid(1));
                nlexp = new LirBinOp(olexp.id, olexp.opCode, olexp.type, arg0, arg1, olexp.opt);
                this.rmap.put(lexp, nlexp);
                return nlexp;
            }
        }
        return lexp;
    }

    private LirNode replLeft(LirNode lexp) {
        switch (lexp.opCode) {
            case 6: {
                LirSymRef reg = (LirSymRef)lexp;
                SymAuto sym = (SymAuto)reg.symbol;
                String symname = sym.name;
                String s = this.name.newName(symname);
                Symbol nsym = this.func.addSymbol(s, sym.storage, sym.type, sym.boundary, sym.offset(), sym.opt());
                LirSymRef nlexp = new LirSymRef(reg.id, 6, reg.type, nsym, reg.opt);
                this.rmap.put(lexp, nlexp);
                this.putNtmap(lexp, nlexp);
                return nlexp;
            }
        }
        LirNode nlexp = (LirNode)this.rmap.get(lexp);
        if (nlexp != null) {
            return nlexp;
        }
        return this.replRight(lexp);
    }

    public void toOldName(BasicBlk blk) {
        BiLink lir = blk.instrList().first();
        while (!lir.atEnd()) {
            LirNode ins = (LirNode)lir.elem();
            LirNode newins = (LirNode)this.rmap.revget(ins);
            if (newins != null) {
                lir.setElem(newins);
                return;
            }
            if (ins.opCode == 48) {
                LirNode l = this.replToOldName(ins.kid(0));
                LirNode r = this.replToOldName(ins.kid(1));
                newins = new LirBinOp(ins.id, 48, ins.type, l, r, ins.opt);
                lir.setElem(newins);
            }
            lir = lir.next();
        }
    }

    public void toOldName(Vector in) {
        for (int i = 0; i < in.size(); ++i) {
            LirNode ins = (LirNode)in.elementAt(i);
            LirNode newins = this.toOldName(ins);
            in.setElementAt(newins, i);
        }
    }

    private LirNode toOldName(LirNode ins) {
        LirNode newins = (LirNode)this.rmap.revget(ins);
        if (newins != null) {
            return newins;
        }
        if (ins.opCode == 48) {
            LirNode l = this.replToOldName(ins.kid(0));
            LirNode r = this.replToOldName(ins.kid(1));
            newins = new LirBinOp(ins.id, 48, ins.type, l, r, ins.opt);
            return newins;
        }
        if (ins.opCode == 56) {
            LirNode[] kids = new LirNode[ins.nKids()];
            for (int i = 0; i < ins.nKids(); ++i) {
                LirNode lnode;
                kids[i] = lnode = this.toOldName(ins.kid(i));
            }
            newins = this.newLir.operator(56, 0, kids, ImList.Empty);
            return newins;
        }
        return ins;
    }

    private LirNode replToOldName(LirNode lexp) {
        LirNode nlexp = (LirNode)this.rmap.revget(lexp);
        if (nlexp != null) {
            return nlexp;
        }
        switch (lexp.opCode) {
            case 6: {
                LirSymRef reg = (LirSymRef)lexp;
                SymAuto sym = (SymAuto)reg.symbol;
                String symname = sym.name;
                String s = this.name.origName(symname);
                if (s == symname) {
                    return lexp;
                }
                Symbol nsym = this.func.addSymbol(s, sym.storage, sym.type, sym.boundary, sym.offset(), sym.opt());
                nlexp = new LirSymRef(reg.id, 6, reg.type, nsym, reg.opt);
                return nlexp;
            }
            case 7: {
                LirBinOp olexp = (LirBinOp)lexp;
                LirNode arg0 = this.replToOldName(olexp.kid(0));
                nlexp = new LirBinOp(olexp.id, olexp.opCode, olexp.type, arg0, olexp.kid(1), olexp.opt);
                return nlexp;
            }
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 47: {
                LirUnaOp olexp = (LirUnaOp)lexp;
                LirNode arg0 = this.replToOldName(olexp.kid(0));
                nlexp = new LirUnaOp(olexp.id, olexp.opCode, olexp.type, arg0, olexp.opt);
                return nlexp;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                LirBinOp olexp = (LirBinOp)lexp;
                LirNode arg0 = this.replToOldName(olexp.kid(0));
                LirNode arg1 = this.replToOldName(olexp.kid(1));
                nlexp = new LirBinOp(olexp.id, olexp.opCode, olexp.type, arg0, arg1, olexp.opt);
                return nlexp;
            }
        }
        return lexp;
    }

    private void putNtmap(LirNode e1, LirNode e2) {
        List<LirNode> v;
        if (!this.ntmap.containsKey(e1)) {
            v = new LinkedList<LirNode>();
            v.add(e1);
        } else {
            v = (List)this.ntmap.get(e1);
        }
        if (!v.contains(e2)) {
            v.add(e2);
        }
        this.ntmap.put(e1, v);
    }

    public Collection getNtmap() {
        return this.ntmap.values();
    }

    public Vector getReplRegPairs() {
        Set s = this.rmap.entries();
        Vector<Map.Entry> out = new Vector<Map.Entry>();
        for (Map.Entry pair : s) {
            if (!(pair.getValue() instanceof LirNode) || ((LirNode)pair.getValue()).opCode != 6) continue;
            out.addElement(pair);
        }
        for (int i = 0; i < out.size(); ++i) {
            Map.Entry pair = (Map.Entry)out.elementAt(i);
            LirNode p1 = (LirNode)pair.getKey();
            LirNode p2 = (LirNode)pair.getValue();
            System.out.println("Entry pair: key=" + p1 + " ,value=" + p2);
        }
        return out;
    }
}

