/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.simd.Relation;
import coins.simd.SimdOptException;
import java.util.Comparator;

public class LirOrder
implements Comparator {
    private Relation orderRel;

    public void saturate() throws SimdOptException {
        this.orderRel.saturate();
    }

    public void put(Relation r) {
        this.orderRel = r;
    }

    public void add(LirNode e1, LirNode e2) throws SimdOptException {
        this.orderRel.add(e1, e2);
    }

    public int compare(Object o1, Object o2) {
        int retval = 0;
        if (o1 instanceof LirNode && o2 instanceof LirNode) {
            LirNode e1 = (LirNode)o1;
            LirNode e2 = (LirNode)o2;
            retval = this.orderRel.isRelated(e1, e2) ? -1 : (this.orderRel.isRelated(e2, e1) ? 1 : -10000);
        }
        return retval;
    }

    private String name(LirNode e) {
        switch (e.opCode) {
            case 48: 
            case 56: {
                return this.name(e.kid(0));
            }
            case 6: {
                LirSymRef symref = (LirSymRef)e;
                Symbol sym = symref.symbol;
                return sym.name;
            }
        }
        return e.toString();
    }

    public boolean equals(Object o) {
        return true;
    }

    public void printOrder() {
        this.orderRel.printRel();
    }
}

