/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.lir.LirNode;
import java.util.Vector;

public class LirMemUtil {
    public static boolean hasMemDef(LirNode inst) {
        switch (inst.opCode) {
            case 56: {
                return LirMemUtil.hasMemDef(inst.kid(0));
            }
            case 48: {
                return inst.kid((int)0).opCode == 47;
            }
        }
        return false;
    }

    public static LirNode getMemName(LirNode inst) {
        switch (inst.opCode) {
            case 56: {
                return LirMemUtil.getMemName(inst.kid(0));
            }
            case 48: {
                if (inst.kid((int)0).opCode != 47) {
                    return null;
                }
                return LirMemUtil.getMemBase(inst.kid(0).kid(0));
            }
        }
        return null;
    }

    public static LirNode getMemBase(LirNode mem) {
        switch (mem.opCode) {
            case 47: {
                return LirMemUtil.getMemBase(mem.kid(0));
            }
            case 4: 
            case 5: 
            case 6: {
                return mem;
            }
            case 10: 
            case 11: 
            case 12: {
                if (mem.kid((int)0).opCode == 2) {
                    return LirMemUtil.getMemBase(mem.kid(1));
                }
                return LirMemUtil.getMemBase(mem.kid(0));
            }
        }
        return null;
    }

    public static void findMemUse(Vector lirs, int i, LirNode base, Vector out) {
        block0: for (int j = i; j < lirs.size(); ++j) {
            LirNode mb;
            LirNode inst = (LirNode)lirs.elementAt(j);
            if (LirMemUtil.hasMemDef(inst) && (mb = LirMemUtil.getMemName(inst)) == base) {
                return;
            }
            Vector mus = new Vector();
            LirMemUtil.getMemUse(inst, mus);
            for (int k = 0; k < mus.size(); ++k) {
                if (mus.elementAt(k) != base) continue;
                out.addElement(inst);
                continue block0;
            }
        }
    }

    public static void getMemUse(LirNode inst, Vector out) {
        switch (inst.opCode) {
            case 47: {
                LirNode base = LirMemUtil.getMemBase(inst);
                if (base != null) {
                    out.addElement(base);
                }
                return;
            }
            case 48: {
                LirMemUtil.getMemUse(inst.kid(1), out);
                return;
            }
            case 56: {
                for (int i = 0; i < inst.nKids(); ++i) {
                    LirNode kInst = inst.kid(i);
                    if (kInst.opCode != 48) continue;
                    LirMemUtil.getMemUse(kInst.kid(1), out);
                }
                return;
            }
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 30: {
                LirMemUtil.getMemUse(inst.kid(0), out);
                return;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                LirMemUtil.getMemUse(inst.kid(0), out);
                LirMemUtil.getMemUse(inst.kid(1), out);
                return;
            }
        }
    }
}

