/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.lir.LirBinOp;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNaryOp;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.lir.LirUnaOp;
import coins.backend.util.ImList;
import java.util.Vector;

public class LirMatch {
    public LirFactory newLir;

    public boolean match(LirNode x, LirNode y, LirNode[] env) {
        if (x == y) {
            return true;
        }
        if (x.opCode == 1) {
            if (x.type != y.type) {
                return false;
            }
            int n = (int)((LirIconst)((LirUnaOp)x).kid((int)0)).value;
            if (env[n] != null) {
                return y.equals(env[n]);
            }
            env[n] = y;
            return true;
        }
        if (x.opCode != y.opCode || x.type != y.type) {
            return false;
        }
        if (x instanceof LirIconst && y instanceof LirIconst) {
            return (int)((LirIconst)x).value == (int)((LirIconst)y).value;
        }
        if (x instanceof LirFconst && y instanceof LirFconst) {
            return ((LirFconst)x).value == ((LirFconst)y).value;
        }
        if (x instanceof LirSymRef && y instanceof LirSymRef) {
            return ((LirSymRef)x).symbol == ((LirSymRef)y).symbol;
        }
        int n = x.nKids();
        if (n != y.nKids()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.match(x.kid(i), y.kid(i), env)) continue;
            return false;
        }
        return true;
    }

    public LirNode replace(LirNode e, LirNode[] env) {
        if (e.opCode == 1) {
            return env[(int)((LirIconst)((LirUnaOp)e).kid((int)0)).value];
        }
        if (e instanceof LirUnaOp) {
            LirNode esub = this.replace(e.kid(0), env);
            if (esub.equals(e.kid(0))) {
                return e;
            }
            return this.newLir.operator(e.opCode, e.type, esub, ImList.Empty);
        }
        if (e instanceof LirBinOp) {
            LirNode esub0 = this.replace(e.kid(0), env);
            LirNode esub1 = this.replace(e.kid(1), env);
            if (esub0.equals(e.kid(0)) && esub1.equals(e.kid(1))) {
                return e;
            }
            return this.newLir.operator(e.opCode, e.type, esub0, esub1, ImList.Empty);
        }
        if (e instanceof LirNaryOp) {
            int i;
            int n = e.nKids();
            LirNode[] src = new LirNode[n];
            for (i = 0; i < n; ++i) {
                src[i] = this.replace(e.kid(i), env);
            }
            for (i = 0; i < n; ++i) {
                if (src[i].equals(e.kid(i))) continue;
                return this.newLir.operator(e.opCode, e.type, src, ImList.Empty);
            }
            return e;
        }
        return e;
    }

    public boolean matchReg(LirNode x, LirNode y, Vector xv, Vector yv) {
        if (x == y) {
            return true;
        }
        if (x.opCode == 6) {
            for (int i = 0; i < xv.size(); ++i) {
                if (((LirNode)xv.elementAt((int)i)).opCode != 6 || ((LirSymRef)xv.elementAt((int)i)).symbol != ((LirSymRef)x).symbol || !this.isEqual((LirNode)yv.elementAt(i), y)) continue;
                return true;
            }
            xv.addElement(x);
            yv.addElement(y);
            return true;
        }
        if (x.opCode != y.opCode || x.type != y.type) {
            return false;
        }
        if (x instanceof LirIconst && y instanceof LirIconst) {
            return (int)((LirIconst)x).value == (int)((LirIconst)y).value;
        }
        if (x instanceof LirFconst && y instanceof LirFconst) {
            return ((LirFconst)x).value == ((LirFconst)y).value;
        }
        if (x instanceof LirSymRef && y instanceof LirSymRef) {
            return ((LirSymRef)x).symbol == ((LirSymRef)y).symbol;
        }
        if (x instanceof LirUnaOp && y instanceof LirUnaOp) {
            return this.matchReg(x.kid(0), y.kid(0), xv, yv);
        }
        if (x instanceof LirBinOp && y instanceof LirBinOp) {
            return this.matchReg(x.kid(0), y.kid(0), xv, yv) && this.matchReg(x.kid(1), y.kid(1), xv, yv);
        }
        if (x instanceof LirNaryOp && y instanceof LirNaryOp) {
            int n = x.nKids();
            if (n != y.nKids()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.matchReg(x.kid(i), y.kid(i), xv, yv)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isEqual(LirNode x, LirNode y) {
        if (x == y) {
            return true;
        }
        if (x.opCode != y.opCode) {
            return false;
        }
        switch (x.opCode) {
            case 2: {
                return x == y;
            }
            case 6: {
                return ((LirSymRef)x).symbol == ((LirSymRef)y).symbol;
            }
        }
        for (int i = 0; i < x.nKids(); ++i) {
            if (this.isEqual(x.kid(i), y.kid(i))) continue;
            return false;
        }
        return true;
    }
}

