/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.Op;
import coins.backend.Storage;
import coins.backend.SyntaxError;
import coins.backend.Type;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.sym.Symbol;
import coins.backend.util.ImList;

public class LirDecoder {
    private LirFactory newLir;
    private Function func;

    public LirDecoder(Function f) {
        this.newLir = f.newLir;
        this.func = f;
    }

    public LirNode decodeLir(ImList stmt) throws SyntaxError {
        int code = Op.toCode((String)stmt.elem());
        switch (code) {
            case 2: {
                return this.newLir.iconst(Type.decode((String)stmt.elem2nd()), Integer.parseInt((String)stmt.elem3rd()), ImList.Empty);
            }
            case 3: {
                return this.newLir.fconst(Type.decode((String)stmt.elem2nd()), Double.parseDouble((String)stmt.elem3rd()), ImList.Empty);
            }
            case 6: {
                int type = Type.decode((String)stmt.elem2nd());
                String name = (String)stmt.elem3rd();
                Symbol sym = this.func.localSymtab.get(name);
                if (sym == null && (sym = this.func.module.globalSymtab.get(name)) == null) {
                    sym = this.registerRegname(this.func, stmt);
                }
                return this.newLir.symRef(code, type, sym, ImList.Empty);
            }
            case 7: {
                LirNode inum = this.newLir.iconst(Type.decode("I32"), Integer.parseInt((String)stmt.elem4th()), ImList.Empty);
                return this.newLir.operator(code, Type.decode((String)stmt.elem2nd()), this.decodeLir((ImList)stmt.elem3rd()), inum, ImList.Empty);
            }
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 47: {
                return this.newLir.operator(code, Type.decode((String)stmt.elem2nd()), this.decodeLir((ImList)stmt.elem3rd()), ImList.Empty);
            }
            case 1: {
                LirNode hnum = this.newLir.iconst(Type.decode("I32"), Integer.parseInt((String)stmt.elem2nd()), ImList.Empty);
                return this.newLir.operator(code, Type.decode((String)stmt.elem3rd()), hnum, ImList.Empty);
            }
            case 49: 
            case 57: 
            case 58: {
                return this.newLir.operator(code, 0, this.decodeLir((ImList)stmt.elem2nd()), ImList.Empty);
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                return this.newLir.operator(code, Type.decode((String)stmt.elem2nd()), this.decodeLir((ImList)stmt.elem3rd()), this.decodeLir((ImList)stmt.elem4th()), ImList.Empty);
            }
            case 56: {
                int n = stmt.next().length();
                LirNode[] src = new LirNode[n];
                int i = 0;
                ImList p = stmt.next();
                while (!p.atEnd()) {
                    src[i++] = this.decodeLir((ImList)p.elem());
                    p = p.next();
                }
                return this.newLir.operator(code, 0, src, ImList.Empty);
            }
        }
        throw new Error("Unknown opCode");
    }

    private Symbol registerRegname(Function f, ImList stmt) throws SyntaxError {
        return f.localSymtab.addSymbol((String)stmt.elem3rd(), Storage.decode("REG"), Type.decode((String)stmt.elem2nd()), 0, 0, ImList.Empty);
    }
}

