/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.SyntaxError;
import coins.backend.lir.LirNode;
import coins.backend.util.ImList;
import coins.simd.LirDecoder;
import coins.simd.LirMatch;
import coins.simd.LirUtil;
import coins.simd.RegGroups;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;

public abstract class LirBoneList
extends LirMatch {
    private static final int MAX_ENV_SIZE = 33;
    private LirDecoder decoder;
    public ImList[] templateList;
    public ImList[] auxtemplateList;
    public ImList[] rewriteList;

    public abstract ImList[] initBoneList();

    public abstract ImList[] initRewriteList();

    public abstract ImList[] initAuxBoneList();

    public void init(Function f) {
        this.newLir = f.newLir;
        this.decoder = new LirDecoder(f);
        this.templateList = this.initBoneList();
        this.auxtemplateList = this.initAuxBoneList();
        this.rewriteList = this.initRewriteList();
    }

    public ImList find(LirNode inst, LirNode[] env) {
        int j;
        int i;
        if (this.templateList == null) {
            return null;
        }
        for (i = 0; i < this.templateList.length; ++i) {
            for (j = 0; j < env.length; ++j) {
                env[j] = null;
            }
            if (!this.match((LirNode)this.templateList[i].next().elem(), inst, env)) continue;
            return this.templateList[i];
        }
        for (i = 0; i < this.auxtemplateList.length; ++i) {
            for (j = 0; j < env.length; ++j) {
                env[j] = null;
            }
            if (!this.match((LirNode)this.auxtemplateList[i].next().elem(), inst, env) || !this.chkAuxCond(i, inst)) continue;
            return this.auxtemplateList[i];
        }
        return null;
    }

    public abstract boolean chkAuxCond(int var1, LirNode var2);

    public ImList find(LirNode inst) {
        LirNode[] env = new LirNode[33];
        for (int n = 0; n < 33; ++n) {
            env[n] = null;
        }
        return this.find(inst, env);
    }

    public ImList mkBone(String infostr, String bodystr) {
        try {
            PushbackReader irder = new PushbackReader(new StringReader(infostr));
            ImList info = (ImList)ImList.readSexp(irder);
            PushbackReader brder = new PushbackReader(new StringReader(bodystr));
            ImList bbody = (ImList)ImList.readSexp(brder);
            LirNode nd = this.decoder.decodeLir(bbody);
            return new ImList(info, new ImList(nd, ImList.Empty));
        }
        catch (SyntaxError se) {
            System.out.println("mkBone:" + se.getMessage());
            return null;
        }
        catch (IOException msg) {
            System.out.println("mkBone:IOError");
            return null;
        }
    }

    public ImList mkRw(String s) {
        try {
            PushbackReader rd = new PushbackReader(new StringReader(s));
            ImList stmts = (ImList)ImList.readSexp(rd);
            ImList lirs = ImList.Empty;
            while (!stmts.atEnd()) {
                lirs = new ImList(this.decoder.decodeLir((ImList)stmts.elem()), lirs);
                stmts = stmts.next();
            }
            return lirs.destructiveReverse();
        }
        catch (SyntaxError se) {
            System.out.println("mkRw:" + se.getMessage());
            return null;
        }
        catch (IOException msg) {
            System.out.println("mkRw:IOError");
            return null;
        }
    }

    public boolean chkBoneCnstr(ImList bone, LirNode inst, LirNode[] env, RegGroups rgs) {
        LirNode[] localenv = new LirNode[33];
        if (this.match(this.boneBody(bone), inst, localenv)) {
            for (int i = 0; i < 33 && !(env[i] == null & localenv[i] == null); ++i) {
                if (!rgs.isEquivalent(env[i], localenv[i])) {
                    return false;
                }
                if (env[i].opCode != localenv[i].opCode) {
                    return false;
                }
                if (!LirUtil.isShiftOp(inst.kid(1)) || env[i].opCode != 2 || env[i] == localenv[i]) continue;
                return false;
            }
            if (this.boneSharedhnum(bone).equals("nil")) {
                return true;
            }
            int n = Integer.parseInt(this.boneSharedhnum(bone));
            return localenv[n].equals(env[n]);
        }
        return false;
    }

    public ImList boneInfo(ImList b) {
        return (ImList)b.elem();
    }

    public LirNode boneBody(ImList b) {
        return (LirNode)b.elem2nd();
    }

    public ImList boneParacnts(ImList b) {
        return this.paracnts(this.boneInfo(b));
    }

    public ImList paracnts(ImList binfo) {
        if (binfo.length() == 0) {
            return null;
        }
        return this.toIntList((ImList)binfo.elem());
    }

    private ImList toIntList(ImList is) {
        if (is == ImList.Empty) {
            return ImList.Empty;
        }
        ImList iList = new ImList(Integer.decode((String)is.elem()), this.toIntList(is.next()));
        return iList;
    }

    public String boneHolenum(ImList b) {
        return this.holenum(this.boneInfo(b));
    }

    public String holenum(ImList binfo) {
        if (binfo.length() < 2) {
            return "nil";
        }
        return (String)binfo.elem2nd();
    }

    public String boneChng(ImList b) {
        return this.chng(this.boneInfo(b));
    }

    public String chng(ImList binfo) {
        if (binfo.length() < 3) {
            return "nil";
        }
        return (String)binfo.elem3rd();
    }

    public String boneReplnum(ImList b) {
        return this.replnum(this.boneInfo(b));
    }

    public String replnum(ImList binfo) {
        if (binfo.length() < 4) {
            return "nil";
        }
        return (String)binfo.elem4th();
    }

    public String boneSharedhnum(ImList b) {
        return this.sharedhnum(this.boneInfo(b));
    }

    public String sharedhnum(ImList binfo) {
        if (binfo.length() < 6) {
            return "nil";
        }
        return (String)binfo.elem6th();
    }

    public ImList boneNosubsthnum(ImList b) {
        return this.nosubsthnum(this.boneInfo(b));
    }

    public ImList nosubsthnum(ImList binfo) {
        if (binfo.length() < 7) {
            return ImList.Empty;
        }
        return (ImList)binfo.next().elem6th();
    }

    public ImList boneSubgroups(ImList b) {
        return this.subgroups(this.boneInfo(b));
    }

    public ImList subgroups(ImList binfo) {
        if (binfo.length() < 8) {
            return ImList.Empty;
        }
        return (ImList)binfo.next().next().elem6th();
    }
}

