/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.Type;
import coins.backend.ana.Dominators;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.opt.If2Jumpc;
import coins.backend.sym.Label;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.simd.ConcatBlks;
import coins.simd.SimdEnvironment;
import coins.simd.Util;
import java.util.Hashtable;

class IfConvert {
    public final String CONV_NUM = "simd-conv-num";
    public final int THR = 2000;
    private final int MAX_NUM;
    private SimdEnvironment env;
    private Function f;
    private BiList sortedList;

    IfConvert(SimdEnvironment e, Function function) {
        this.env = e;
        this.f = function;
        this.MAX_NUM = this.env.opt.isSet("simd-conv-num") ? Integer.parseInt(this.env.opt.getArg("simd-conv-num")) : 2;
    }

    void invoke() {
        boolean changed = true;
        while (changed) {
            ConcatBlks concatBlks = new ConcatBlks(this.env, this.f);
            concatBlks.invoke();
            changed = false;
            this.sortedList = new BiList();
            this.checkNestedIf(this.f.flowGraph().entryBlk(), new BiList());
            BiLink p = this.sortedList.first();
            while (!p.atEnd()) {
                BasicBlk blk = (BasicBlk)p.elem();
                LirNode node = (LirNode)blk.instrList().last().elem();
                if (node.opCode == 50) {
                    this.env.println("Branch : " + blk.id, 2000);
                    this.env.print("    structure.....", 2000);
                    if (!this.checkBranchStructure(blk)) {
                        this.env.println("FAIL", 2000);
                    } else {
                        this.env.println("OK", 2000);
                        this.env.print("    instruction...", 2000);
                        if (!this.checkInstruction(blk)) {
                            this.env.println("FAIL", 2000);
                        } else {
                            this.env.println("OK", 2000);
                            this.env.print("    merge.........", 2000);
                            if (!this.merge(blk)) {
                                this.env.println("FAIL", 2000);
                            } else {
                                this.env.println("OK", 2000);
                                this.reconstruct(blk);
                                changed = true;
                            }
                        }
                    }
                }
                p = p.next();
            }
        }
    }

    private void reconstruct(BasicBlk blk) {
        BiList removeList = new BiList();
        BasicBlk succ = (BasicBlk)blk.succList().first().elem();
        BasicBlk target = (BasicBlk)succ.succList().first().elem();
        BiLink p = blk.succList().first();
        while (!p.atEnd()) {
            succ = (BasicBlk)p.elem();
            succ.clearEdges();
            removeList.add(succ);
            p = p.next();
        }
        blk.instrList().last().unlink();
        LirNode newJump = this.env.lir.operator(49, 0, this.env.lir.labelRef(target.label()), ImList.Empty);
        blk.instrList().last().addAfter(newJump);
        blk.maintEdges();
        BiLink p2 = removeList.first();
        while (!p2.atEnd()) {
            succ = (BasicBlk)p2.elem();
            this.f.flowGraph().basicBlkList.remove(succ);
            p2 = p2.next();
        }
    }

    private Hashtable findDepend(BasicBlk blk) {
        Hashtable<LirNode, BiList> table = new Hashtable<LirNode, BiList>();
        BiLink p = blk.instrList().first();
        while (!p.atEnd()) {
            LirNode node = (LirNode)p.elem();
            if (node.opCode == 48) {
                BiList list = (BiList)table.get(node);
                if (list == null) {
                    list = new BiList();
                    table.put(node, list);
                }
                Util util = new Util();
                BiList tmp = util.findTargetLir(node.kid(1), 6, new BiList());
                BiList depList = new BiList();
                BiLink q = tmp.first();
                while (!q.atEnd()) {
                    LirSymRef ref = (LirSymRef)q.elem();
                    Symbol s = ref.symbol;
                    depList.add(s);
                    q = q.next();
                }
                if (depList.length() > 0) {
                    q = p.prev();
                    while (!q.atEnd()) {
                        LirNode dep = (LirNode)q.elem();
                        if (dep.opCode == 48 && depList.contains(((LirSymRef)dep.kid((int)0)).symbol)) {
                            list.add(dep);
                        }
                        q = q.prev();
                    }
                }
            }
            p = p.next();
        }
        return table;
    }

    private boolean merge(BasicBlk blk) {
        LirNode root = (LirNode)blk.instrList().last().elem();
        LirNode tmpDst = this.f.newTemp(root.kid((int)0).kid((int)0).type);
        LirNode tmp = this.env.lir.operator(48, root.kid((int)0).kid((int)0).type, tmpDst, root.kid(0).kid(0).makeCopy(this.env.lir), ImList.Empty);
        root.kid(0).setKid(0, tmpDst.makeCopy(this.env.lir));
        blk.instrList().last().addBefore(tmp);
        tmpDst = this.f.newTemp(root.kid((int)0).kid((int)1).type);
        tmp = this.env.lir.operator(48, root.kid((int)0).kid((int)1).type, tmpDst, root.kid(0).kid(1).makeCopy(this.env.lir), ImList.Empty);
        root.kid(0).setKid(1, tmpDst.makeCopy(this.env.lir));
        blk.instrList().last().addBefore(tmp);
        BasicBlk thenPart = root.getTargets()[0].basicBlk();
        BasicBlk elsePart = root.getTargets()[1].basicBlk();
        Hashtable dependMap = this.findDepend(elsePart);
        BiList candidateThen = new BiList();
        BiList candidateElse = new BiList();
        BiLink p = thenPart.instrList().first();
        while (!p.atEnd()) {
            LirNode thenNode = (LirNode)p.elem();
            if (thenNode.opCode == 48) {
                boolean find = false;
                Symbol s = ((LirSymRef)thenNode.kid((int)0)).symbol;
                BiLink q = elsePart.instrList().first();
                while (!q.atEnd()) {
                    Symbol ss;
                    LirNode elseNode = (LirNode)q.elem();
                    if (elseNode.opCode == 48 && s.equals(ss = ((LirSymRef)elseNode.kid((int)0)).symbol) && !candidateElse.contains(elseNode)) {
                        BiList list = (BiList)dependMap.get(elseNode);
                        BiLink pp = list.first();
                        while (!pp.atEnd()) {
                            LirNode dep = (LirNode)pp.elem();
                            if (!candidateElse.contains(dep)) {
                                return false;
                            }
                            pp = pp.next();
                        }
                        candidateElse.add(elseNode);
                        find = true;
                        break;
                    }
                    q = q.next();
                }
                if (!find) {
                    LirNode copyNode = this.env.lir.operator(48, s.type, this.env.lir.symRef(s), this.env.lir.symRef(s), ImList.Empty);
                    candidateElse.add(copyNode);
                }
                candidateThen.add(thenNode);
            }
            p = p.next();
        }
        p = elsePart.instrList().first();
        while (!p.atEnd()) {
            LirNode elseNode = (LirNode)p.elem();
            if (elseNode.opCode == 48 && !candidateElse.contains(elseNode)) {
                Symbol s = ((LirSymRef)elseNode.kid((int)0)).symbol;
                LirNode copyNode = this.env.lir.operator(48, s.type, this.env.lir.symRef(s), this.env.lir.symRef(s), ImList.Empty);
                candidateThen.add(copyNode);
                candidateElse.add(elseNode);
            }
            p = p.next();
        }
        p = candidateThen.first();
        BiLink q = candidateElse.first();
        BiLink r = blk.instrList().last();
        LirNode condition = root.kid(0);
        while (!p.atEnd() && !q.atEnd()) {
            LirNode thenNode = (LirNode)p.elem();
            if (thenNode.opCode == 48) {
                LirNode elseNode;
                LirNode elsekid;
                LirNode thenkid = thenNode.kid(1);
                LirNode mergedNode = this.mergeExp(thenkid, elsekid = (elseNode = (LirNode)q.elem()).kid(1), condition, false);
                if (mergedNode == null) {
                    return false;
                }
                LirNode setNode = this.env.lir.operator(48, mergedNode.type, thenNode.kid(0).makeCopy(this.env.lir), mergedNode, ImList.Empty);
                r.addBefore(setNode);
                this.f.touch();
                q = q.next();
            }
            p = p.next();
        }
        return true;
    }

    private boolean checkInstruction(BasicBlk blk) {
        LirNode root = (LirNode)blk.instrList().last().elem();
        BasicBlk thenPart = root.getTargets()[0].basicBlk();
        BasicBlk elsePart = root.getTargets()[1].basicBlk();
        if (!this.check(thenPart)) {
            return false;
        }
        return this.check(elsePart);
    }

    private boolean check(BasicBlk blk) {
        int count = 0;
        BiLink p = blk.instrList().first();
        while (!p.atEnd()) {
            LirNode node = (LirNode)p.elem();
            switch (node.opCode) {
                case 48: {
                    if (node.kid((int)0).opCode != 6) {
                        return false;
                    }
                    if (++count > this.MAX_NUM) {
                        return false;
                    }
                    if (Type.tag(node.type) != 2) {
                        return false;
                    }
                    Util util = new Util();
                    BiList list = util.findTargetLir(node.kid(1), 14, new BiList());
                    list = util.findTargetLir(node.kid(1), 13, list);
                    if (list.length() == 0) break;
                    return false;
                }
                case 49: 
                case 50: 
                case 51: 
                case 55: {
                    break;
                }
                default: {
                    return false;
                }
            }
            p = p.next();
        }
        return true;
    }

    private boolean checkBranchStructure(BasicBlk blk) {
        LirNode node = (LirNode)blk.instrList().last().elem();
        BasicBlk thenPart = node.getTargets()[0].basicBlk();
        BasicBlk elsePart = node.getTargets()[1].basicBlk();
        LirNode lastNode1 = (LirNode)thenPart.instrList().last().elem();
        LirNode lastNode2 = (LirNode)elsePart.instrList().last().elem();
        return thenPart.predList().length() == 1 && elsePart.predList().length() == 1 && lastNode1.opCode == 49 && lastNode2.opCode == 49 && lastNode1.getTargets()[0] == lastNode2.getTargets()[0];
    }

    private BiList checkNestedIf(BasicBlk blk, BiList visited) {
        if (visited.contains(blk)) {
            return visited;
        }
        visited.add(blk);
        Dominators dom = (Dominators)this.f.require(Dominators.analyzer);
        LirNode lastNode = (LirNode)blk.instrList().last().elem();
        if (lastNode.opCode == 50) {
            Label[] targets = lastNode.getTargets();
            BiLink p = dom.kids[blk.id].first();
            while (!p.atEnd()) {
                BasicBlk b = (BasicBlk)p.elem();
                boolean isTarget = false;
                for (int i = 0; i < targets.length; ++i) {
                    if (b != targets[i].basicBlk()) continue;
                    isTarget = true;
                    break;
                }
                visited = isTarget ? this.checkNestedIf(b, visited) : this.checkNestedIf(b, visited);
                p = p.next();
            }
        } else {
            BiLink p = dom.kids[blk.id].first();
            while (!p.atEnd()) {
                BasicBlk b = (BasicBlk)p.elem();
                visited = this.checkNestedIf(b, visited);
                p = p.next();
            }
        }
        if (lastNode.opCode == 50) {
            this.sortedList.addNew(blk);
        }
        return visited;
    }

    void makeIfNode() {
        BiLink p = this.f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                if (node.opCode == 48) {
                    if (this.usingTstNode(node)) {
                        Hashtable map = new Hashtable();
                        BiList list = this.replaceTstNode(node, null, -1, new BiList(), map);
                        BiLink pp = list.last();
                        while (!pp.atEnd()) {
                            LirNode n = (LirNode)pp.elem();
                            Symbol s = (Symbol)map.get(n);
                            LirNode symRef = this.env.lir.symRef(s);
                            LirNode ifNode = this.env.lir.operator(60, n.type, n.makeCopy(this.env.lir), this.env.lir.iconst(n.type, -1L), this.env.lir.iconst(n.type, 0L), ImList.Empty);
                            LirNode assign = this.env.lir.operator(48, symRef.type, symRef, ifNode, ImList.Empty);
                            q.addBefore(assign);
                            pp = pp.prev();
                        }
                    } else if (Type.tag(node.type) == 2 && Type.bits(node.type) < 32) {
                        LirNode newNode = this.insertConvert(node.type, this.integralPromotion(node.kid(1)));
                        node.setKid(1, newNode);
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
        this.f.apply(If2Jumpc.trig);
    }

    private LirNode integralPromotion(LirNode node) {
        switch (node.opCode) {
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 47: {
                return node;
            }
        }
        switch (node.opCode) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                break;
            }
            default: {
                for (int i = 0; i < node.nKids(); ++i) {
                    node.setKid(i, this.integralPromotion(node.kid(i)));
                }
            }
        }
        switch (node.opCode) {
            case 2: 
            case 3: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                node = this.insertConvert(Type.type(2, 32L), node);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                node = this.env.lir.operator(node.opCode, Type.type(2, 32L), node.kid(0).makeCopy(this.env.lir), node.kid(1).makeCopy(this.env.lir), ImList.Empty);
                break;
            }
            case 9: 
            case 30: {
                node = this.env.lir.operator(node.opCode, Type.type(2, 32L), node.kid(0).makeCopy(this.env.lir), ImList.Empty);
                break;
            }
        }
        return node;
    }

    private BiList replaceTstNode(LirNode node, LirNode parent, int place, BiList list, Hashtable map) {
        for (int i = 0; i < node.nKids(); ++i) {
            this.replaceTstNode(node.kid(i), node, i, list, map);
        }
        switch (node.opCode) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                Symbol s = (Symbol)map.get(node);
                if (s == null) {
                    s = ((LirSymRef)this.f.newTemp((int)node.type)).symbol;
                    map.put(node, s);
                    list.add(node);
                }
                LirNode symRef = this.env.lir.symRef(s);
                parent.setKid(place, this.insertConvert(parent.type, symRef));
            }
        }
        return list;
    }

    private boolean usingTstNode(LirNode node) {
        switch (node.opCode) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return true;
            }
        }
        for (int i = 0; i < node.nKids(); ++i) {
            if (!this.usingTstNode(node.kid(i))) continue;
            return true;
        }
        return false;
    }

    private LirNode insertConvert(int type, LirNode target) {
        if (type == target.type) {
            return target;
        }
        if (Type.tag(target.type) == 2) {
            if (Type.tag(type) == 2) {
                if (Type.bits(target.type) > Type.bits(type)) {
                    return this.env.lir.operator(19, type, target.makeCopy(this.env.lir), ImList.Empty);
                }
                return this.env.lir.operator(17, type, target.makeCopy(this.env.lir), ImList.Empty);
            }
            if (Type.tag(type) == 4) {
                return this.env.lir.operator(25, type, target.makeCopy(this.env.lir), ImList.Empty);
            }
            return null;
        }
        if (Type.tag(target.type) == 4) {
            if (Type.tag(type) == 2) {
                return this.env.lir.operator(23, type, target.makeCopy(this.env.lir), ImList.Empty);
            }
            if (Type.tag(type) == 4) {
                if (Type.bits(target.type) > Type.bits(type)) {
                    return this.env.lir.operator(21, type, target.makeCopy(this.env.lir), ImList.Empty);
                }
                return this.env.lir.operator(20, type, target.makeCopy(this.env.lir), ImList.Empty);
            }
            return null;
        }
        return null;
    }

    private LirNode mergeExp(LirNode thenNode, LirNode elseNode, LirNode condition, boolean makeIfNode) {
        if (condition.type != thenNode.type) {
            condition = this.insertConvert(thenNode.type, condition);
        }
        if (condition == null) {
            return null;
        }
        if (makeIfNode) {
            LirNode ifNode = this.env.lir.operator(60, thenNode.type, condition.makeCopy(this.env.lir), thenNode.makeCopy(this.env.lir), elseNode.makeCopy(this.env.lir), ImList.Empty);
            return ifNode;
        }
        LirNode thenPart = this.env.lir.operator(27, thenNode.type, thenNode.makeCopy(this.env.lir), condition.makeCopy(this.env.lir), ImList.Empty);
        LirNode bnotNode = this.env.lir.operator(30, condition.type, condition.makeCopy(this.env.lir), ImList.Empty);
        LirNode elsePart = this.env.lir.operator(27, elseNode.type, elseNode, bnotNode, ImList.Empty);
        LirNode borNode = this.env.lir.operator(28, thenPart.type, thenPart, elsePart, ImList.Empty);
        return borNode;
    }
}

