/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.Type;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.sym.Symbol;
import coins.backend.util.ImList;
import coins.simd.LirUtil;
import java.util.Vector;

public class ContigMemAccess {
    private LirFactory newLir;
    private int[] cnts8 = new int[]{16, 8};
    private int[] cnts16 = new int[]{8, 4};
    private int[] cnts32 = new int[]{4, 2};
    private int[] cnts64 = new int[]{2};
    private Vector paraRegs;

    ContigMemAccess(Function f, Vector paraRegs) {
        this.newLir = f.newLir;
        this.paraRegs = paraRegs;
    }

    public Vector collectMemAccess(Vector in) {
        int n = in.size();
        Object[] ia = new LirNode[n];
        in.copyInto(ia);
        this.collectMemLoad((LirNode[])ia);
        this.collectMemStore((LirNode[])ia);
        Vector<Object> out = new Vector<Object>();
        for (int i = 0; i < n; ++i) {
            if (ia[i] == null) continue;
            out.addElement(ia[i]);
        }
        return out;
    }

    private void collectMemLoad(LirNode[] ia) {
        for (int i = 0; i < ia.length; ++i) {
            LirNode inst;
            int[] a;
            int k;
            if (ia[i] == null || ia[i].opCode == 56 || !this.isMemLoadLir(ia[i]) || (k = this.pickupMemLoadLir(ia, i, a = new int[16])) == 0) continue;
            LirNode[] instArray = new LirNode[k + 1];
            for (int j = 0; j < k; ++j) {
                instArray[j + 1] = ia[a[j]];
                ia[a[j]] = null;
            }
            instArray[0] = ia[i];
            Vector<LirNode> regs = new Vector<LirNode>();
            for (int n = 0; n < k + 1; ++n) {
                inst = instArray[n];
                regs.add(inst.kid(0));
            }
            this.paraRegs.add(regs);
            ia[i] = null;
            int lpos = i;
            ia[lpos] = inst = this.newLir.operator(56, 0, instArray, ImList.Empty);
        }
    }

    private void collectMemStore(LirNode[] ia) {
        for (int i = 0; i < ia.length; ++i) {
            LirNode inst;
            int[] a;
            int k;
            if (ia[i] == null || ia[i].opCode == 56 || !this.isMemStoreLir(ia[i]) || (k = this.pickupMemStoreLir(ia, i, a = new int[16])) == 0) continue;
            LirNode[] instArray = new LirNode[k + 1];
            for (int j = 0; j < k; ++j) {
                instArray[j + 1] = ia[a[j]];
                ia[a[j]] = null;
            }
            instArray[0] = ia[i];
            ia[i] = null;
            int lpos = i;
            ia[lpos] = inst = this.newLir.operator(56, 0, instArray, ImList.Empty);
        }
    }

    private boolean isMemLoadLir(LirNode inst) {
        return inst.opCode == 48 && inst.kid((int)0).opCode == 6 && inst.kid((int)1).opCode == 47;
    }

    private boolean isMemStoreLir(LirNode inst) {
        return inst.opCode == 48 && inst.kid((int)0).opCode == 47;
    }

    private int pickupMemLoadLir(LirNode[] ia, int i, int[] a) {
        int k = 0;
        if (ia[i].opCode != 48) {
            return 0;
        }
        if (ia[i].kid((int)1).opCode != 47) {
            return 0;
        }
        Symbol basesymbol = LirUtil.basesymbol(ia[i].kid(1));
        if (basesymbol == null) {
            return 0;
        }
        long currentval = LirUtil.dispval(ia[i].kid(1));
        long incval = LirUtil.calcIncval(ia[i].kid((int)1).type);
        int typ = ia[i].type;
        int[] b = new int[a.length];
        for (int j = i + 1; j < ia.length; ++j) {
            if (ia[j] == null || ia[j].opCode != 48 || ia[j].type != typ || LirUtil.basesymbol(ia[j].kid(1)) != basesymbol || (LirUtil.dispval(ia[j].kid(1)) - currentval) % incval != 0L) continue;
            b[k++] = j;
        }
        int kc = 0;
        for (int j = 0; j < k; ++j) {
            int jc;
            currentval += incval;
            for (jc = 0; jc < k && (b[jc] < 0 || LirUtil.dispval(ia[b[jc]].kid(1)) != currentval); ++jc) {
            }
            if (jc >= k) continue;
            a[kc++] = b[jc];
            b[jc] = -1;
        }
        k = kc;
        int[] cnts = this.adjustnums(typ);
        if (cnts == null) {
            return 0;
        }
        for (int n = 0; n < cnts.length; ++n) {
            int m = cnts[n];
            if (k < m - 1) continue;
            return m - 1;
        }
        return 0;
    }

    private int pickupMemStoreLir(LirNode[] ia, int i, int[] a) {
        int k = 0;
        if (ia[i].opCode != 48) {
            return 0;
        }
        if (ia[i].kid((int)0).opCode != 47) {
            return 0;
        }
        Symbol basesymbol = LirUtil.basesymbol(ia[i].kid(0));
        if (basesymbol == null) {
            return 0;
        }
        long currentval = LirUtil.dispval(ia[i].kid(0));
        long incval = LirUtil.calcIncval(ia[i].kid((int)1).type);
        int typ = ia[i].type;
        int[] b = new int[a.length];
        for (int j = i + 1; j < ia.length; ++j) {
            if (ia[j] == null || ia[j].opCode != 48 || ia[j].type != typ || LirUtil.basesymbol(ia[j].kid(0)) != basesymbol || (LirUtil.dispval(ia[j].kid(0)) - currentval) % incval != 0L) continue;
            LirNode src = ia[j].kid(1);
            if (src.opCode == 2 || src.opCode == 3) continue;
            b[k++] = j;
        }
        int kc = 0;
        for (int j = 0; j < k; ++j) {
            int jc;
            currentval += incval;
            for (jc = 0; jc < k && (b[jc] < 0 || LirUtil.dispval(ia[b[jc]].kid(0)) != currentval); ++jc) {
            }
            if (jc >= k) continue;
            a[kc++] = b[jc];
            b[jc] = -1;
        }
        k = kc;
        int[] cnts = this.adjustnums(typ);
        if (cnts == null) {
            return 0;
        }
        for (int n = 0; n < cnts.length; ++n) {
            int m = cnts[n];
            if (k < m - 1) continue;
            return m - 1;
        }
        return 0;
    }

    private int[] adjustnums(int type) {
        switch (Type.bits(type)) {
            case 8: {
                return this.cnts8;
            }
            case 16: {
                return this.cnts16;
            }
            case 32: {
                return this.cnts32;
            }
            case 64: {
                return this.cnts64;
            }
        }
        return null;
    }
}

