/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.Type;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;

class AlignmentTest {
    private static int addrtype = Type.type(2, 32L);
    private static ImList optDefault = ImList.Empty;
    private Function func;
    private BiList srcAlignments;
    private BiList tgtAlignments;
    private final long ONE = 1L;
    private final LirNode iconst_1;

    public AlignmentTest(Function func) {
        this.func = func;
        this.srcAlignments = new BiList();
        this.tgtAlignments = new BiList();
        this.iconst_1 = func.newLir.iconst(addrtype, 1L);
    }

    public BiList doIt() {
        BiList basicBlkList = this.func.flowGraph().basicBlkList;
        BiLink p = basicBlkList.first();
        while (!p.atEnd()) {
            this.chkAlignmentBlk((BasicBlk)p.elem());
            p = p.next();
        }
        return this.merge();
    }

    private void chkAlignmentBlk(BasicBlk b) {
        BiLink insp = b.instrList().first();
        while (!insp.atEnd()) {
            this.chkAlignment((LirNode)insp.elem());
            insp = insp.next();
        }
    }

    private void chkAlignment(LirNode ins) {
        if (ins.opCode == 56 && ins.kid((int)0).opCode == 48) {
            int k = ins.nKids();
            LirNode ins0 = ins.kid(0);
            if (ins0.kid((int)0).opCode == 47) {
                this.tgtAlignments.add(new Alignment(ins0.kid(0), k));
            }
            if (ins0.kid((int)1).opCode == 47) {
                this.srcAlignments.add(new Alignment(ins0.kid(1), k));
            }
        }
    }

    public LirNode memAccessOverlappingTest() {
        BiList codes = new BiList();
        BiLink sp = this.srcAlignments.first();
        while (!sp.atEnd()) {
            Alignment sa = (Alignment)sp.elem();
            BiLink tp = this.tgtAlignments.first();
            while (!tp.atEnd()) {
                Alignment ta = (Alignment)tp.elem();
                LirNode nd_1 = this.func.newLir.operator(41, addrtype, sa.startAddr(), ta.startAddr(), optDefault);
                LirNode nd_2 = this.func.newLir.operator(10, addrtype, sa.startAddr(), sa.length(), optDefault);
                LirNode nd_3 = this.func.newLir.operator(41, addrtype, ta.startAddr(), nd_2, optDefault);
                LirNode nd_4 = this.func.newLir.operator(27, addrtype, nd_1, nd_3, optDefault);
                LirNode nd_5 = this.func.newLir.operator(41, addrtype, ta.startAddr(), sa.startAddr(), optDefault);
                LirNode nd_6 = this.func.newLir.operator(10, addrtype, ta.startAddr(), ta.length(), optDefault);
                LirNode nd_7 = this.func.newLir.operator(41, addrtype, sa.startAddr(), nd_5, optDefault);
                LirNode nd_8 = this.func.newLir.operator(27, addrtype, nd_5, nd_7, optDefault);
                LirNode nd_9 = this.func.newLir.operator(28, addrtype, nd_4, nd_8, optDefault);
                LirNode nd = this.func.newLir.operator(35, addrtype, nd_9, this.iconst_1, optDefault);
                codes.add(nd);
                tp = tp.next();
            }
            sp = sp.next();
        }
        if (codes.length() == 0) {
            return null;
        }
        LirNode code = (LirNode)codes.takeFirst();
        if (codes.length() > 0) {
            BiLink cp = codes.first();
            while (!cp.atEnd()) {
                code = this.func.newLir.operator(28, addrtype, code, (LirNode)cp.elem(), optDefault);
                cp = cp.next();
            }
            code = this.func.newLir.operator(35, addrtype, code, this.iconst_1, optDefault);
        }
        return code;
    }

    private BiList merge() {
        BiList bothaligns = new BiList();
        BiLink p = this.srcAlignments.first();
        while (!p.atEnd()) {
            bothaligns.add(p.elem());
            p = p.next();
        }
        p = this.tgtAlignments.first();
        while (!p.atEnd()) {
            bothaligns.addNew(p.elem());
            p = p.next();
        }
        return bothaligns;
    }

    public BiList srcAlignments() {
        return this.srcAlignments;
    }

    public BiList tgtAlignments() {
        return this.tgtAlignments;
    }

    class Alignment {
        private LirNode startAddr;
        private LirNode length;

        Alignment(LirNode e, int k) {
            if (e.opCode == 47) {
                this.startAddr = e.kid(0);
                long i = Type.bytes(e.type) * k;
                this.length = ((AlignmentTest)AlignmentTest.this).func.newLir.iconst(addrtype, i);
            }
        }

        public LirNode startAddr() {
            return this.startAddr;
        }

        public LirNode length() {
            return this.length;
        }

        public LirNode toCondition() {
            LirNode e1 = ((AlignmentTest)AlignmentTest.this).func.newLir.operator(16, addrtype, this.startAddr, this.length, optDefault);
            return e1;
        }
    }
}

