/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.ir.hir.VarNode;
import coins.sym.Sym;
import coins.sym.Var;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ReplaceInfo {
    protected Map fReplaceMap;

    public ReplaceInfo() {
        this.clear();
    }

    public void clear() {
        this.fReplaceMap = new HashMap();
    }

    protected Item getItem(Sym pSym) {
        return (Item)this.fReplaceMap.get(pSym);
    }

    public void add(VarNode lGlobalVarNode) {
        Sym lSym = lGlobalVarNode.getSym();
        Item lItem = this.getItem(lSym);
        if (lItem == null) {
            lItem = new Item();
            this.fReplaceMap.put(lSym, lItem);
        }
        lItem.add(lGlobalVarNode);
    }

    public void remove(Sym pSym) {
        this.fReplaceMap.remove(pSym);
    }

    public Set getReplaceSymSet(int pCount) {
        HashSet<Sym> lReplaceSymSet = new HashSet<Sym>();
        Set lKeySet = this.fReplaceMap.keySet();
        for (Sym lSym : lKeySet) {
            Item lItem = this.getItem(lSym);
            if (lItem == null || lItem.getCount() < pCount || lItem.getReplaceNodeCount() <= 0) continue;
            lReplaceSymSet.add(lSym);
        }
        return lReplaceSymSet;
    }

    public List getReplaceNodeList(Sym pSym) {
        Item lItem = this.getItem(pSym);
        return lItem == null ? null : lItem.getReplaceNodeList();
    }

    public Var getReplacedVar(Sym pSym) {
        Item lItem = this.getItem(pSym);
        return lItem == null ? null : lItem.getReplacedVar();
    }

    public boolean setReplacedVar(Sym pSym, Var pVar) {
        Item lItem = this.getItem(pSym);
        if (lItem == null) {
            return false;
        }
        lItem.setReplacedVar(pVar);
        return true;
    }

    public boolean removeReplacedNode(VarNode pVarNode) {
        Sym lSym = pVarNode.getSym();
        Item lItem = this.getItem(lSym);
        return lItem == null ? false : lItem.removeReplacdNode(pVarNode);
    }

    class Item {
        protected int fCount;
        protected Var fReplacedVar;
        protected List fReplaceNodeList;

        public Item() {
            this.clear();
        }

        public void clear() {
            this.fCount = 0;
            this.fReplacedVar = null;
            this.fReplaceNodeList = new LinkedList();
        }

        public int getCount() {
            return this.fCount;
        }

        public Var getReplacedVar() {
            return this.fReplacedVar;
        }

        public void setReplacedVar(Var pVar) {
            this.fReplacedVar = pVar;
        }

        public List getReplaceNodeList() {
            return this.fReplaceNodeList;
        }

        public int getReplaceNodeCount() {
            return this.fReplaceNodeList == null ? 0 : this.fReplaceNodeList.size();
        }

        public void add(VarNode pReplaceVarNode) {
            ++this.fCount;
            this.fReplaceNodeList.add(pReplaceVarNode);
        }

        public boolean removeReplacdNode(VarNode pReplacedNode) {
            return this.fReplaceNodeList.remove(pReplacedNode);
        }
    }
}

