/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.IoRoot;
import coins.alias.RecordAlias;
import coins.driver.CompileThread;
import coins.flow.BBlock;
import coins.flow.BBlockHir;
import coins.flow.BBlockHirSubtreeIteratorImpl;
import coins.flow.BBlockNodeIterator;
import coins.flow.BBlockStmtIterator;
import coins.flow.BBlockSubtreeIterator;
import coins.flow.ExpVector;
import coins.flow.Flow;
import coins.flow.FlowAnalSymVector;
import coins.flow.SetRefReprHirEImpl;
import coins.flow.SetRefReprList;
import coins.flow.ShowDataFlow;
import coins.flow.SubpFlow;
import coins.flow.SubpFlowImpl;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirList;
import coins.ir.hir.IfStmt;
import coins.ir.hir.IfStmtImpl;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.LoopStmtImpl;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubsPtrTransformation;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.SwitchStmtImpl;
import coins.ir.hir.VarNode;
import coins.opt.CommonSubexpElimHirE;
import coins.opt.NormalizeHir;
import coins.opt.OptUtil;
import coins.sym.ExpId;
import coins.sym.Var;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class PRE
extends CommonSubexpElimHirE {
    public final IoRoot ioRoot;
    public final Flow flow;
    protected ShowDataFlow fShowFlow;
    protected SubpDefinition fSubpDef;
    protected boolean fRegularSubp = true;
    protected boolean fSubsPtr;
    protected int fTraceLevel;
    CompileThread fCompileThread;
    static long fTimeInMillis = 0L;
    boolean fCompileTime = false;
    ExpVector[] fComp;
    ExpVector[] fAntloc;
    ExpVector[] fTransp;
    ExpVector[] fAvailIn;
    ExpVector[] fAvailOut;
    ExpVector[] fAntIn;
    ExpVector[] fAntOut;
    ExpVector[] fEpsIn;
    ExpVector[] fEpsOut;
    ExpVector[] fRedund;
    ExpVector[] fInsert;
    List[] fInsertEdge;
    ExpVector[] fSaveIn;
    ExpVector[] fSaveOut;
    ExpVector[] fSave;
    ExpVector fAllZero;
    ExpVector fAllOne;

    public PRE(SubpFlow pSubpFlow, SubpDefinition pSubpDef, boolean pSubsPtr, int pThreshold) {
        super(((SubpFlowImpl)pSubpFlow).flowRoot, pThreshold);
        this.ioRoot = this.flowRoot.ioRoot;
        this.flow = this.flowRoot.flow;
        ((SubpFlowImpl)this.fSubpFlow).fHirAnalExtended = true;
        this.fSubpDef = pSubpDef;
        this.fSubsPtr = pSubsPtr;
        this.fTraceLevel = this.ioRoot.dbgOpt1.getLevel();
        this.fCompileThread = (CompileThread)Thread.currentThread();
        this.dbg(1, "\nPRE threshold=" + pThreshold + " subsptr " + pSubsPtr + " trace level=" + this.fTraceLevel);
        this.dbg(1, " subp " + this.fSubpDef.getSubpSym().toString() + "\n");
    }

    public boolean doPRE() {
        boolean lChanged5;
        HashMap lPtrSubsCorrespondence;
        boolean lChanged1;
        Calendar lCalendar = Calendar.getInstance();
        boolean lChanged = false;
        this.dbg(1, "\ndoPRE", this.fSubpFlow.getSubpSym().toString() + "\n");
        if (this.fCompileTime) {
            this.printTimeInMillis("Start PRE " + this.fSubpFlow.getSubpSym().toString(), true, true);
        }
        if (lChanged1 = this.subscriptToPointerTransformation(lPtrSubsCorrespondence = new HashMap())) {
            this.fSubpFlow.resetControlAndDataFlowInformation();
            lChanged = true;
        }
        if (this.fTraceLevel >= 2) {
            System.out.print("\nControl flow analysis before PRE \n");
        }
        if (!this.fSubpFlow.isComputed(4)) {
            this.flow.controlFlowAnal(this.fSubpFlow);
        }
        if (this.fSubpFlow.isFailed()) {
            return lChanged;
        }
        boolean lChanged2 = this.normalizeHir();
        if (this.fCompileTime) {
            this.printTimeInMillis(" time after preparatpryTransformation", true, true);
        }
        if (lChanged2) {
            if (this.fSubpFlow.isComputed(4)) {
                this.fSubpFlow.clearDataFlow();
            } else {
                this.fSubpFlow.resetControlAndDataFlowInformation();
            }
            lChanged = true;
        }
        boolean lChanged3 = this.localCommonSubexpElimination();
        if (this.fCompileTime) {
            this.printTimeInMillis(" time after localCommonSubexpElimination", true, true);
        }
        if (lChanged3) {
            this.fSubpFlow.resetControlAndDataFlowInformation();
            lChanged = true;
        }
        if (this.fTraceLevel >= 3) {
            System.out.print("\nHIR before partial redundancy elimination");
            this.fSubpDef.print(2, true);
        }
        this.fAvailableExps = new HashSet();
        this.fAvailableTemps = new HashSet();
        this.fReplacedNodes = new HashSet();
        this.estimateExpCost(this.fSubpDef);
        if (lChanged3) {
            this.flowRoot.flow.controlFlowAnal(this.fSubpFlow);
            if (this.fSubpFlow.isFailed()) {
                return lChanged;
            }
            if (this.fCompileTime) {
                this.printTimeInMillis(" time after controlFlowAnal", true, true);
            }
            this.flowRoot.flow.dataFlowAnal(this.fSubpDef);
        }
        this.fRecordAlias = this.fSubpFlow.getRecordAlias();
        this.initiateDataFlowInformation();
        if (this.fCompileTime) {
            this.printTimeInMillis(" time after initiateDataFlowInf", true, true);
        }
        this.solveDataFlowEquations();
        if (this.fCompileTime) {
            this.printTimeInMillis(" time after solveDataFlowEquation", true, true);
        }
        this.selectExpsForPRE();
        boolean lChanged4 = this.eliminateRedundantExpressions();
        if (this.fCompileTime) {
            this.printTimeInMillis(" time after eliminateRedundantExpressions", true, true);
        }
        if (lChanged4) {
            lChanged = true;
            if (this.fTraceLevel > 2) {
                this.fSubpFlow.getSubpDefinition().printHir("Changed HIR");
            }
        }
        if (this.fTraceLevel > 2) {
            this.dbg(3, "\n transformed is " + lChanged4 + "\n");
        }
        if (this.fSubsPtr) {
            SubsPtrTransformation lSubsPtrTransformation = new SubsPtrTransformation(this.flowRoot.hirRoot);
            lChanged5 = lSubsPtrTransformation.ptrToSubsTransformation(this.fSubpDef, lPtrSubsCorrespondence);
            lChanged |= lChanged5;
        } else {
            lChanged5 = false;
        }
        if (lChanged3 | lChanged4 | lChanged5) {
            this.fSubpDef.finishHir();
            this.fSubpFlow.setComputedFlag(2);
            this.fSubpFlow.setFlowAnalStateLevel(1);
        } else if (this.fTraceLevel > 0) {
            this.dbg(1, "\n No change by this partial redundancy elimination \n");
        }
        if (this.fCompileTime) {
            this.printTimeInMillis(" time end of PRE", true, true);
        }
        return lChanged;
    }

    protected boolean subscriptToPointerTransformation(Map pPtrSubsCorrespondence) {
        boolean lTransformed1 = false;
        if (this.fTraceLevel > 0) {
            this.dbg(2, " Preparatory transformation - subscriptToPointer \n");
        }
        if (this.fSubsPtr) {
            SubsPtrTransformation lSubsPtrTransformation = new SubsPtrTransformation(this.flowRoot.hirRoot);
            lTransformed1 = lSubsPtrTransformation.subsToPtrTrasnsformation(this.fSubpDef, pPtrSubsCorrespondence);
        }
        if (this.fTraceLevel > 0) {
            this.dbg(3, " transformed is " + lTransformed1 + "\n");
        }
        return lTransformed1;
    }

    protected boolean normalizeHir() {
        NormalizeHir normalizeHir;
        boolean lTransformed2 = false;
        if (this.fTraceLevel > 0) {
            this.dbg(2, "Preparatory transformation - normalize\n");
        }
        if (lTransformed2 = (normalizeHir = new NormalizeHir(this.flowRoot, this.fSubpDef)).processCriticalEdge()) {
            if (this.fTraceLevel >= 4) {
                this.dbg(2, "\n After processCriticalEdges ");
                this.fSubpDef.print(2, true);
            }
            this.fSubpDef.finishHir();
            this.fSubpFlow.setComputedFlag(2);
            if (this.fTraceLevel >= 5) {
                this.dbg(2, "\n Before checkCriticalEdges ");
                this.fSubpDef.print(2, true);
            }
            normalizeHir.checkCriticalEdges(this.fSubpFlow, this.fSubpDef);
        }
        if (this.fTraceLevel > 2) {
            this.dbg(3, " transformed is " + lTransformed2 + "\n");
        }
        return lTransformed2;
    }

    protected boolean localCommonSubexpElimination() {
        if (this.fTraceLevel > 0) {
            this.dbg(2, "\n localCommonSubexpElimination \n");
        }
        if (this.flow.getFlowAnalStateLevel() < 2) {
            this.flowRoot.flow.controlFlowAnal(this.fSubpFlow);
        }
        if (this.flow.getFlowAnalStateLevel() < 4) {
            this.flowRoot.flow.dataFlowAnal(this.fSubpDef);
        }
        RecordAlias lRecordAlias = this.fSubpFlow.getRecordAlias();
        CommonSubexpElimHirE cse = new CommonSubexpElimHirE(((SubpFlowImpl)this.fSubpFlow).flowRoot, this.fThreshold, true);
        cse.estimateExpCost(this.fSubpDef);
        boolean lOptimized = cse.doBBlockLocal(this.fSubpFlow);
        if (lOptimized && this.fTraceLevel >= 4) {
            System.out.println("\nHIR after common subexpression elimination");
            this.fSubpDef.print(1, true);
        }
        if (this.fTraceLevel > 2) {
            this.dbg(3, " transformed is " + lOptimized + "\n");
        }
        return lOptimized;
    }

    protected void collectTempsUsedInReplacement() {
        this.fGlobalExpTempMap = new HashMap();
        if (this.fTraceLevel > 0) {
            this.dbg(2, "\n collectTempsUsedInReplacement ");
        }
        ArrayList fBBlockTable = this.fSubpFlow.getBBlockTable();
        for (BBlock lBBlock : fBBlockTable) {
            if (lBBlock.getBBlockNumber() == 0) continue;
            BBlockStmtIterator lIterator = this.fSubpFlow.bblockStmtIterator((BBlockHir)lBBlock);
            while (lIterator.hasNext()) {
                Exp lRHS;
                ExpId lExpId;
                Var lVar;
                Stmt lStmt = (Stmt)lIterator.next();
                if (lStmt instanceof LabeledStmt) {
                    lStmt = ((LabeledStmt)lStmt).getStmt();
                }
                if (lStmt == null) continue;
                if (this.fTraceLevel > 3) {
                    this.dbg(4, lStmt.toString());
                }
                if (!(lStmt instanceof AssignStmt) || !(lStmt.getChild1() instanceof VarNode) || !(lVar = (Var)((VarNode)lStmt.getChild1()).getSymNodeSym()).getFlag(2) || (lExpId = this.fSubpFlow.getExpId(lRHS = (Exp)lStmt.getChild2())) == null) continue;
                this.fGlobalExpTempMap.put(lExpId, lVar);
            }
        }
        if (this.fTraceLevel > 2) {
            this.dbg(3, "\n fGlobalExpTempMap " + this.fGlobalExpTempMap.toString());
        }
    }

    protected void initiateDataFlowInformation() {
        int fBBlockCount = this.fSubpFlow.getNumberOfBBlocks();
        if (this.fTraceLevel > 0) {
            this.dbg(2, "\n initiateDataFlowInformation for PRE BBlockCount " + fBBlockCount + " ");
            if (this.fCompileTime) {
                this.printTimeInMillis("initiateDataFlowInformation for PRE ", true, true);
            }
            if (this.fSubpFlow.getRecordAlias() != null && this.fTraceLevel > 0) {
                this.dbg(2, "considering alias \n");
            }
        }
        ArrayList fBBlockTable = this.fSubpFlow.getBBlockTable();
        ExpVector lTemp1 = this.fSubpFlow.expVector();
        ExpVector lTemp2 = this.fSubpFlow.expVector();
        ExpVector lTemp3 = this.fSubpFlow.expVector();
        this.fAllZero = this.fSubpFlow.expVector();
        this.fAllOne = this.fSubpFlow.expVector();
        this.fAllZero.vectorNot(this.fAllOne);
        this.fComp = new ExpVector[fBBlockCount + 1];
        this.fAntloc = new ExpVector[fBBlockCount + 1];
        this.fTransp = new ExpVector[fBBlockCount + 1];
        this.fAvailIn = new ExpVector[fBBlockCount + 1];
        this.fAvailOut = new ExpVector[fBBlockCount + 1];
        this.fAntIn = new ExpVector[fBBlockCount + 1];
        this.fAntOut = new ExpVector[fBBlockCount + 1];
        this.fEpsIn = new ExpVector[fBBlockCount + 1];
        this.fEpsOut = new ExpVector[fBBlockCount + 1];
        this.fRedund = new ExpVector[fBBlockCount + 1];
        this.fInsert = new ExpVector[fBBlockCount + 1];
        this.fInsertEdge = new ArrayList[fBBlockCount + 1];
        this.fSaveIn = new ExpVector[fBBlockCount + 1];
        this.fSaveOut = new ExpVector[fBBlockCount + 1];
        this.fSave = new ExpVector[fBBlockCount + 1];
        for (BBlock lBBlock : fBBlockTable) {
            ExpVector lEKillAll;
            ExpVector lEGen;
            ExpVector lAvailOut;
            if (lBBlock == null) continue;
            int lBBlockNum = lBBlock.getBBlockNumber();
            if (this.fTraceLevel > 2) {
                this.dbg(3, "BBlockNum " + lBBlockNum + " " + lBBlock.getLabel() + "\n");
            }
            SetRefReprList lSetRefReprs = this.fSubpFlow.getSetRefReprList(lBBlock);
            if (this.fTraceLevel > 3 && lSetRefReprs != null) {
                this.ioRoot.dbgOpt1.print(6, " lSetRefReprs ", lSetRefReprs.toString());
            }
            this.fComp[lBBlockNum] = this.fSubpFlow.expVector();
            this.fAntloc[lBBlockNum] = this.fSubpFlow.expVector();
            this.fTransp[lBBlockNum] = this.fSubpFlow.expVector();
            this.fAvailIn[lBBlockNum] = this.fSubpFlow.expVector();
            this.fAvailOut[lBBlockNum] = this.fSubpFlow.expVector();
            this.fAntIn[lBBlockNum] = this.fSubpFlow.expVector();
            this.fAvailOut[lBBlockNum] = this.fSubpFlow.expVector();
            this.fEpsIn[lBBlockNum] = this.fSubpFlow.expVector();
            this.fEpsOut[lBBlockNum] = this.fSubpFlow.expVector();
            this.fRedund[lBBlockNum] = this.fSubpFlow.expVector();
            this.fInsert[lBBlockNum] = this.fSubpFlow.expVector();
            this.fSaveIn[lBBlockNum] = this.fSubpFlow.expVector();
            this.fSaveOut[lBBlockNum] = this.fSubpFlow.expVector();
            this.fSave[lBBlockNum] = this.fSubpFlow.expVector();
            this.fInsertEdge[lBBlockNum] = new ArrayList();
            if (lBBlockNum == 0) continue;
            ExpVector lAvailIn = lBBlock.getAvailIn();
            if (lAvailIn != null) {
                lAvailIn.vectorCopy(this.fAvailIn[lBBlockNum]);
            }
            if (this.fTraceLevel > 2) {
                this.dbg(3, " AvailIn", this.fAvailIn[lBBlockNum].toStringShort());
            }
            if ((lAvailOut = lBBlock.getAvailOut()) != null) {
                lAvailOut.vectorCopy(this.fAvailOut[lBBlockNum]);
            }
            if (this.fTraceLevel > 2) {
                this.dbg(3, " AvailOut", this.fAvailOut[lBBlockNum].toStringShort());
            }
            if ((lEGen = lBBlock.getEGen()) != null) {
                lEGen.vectorCopy(this.fComp[lBBlockNum]);
            }
            if (this.fTraceLevel > 2) {
                this.dbg(3, " Comp", this.fComp[lBBlockNum].toStringShort());
            }
            this.fAntloc[lBBlockNum] = this.computeAntloc(lBBlock);
            if (this.fTraceLevel > 2) {
                this.dbg(3, " Antloc", this.fAntloc[lBBlockNum].toStringShort());
            }
            if ((lEKillAll = lBBlock.getEKillAll()) != null) {
                lEKillAll.vectorNot(lTemp1);
                FlowAnalSymVector lDefined = lBBlock.getDefined();
                if (lDefined != null) {
                    lTemp2 = lDefined.flowAnalSymToExpVector();
                    lTemp1.vectorSub(lTemp2, this.fTransp[lBBlockNum]);
                } else {
                    lTemp1.vectorCopy(this.fTransp[lBBlockNum]);
                }
            }
            if (this.fTraceLevel > 2) {
                this.dbg(3, " Transp", this.fTransp[lBBlockNum].toStringShort());
            }
            this.fAllOne.vectorCopy(this.fAntOut[lBBlockNum]);
            this.fAvailIn[lBBlockNum].vectorNot(this.fEpsIn[lBBlockNum]);
            this.fAntloc[lBBlockNum].vectorNot(this.fEpsOut[lBBlockNum]);
            this.fAntloc[lBBlockNum].vectorCopy(this.fRedund[lBBlockNum]);
            this.fAvailOut[lBBlockNum].vectorNot(this.fInsert[lBBlockNum]);
            this.fComp[lBBlockNum].vectorNot(this.fSaveIn[lBBlockNum]);
            this.fAvailOut[lBBlockNum].vectorCopy(this.fSaveOut[lBBlockNum]);
            this.fComp[lBBlockNum].vectorCopy(this.fSave[lBBlockNum]);
        }
    }

    protected ExpVector computeAntloc(BBlock pBBlock) {
        ExpVector lAntloc = this.fSubpFlow.expVector();
        FlowAnalSymVector lExposed = pBBlock.getExposed();
        Set lExposedSet = lExposed.flowAnalSyms();
        if (this.fTraceLevel > 3) {
            this.dbg(4, "computeAntloc B" + pBBlock.getBBlockNumber());
            this.dbg(5, " Exposed " + lExposed.toStringShort() + lExposedSet);
        }
        BBlockNodeIterator lIterator = pBBlock.bblockNodeIterator();
        while (lIterator.hasNext()) {
            SetRefReprHirEImpl lExpSetRefRepr;
            HIR lHir = (HIR)lIterator.next();
            if (this.fTraceLevel > 3 && lHir != null) {
                this.dbg(5, " lHir " + lHir.toStringShort());
            }
            if (!(lHir instanceof Exp) || lHir.getChildCount() <= 0 || (lExpSetRefRepr = (SetRefReprHirEImpl)this.fSubpFlow.getSetRefReprOfIR(lHir)) == null) continue;
            Set lLeafOperands = lExpSetRefRepr.leafOperands();
            if (this.fTraceLevel > 3) {
                this.dbg(5, " " + lHir.toStringShort() + " leafOperands " + lLeafOperands.toString());
            }
            if (!lExposedSet.containsAll(lLeafOperands)) continue;
            ExpId lExpId = this.fSubpFlow.getExpId(lHir);
            if (this.fTraceLevel > 3) {
                this.dbg(5, " expId " + lExpId);
            }
            if (lExpId == null) continue;
            lAntloc.setBit(lExpId.getIndex());
        }
        ExpVector lEKillAll = pBBlock.getEKillAll();
        lAntloc.vectorSub(lEKillAll, lAntloc);
        if (this.fTraceLevel > 3) {
            this.dbg(5, " antloc " + lAntloc.toStringShort());
        }
        return lAntloc;
    }

    protected void solveDataFlowEquations() {
        Iterator lCFGIterator;
        List lSuccList;
        int lBBlockNum;
        BBlock lBBlock2;
        Iterator lCFGIterator2;
        boolean lChanged = false;
        if (this.fDbgLevel > 0) {
            this.dbg(2, " solveDataFlowEquqtions \n");
        }
        ExpVector lTemp1 = this.fSubpFlow.expVector();
        ExpVector lTemp2 = this.fSubpFlow.expVector();
        ExpVector lTemp3 = this.fSubpFlow.expVector();
        ExpVector lTemp4 = this.fSubpFlow.expVector();
        ExpVector lTemp5 = this.fSubpFlow.expVector();
        do {
            lChanged = false;
            lCFGIterator2 = this.fSubpFlow.getListOfBBlocksFromExit().iterator();
            while (lCFGIterator2.hasNext()) {
                ExpVector lNewAntIn = this.fSubpFlow.expVector();
                ExpVector lNewAntOut = this.fSubpFlow.expVector();
                lBBlock2 = (BBlock)lCFGIterator2.next();
                lBBlockNum = lBBlock2.getBBlockNumber();
                lSuccList = lBBlock2.getSuccList();
                if (lSuccList.isEmpty()) {
                    this.fAllZero.vectorCopy(lNewAntOut);
                } else {
                    this.fAllOne.vectorCopy(lNewAntOut);
                    for (BBlock lSuccBBlock : lSuccList) {
                        ExpVector lSuccAntIn = this.fAntIn[lSuccBBlock.getBBlockNumber()];
                        lNewAntOut.vectorAnd(lSuccAntIn, lNewAntOut);
                    }
                }
                if (!lNewAntOut.vectorEqual(this.fAntOut[lBBlockNum])) {
                    lChanged = true;
                }
                this.fAntOut[lBBlockNum] = lNewAntOut;
                lNewAntOut.vectorAnd(this.fTransp[lBBlockNum], lTemp1);
                lTemp1.vectorOr(this.fAntloc[lBBlockNum], lNewAntIn);
                if (!lNewAntIn.vectorEqual(this.fAntIn[lBBlockNum])) {
                    lChanged = true;
                }
                this.fAntIn[lBBlockNum] = lNewAntIn;
            }
        } while (lChanged);
        if (this.fDbgLevel >= 2) {
            this.printExpVectorArray2(" AntIn  B", this.fAntIn, "AntOut B", this.fAntOut);
        }
        do {
            lChanged = false;
            lCFGIterator2 = this.fSubpFlow.getListOfBBlocksFromEntry().iterator();
            while (lCFGIterator2.hasNext()) {
                ExpVector lNewEpsIn = this.fSubpFlow.expVector();
                ExpVector lNewEpsOut = this.fSubpFlow.expVector();
                lBBlock2 = (BBlock)lCFGIterator2.next();
                lBBlockNum = lBBlock2.getBBlockNumber();
                List lPredList = lBBlock2.getPredList();
                this.fAllZero.vectorCopy(lTemp1);
                for (BBlock lPredBBlock : lPredList) {
                    ExpVector lPredEpsOut = this.fEpsOut[lPredBBlock.getBBlockNumber()];
                    ExpVector lPredAvailOut = this.fAvailOut[lPredBBlock.getBBlockNumber()];
                    lPredAvailOut.vectorOr(lTemp1, lTemp1);
                    lPredEpsOut.vectorOr(lTemp1, lTemp1);
                }
                lTemp1.vectorAnd(this.fAntIn[lBBlockNum], lTemp2);
                this.fAvailIn[lBBlockNum].vectorNot(lTemp3);
                lTemp2.vectorAnd(lTemp3, lNewEpsIn);
                if (!lNewEpsIn.vectorEqual(this.fEpsIn[lBBlockNum])) {
                    lChanged = true;
                }
                this.fEpsIn[lBBlockNum] = lNewEpsIn;
                this.fAntloc[lBBlockNum].vectorNot(lTemp4);
                lNewEpsIn.vectorAnd(lTemp4, lNewEpsOut);
                if (!lNewEpsOut.vectorEqual(this.fEpsOut[lBBlockNum])) {
                    lChanged = true;
                }
                this.fEpsOut[lBBlockNum] = lNewEpsOut;
            }
        } while (lChanged);
        if (this.fDbgLevel >= 2) {
            this.printExpVectorArray2(" EpsIn  B", this.fEpsIn, "EpsOut B", this.fEpsOut);
        }
        lCFGIterator2 = this.fSubpFlow.getListOfBBlocksFromEntry().iterator();
        while (lCFGIterator2.hasNext()) {
            ExpVector lRedund = this.fSubpFlow.expVector();
            lBBlock2 = (BBlock)lCFGIterator2.next();
            lBBlockNum = lBBlock2.getBBlockNumber();
            this.fEpsIn[lBBlockNum].vectorOr(this.fAvailIn[lBBlockNum], lTemp1);
            lTemp1.vectorAnd(this.fAntloc[lBBlockNum], lTemp2);
            lTemp2.vectorCopy(lRedund);
            this.fRedund[lBBlockNum] = lRedund;
            if (this.fTraceLevel <= 1) continue;
            this.dbg(2, " Redund B" + lBBlockNum + ' ' + this.fRedund[lBBlockNum].toStringDescriptive() + '\n');
        }
        ExpVector lPaiEpsIn = this.fSubpFlow.expVector();
        ExpVector lSuccEpsIn = this.fSubpFlow.expVector();
        Iterator lCFGIterator3 = this.fSubpFlow.getListOfBBlocksFromExit().iterator();
        while (lCFGIterator3.hasNext()) {
            ExpVector lNewInsert = this.fSubpFlow.expVector();
            lBBlock2 = (BBlock)lCFGIterator3.next();
            lBBlockNum = lBBlock2.getBBlockNumber();
            this.fAllOne.vectorCopy(lPaiEpsIn);
            lSuccList = lBBlock2.getSuccList();
            if (lSuccList.isEmpty()) {
                lNewInsert.vectorReset();
            } else {
                for (BBlock lSuccBBlock : lSuccList) {
                    lSuccEpsIn = this.fEpsIn[lSuccBBlock.getBBlockNumber()];
                    lPaiEpsIn.vectorAnd(lSuccEpsIn, lPaiEpsIn);
                }
                this.fAvailOut[lBBlockNum].vectorNot(lTemp1);
                this.fEpsOut[lBBlockNum].vectorNot(lTemp2);
                lTemp1.vectorAnd(lTemp2, lTemp3);
                lTemp3.vectorAnd(lPaiEpsIn, lNewInsert);
            }
            if (!lNewInsert.vectorEqual(this.fInsert[lBBlockNum])) {
                lChanged = true;
            }
            this.fInsert[lBBlockNum] = lNewInsert;
            if (this.fTraceLevel <= 1) continue;
            this.dbg(2, " Insert B" + lBBlockNum + " " + this.fInsert[lBBlockNum].toStringDescriptive() + '\n');
        }
        ExpVector lFromPart = this.fSubpFlow.expVector();
        ExpVector lToPart = this.fSubpFlow.expVector();
        for (BBlock lBBlock2 : this.fSubpFlow.getListOfBBlocksFromExit()) {
            lBBlockNum = lBBlock2.getBBlockNumber();
            List lSuccList2 = lBBlock2.getSuccList();
            this.fAvailOut[lBBlockNum].vectorNot(lFromPart);
            this.fEpsOut[lBBlockNum].vectorNot(lTemp1);
            lFromPart.vectorAnd(lTemp1, lFromPart);
            this.fInsert[lBBlockNum].vectorNot(lTemp2);
            lFromPart.vectorAnd(lTemp2, lFromPart);
            Iterator lSuccIterator = lSuccList2.iterator();
            while (lSuccIterator.hasNext()) {
                BBlock lSuccBBlock;
                ExpVector lEdgeValue = this.fSubpFlow.expVector();
                lSuccBBlock = (BBlock)lSuccIterator.next();
                int lSuccNum = lSuccBBlock.getBBlockNumber();
                lToPart = this.fEpsIn[lSuccNum];
                lFromPart.vectorAnd(lToPart, lEdgeValue);
                this.fInsertEdge[lBBlockNum].add(lEdgeValue);
                if (this.fTraceLevel <= 1) continue;
                this.dbg(2, " InsertEdge B" + lBBlockNum + " to " + lSuccNum + " " + lEdgeValue.toStringDescriptive() + '\n');
            }
        }
        ExpVector lSigmaPart = this.fSubpFlow.expVector();
        do {
            lChanged = false;
            lCFGIterator = this.fSubpFlow.getListOfBBlocksFromExit().iterator();
            while (lCFGIterator.hasNext()) {
                ExpVector lNewSaveIn = this.fSubpFlow.expVector();
                ExpVector lNewSaveOut = this.fSubpFlow.expVector();
                lBBlock2 = (BBlock)lCFGIterator.next();
                lBBlockNum = lBBlock2.getBBlockNumber();
                lSigmaPart.vectorReset();
                List lSuccList3 = lBBlock2.getSuccList();
                for (BBlock lSuccBBlock : lSuccList3) {
                    int lSuccNum = lSuccBBlock.getBBlockNumber();
                    this.fEpsIn[lSuccNum].vectorOr(lSigmaPart, lSigmaPart);
                    this.fRedund[lSuccNum].vectorOr(lSigmaPart, lSigmaPart);
                    this.fSaveIn[lSuccNum].vectorOr(lSigmaPart, lSigmaPart);
                }
                lSigmaPart.vectorAnd(this.fAvailOut[lBBlockNum], lNewSaveOut);
                if (!lNewSaveOut.vectorEqual(this.fSaveOut[lBBlockNum])) {
                    lChanged = true;
                }
                this.fSaveOut[lBBlockNum] = lNewSaveOut;
                this.fComp[lBBlockNum].vectorNot(lTemp1);
                this.fSaveOut[lBBlockNum].vectorAnd(lTemp1, lNewSaveIn);
                if (!lNewSaveIn.vectorEqual(this.fSaveIn[lBBlockNum])) {
                    lChanged = true;
                }
                this.fSaveIn[lBBlockNum] = lNewSaveIn;
            }
        } while (lChanged);
        if (this.fDbgLevel >= 2) {
            this.printExpVectorArray2(" SaveIn B", this.fSaveIn, "SaveOut B", this.fSaveOut);
        }
        lCFGIterator = this.fSubpFlow.getListOfBBlocksFromEntry().iterator();
        while (lCFGIterator.hasNext()) {
            ExpVector lNewSave = this.fSubpFlow.expVector();
            lBBlock2 = (BBlock)lCFGIterator.next();
            lBBlockNum = lBBlock2.getBBlockNumber();
            this.fSaveOut[lBBlockNum].vectorAnd(this.fComp[lBBlockNum], lTemp1);
            this.fRedund[lBBlockNum].vectorAnd(this.fTransp[lBBlockNum], lTemp2);
            lTemp2.vectorNot(lTemp3);
            lTemp1.vectorAnd(lTemp3, lNewSave);
            this.fSave[lBBlockNum] = lNewSave;
            if (this.fTraceLevel <= 1) continue;
            this.dbg(2, " Save B" + lBBlockNum + ' ' + this.fSave[lBBlockNum].toStringDescriptive() + '\n');
        }
    }

    protected void selectExpsForPRE() {
        if (this.fTraceLevel > 1) {
            this.dbg(2, "\n selectExpsForPRE \n");
        }
        ArrayList fBBlockTable = this.fSubpFlow.getBBlockTable();
        HashSet lAllSelectedExpId = new HashSet();
        for (BBlock lBBlock : this.fSubpFlow.getListOfBBlocksFromEntry()) {
            int lBBlockNum = lBBlock.getBBlockNumber();
            Set lRedundantExpId = this.fRedund[lBBlockNum].exps();
            HashSet lSelectedExpId = new HashSet();
            this.selectLargestRedundantExpsInBBlock(lRedundantExpId, lSelectedExpId, lBBlock);
            if (this.fTraceLevel > 1) {
                this.dbg(2, "\nSelected redundant expressions in B" + lBBlockNum + " " + ((Object)lSelectedExpId).toString());
            }
            lAllSelectedExpId.addAll(lSelectedExpId);
        }
        if (this.fTraceLevel > 1) {
            this.dbg(2, "\nAll selected redundant expressions " + ((Object)lAllSelectedExpId).toString());
        }
        for (ExpId lExpId : lAllSelectedExpId) {
            Exp lExp = (Exp)lExpId.getLinkedNode();
            if (this.fTraceLevel > 3) {
                this.dbg(4, "\n redundant " + lExp.toStringWithChildren() + " index " + lExp.getIndex() + " const " + this.fExpCost[lExp.getIndex() - this.fIndexMin]);
            }
            if (this.fExpCost[lExp.getIndex() - this.fIndexMin] < this.fThreshold) continue;
            Var lTemp = this.fGlobalExpTempMap.containsKey(lExpId) ? (Var)this.fGlobalExpTempMap.get(lExpId) : this.symRoot.symTableCurrentSubp.generateVar(lExp.getType());
            this.recordTempExpCorrespondence(lTemp, lExp);
            if (this.fTraceLevel <= 2) continue;
            this.dbg(3, " selected");
        }
        this.dbg(2, " \n");
    }

    void selectLargestRedundantExpsInBBlock(Set pRedundantExps, Set pSelectedExps, BBlock pBBlock) {
        BBlockHirSubtreeIteratorImpl lIterator = new BBlockHirSubtreeIteratorImpl(this.flowRoot, (BBlockHir)pBBlock);
        while (lIterator.hasNext()) {
            HIR lSubtree = (HIR)lIterator.next();
            if (lSubtree instanceof LabeledStmt) {
                lSubtree = ((LabeledStmt)lSubtree).getStmt();
            }
            if (lSubtree == null) continue;
            if (this.fTraceLevel > 2) {
                this.flowRoot.ioRoot.dbgOpt1.print(3, "lSubtree", ((Object)lSubtree).toString());
            }
            this.selectLargestRedundantExps(lSubtree, pRedundantExps, pSelectedExps, pBBlock);
        }
    }

    void selectLargestRedundantExps(HIR pHir, Set pRedundantExps, Set pSelectedExps, BBlock pBBlock) {
        if (pHir == null) {
            return;
        }
        if (this.fTraceLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, " selectLargestRedundantExps", pHir.toStringShort() + " " + pRedundantExps);
        }
        if (pHir.getIndex() == 0) {
            if (this.fTraceLevel > 3) {
                this.flowRoot.ioRoot.dbgOpt1.print(4, " Generated HIR");
            }
            return;
        }
        if (pHir instanceof HirList) {
            ListIterator lIterator = ((HirList)pHir).iterator();
            while (lIterator.hasNext()) {
                Object lElem = lIterator.next();
                if (!(lElem instanceof Exp)) continue;
                this.selectLargestRedundantExps((Exp)lElem, pRedundantExps, pSelectedExps, pBBlock);
            }
        } else if (pHir instanceof AssignStmt) {
            HIR lLHS = (HIR)pHir.getChild1();
            for (int i = 1; i <= lLHS.getChildCount(); ++i) {
                this.selectLargestRedundantExps((HIR)lLHS.getChild(i), pRedundantExps, pSelectedExps, pBBlock);
            }
            this.selectLargestRedundantExps((Exp)pHir.getChild2(), pRedundantExps, pSelectedExps, pBBlock);
        } else {
            ExpId lExpId = this.fSubpFlow.getExpId(pHir);
            if (lExpId != null && pRedundantExps.contains(lExpId) && !lExpId.isLHS() && this.isRegisterizableExp(pHir)) {
                pSelectedExps.add(lExpId);
                return;
            }
            for (int i = 1; i <= pHir.getChildCount(); ++i) {
                HIR lChild = (HIR)pHir.getChild(i);
                if (lChild == null) continue;
                if (lChild.getIndex() == 0) {
                    if (this.fTraceLevel <= 3) continue;
                    this.flowRoot.ioRoot.dbgOpt1.print(4, "Generated HIR " + ((Object)lChild).toString());
                    continue;
                }
                if (this.fSubpFlow.getBBlockOfIR(lChild.getIndex()) != pBBlock) continue;
                this.selectLargestRedundantExps(lChild, pRedundantExps, pSelectedExps, pBBlock);
            }
        }
    }

    protected boolean eliminateRedundantExpressions() {
        if (this.fDbgLevel > 0) {
            this.dbg(1, "\neliminateRedundantExpressions \n");
        }
        boolean lChanged = false;
        if (this.fTraceLevel > 1) {
            this.dbg(2, " fGlobalExpTempMap " + this.fGlobalExpTempMap.toString());
        }
        for (BBlock lBBlock : this.fSubpFlow.getListOfBBlocksFromEntry()) {
            Exp lExp;
            Var lTemp;
            int lBBlockNum = lBBlock.getBBlockNumber();
            if (this.fTraceLevel > 2) {
                this.dbg(3, "\n Basic block " + lBBlockNum + '\n');
            }
            Set lSaveExps = this.fSave[lBBlockNum].exps();
            Set lRedundExps = this.fRedund[lBBlockNum].exps();
            if (this.fTraceLevel > 2) {
                this.dbg(3, "\n saveExps " + lSaveExps.toString());
                this.dbg(3, "\n redundExps " + lRedundExps.toString());
            }
            if (!lSaveExps.isEmpty() || !lRedundExps.isEmpty()) {
                HashSet<Stmt> lGeneratedStmt = new HashSet<Stmt>();
                HashSet<ExpId> lSaveProcessed = new HashSet<ExpId>();
                HashSet<ExpId> lRedundProcessed = new HashSet<ExpId>();
                BBlockSubtreeIterator lSubtreeIterator = lBBlock.bblockSubtreeIterator();
                while (lSubtreeIterator.hasNext()) {
                    Stmt lStmt;
                    HIR lHir = (HIR)lSubtreeIterator.next();
                    if (this.fTraceLevel > 3) {
                        this.dbg(4, "\nlHir " + lHir);
                    }
                    if (lHir == null) break;
                    if (lHir instanceof Stmt) {
                        lStmt = (Stmt)lHir;
                    } else {
                        if (lHir.getType() != this.symRoot.typeBool || !(lHir.getParent() instanceof IfStmt)) continue;
                        lStmt = (Stmt)lHir.getParent();
                    }
                    HIR lParent = (HIR)lStmt.getParent();
                    int lChildNumber = lStmt.getChildNumber();
                    if (lStmt instanceof LabeledStmt) {
                        lStmt = ((LabeledStmt)lStmt).getStmt();
                    }
                    if (lStmt == null || lStmt instanceof BlockStmt || lGeneratedStmt.contains(lStmt)) continue;
                    Stmt lChangedStmt = lStmt;
                    if (this.fTraceLevel > 3) {
                        this.dbg(4, " lParent " + ((Object)lParent).toString() + " childNumber " + lChildNumber + '\n');
                    }
                    for (ExpId lExpId : lSaveExps) {
                        if (this.fTraceLevel > 3) {
                            this.dbg(4, "\n ExpId of SaveExp " + lExpId.toString());
                        }
                        if (lSaveProcessed.contains(lExpId)) {
                            this.dbg(4, " Exp of " + lExpId.toString() + " is already saved. ");
                            continue;
                        }
                        Exp lSaveExp = this.findExpWithExpId(lStmt, lExpId);
                        if (this.fTraceLevel > 3) {
                            this.dbg(4, "\n Save Exp " + lSaveExp + " of " + lStmt.toStringShort());
                        }
                        if (lSaveExp != null) {
                            lTemp = (Var)this.fGlobalExpTempMap.get(lExpId);
                            if (lTemp != null) {
                                boolean lSaved = false;
                                Stmt lAssignStmt = this.makeAssignStmt(lTemp, lSaveExp);
                                if (this.fTraceLevel > 3) {
                                    this.dbg(4, "\n Generate " + lAssignStmt.toStringWithChildren());
                                }
                                if (lStmt instanceof ExpStmt) {
                                    Stmt lControlStmt = lStmt.ancestorControlStmtOfConditionalExp(lSaveExp);
                                    if (lControlStmt != null) {
                                        if (this.fTraceLevel > 3) {
                                            this.dbg(4, " lControlStmt " + lControlStmt.toStringShort());
                                        }
                                        lControlStmt.combineWithConditionalExp(lAssignStmt, lSaveExp);
                                        this.replaceExpWithTemp(lSaveExp, lTemp);
                                        lSaved = true;
                                    } else {
                                        this.dbg(1, " Control-statement for ", lStmt.toStringWithChildren() + " not found");
                                    }
                                } else {
                                    if (this.fTraceLevel > 3) {
                                        this.dbg(4, " Containing-Stmt is not ExpStmt " + lStmt.toStringShort());
                                    }
                                    if (lStmt instanceof LoopStmt && (((LoopStmt)lStmt).getLoopStartCondition() != null && ((LoopStmt)lStmt).getLoopStartCondition().contains(lSaveExp) || ((LoopStmt)lStmt).getLoopEndCondition() != null && ((LoopStmt)lStmt).getLoopEndCondition().contains(lSaveExp))) {
                                        ((LoopStmtImpl)lStmt).combineWithConditionalExp(lAssignStmt, lSaveExp);
                                        this.replaceExpWithTemp(lSaveExp, lTemp);
                                        lSaved = true;
                                    } else if (lStmt instanceof IfStmt && ((IfStmt)lStmt).getIfCondition().contains(lSaveExp)) {
                                        ((IfStmtImpl)lStmt).combineWithConditionalExp(lAssignStmt, lSaveExp);
                                        this.replaceExpWithTemp(lSaveExp, lTemp);
                                        lSaved = true;
                                    } else if (lStmt instanceof SwitchStmt && ((SwitchStmt)lStmt).getSelectionExp().contains(lSaveExp)) {
                                        ((SwitchStmtImpl)lStmt).combineWithConditionalExp(lAssignStmt, lSaveExp);
                                        this.replaceExpWithTemp(lSaveExp, lTemp);
                                        lSaved = true;
                                    }
                                }
                                if (!lSaved) {
                                    OptUtil.insertPreviousStmt(lStmt, lAssignStmt);
                                    this.replaceExpWithTemp(lSaveExp, lTemp);
                                }
                                lChanged = true;
                                lGeneratedStmt.add(lAssignStmt);
                                lSaveProcessed.add(lExpId);
                                if (this.fTraceLevel > 2) {
                                    this.dbg(3, " Saved " + lAssignStmt.toStringWithChildren() + "\n");
                                }
                            } else if (this.fTraceLevel > 2) {
                                this.dbg(4, " Unnecessary to save " + lSaveExp.toStringShort());
                            }
                        }
                        lStmt = lChangedStmt;
                    }
                    for (ExpId lExpId : lRedundExps) {
                        Exp lRedundExp;
                        if (lRedundProcessed.contains(lExpId) || (lRedundExp = this.findExpWithExpId(lStmt, lExpId)) == null) continue;
                        if (this.fTraceLevel > 3) {
                            this.dbg(4, "\n lRedundExp " + lRedundExp.toStringShort());
                        }
                        if ((lTemp = (Var)this.fGlobalExpTempMap.get(lExpId)) == null) continue;
                        this.replaceExpWithTemp(lRedundExp, lTemp);
                        lChanged = true;
                        lRedundProcessed.add(lExpId);
                        if (this.fTraceLevel <= 2) continue;
                        this.dbg(3, " Replace redundant " + lRedundExp.toStringWithChildren() + " by " + lTemp.toStringShort() + "\n");
                    }
                }
                if (!lSaveExps.isEmpty()) {
                    if (this.fTraceLevel > 2) {
                        this.dbg(3, "\nSave expressions that does not appear in this BBlock " + lBBlock);
                    }
                    for (ExpId lExpId : lSaveExps) {
                        if (this.fTraceLevel > 3) {
                            this.dbg(4, "\n advance to " + lExpId);
                        }
                        if (lSaveProcessed.contains(lExpId)) {
                            if (this.fTraceLevel <= 3) continue;
                            this.dbg(4, " It is already saved. ");
                            continue;
                        }
                        Var lTemp2 = (Var)this.fGlobalExpTempMap.get(lExpId);
                        if (lTemp2 == null) {
                            if (this.fTraceLevel <= 3) continue;
                            this.dbg(4, " It is not a selected expression. ");
                            continue;
                        }
                        HIR lLinkedExp = (HIR)lExpId.getLinkedNode();
                        if (lLinkedExp == null) continue;
                        Stmt lAssignStmt = this.makeAssignStmt(lTemp2, (Exp)lLinkedExp);
                        if (this.fTraceLevel > 3) {
                            this.dbg(4, "\nSave " + lLinkedExp.toStringWithChildren());
                        }
                        Stmt lContainingStmt = lLinkedExp.getStmtContainingThisNode();
                        this.addLastStmtOfBBlock(lAssignStmt, lBBlock);
                    }
                }
            }
            Set lInsertExps = this.fInsert[lBBlockNum].exps();
            if (this.fTraceLevel > 2) {
                this.dbg(3, "\n insertExps " + lInsertExps.toString());
            }
            for (ExpId lExpId : lInsertExps) {
                lExp = (Exp)lExpId.getCopiedExp();
                lTemp = (Var)this.fGlobalExpTempMap.get(lExpId);
                if (lTemp == null) continue;
                Stmt lAssignStmt = this.makeAssignStmt(lTemp, lExp);
                this.insertTailStmtCaringBranch(lBBlock, lAssignStmt);
                lChanged = true;
                if (this.fTraceLevel <= 2) continue;
                this.dbg(3, " Insert " + lAssignStmt.toStringWithChildren() + "\n");
            }
            List lSuccList = lBBlock.getSuccList();
            int lSuccIndex = 0;
            for (BBlock lSuccBBlock : lSuccList) {
                ExpVector lEdgeValue;
                if (!this.fInsertEdge[lBBlockNum].isEmpty() && (lEdgeValue = (ExpVector)this.fInsertEdge[lBBlockNum].get(lSuccIndex)) != null) {
                    Set lEdgeExps = lEdgeValue.exps();
                    for (ExpId lExpId : lEdgeExps) {
                        lExp = (Exp)lExpId.getLinkedNode();
                        lTemp = (Var)this.fGlobalExpTempMap.get(lExpId);
                        if (lTemp == null) continue;
                        Stmt lAssignStmt = this.makeAssignStmt(lTemp, lExp);
                        this.insertToEdge(lBBlock, lSuccBBlock, lAssignStmt);
                        lChanged = true;
                        if (this.fTraceLevel <= 2) continue;
                        this.dbg(3, " edge from " + lBBlock.toString() + " to " + lSuccBBlock.toString() + " " + lAssignStmt.toStringWithChildren() + "\n");
                    }
                }
                ++lSuccIndex;
            }
        }
        return lChanged;
    }

    protected Exp findExpWithExpId(HIR pHir, ExpId pExpId) {
        if (this.fTraceLevel > 3) {
            this.dbg(4, "\n findExpWithExpId " + pExpId.toStringShort() + " in " + pHir.toStringShort());
        }
        boolean lNewBBlock = false;
        HirIterator lIterator = this.hir.hirIterator(pHir);
        while (lIterator.hasNext()) {
            HIR lHir = lIterator.next();
            if (lHir instanceof LabeledStmt) {
                if (lNewBBlock) {
                    return null;
                }
                lNewBBlock = true;
            }
            if (!(lHir instanceof Exp) || lHir.getChildCount() <= 0 || this.fSubpFlow.getExpId(lHir) != pExpId) continue;
            if (this.fTraceLevel > 3) {
                this.dbg(4, " found " + lHir.toStringWithChildren());
            }
            return (Exp)lHir;
        }
        return null;
    }

    public void replaceExpWithTemp(Exp pExp, Var pVar) {
        HIR lParent = (HIR)pExp.getParent();
        if (lParent instanceof AssignStmt && lParent.getChild1() instanceof VarNode && pExp.getChildNumber() == 2 && ((VarNode)lParent.getChild1()).getSymNodeSym() == pVar) {
            OptUtil.deleteStmt((AssignStmt)lParent);
            return;
        }
        VarNode lVarNode = this.hir.varNode(pVar);
        OptUtil.replaceNode(pExp, lVarNode);
    }

    public Stmt makeAssignStmt(Var pVar, Exp pExp) {
        return this.hir.assignStmt(this.hir.varNode(pVar), (Exp)pExp.copyWithOperands());
    }

    public void insertToEdge(BBlock pFrom, BBlock pTo, Stmt pStmt) {
        if (pStmt == null) {
            return;
        }
        if (this.fTraceLevel > 3) {
            this.dbg(4, " InsertToEdge from " + pFrom.toString() + " to " + pTo.toString() + pStmt.toStringShort() + '\n');
        }
        if (pFrom.getSuccList().size() == 1) {
            this.insertTailStmtCaringBranch(pFrom, pStmt);
        } else if (pTo.getPredList().size() == 1) {
            this.insertHeadStmtCaringBranch(pTo, pStmt);
        } else if (this.fTraceLevel > 0) {
            this.dbg(1, " Critical edge encountered in InsertToEdge from " + pFrom.toString() + " to " + pTo.toString() + pStmt.toStringShort() + '\n');
        }
    }

    public void insertHeadStmtCaringBranch(BBlock pBBlock, Stmt pStmt) {
        LabeledStmt lFirstStmt;
        Stmt lStmtBody;
        if (pStmt == null) {
            return;
        }
        if (this.fTraceLevel > 3) {
            this.dbg(4, " InsertHeadStmtCaringBranch " + pBBlock.toString() + " " + pStmt.toStringWithChildren() + '\n');
        }
        if ((lStmtBody = (lFirstStmt = (LabeledStmt)pBBlock.getIrLink()).getStmt()) != null) {
            if (this.isConditionalExpOfControlStmt(lStmtBody)) {
                if (this.fTraceLevel > 3) {
                    this.dbg(4, "  Insert before ExpStmt " + lStmtBody.toStringShort() + " Insert to all predecessors.\n");
                }
                List lPredList = pBBlock.getPredList();
                for (BBlock lPredBBlock : lPredList) {
                    this.addLastStmtOfBBlock(pStmt, pBBlock);
                }
            } else {
                OptUtil.insertPreviousStmt(lStmtBody, pStmt);
            }
        } else {
            OptUtil.setStmt(lFirstStmt, pStmt);
        }
    }

    public void insertTailStmtCaringBranch(BBlock pBBlock, Stmt pStmt) {
        if (pStmt == null) {
            return;
        }
        if (this.fTraceLevel > 3) {
            this.dbg(4, " InsertTailStmtCaringBranch in " + pBBlock.toString() + " " + pStmt.toStringWithChildren());
        }
        Stmt lLastStmt = ((BBlockHir)pBBlock).getLastStmt();
        if (this.fTraceLevel > 3) {
            this.dbg(4, "  lastStmt " + lLastStmt + '\n');
        }
        Stmt lChildStmt = null;
        while ((lLastStmt instanceof LabeledStmt || lLastStmt instanceof BlockStmt) && (lChildStmt = lLastStmt instanceof LabeledStmt ? ((LabeledStmt)lLastStmt).getStmt() : ((BlockStmt)lLastStmt).getLastStmt()) != null) {
            lLastStmt = lChildStmt;
        }
        if (lChildStmt instanceof ExpStmt) {
            lLastStmt = lChildStmt;
        }
        if (this.isConditionalExpOfControlStmt(lLastStmt)) {
            if (this.fTraceLevel > 3) {
                this.dbg(4, " Insert after ExpStmt " + lLastStmt.toStringShort() + " Insert to all successors.\n");
            }
            List lSuccList = pBBlock.getSuccList();
            for (BBlock lSuccBBlock : lSuccList) {
                this.addFirstStmtOfBBlock(pStmt, pBBlock);
            }
        } else if (lLastStmt instanceof IfStmt || lLastStmt instanceof SwitchStmt || lLastStmt instanceof LoopStmt || lLastStmt instanceof ReturnStmt || lLastStmt instanceof JumpStmt) {
            OptUtil.insertPreviousStmt(lLastStmt, pStmt);
        } else if (lLastStmt != null) {
            OptUtil.addNextStmt(lLastStmt, pStmt);
        } else {
            Stmt lLinkedStmt = (Stmt)((BBlockHir)pBBlock).getIrLink();
            Stmt lCombinedStmt = lLinkedStmt.combineStmt(pStmt, true);
            OptUtil.replaceStmt(lLinkedStmt, lCombinedStmt);
        }
    }

    public void addFirstStmtOfBBlock(Stmt pStmt, BBlock pBBlock) {
        if (pStmt == null) {
            return;
        }
        LabeledStmt lLabeledStmt = (LabeledStmt)pBBlock.getIrLink();
        Stmt lFirstStmt = lLabeledStmt.getStmt();
        if (lFirstStmt == null) {
            OptUtil.setStmt(lLabeledStmt, pStmt);
        } else if (lFirstStmt instanceof BlockStmt) {
            OptUtil.addFirstStmt((BlockStmt)lFirstStmt, pStmt);
        } else {
            lFirstStmt.cutParentLink();
            Stmt lCombinedStmt = (Stmt)pStmt.copyWithOperands();
            lCombinedStmt.combineStmt(lFirstStmt, true);
            OptUtil.setStmt(lLabeledStmt, lCombinedStmt);
        }
        if (this.fTraceLevel > 3) {
            this.dbg(4, "addFirstStmt", pBBlock.toString() + " " + lLabeledStmt.toStringWithChildren());
        }
    }

    public void addLastStmtOfBBlock(Stmt pStmt, BBlock pBBlock) {
        Stmt lNextStmt;
        Stmt lLastStmt = null;
        if (pStmt == null) {
            return;
        }
        if (this.fTraceLevel > 3) {
            this.dbg(4, "\naddLastStmtOfBBlock", pBBlock.toString() + " " + pStmt.toStringWithChildren());
        }
        BBlockStmtIterator lIterator = this.fSubpFlow.bblockStmtIterator((BBlockHir)pBBlock);
        block3: while (lIterator.hasNext() && (lNextStmt = (Stmt)lIterator.next()) != null) {
            switch (lNextStmt.getOperator()) {
                case 22: 
                case 35: 
                case 36: {
                    lLastStmt = lNextStmt;
                    continue block3;
                }
            }
        }
        if (lLastStmt == null) {
            this.addFirstStmtOfBBlock(pStmt, pBBlock);
        } else {
            if (this.fTraceLevel > 3) {
                this.dbg(4, " lLastStmt " + lLastStmt.toStringShort());
            }
            if (this.isConditionalExpOfControlStmt(lLastStmt)) {
                Stmt lControlStmt = lLastStmt.ancestorControlStmtOfConditionalExp(lLastStmt);
                lControlStmt.combineWithConditionalExp(pStmt, lLastStmt);
            } else if (lLastStmt instanceof LabeledStmt) {
                LabeledStmt lLabeledStmt = (LabeledStmt)lLastStmt;
                if (lLabeledStmt.getStmt() == null) {
                    OptUtil.setStmt(lLabeledStmt, pStmt);
                } else {
                    OptUtil.insertPreviousStmt(lLabeledStmt.getStmt(), pStmt);
                }
            } else if (lLastStmt instanceof BlockStmt) {
                OptUtil.addLastStmt((BlockStmt)lLastStmt, pStmt);
            } else if (lLastStmt.getParent() instanceof BlockStmt) {
                OptUtil.addNextStmt(lLastStmt, pStmt);
            } else {
                Stmt lCopiedStmt = (Stmt)lLastStmt.copyWithOperands();
                Stmt lCombinedStmt = lCopiedStmt.combineStmt(pStmt, true);
                OptUtil.replaceStmt(lLastStmt, lCombinedStmt);
            }
        }
        if (this.fTraceLevel > 3) {
            this.dbg(4, "addLastStmt", pBBlock.toString() + " " + lLastStmt.toStringWithChildren());
        }
    }

    public boolean isConditionalExpOfControlStmt(HIR pHir) {
        Stmt lContainingControlStmt;
        Stmt lContainingStmt;
        if (this.fTraceLevel > 3) {
            this.dbg(4, "\nisConditionalExpOfControlStmt " + pHir);
        }
        boolean lAnswer = false;
        if (pHir != null && (lContainingStmt = pHir.getStmtContainingThisNode()) instanceof ExpStmt && lContainingStmt.getChild1() != null && ((HIR)lContainingStmt.getChild1()).getType() == this.symRoot.typeBool && (lContainingControlStmt = lContainingStmt.ancestorControlStmtOfConditionalExp(pHir)) != null) {
            lAnswer = true;
        }
        if (this.fTraceLevel > 3) {
            this.dbg(4, " answer " + lAnswer);
        }
        return lAnswer;
    }

    protected boolean isRegisterizableExp(HIR pHir) {
        if (pHir == null) {
            return false;
        }
        if (!pHir.getType().isScalar()) {
            return false;
        }
        if (this.toBeExcluded(pHir)) {
            return false;
        }
        HIR lParent = (HIR)pHir.getParent();
        if (lParent instanceof AssignStmt && lParent.getChild1() == pHir) {
            return false;
        }
        switch (pHir.getOperator()) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                return true;
            }
            case 68: {
                return false;
            }
        }
        return false;
    }

    protected void printExpVectorArray(String pHeader, ExpVector[] pVectorArray) {
        for (int lIndex = 1; lIndex < pVectorArray.length; ++lIndex) {
            System.out.print(pHeader + lIndex + ' ' + pVectorArray[lIndex].toStringShort() + '\n');
        }
    }

    protected void printExpVectorArray2(String pHeader1, ExpVector[] pVectorArray1, String pHeader2, ExpVector[] pVectorArray2) {
        for (int lIndex = 1; lIndex < pVectorArray1.length; ++lIndex) {
            if (pVectorArray1[lIndex] != null) {
                System.out.print(pHeader1 + lIndex + ' ' + pVectorArray1[lIndex].toStringShort() + '\n');
            } else {
                System.out.print(pHeader1 + lIndex + '\n');
            }
            if (pVectorArray2[lIndex] != null) {
                System.out.print(pHeader2 + lIndex + ' ' + pVectorArray2[lIndex].toStringShort() + '\n');
                continue;
            }
            System.out.print(pHeader2 + lIndex + '\n');
        }
    }

    public long printTimeInMillis(String pHeader, boolean pPrint, boolean pMonitor) {
        long lTimeInMillis = this.fCompileThread.elapsedTime();
        long lInterval = fTimeInMillis == 0L ? 0L : lTimeInMillis - fTimeInMillis;
        if (pPrint) {
            System.out.print('\n' + pHeader + " time " + lTimeInMillis + " diff " + lInterval + " ");
        }
        if (pMonitor) {
            System.err.print('\n' + pHeader + " time " + lTimeInMillis + " diff " + lInterval + " ");
        }
        fTimeInMillis = lTimeInMillis;
        return lTimeInMillis;
    }
}

