/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.Debug;
import coins.SymRoot;
import coins.alias.AliasAnal;
import coins.alias.AliasAnalHir1;
import coins.alias.RecordAlias;
import coins.flow.BBlock;
import coins.flow.SetRefRepr;
import coins.flow.SetRefReprList;
import coins.flow.SubpFlow;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubpNode;
import coins.ir.hir.VarNode;
import coins.opt.OptUtil;
import coins.opt.ReplaceInfo;
import coins.opt.TempInfo;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.Var;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GlobalVariableTemporalize {
    protected final SubpDefinition fSubpDef;
    protected final SubpFlow fSubpFlow;
    protected final AliasAnal fAliasAnal;
    private RecordAlias fRecordAlias;
    protected int fMinimumUseCountForTemporalize = 2;
    protected Set fValidFunctionSet;
    private TempInfo fTempInfo;

    public GlobalVariableTemporalize(SubpDefinition pSubpDef, SubpFlow pSubpFlow, AliasAnal pAliasAnal) {
        this.fSubpDef = pSubpDef;
        this.fSubpFlow = pSubpFlow;
        this.fAliasAnal = pAliasAnal;
        HashSet<String> lValidFunctionSet = new HashSet<String>();
        lValidFunctionSet.add("printf");
        this.fValidFunctionSet = lValidFunctionSet;
        this.fTempInfo = new TempInfo();
    }

    protected SubpDefinition getSubpDef() {
        return this.fSubpDef;
    }

    protected SubpFlow getSubpFlow() {
        return this.fSubpFlow;
    }

    protected AliasAnal getAliasAnal() {
        return this.fAliasAnal;
    }

    protected RecordAlias getRecordAlias() {
        return this.fRecordAlias;
    }

    protected Debug getDebug() {
        return this.fSubpFlow.getFlowRoot().ioRoot.dbgOpt1;
    }

    public int getMinimumUseCountForTemporalize() {
        return this.fMinimumUseCountForTemporalize;
    }

    public void setMinimumUseCountForTemporalize(int pCount) {
        this.fMinimumUseCountForTemporalize = pCount;
    }

    public Set getValidFunctions() {
        return this.fValidFunctionSet;
    }

    public void setValidFunctions(Set pValidFunctions) {
        this.fValidFunctionSet = pValidFunctions;
    }

    public boolean doSubprogram() {
        this.initialize();
        this.getDebug().print(1, "doSubprogram", this.getSubpFlow().getSubpSym().toString());
        boolean lChanged = false;
        for (BBlock lBBlock : this.getSubpFlow().getBBlockTable()) {
            if (!this.doBBlock(lBBlock)) continue;
            lChanged = true;
        }
        if (lChanged) {
            // empty if block
        }
        return lChanged;
    }

    public boolean doBBlock(BBlock pBBlock) {
        if (pBBlock == null || pBBlock.getBBlockNumber() == 0) {
            return false;
        }
        String lMethodName = "doBBlock";
        int lChangeCount = 0;
        this.getDebug().print(2, "doBBlock", "pBBlock:" + pBBlock.toString());
        ReplaceInfo lReplaceInfo = new ReplaceInfo();
        Set lGlobalSimpleVariableSet = this.getGlobalSimpleVariableSet(pBBlock);
        SetRefReprList lSetRefReprList = this.fSubpFlow.getSetRefReprList(pBBlock);
        this.getDebug().print(6, "doBBlock", "lSetRefReprList:" + lSetRefReprList.toString());
        for (SetRefRepr lSetRefRepr : lSetRefReprList) {
            if (this.hasInvalidCall(lSetRefRepr)) {
                this.getDebug().print(6, "doBBlock", "lSetRefReprList:Invalid call is included " + lSetRefRepr);
                lReplaceInfo.clear();
                continue;
            }
            if (lSetRefRepr.hasCallWithSideEffect()) {
                this.getDebug().print(6, "doBBlock", "lSetRefReprList:Valid call is included " + lSetRefRepr);
                continue;
            }
            Iterator lItUseNodeList = lSetRefRepr.useNodeIterator();
            while (lItUseNodeList.hasNext()) {
                HIR lNode = (HIR)lItUseNodeList.next();
                Sym lUseSym = lNode.getSym();
                if (!lGlobalSimpleVariableSet.contains(lUseSym)) continue;
                this.getDebug().print(6, "doBBlock", "Use gloval var :" + lUseSym);
                boolean isPossiblyAddressTaken = this.fRecordAlias.possiblyAddressTaken(lUseSym);
                if (isPossiblyAddressTaken) {
                    this.getDebug().print(4, "doBBlock", "Address taken :" + lUseSym);
                    continue;
                }
                lReplaceInfo.add((VarNode)lNode);
                this.getDebug().print(6, "doBBlock", "Add replace var node :" + lNode);
            }
            Set lModSymsSet = lSetRefRepr.modSyms();
            this.getDebug().print(6, "doBBlock", "Mod syms:" + lModSymsSet);
            lModSymsSet.retainAll(lGlobalSimpleVariableSet);
            this.getDebug().print(6, "doBBlock", "Global mod syms:" + lModSymsSet);
            Set lAliassedSymsSet = this.getRecordAlias().aliasSymGroup(lModSymsSet);
            this.getDebug().print(6, "doBBlock", "Aliassed syms:" + lModSymsSet);
            lAliassedSymsSet.retainAll(lGlobalSimpleVariableSet);
            this.getDebug().print(4, "doBBlock", "Global aliassed syms:" + lModSymsSet);
            for (Sym lSymMod : lAliassedSymsSet) {
                lReplaceInfo.remove(lSymMod);
            }
            lChangeCount += this.replace(lReplaceInfo);
        }
        this.getDebug().print(6, "doBBlock", "replaced count :" + lChangeCount);
        return lChangeCount > 0;
    }

    private int replace(ReplaceInfo pReplaceInfo) {
        String lMethodName = "replace";
        int lReplaceCount = 0;
        Set lReplaceSymSet = pReplaceInfo.getReplaceSymSet(this.getMinimumUseCountForTemporalize());
        this.getDebug().print(4, "replace", "Replace global vars:" + lReplaceSymSet);
        for (Sym lSym : lReplaceSymSet) {
            List lReplaceNodeList = pReplaceInfo.getReplaceNodeList(lSym);
            if (lReplaceNodeList == null) {
                this.getDebug().print(3, "replace", "Get replacenode of sym :" + lSym + " is null.");
                continue;
            }
            this.getDebug().print(4, "replace", "Replace Nodes of gloval var: " + lSym + " is " + lReplaceNodeList);
            Iterator lReplaceNodeListIterator = lReplaceNodeList.iterator();
            while (lReplaceNodeListIterator.hasNext()) {
                VarNode lVarNode = (VarNode)lReplaceNodeListIterator.next();
                if (!this.replace(lVarNode, pReplaceInfo)) continue;
                lReplaceNodeListIterator.remove();
                ++lReplaceCount;
            }
        }
        return lReplaceCount;
    }

    private boolean replace(VarNode pVarNode, ReplaceInfo pReplaceInfo) {
        String lMethodName = "replace";
        boolean isChange = false;
        Stmt lStmt = pVarNode.getStmtContainingThisNode();
        if (lStmt == null) {
            this.getDebug().print(3, "replace", "Get Stmt failed.");
            return false;
        }
        this.getDebug().print(6, "replace", "Stmt:" + lStmt);
        SymRoot lSymRoot = this.fSubpFlow.getFlowRoot().symRoot;
        Var lGlobalVar = (Var)pVarNode.getSym();
        Var lInsertedLHSVar = this.fTempInfo.get(lGlobalVar);
        if (lInsertedLHSVar == null) {
            lInsertedLHSVar = lSymRoot.symTableCurrent.generateVar(pVarNode.getType(), lSymRoot.subpCurrent);
            this.fTempInfo.set(lGlobalVar, lInsertedLHSVar);
        }
        if (pReplaceInfo.getReplacedVar(lGlobalVar) == null) {
            AssignStmt lInsertedStmt = this.createAssignStmt(lInsertedLHSVar, pVarNode);
            this.insertAssignStmt(lStmt, lInsertedStmt);
            this.getDebug().print(4, "replace", "Insert temp assign stmt:" + lInsertedStmt);
            pReplaceInfo.setReplacedVar(lGlobalVar, lInsertedLHSVar);
        }
        this.getDebug().print(6, "replace", "Temp var:" + lInsertedLHSVar.toStringShort());
        HIR hir = this.fSubpFlow.getFlowRoot().hirRoot.hir;
        VarNode lNewNode = hir.varNode(lInsertedLHSVar);
        this.getDebug().print(3, "replace", " replaceNode " + pVarNode + " by " + lNewNode);
        OptUtil.replaceNode(pVarNode, lNewNode);
        isChange = true;
        return isChange;
    }

    private AssignStmt createAssignStmt(Var pLHSVar, Exp pRHSExp) {
        HIR hir = this.fSubpFlow.getFlowRoot().hirRoot.hir;
        Exp lInsertedRHS = (Exp)pRHSExp.copyWithOperands();
        VarNode lInsertedLHS = hir.varNode(pLHSVar);
        return hir.assignStmt(lInsertedLHS, lInsertedRHS);
    }

    private void insertAssignStmt(Stmt pStmt, AssignStmt pInsertStmt) {
        if (pStmt instanceof LabeledStmt) {
            Stmt lStmtBody = ((LabeledStmt)pStmt).getStmt();
            if (lStmtBody == null) {
                ((LabeledStmt)pStmt).setStmt(pInsertStmt);
            } else {
                lStmtBody.insertPreviousStmt(pInsertStmt, pStmt.getBlockStmt());
            }
        } else {
            pStmt.insertPreviousStmt(pInsertStmt, pStmt.getBlockStmt());
        }
    }

    private boolean hasInvalidCall(SetRefRepr pSetRefRepl) {
        String lMethodName = "hasInvalidCall";
        boolean lHasInvalidCall = false;
        List lCallNodes = pSetRefRepl.callNodes();
        for (FunctionExp lFunctionExp : lCallNodes) {
            Exp lExp = (Exp)lFunctionExp.getChild1();
            String lFunctionName = null;
            SubpNode lFunctionNode = lFunctionExp.getFunctionNode();
            if (lFunctionNode != null) {
                Sym lFunctionSym = lFunctionNode.getSym();
                lFunctionName = lFunctionSym.getName();
            }
            if (lFunctionName == null || lFunctionName.length() == 0) {
                this.getDebug().print(6, "hasInvalidCall", "Non named function is found. It's regarded as valid function.");
                lHasInvalidCall = true;
                break;
            }
            this.getDebug().print(8, "hasInvalidCall", "Function name: " + lFunctionName);
            Set lValidFunctionsSet = this.getValidFunctions();
            if (lValidFunctionsSet != null && lValidFunctionsSet.contains(lFunctionName)) {
                this.getDebug().print(6, "hasInvalidCall", "Function name: " + lFunctionName + " is valid function.");
                continue;
            }
            lHasInvalidCall = true;
            break;
        }
        return lHasInvalidCall;
    }

    private boolean hasInvalidCall(BBlock pBBlock) {
        String lMethodName = "hasInvalidCall";
        SetRefReprList lSetRefReprList = this.fSubpFlow.getSetRefReprList(pBBlock);
        this.getDebug().print(6, "hasInvalidCall", "lSetRefReprList:" + lSetRefReprList.toString());
        Iterator lIterator = lSetRefReprList.iterator();
        boolean lHasInvalidCall = false;
        while (lIterator.hasNext()) {
            SetRefRepr lSetRefRepr = (SetRefRepr)lIterator.next();
            if (!this.hasInvalidCall(lSetRefRepr)) continue;
            lHasInvalidCall = true;
            break;
        }
        return lHasInvalidCall;
    }

    protected void initialize() {
        if (!this.fSubpFlow.isComputed(4)) {
            this.fSubpFlow.getFlowRoot().flow.controlFlowAnal(this.fSubpFlow);
        }
        this.fRecordAlias = new RecordAlias((AliasAnalHir1)this.getAliasAnal(), this.getSubpDef());
        this.fTempInfo.clear();
    }

    private Set getGlobalSimpleVariableSet(BBlock pBBlock) {
        String lMethodName = "getGlobalSimpleVariableSet";
        this.getDebug().print(3, "getGlobalSimpleVariableSet", "BBlock:" + pBBlock);
        Set lGlobalVariablesSet = this.fSubpFlow.setOfGlobalVariables();
        this.getDebug().print(6, "getGlobalSimpleVariableSet", "lGlobalVariablesSet:" + lGlobalVariablesSet);
        HashSet<Sym> lGlobalSimpleVariableSet = new HashSet<Sym>();
        for (Sym sym : lGlobalVariablesSet) {
            if (!(sym instanceof Var)) continue;
            this.getDebug().print(8, "getGlobalSimpleVariableSet", "Sym:" + sym + "Kind:" + sym.getSymKindName());
            Type lType = sym.getSymType();
            if (lType == null) {
                this.getDebug().print(3, "getGlobalSimpleVariableSet", "getSymType() returns null of sym:" + sym);
            } else if (lType.isVolatile()) {
                this.getDebug().print(3, "getGlobalSimpleVariableSet", "sym:" + sym + " is volatile type.");
                continue;
            }
            if (!sym.getSymType().isBasicType()) continue;
            lGlobalSimpleVariableSet.add(sym);
        }
        return lGlobalSimpleVariableSet;
    }
}

